/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.zookeeper.util.CircularBlockingQueue;
import org.junit.Assert;
import org.junit.Test;

public class TestCircularBlockingQueue {
    @Test
    public void testCircularBlockingQueue() throws InterruptedException {
        CircularBlockingQueue testQueue = new CircularBlockingQueue(2);
        testQueue.offer((Object)1);
        testQueue.offer((Object)2);
        testQueue.offer((Object)3);
        Assert.assertEquals((long)2L, (long)testQueue.size());
        Assert.assertEquals((long)2L, (long)((Integer)testQueue.take()).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)testQueue.take()).intValue());
        Assert.assertEquals((long)1L, (long)testQueue.getDroppedCount());
        Assert.assertEquals((long)0L, (long)testQueue.size());
        Assert.assertEquals((Object)true, (Object)testQueue.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCircularBlockingQueueTakeBlock() throws InterruptedException, ExecutionException {
        CircularBlockingQueue testQueue = new CircularBlockingQueue(2);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<Integer> testTake = executor.submit(() -> (Integer)testQueue.take());
            while (!testQueue.isConsumerThreadBlocked()) {
                Thread.sleep(50L);
            }
            testQueue.offer((Object)10);
            Integer result = testTake.get();
            Assert.assertEquals((long)10L, (long)result.intValue());
        }
        finally {
            executor.shutdown();
        }
    }
}

