/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ClientTest;
import org.apache.zookeeper.test.DisconnectableZooKeeper;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FollowerResyncConcurrencyTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(FollowerResyncConcurrencyTest.class);
    public static final long CONNECTION_TIMEOUT = ClientTest.CONNECTION_TIMEOUT;
    private AtomicInteger counter = new AtomicInteger(0);
    private AtomicInteger errors = new AtomicInteger(0);
    private AtomicInteger pending = new AtomicInteger(0);

    @BeforeEach
    public void setUp() throws Exception {
        this.pending.set(0);
        this.errors.set(0);
        this.counter.set(0);
    }

    @AfterEach
    public void tearDown() throws Exception {
        LOG.info("Error count {}", (Object)this.errors.get());
    }

    @Test
    public void testLaggingFollowerResyncsUnderNewEpoch() throws Exception {
        ClientBase.CountdownWatcher watcher1 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher watcher2 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher watcher3 = new ClientBase.CountdownWatcher();
        QuorumUtil qu = new QuorumUtil(1);
        qu.shutdownAll();
        qu.start(1);
        qu.start(2);
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + qu.getPeer((int)1).clientPort, ClientBase.CONNECTION_TIMEOUT), (String)"Waiting for server up");
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + qu.getPeer((int)2).clientPort, ClientBase.CONNECTION_TIMEOUT), (String)"Waiting for server up");
        DisconnectableZooKeeper zk1 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)1).peer.getClientPort(), watcher1);
        LOG.info("zk1 has session id 0x{}", (Object)Long.toHexString(zk1.getSessionId()));
        String resyncPath = "/resyncundernewepoch";
        zk1.create("/resyncundernewepoch", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.close();
        qu.shutdown(1);
        qu.shutdown(2);
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + qu.getPeer((int)1).clientPort, ClientBase.CONNECTION_TIMEOUT), (String)"Waiting for server down");
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + qu.getPeer((int)2).clientPort, ClientBase.CONNECTION_TIMEOUT), (String)"Waiting for server down");
        qu.start(1);
        qu.start(2);
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + qu.getPeer((int)1).clientPort, ClientBase.CONNECTION_TIMEOUT), (String)"Waiting for server up");
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + qu.getPeer((int)2).clientPort, ClientBase.CONNECTION_TIMEOUT), (String)"Waiting for server up");
        qu.start(3);
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + qu.getPeer((int)3).clientPort, ClientBase.CONNECTION_TIMEOUT), (String)"Waiting for server up");
        zk1 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)1).peer.getClientPort(), watcher1);
        LOG.info("zk1 has session id 0x{}", (Object)Long.toHexString(zk1.getSessionId()));
        Assertions.assertNotNull((Object)zk1.exists("/resyncundernewepoch", false), (String)"zk1 has data");
        DisconnectableZooKeeper zk2 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)2).peer.getClientPort(), watcher2);
        LOG.info("zk2 has session id 0x{}", (Object)Long.toHexString(zk2.getSessionId()));
        Assertions.assertNotNull((Object)zk2.exists("/resyncundernewepoch", false), (String)"zk2 has data");
        DisconnectableZooKeeper zk3 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)3).peer.getClientPort(), watcher3);
        LOG.info("zk3 has session id 0x{}", (Object)Long.toHexString(zk3.getSessionId()));
        Assertions.assertNotNull((Object)zk3.exists("/resyncundernewepoch", false), (String)"zk3 has data");
        zk1.close();
        zk2.close();
        zk3.close();
        qu.shutdownAll();
    }

    @Test
    public void testResyncBySnapThenDiffAfterFollowerCrashes() throws Throwable {
        this.followerResyncCrashTest(false);
    }

    @Test
    public void testResyncByTxnlogThenDiffAfterFollowerCrashes() throws Throwable {
        this.followerResyncCrashTest(true);
    }

    public void followerResyncCrashTest(boolean useTxnLogResync) throws Throwable {
        final Semaphore sem = new Semaphore(0);
        QuorumUtil qu = new QuorumUtil(1);
        qu.startAll();
        ClientBase.CountdownWatcher watcher1 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher watcher2 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher watcher3 = new ClientBase.CountdownWatcher();
        int index = 1;
        while (qu.getPeer((int)index).peer.leader == null) {
            ++index;
        }
        Leader leader = qu.getPeer((int)index).peer.leader;
        Assertions.assertNotNull((Object)leader);
        if (useTxnLogResync) {
            qu.getPeer((int)index).peer.getActiveServer().getZKDatabase().setSnapshotSizeFactor(1000.0);
        } else {
            qu.getPeer((int)index).peer.getActiveServer().getZKDatabase().setSnapshotSizeFactor(-1.0);
        }
        index = index == 1 ? 2 : 1;
        LOG.info("Connecting to follower: {}", (Object)index);
        qu.shutdown(index);
        final DisconnectableZooKeeper zk3 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)3).peer.getClientPort(), watcher3);
        LOG.info("zk3 has session id 0x{}", (Object)Long.toHexString(zk3.getSessionId()));
        zk3.create("/mybar", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        qu.restart(index);
        DisconnectableZooKeeper zk1 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)index).peer.getClientPort(), watcher1);
        LOG.info("zk1 has session id 0x{}", (Object)Long.toHexString(zk1.getSessionId()));
        DisconnectableZooKeeper zk2 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)index).peer.getClientPort(), watcher2);
        LOG.info("zk2 has session id 0x{}", (Object)Long.toHexString(zk2.getSessionId()));
        zk1.create("/first", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Thread mytestfooThread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 3000; ++i) {
                    zk3.create("/mytestfoo", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, (rc, path, ctx, name) -> {
                        FollowerResyncConcurrencyTest.this.pending.decrementAndGet();
                        FollowerResyncConcurrencyTest.this.counter.incrementAndGet();
                        if (rc != 0) {
                            FollowerResyncConcurrencyTest.this.errors.incrementAndGet();
                        }
                        if (FollowerResyncConcurrencyTest.this.counter.get() == 16200) {
                            sem.release();
                        }
                    }, null);
                    FollowerResyncConcurrencyTest.this.pending.incrementAndGet();
                    if (i % 10 != 0) continue;
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        for (int i = 0; i < 13000; ++i) {
            zk3.create("/mybar", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, (rc, path, ctx, name) -> {
                this.pending.decrementAndGet();
                this.counter.incrementAndGet();
                if (rc != 0) {
                    this.errors.incrementAndGet();
                }
                if (this.counter.get() == 16200) {
                    sem.release();
                }
            }, null);
            this.pending.incrementAndGet();
            if (i == 5000) {
                qu.shutdown(index);
                LOG.info("Shutting down s1");
            }
            if (i == 12000) {
                mytestfooThread.start();
                LOG.info("Restarting follower: {}", (Object)index);
                qu.restart(index);
                Thread.sleep(300L);
                LOG.info("Shutdown follower: {}", (Object)index);
                qu.shutdown(index);
                Thread.sleep(300L);
                LOG.info("Restarting follower: {}", (Object)index);
                qu.restart(index);
                LOG.info("Setting up server: {}", (Object)index);
            }
            if (i % 1000 == 0) {
                Thread.sleep(1000L);
            }
            if (i % 50 != 0) continue;
            zk2.create("/newbaz", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, (rc, path, ctx, name) -> {
                this.pending.decrementAndGet();
                this.counter.incrementAndGet();
                if (rc != 0) {
                    this.errors.incrementAndGet();
                }
                if (this.counter.get() == 16200) {
                    sem.release();
                }
            }, null);
            this.pending.incrementAndGet();
        }
        if (!sem.tryAcquire(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS)) {
            LOG.warn("Did not aquire semaphore fast enough");
        }
        mytestfooThread.join(ClientBase.CONNECTION_TIMEOUT);
        if (mytestfooThread.isAlive()) {
            LOG.error("mytestfooThread is still alive");
        }
        Assertions.assertTrue((boolean)this.waitForPendingRequests(60));
        Assertions.assertTrue((boolean)this.waitForSync(qu, index, 10));
        this.verifyState(qu, index, leader);
        zk1.close();
        zk2.close();
        zk3.close();
        qu.shutdownAll();
    }

    @Test
    public void testResyncByDiffAfterFollowerCrashes() throws IOException, InterruptedException, KeeperException, Throwable {
        final Semaphore sem = new Semaphore(0);
        QuorumUtil qu = new QuorumUtil(1);
        qu.startAll();
        ClientBase.CountdownWatcher watcher1 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher watcher2 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher watcher3 = new ClientBase.CountdownWatcher();
        int index = 1;
        while (qu.getPeer((int)index).peer.leader == null) {
            ++index;
        }
        Leader leader = qu.getPeer((int)index).peer.leader;
        Assertions.assertNotNull((Object)leader);
        index = index == 1 ? 2 : 1;
        LOG.info("Connecting to follower: {}", (Object)index);
        DisconnectableZooKeeper zk1 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)index).peer.getClientPort(), watcher1);
        LOG.info("zk1 has session id 0x{}", (Object)Long.toHexString(zk1.getSessionId()));
        DisconnectableZooKeeper zk2 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)index).peer.getClientPort(), watcher2);
        LOG.info("zk2 has session id 0x{}", (Object)Long.toHexString(zk2.getSessionId()));
        final DisconnectableZooKeeper zk3 = FollowerResyncConcurrencyTest.createClient(qu.getPeer((int)3).peer.getClientPort(), watcher3);
        LOG.info("zk3 has session id 0x{}", (Object)Long.toHexString(zk3.getSessionId()));
        zk1.create("/first", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk2.create("/mybar", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        final AtomicBoolean runNow = new AtomicBoolean(false);
        Thread mytestfooThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int inSyncCounter = 0;
                while (inSyncCounter < 400) {
                    if (runNow.get()) {
                        zk3.create("/mytestfoo", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, (rc, path, ctx, name) -> {
                            FollowerResyncConcurrencyTest.this.pending.decrementAndGet();
                            FollowerResyncConcurrencyTest.this.counter.incrementAndGet();
                            if (rc != 0) {
                                FollowerResyncConcurrencyTest.this.errors.incrementAndGet();
                            }
                            if (FollowerResyncConcurrencyTest.this.counter.get() > 7300) {
                                sem.release();
                            }
                        }, null);
                        FollowerResyncConcurrencyTest.this.pending.incrementAndGet();
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++inSyncCounter;
                        continue;
                    }
                    Thread.yield();
                }
            }
        });
        mytestfooThread.start();
        for (int i = 0; i < 5000; ++i) {
            zk2.create("/mybar", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, (rc, path, ctx, name) -> {
                this.pending.decrementAndGet();
                this.counter.incrementAndGet();
                if (rc != 0) {
                    this.errors.incrementAndGet();
                }
                if (this.counter.get() > 7300) {
                    sem.release();
                }
            }, null);
            this.pending.incrementAndGet();
            if (i == 1000) {
                qu.shutdown(index);
                Thread.sleep(1100L);
                LOG.info("Shutting down s1");
            }
            if (i == 1100 || i == 1150 || i == 1200) {
                Thread.sleep(1000L);
            }
            if (i == 1200) {
                qu.startThenShutdown(index);
                runNow.set(true);
                qu.restart(index);
                LOG.info("Setting up server: {}", (Object)index);
            }
            if (i >= 1000 && i % 2 == 0) {
                zk3.create("/newbaz", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, (rc, path, ctx, name) -> {
                    this.pending.decrementAndGet();
                    this.counter.incrementAndGet();
                    if (rc != 0) {
                        this.errors.incrementAndGet();
                    }
                    if (this.counter.get() > 7300) {
                        sem.release();
                    }
                }, null);
                this.pending.incrementAndGet();
            }
            if (i != 1050 && i != 1100 && i != 1150) continue;
            Thread.sleep(1000L);
        }
        if (!sem.tryAcquire(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS)) {
            LOG.warn("Did not aquire semaphore fast enough");
        }
        mytestfooThread.join(ClientBase.CONNECTION_TIMEOUT);
        if (mytestfooThread.isAlive()) {
            LOG.error("mytestfooThread is still alive");
        }
        Assertions.assertTrue((boolean)this.waitForPendingRequests(60));
        Assertions.assertTrue((boolean)this.waitForSync(qu, index, 10));
        this.verifyState(qu, index, leader);
        zk1.close();
        zk2.close();
        zk3.close();
        qu.shutdownAll();
    }

    private static DisconnectableZooKeeper createClient(int port, ClientBase.CountdownWatcher watcher) throws IOException, TimeoutException, InterruptedException {
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper("127.0.0.1:" + port, ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        return zk;
    }

    private boolean waitForPendingRequests(int timeout) throws InterruptedException {
        LOG.info("Wait for pending requests: {}", (Object)this.pending.get());
        for (int i = 0; i < timeout; ++i) {
            Thread.sleep(1000L);
            if (this.pending.get() != 0) continue;
            return true;
        }
        LOG.info("Timeout waiting for pending requests: {}", (Object)this.pending.get());
        return false;
    }

    private boolean waitForSync(QuorumUtil qu, int index, int timeout) throws InterruptedException {
        LOG.info("Wait for server to sync");
        int leaderIndex = index == 1 ? 2 : 1;
        ZKDatabase restartedDb = qu.getPeer((int)index).peer.getActiveServer().getZKDatabase();
        ZKDatabase cleanDb = qu.getPeer((int)3).peer.getActiveServer().getZKDatabase();
        ZKDatabase leadDb = qu.getPeer((int)leaderIndex).peer.getActiveServer().getZKDatabase();
        long leadZxid = 0L;
        long cleanZxid = 0L;
        long restartedZxid = 0L;
        for (int i = 0; i < timeout; ++i) {
            leadZxid = leadDb.getDataTreeLastProcessedZxid();
            cleanZxid = cleanDb.getDataTreeLastProcessedZxid();
            restartedZxid = restartedDb.getDataTreeLastProcessedZxid();
            if (leadZxid == cleanZxid && leadZxid == restartedZxid) {
                return true;
            }
            Thread.sleep(1000L);
        }
        LOG.info("Timeout waiting for zxid to sync: leader 0x{} clean 0x{} restarted 0x{}", new Object[]{Long.toHexString(leadZxid), Long.toHexString(cleanZxid), Long.toHexString(restartedZxid)});
        return false;
    }

    private static TestableZooKeeper createTestableClient(String hp) throws IOException, TimeoutException, InterruptedException {
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        return FollowerResyncConcurrencyTest.createTestableClient(watcher, hp);
    }

    private static TestableZooKeeper createTestableClient(ClientBase.CountdownWatcher watcher, String hp) throws IOException, TimeoutException, InterruptedException {
        TestableZooKeeper zk = new TestableZooKeeper(hp, ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        return zk;
    }

    private void verifyState(QuorumUtil qu, int index, Leader leader) {
        LOG.info("Verifying state");
        Assertions.assertTrue((qu.getPeer((int)index).peer.follower != null ? 1 : 0) != 0, (String)"Not following");
        long epochF = qu.getPeer((int)index).peer.getActiveServer().getZxid() >> 32;
        long epochL = leader.getEpoch() >> 32;
        Assertions.assertTrue((epochF == epochL ? 1 : 0) != 0, (String)("Zxid: " + qu.getPeer((int)index).peer.getActiveServer().getZKDatabase().getDataTreeLastProcessedZxid() + "Current epoch: " + epochF));
        int leaderIndex = index == 1 ? 2 : 1;
        Collection sessionsRestarted = qu.getPeer((int)index).peer.getActiveServer().getZKDatabase().getSessions();
        Collection sessionsNotRestarted = qu.getPeer((int)leaderIndex).peer.getActiveServer().getZKDatabase().getSessions();
        for (Long l : sessionsRestarted) {
            Assertions.assertTrue((boolean)sessionsNotRestarted.contains(l), (String)("Should have same set of sessions in both servers, did not expect: " + l));
        }
        Assertions.assertEquals((int)sessionsNotRestarted.size(), (int)sessionsRestarted.size(), (String)"Should have same number of sessions");
        ZKDatabase restarted = qu.getPeer((int)index).peer.getActiveServer().getZKDatabase();
        ZKDatabase clean = qu.getPeer((int)3).peer.getActiveServer().getZKDatabase();
        ZKDatabase lead = qu.getPeer((int)leaderIndex).peer.getActiveServer().getZKDatabase();
        for (Long l : sessionsRestarted) {
            LOG.info("Validating ephemeral for session id 0x{}", (Object)Long.toHexString(l));
            Assertions.assertTrue((boolean)sessionsNotRestarted.contains(l), (String)("Should have same set of sessions in both servers, did not expect: " + l));
            Set ephemerals = restarted.getEphemerals(l.longValue());
            Set cleanEphemerals = clean.getEphemerals(l.longValue());
            for (String o : cleanEphemerals) {
                if (ephemerals.contains(o)) continue;
                LOG.info("Restarted follower doesn't contain ephemeral {} zxid 0x{}", (Object)o, (Object)Long.toHexString(clean.getDataTree().getNode((String)o).stat.getMzxid()));
            }
            for (String o : ephemerals) {
                if (cleanEphemerals.contains(o)) continue;
                LOG.info("Restarted follower has extra ephemeral {} zxid 0x{}", (Object)o, (Object)Long.toHexString(restarted.getDataTree().getNode((String)o).stat.getMzxid()));
            }
            Set leadEphemerals = lead.getEphemerals(l.longValue());
            for (String o : leadEphemerals) {
                if (cleanEphemerals.contains(o)) continue;
                LOG.info("Follower doesn't contain ephemeral from leader {} zxid 0x{}", (Object)o, (Object)Long.toHexString(lead.getDataTree().getNode((String)o).stat.getMzxid()));
            }
            for (String o : cleanEphemerals) {
                if (leadEphemerals.contains(o)) continue;
                LOG.info("Leader doesn't contain ephemeral from follower {} zxid 0x{}", (Object)o, (Object)Long.toHexString(clean.getDataTree().getNode((String)o).stat.getMzxid()));
            }
            Assertions.assertEquals((int)ephemerals.size(), (int)cleanEphemerals.size(), (String)"Should have same number of ephemerals in both followers");
            Assertions.assertEquals((int)lead.getEphemerals(l.longValue()).size(), (int)cleanEphemerals.size(), (String)"Leader should equal follower");
        }
    }

    @Test
    public void testFollowerSendsLastZxid() throws Exception {
        QuorumUtil qu = new QuorumUtil(1);
        qu.startAll();
        int index = 1;
        while (qu.getPeer((int)index).peer.follower == null) {
            ++index;
        }
        LOG.info("Connecting to follower: {}", (Object)index);
        TestableZooKeeper zk = FollowerResyncConcurrencyTest.createTestableClient("localhost:" + qu.getPeer((int)index).peer.getClientPort());
        Assertions.assertEquals((long)0L, (long)zk.testableLastZxid());
        zk.exists("/", false);
        long lzxid = zk.testableLastZxid();
        Assertions.assertTrue((lzxid > 0L ? 1 : 0) != 0, (String)("lzxid:" + lzxid + " > 0"));
        zk.close();
        qu.shutdownAll();
    }

    @Test
    public void testFollowerWatcherResync() throws Exception {
        QuorumUtil qu = new QuorumUtil(1);
        qu.startAll();
        int index = 1;
        while (qu.getPeer((int)index).peer.follower == null) {
            ++index;
        }
        LOG.info("Connecting to follower: {}", (Object)index);
        TestableZooKeeper zk1 = FollowerResyncConcurrencyTest.createTestableClient("localhost:" + qu.getPeer((int)index).peer.getClientPort());
        zk1.create("/foo", "foo".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher watcher = new MyWatcher();
        TestableZooKeeper zk2 = FollowerResyncConcurrencyTest.createTestableClient(watcher, "localhost:" + qu.getPeer((int)index).peer.getClientPort());
        zk2.exists("/foo", true);
        watcher.reset();
        zk2.testableConnloss();
        if (!watcher.clientConnected.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS)) {
            Assertions.fail((String)"Unable to connect to server");
        }
        Assertions.assertArrayEquals((byte[])"foo".getBytes(), (byte[])zk2.getData("/foo", false, null));
        Assertions.assertNull((Object)watcher.events.poll(5L, TimeUnit.SECONDS));
        zk1.close();
        zk2.close();
        qu.shutdownAll();
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        LinkedBlockingQueue<WatchedEvent> events = new LinkedBlockingQueue();

        private MyWatcher() {
        }

        @Override
        public void process(WatchedEvent event) {
            super.process(event);
            if (event.getType() != Watcher.Event.EventType.None) {
                try {
                    this.events.put(event);
                }
                catch (InterruptedException e) {
                    LOG.warn("ignoring interrupt during event.put");
                }
            }
        }
    }
}

