/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Struct;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.EquivalentAddressGroup;
import io.grpc.HttpConnectProxiedSocketAddress;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.StatusOr;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.ObjectPool;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.util.OutlierDetectionLoadBalancer;
import io.grpc.xds.AddressFilter;
import io.grpc.xds.ClusterImplLoadBalancerProvider;
import io.grpc.xds.ClusterResolverLoadBalancerProvider;
import io.grpc.xds.Endpoints;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.PriorityLoadBalancerProvider;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsEndpointResource;
import io.grpc.xds.client.Bootstrapper;
import io.grpc.xds.client.Locality;
import io.grpc.xds.client.XdsClient;
import io.grpc.xds.client.XdsLogger;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class ClusterResolverLoadBalancer
extends LoadBalancer {
    private static final Locality LOGICAL_DNS_CLUSTER_LOCALITY = Locality.create("", "", "");
    private final XdsLogger logger;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private final LoadBalancerRegistry lbRegistry;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final GracefulSwitchLoadBalancer delegate;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private ClusterResolverLoadBalancerProvider.ClusterResolverConfig config;

    ClusterResolverLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry(), (BackoffPolicy.Provider)new ExponentialBackoffPolicy.Provider());
    }

    @VisibleForTesting
    ClusterResolverLoadBalancer(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry, BackoffPolicy.Provider backoffPolicyProvider) {
        this.lbRegistry = (LoadBalancerRegistry)Preconditions.checkNotNull((Object)lbRegistry, (Object)"lbRegistry");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)helper.getSynchronizationContext(), (Object)"syncContext");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)helper.getScheduledExecutorService(), (Object)"timeService");
        this.delegate = new GracefulSwitchLoadBalancer(helper);
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"cluster-resolver-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created", new Object[0]);
    }

    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        ClusterResolverLoadBalancerProvider.ClusterResolverConfig config;
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        if (this.xdsClientPool == null) {
            this.xdsClientPool = (ObjectPool)resolvedAddresses.getAttributes().get(XdsAttributes.XDS_CLIENT_POOL);
            this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        }
        if (!Objects.equals(this.config, config = (ClusterResolverLoadBalancerProvider.ClusterResolverConfig)resolvedAddresses.getLoadBalancingPolicyConfig())) {
            this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Config: {0}", config);
            this.config = config;
            Object gracefulConfig = GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig((LoadBalancer.Factory)new ClusterResolverLbStateFactory(), (Object)config);
            this.delegate.handleResolvedAddresses(resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(gracefulConfig).build());
        }
        return Status.OK;
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        this.delegate.handleNameResolutionError(error);
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown", new Object[0]);
        this.delegate.shutdown();
        if (this.xdsClientPool != null) {
            this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    private static PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig generateDnsBasedPriorityChildConfig(String cluster, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext, Map<String, Struct> filterMetadata, LoadBalancerRegistry lbRegistry, List<Endpoints.DropOverload> dropOverloads) {
        Object endpointLbConfig = GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig((LoadBalancer.Factory)lbRegistry.getProvider("pick_first"), null);
        ClusterImplLoadBalancerProvider.ClusterImplConfig clusterImplConfig = new ClusterImplLoadBalancerProvider.ClusterImplConfig(cluster, null, lrsServerInfo, maxConcurrentRequests, dropOverloads, endpointLbConfig, tlsContext, filterMetadata);
        LoadBalancerProvider clusterImplLbProvider = lbRegistry.getProvider("cluster_impl_experimental");
        Object clusterImplPolicy = GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig((LoadBalancer.Factory)clusterImplLbProvider, (Object)clusterImplConfig);
        return new PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig(clusterImplPolicy, false);
    }

    private static Map<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> generateEdsBasedPriorityChildConfigs(String cluster, @Nullable String edsServiceName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext, Map<String, Struct> filterMetadata, @Nullable EnvoyServerProtoData.OutlierDetection outlierDetection, Object endpointLbConfig, LoadBalancerRegistry lbRegistry, Map<String, Map<Locality, Integer>> prioritizedLocalityWeights, List<Endpoints.DropOverload> dropOverloads) {
        HashMap<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> configs = new HashMap<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig>();
        for (String priority : prioritizedLocalityWeights.keySet()) {
            ClusterImplLoadBalancerProvider.ClusterImplConfig clusterImplConfig = new ClusterImplLoadBalancerProvider.ClusterImplConfig(cluster, edsServiceName, lrsServerInfo, maxConcurrentRequests, dropOverloads, endpointLbConfig, tlsContext, filterMetadata);
            LoadBalancerProvider clusterImplLbProvider = lbRegistry.getProvider("cluster_impl_experimental");
            Object priorityChildPolicy = GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig((LoadBalancer.Factory)clusterImplLbProvider, (Object)clusterImplConfig);
            if (outlierDetection != null) {
                LoadBalancerProvider outlierDetectionProvider = lbRegistry.getProvider("outlier_detection_experimental");
                priorityChildPolicy = GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig((LoadBalancer.Factory)outlierDetectionProvider, (Object)ClusterResolverLoadBalancer.buildOutlierDetectionLbConfig(outlierDetection, priorityChildPolicy));
            }
            PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig priorityChildConfig = new PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig(priorityChildPolicy, true);
            configs.put(priority, priorityChildConfig);
        }
        return configs;
    }

    private static OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig buildOutlierDetectionLbConfig(EnvoyServerProtoData.OutlierDetection outlierDetection, Object childConfig) {
        EnvoyServerProtoData.FailurePercentageEjection failurePercentage;
        EnvoyServerProtoData.SuccessRateEjection successRate;
        OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.Builder configBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.Builder();
        configBuilder.setChildConfig(childConfig);
        if (outlierDetection.intervalNanos() != null) {
            configBuilder.setIntervalNanos(outlierDetection.intervalNanos());
        }
        if (outlierDetection.baseEjectionTimeNanos() != null) {
            configBuilder.setBaseEjectionTimeNanos(outlierDetection.baseEjectionTimeNanos());
        }
        if (outlierDetection.maxEjectionTimeNanos() != null) {
            configBuilder.setMaxEjectionTimeNanos(outlierDetection.maxEjectionTimeNanos());
        }
        if (outlierDetection.maxEjectionPercent() != null) {
            configBuilder.setMaxEjectionPercent(outlierDetection.maxEjectionPercent());
        }
        if ((successRate = outlierDetection.successRateEjection()) != null) {
            OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.SuccessRateEjection.Builder successRateConfigBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.SuccessRateEjection.Builder();
            if (successRate.stdevFactor() != null) {
                successRateConfigBuilder.setStdevFactor(successRate.stdevFactor());
            }
            if (successRate.enforcementPercentage() != null) {
                successRateConfigBuilder.setEnforcementPercentage(successRate.enforcementPercentage());
            }
            if (successRate.minimumHosts() != null) {
                successRateConfigBuilder.setMinimumHosts(successRate.minimumHosts());
            }
            if (successRate.requestVolume() != null) {
                successRateConfigBuilder.setRequestVolume(successRate.requestVolume());
            }
            configBuilder.setSuccessRateEjection(successRateConfigBuilder.build());
        }
        if ((failurePercentage = outlierDetection.failurePercentageEjection()) != null) {
            OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.FailurePercentageEjection.Builder failurePercentageConfigBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.FailurePercentageEjection.Builder();
            if (failurePercentage.threshold() != null) {
                failurePercentageConfigBuilder.setThreshold(failurePercentage.threshold());
            }
            if (failurePercentage.enforcementPercentage() != null) {
                failurePercentageConfigBuilder.setEnforcementPercentage(failurePercentage.enforcementPercentage());
            }
            if (failurePercentage.minimumHosts() != null) {
                failurePercentageConfigBuilder.setMinimumHosts(failurePercentage.minimumHosts());
            }
            if (failurePercentage.requestVolume() != null) {
                failurePercentageConfigBuilder.setRequestVolume(failurePercentage.requestVolume());
            }
            configBuilder.setFailurePercentageEjection(failurePercentageConfigBuilder.build());
        }
        return configBuilder.build();
    }

    private static String priorityName(String cluster, int priority) {
        return cluster + "[child" + priority + "]";
    }

    private static String localityName(Locality locality) {
        return "{region=\"" + locality.region() + "\", zone=\"" + locality.zone() + "\", sub_zone=\"" + locality.subZone() + "\"}";
    }

    private static class ClusterResolutionResult {
        private final List<EquivalentAddressGroup> addresses;
        private final Map<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> priorityChildConfigs;
        private final List<String> priorities;

        ClusterResolutionResult(List<EquivalentAddressGroup> addresses, String priority, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig config) {
            this(addresses, Collections.singletonMap(priority, config), Collections.singletonList(priority));
        }

        ClusterResolutionResult(List<EquivalentAddressGroup> addresses, Map<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> configs, List<String> priorities) {
            this.addresses = addresses;
            this.priorityChildConfigs = configs;
            this.priorities = priorities;
        }
    }

    private final class ClusterResolverLbState
    extends LoadBalancer {
        private final LoadBalancer.Helper helper;
        private final List<String> clusters = new ArrayList<String>();
        private final Map<String, ClusterState> clusterStates = new HashMap<String, ClusterState>();
        private Object endpointLbConfig;
        private LoadBalancer.ResolvedAddresses resolvedAddresses;
        private LoadBalancer childLb;

        ClusterResolverLbState(LoadBalancer.Helper helper) {
            this.helper = new RefreshableHelper((LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper"));
            ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "New ClusterResolverLbState", new Object[0]);
        }

        public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
            this.resolvedAddresses = resolvedAddresses;
            ClusterResolverLoadBalancerProvider.ClusterResolverConfig config = (ClusterResolverLoadBalancerProvider.ClusterResolverConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
            this.endpointLbConfig = config.lbConfig;
            for (ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism instance : config.discoveryMechanisms) {
                this.clusters.add(instance.cluster);
                ClusterState state = instance.type == ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism.Type.EDS ? new EdsClusterState(instance.cluster, instance.edsServiceName, instance.lrsServerInfo, instance.maxConcurrentRequests, instance.tlsContext, instance.filterMetadata, instance.outlierDetection) : new LogicalDnsClusterState(instance.cluster, instance.dnsHostName, instance.lrsServerInfo, instance.maxConcurrentRequests, instance.tlsContext, instance.filterMetadata);
                this.clusterStates.put(instance.cluster, state);
                state.start();
            }
            return Status.OK;
        }

        public void handleNameResolutionError(Status error) {
            if (this.childLb != null) {
                this.childLb.handleNameResolutionError(error);
            } else {
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError((Status)error)));
            }
        }

        public void shutdown() {
            for (ClusterState state : this.clusterStates.values()) {
                state.shutdown();
            }
            if (this.childLb != null) {
                this.childLb.shutdown();
            }
        }

        private void handleEndpointResourceUpdate() {
            ArrayList addresses = new ArrayList();
            HashMap priorityChildConfigs = new HashMap();
            ArrayList priorities = new ArrayList();
            Status endpointNotFound = Status.OK;
            for (String cluster : this.clusters) {
                ClusterState state = this.clusterStates.get(cluster);
                if (!state.resolved && state.status.isOk()) {
                    return;
                }
                if (state.result != null) {
                    addresses.addAll(state.result.addresses);
                    priorityChildConfigs.putAll(state.result.priorityChildConfigs);
                    priorities.addAll(state.result.priorities);
                    continue;
                }
                endpointNotFound = state.status;
            }
            if (addresses.isEmpty()) {
                endpointNotFound = endpointNotFound.isOk() ? Status.UNAVAILABLE.withDescription("No usable endpoint from cluster(s): " + this.clusters) : Status.UNAVAILABLE.withCause(endpointNotFound.getCause()).withDescription(endpointNotFound.getDescription());
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError((Status)endpointNotFound)));
                if (this.childLb != null) {
                    this.childLb.shutdown();
                    this.childLb = null;
                }
                return;
            }
            PriorityLoadBalancerProvider.PriorityLbConfig childConfig = new PriorityLoadBalancerProvider.PriorityLbConfig(Collections.unmodifiableMap(priorityChildConfigs), Collections.unmodifiableList(priorities));
            if (this.childLb == null) {
                this.childLb = ClusterResolverLoadBalancer.this.lbRegistry.getProvider("priority_experimental").newLoadBalancer(this.helper);
            }
            this.childLb.handleResolvedAddresses(this.resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig((Object)childConfig).setAddresses(Collections.unmodifiableList(addresses)).build());
        }

        private void handleEndpointResolutionError() {
            boolean allInError = true;
            Status error = null;
            for (String cluster : this.clusters) {
                ClusterState state = this.clusterStates.get(cluster);
                if (state.status.isOk()) {
                    allInError = false;
                    continue;
                }
                error = state.status;
            }
            if (allInError) {
                if (this.childLb != null) {
                    this.childLb.handleNameResolutionError(error);
                } else {
                    this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(error)));
                }
            }
        }

        private final class LogicalDnsClusterState
        extends ClusterState {
            private final String dnsHostName;
            private final NameResolver.Factory nameResolverFactory;
            private final NameResolver.Args nameResolverArgs;
            private NameResolver resolver;
            @Nullable
            private BackoffPolicy backoffPolicy;
            @Nullable
            private SynchronizationContext.ScheduledHandle scheduledRefresh;

            private LogicalDnsClusterState(String name, @Nullable String dnsHostName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, EnvoyServerProtoData.UpstreamTlsContext tlsContext, Map<String, Struct> filterMetadata) {
                super(name, lrsServerInfo, maxConcurrentRequests, tlsContext, filterMetadata, null);
                this.dnsHostName = (String)Preconditions.checkNotNull((Object)dnsHostName, (Object)"dnsHostName");
                this.nameResolverFactory = (NameResolver.Factory)Preconditions.checkNotNull((Object)ClusterResolverLbState.this.helper.getNameResolverRegistry().asFactory(), (Object)"nameResolverFactory");
                this.nameResolverArgs = (NameResolver.Args)Preconditions.checkNotNull((Object)ClusterResolverLbState.this.helper.getNameResolverArgs(), (Object)"nameResolverArgs");
            }

            @Override
            void start() {
                URI uri;
                try {
                    uri = new URI("dns", "", "/" + this.dnsHostName, null);
                }
                catch (URISyntaxException e) {
                    this.status = Status.INTERNAL.withDescription("Bug, invalid URI creation: " + this.dnsHostName).withCause((Throwable)e);
                    ClusterResolverLbState.this.handleEndpointResolutionError();
                    return;
                }
                this.resolver = this.nameResolverFactory.newNameResolver(uri, this.nameResolverArgs);
                if (this.resolver == null) {
                    this.status = Status.INTERNAL.withDescription("Xds cluster resolver lb for logical DNS cluster [" + this.name + "] cannot find DNS resolver with uri:" + uri);
                    ClusterResolverLbState.this.handleEndpointResolutionError();
                    return;
                }
                this.resolver.start((NameResolver.Listener2)new NameResolverListener(this.dnsHostName));
            }

            void refresh() {
                if (this.resolver == null) {
                    return;
                }
                this.cancelBackoff();
                this.resolver.refresh();
            }

            @Override
            void shutdown() {
                super.shutdown();
                if (this.resolver != null) {
                    this.resolver.shutdown();
                }
                this.cancelBackoff();
            }

            private void cancelBackoff() {
                if (this.scheduledRefresh != null) {
                    this.scheduledRefresh.cancel();
                    this.scheduledRefresh = null;
                    this.backoffPolicy = null;
                }
            }

            private class NameResolverListener
            extends NameResolver.Listener2 {
                private final String dnsHostName;

                NameResolverListener(String dnsHostName) {
                    this.dnsHostName = dnsHostName;
                }

                public void onResult(NameResolver.ResolutionResult resolutionResult) {
                    ClusterResolverLoadBalancer.this.syncContext.execute(() -> this.onResult2(resolutionResult));
                }

                public Status onResult2(NameResolver.ResolutionResult resolutionResult) {
                    if (LogicalDnsClusterState.this.shutdown) {
                        return Status.OK;
                    }
                    String priorityName = ClusterResolverLoadBalancer.priorityName(LogicalDnsClusterState.this.name, 0);
                    ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
                    StatusOr addressesOrError = resolutionResult.getAddressesOrError();
                    if (addressesOrError.hasValue()) {
                        LogicalDnsClusterState.this.backoffPolicy = null;
                        for (EquivalentAddressGroup eag : resolutionResult.getAddresses()) {
                            String localityName = ClusterResolverLoadBalancer.localityName(LOGICAL_DNS_CLUSTER_LOCALITY);
                            Attributes attr = eag.getAttributes().toBuilder().set(XdsAttributes.ATTR_LOCALITY, (Object)LOGICAL_DNS_CLUSTER_LOCALITY).set(XdsAttributes.ATTR_LOCALITY_NAME, (Object)localityName).set(XdsAttributes.ATTR_ADDRESS_NAME, (Object)this.dnsHostName).build();
                            eag = new EquivalentAddressGroup(eag.getAddresses(), attr);
                            eag = AddressFilter.setPathFilter(eag, Arrays.asList(priorityName, localityName));
                            addresses.add(eag);
                        }
                        PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig priorityChildConfig = ClusterResolverLoadBalancer.generateDnsBasedPriorityChildConfig(LogicalDnsClusterState.this.name, LogicalDnsClusterState.this.lrsServerInfo, LogicalDnsClusterState.this.maxConcurrentRequests, LogicalDnsClusterState.this.tlsContext, LogicalDnsClusterState.this.filterMetadata, ClusterResolverLoadBalancer.this.lbRegistry, Collections.emptyList());
                        LogicalDnsClusterState.this.status = Status.OK;
                        LogicalDnsClusterState.this.resolved = true;
                        LogicalDnsClusterState.this.result = new ClusterResolutionResult(addresses, priorityName, priorityChildConfig);
                        ClusterResolverLbState.this.handleEndpointResourceUpdate();
                        return Status.OK;
                    }
                    this.handleErrorInSyncContext(addressesOrError.getStatus());
                    return addressesOrError.getStatus();
                }

                public void onError(Status error) {
                    ClusterResolverLoadBalancer.this.syncContext.execute(() -> this.handleErrorInSyncContext(error));
                }

                private void handleErrorInSyncContext(Status error) {
                    if (LogicalDnsClusterState.this.shutdown) {
                        return;
                    }
                    LogicalDnsClusterState.this.status = error;
                    if (!LogicalDnsClusterState.this.resolved) {
                        LogicalDnsClusterState.this.resolved = true;
                        ClusterResolverLbState.this.handleEndpointResourceUpdate();
                    } else {
                        ClusterResolverLbState.this.handleEndpointResolutionError();
                    }
                    if (LogicalDnsClusterState.this.scheduledRefresh != null && LogicalDnsClusterState.this.scheduledRefresh.isPending()) {
                        return;
                    }
                    if (LogicalDnsClusterState.this.backoffPolicy == null) {
                        LogicalDnsClusterState.this.backoffPolicy = ClusterResolverLoadBalancer.this.backoffPolicyProvider.get();
                    }
                    long delayNanos = LogicalDnsClusterState.this.backoffPolicy.nextBackoffNanos();
                    ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Logical DNS resolver for cluster {0} encountered name resolution error: {1}, scheduling DNS resolution backoff for {2} ns", LogicalDnsClusterState.this.name, error, delayNanos);
                    LogicalDnsClusterState.this.scheduledRefresh = ClusterResolverLoadBalancer.this.syncContext.schedule((Runnable)new DelayedNameResolverRefresh(), delayNanos, TimeUnit.NANOSECONDS, ClusterResolverLoadBalancer.this.timeService);
                }
            }

            private class DelayedNameResolverRefresh
            implements Runnable {
                private DelayedNameResolverRefresh() {
                }

                @Override
                public void run() {
                    LogicalDnsClusterState.this.scheduledRefresh = null;
                    if (!LogicalDnsClusterState.this.shutdown) {
                        LogicalDnsClusterState.this.resolver.refresh();
                    }
                }
            }
        }

        private final class EdsClusterState
        extends ClusterState
        implements XdsClient.ResourceWatcher<XdsEndpointResource.EdsUpdate> {
            @Nullable
            private final String edsServiceName;
            private Map<Locality, String> localityPriorityNames;
            int priorityNameGenId;

            private EdsClusterState(@Nullable String name, @Nullable String edsServiceName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, EnvoyServerProtoData.UpstreamTlsContext tlsContext, @Nullable Map<String, Struct> filterMetadata, EnvoyServerProtoData.OutlierDetection outlierDetection) {
                super(name, lrsServerInfo, maxConcurrentRequests, tlsContext, filterMetadata, outlierDetection);
                this.localityPriorityNames = Collections.emptyMap();
                this.priorityNameGenId = 1;
                this.edsServiceName = edsServiceName;
            }

            @Override
            void start() {
                String resourceName = this.edsServiceName != null ? this.edsServiceName : this.name;
                ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start watching EDS resource {0}", resourceName);
                ClusterResolverLoadBalancer.this.xdsClient.watchXdsResource(XdsEndpointResource.getInstance(), resourceName, this, (Executor)ClusterResolverLoadBalancer.this.syncContext);
            }

            @Override
            protected void shutdown() {
                super.shutdown();
                String resourceName = this.edsServiceName != null ? this.edsServiceName : this.name;
                ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stop watching EDS resource {0}", resourceName);
                ClusterResolverLoadBalancer.this.xdsClient.cancelXdsResourceWatch(XdsEndpointResource.getInstance(), resourceName, this);
            }

            @Override
            public void onChanged(final XdsEndpointResource.EdsUpdate update) {
                class EndpointsUpdated
                implements Runnable {
                    EndpointsUpdated() {
                    }

                    @Override
                    public void run() {
                        if (EdsClusterState.this.shutdown) {
                            return;
                        }
                        ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received endpoint update {0}", update);
                        if (ClusterResolverLoadBalancer.this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
                            ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cluster {0}: {1} localities, {2} drop categories", update.clusterName, update.localityLbEndpointsMap.size(), update.dropPolicies.size());
                        }
                        Map<Locality, Endpoints.LocalityLbEndpoints> localityLbEndpoints = update.localityLbEndpointsMap;
                        List<Endpoints.DropOverload> dropOverloads = update.dropPolicies;
                        ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
                        HashMap prioritizedLocalityWeights = new HashMap();
                        List sortedPriorityNames = EdsClusterState.this.generatePriorityNames(EdsClusterState.this.name, localityLbEndpoints);
                        for (Locality locality : localityLbEndpoints.keySet()) {
                            Endpoints.LocalityLbEndpoints localityLbInfo = localityLbEndpoints.get(locality);
                            String priorityName = (String)EdsClusterState.this.localityPriorityNames.get(locality);
                            boolean discard = true;
                            for (Endpoints.LbEndpoint endpoint : localityLbInfo.endpoints()) {
                                EquivalentAddressGroup eag;
                                if (!endpoint.isHealthy()) continue;
                                discard = false;
                                long weight = localityLbInfo.localityWeight();
                                if (endpoint.loadBalancingWeight() != 0) {
                                    weight *= (long)endpoint.loadBalancingWeight();
                                }
                                String localityName = ClusterResolverLoadBalancer.localityName(locality);
                                Attributes attr = endpoint.eag().getAttributes().toBuilder().set(XdsAttributes.ATTR_LOCALITY, (Object)locality).set(XdsAttributes.ATTR_LOCALITY_NAME, (Object)localityName).set(XdsAttributes.ATTR_LOCALITY_WEIGHT, (Object)localityLbInfo.localityWeight()).set(XdsAttributes.ATTR_SERVER_WEIGHT, (Object)weight).set(XdsAttributes.ATTR_ADDRESS_NAME, (Object)endpoint.hostname()).build();
                                if (ClusterResolverLoadBalancer.this.config.isHttp11ProxyAvailable()) {
                                    ArrayList<SocketAddress> rewrittenAddresses = new ArrayList<SocketAddress>();
                                    for (SocketAddress addr : endpoint.eag().getAddresses()) {
                                        rewrittenAddresses.add(EdsClusterState.this.rewriteAddress(addr, (ImmutableMap<String, Object>)endpoint.endpointMetadata(), (ImmutableMap<String, Object>)localityLbInfo.localityMetadata()));
                                    }
                                    eag = new EquivalentAddressGroup(rewrittenAddresses, attr);
                                } else {
                                    eag = new EquivalentAddressGroup(endpoint.eag().getAddresses(), attr);
                                }
                                eag = AddressFilter.setPathFilter(eag, Arrays.asList(priorityName, localityName));
                                addresses.add(eag);
                            }
                            if (discard) {
                                ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Discard locality {0} with 0 healthy endpoints", locality);
                                continue;
                            }
                            if (!prioritizedLocalityWeights.containsKey(priorityName)) {
                                prioritizedLocalityWeights.put(priorityName, new HashMap());
                            }
                            ((Map)prioritizedLocalityWeights.get(priorityName)).put(locality, localityLbInfo.localityWeight());
                        }
                        if (prioritizedLocalityWeights.isEmpty()) {
                            ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cluster {0} has no usable priority/locality/endpoint", update.clusterName);
                        }
                        sortedPriorityNames.retainAll(prioritizedLocalityWeights.keySet());
                        Map priorityChildConfigs = ClusterResolverLoadBalancer.generateEdsBasedPriorityChildConfigs(EdsClusterState.this.name, EdsClusterState.this.edsServiceName, EdsClusterState.this.lrsServerInfo, EdsClusterState.this.maxConcurrentRequests, EdsClusterState.this.tlsContext, EdsClusterState.this.filterMetadata, EdsClusterState.this.outlierDetection, ClusterResolverLbState.this.endpointLbConfig, ClusterResolverLoadBalancer.this.lbRegistry, prioritizedLocalityWeights, dropOverloads);
                        EdsClusterState.this.status = Status.OK;
                        EdsClusterState.this.resolved = true;
                        EdsClusterState.this.result = new ClusterResolutionResult(addresses, priorityChildConfigs, sortedPriorityNames);
                        ClusterResolverLbState.this.handleEndpointResourceUpdate();
                    }
                }
                new EndpointsUpdated().run();
            }

            private SocketAddress rewriteAddress(SocketAddress addr, ImmutableMap<String, Object> endpointMetadata, ImmutableMap<String, Object> localityMetadata) {
                SocketAddress proxyAddress;
                if (!(addr instanceof InetSocketAddress)) {
                    return addr;
                }
                try {
                    proxyAddress = (SocketAddress)endpointMetadata.get((Object)"envoy.http11_proxy_transport_socket.proxy_address");
                    if (proxyAddress == null) {
                        proxyAddress = (SocketAddress)localityMetadata.get((Object)"envoy.http11_proxy_transport_socket.proxy_address");
                    }
                }
                catch (ClassCastException e) {
                    return addr;
                }
                if (proxyAddress == null) {
                    return addr;
                }
                return HttpConnectProxiedSocketAddress.newBuilder().setTargetAddress((InetSocketAddress)addr).setProxyAddress(proxyAddress).build();
            }

            private List<String> generatePriorityNames(String name, Map<Locality, Endpoints.LocalityLbEndpoints> localityLbEndpoints) {
                TreeMap todo = new TreeMap();
                for (Locality locality : localityLbEndpoints.keySet()) {
                    int priority = localityLbEndpoints.get(locality).priority();
                    if (!todo.containsKey(priority)) {
                        todo.put(priority, new ArrayList());
                    }
                    ((List)todo.get(priority)).add(locality);
                }
                HashMap<Locality, String> newNames = new HashMap<Locality, String>();
                HashSet<String> usedNames = new HashSet<String>();
                ArrayList<String> ret = new ArrayList<String>();
                for (Integer priority : todo.keySet()) {
                    String foundName = "";
                    for (Locality locality : (List)todo.get(priority)) {
                        if (!this.localityPriorityNames.containsKey(locality) || !usedNames.add(this.localityPriorityNames.get(locality))) continue;
                        foundName = this.localityPriorityNames.get(locality);
                        break;
                    }
                    if ("".equals(foundName)) {
                        foundName = String.format(Locale.US, "%s[child%d]", name, this.priorityNameGenId++);
                    }
                    for (Locality locality : (List)todo.get(priority)) {
                        newNames.put(locality, foundName);
                    }
                    ret.add(foundName);
                }
                this.localityPriorityNames = newNames;
                return ret;
            }

            @Override
            public void onResourceDoesNotExist(String resourceName) {
                if (this.shutdown) {
                    return;
                }
                ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Resource {0} unavailable", resourceName);
                this.status = Status.OK;
                this.resolved = true;
                this.result = null;
                ClusterResolverLbState.this.handleEndpointResourceUpdate();
            }

            @Override
            public void onError(Status error) {
                if (this.shutdown) {
                    return;
                }
                String resourceName = this.edsServiceName != null ? this.edsServiceName : this.name;
                this.status = Status.UNAVAILABLE.withDescription(String.format("Unable to load EDS %s. xDS server returned: %s: %s", resourceName, error.getCode(), error.getDescription())).withCause(error.getCause());
                ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received EDS error: {0}", error);
                ClusterResolverLbState.this.handleEndpointResolutionError();
            }
        }

        private abstract class ClusterState {
            protected final String name;
            @Nullable
            protected final Bootstrapper.ServerInfo lrsServerInfo;
            @Nullable
            protected final Long maxConcurrentRequests;
            @Nullable
            protected final EnvoyServerProtoData.UpstreamTlsContext tlsContext;
            protected final Map<String, Struct> filterMetadata;
            @Nullable
            protected final EnvoyServerProtoData.OutlierDetection outlierDetection;
            protected Status status = Status.OK;
            protected boolean resolved;
            @Nullable
            protected ClusterResolutionResult result;
            protected boolean shutdown;

            private ClusterState(@Nullable String name, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, EnvoyServerProtoData.UpstreamTlsContext tlsContext, @Nullable Map<String, Struct> filterMetadata, EnvoyServerProtoData.OutlierDetection outlierDetection) {
                this.name = name;
                this.lrsServerInfo = lrsServerInfo;
                this.maxConcurrentRequests = maxConcurrentRequests;
                this.tlsContext = tlsContext;
                this.filterMetadata = ImmutableMap.copyOf(filterMetadata);
                this.outlierDetection = outlierDetection;
            }

            abstract void start();

            void shutdown() {
                this.shutdown = true;
            }
        }

        private final class RefreshableHelper
        extends ForwardingLoadBalancerHelper {
            private final LoadBalancer.Helper delegate;

            private RefreshableHelper(LoadBalancer.Helper delegate) {
                this.delegate = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
            }

            public void refreshNameResolution() {
                for (ClusterState state : ClusterResolverLbState.this.clusterStates.values()) {
                    if (!(state instanceof LogicalDnsClusterState)) continue;
                    ((LogicalDnsClusterState)state).refresh();
                }
            }

            protected LoadBalancer.Helper delegate() {
                return this.delegate;
            }
        }
    }

    private final class ClusterResolverLbStateFactory
    extends LoadBalancer.Factory {
        private ClusterResolverLbStateFactory() {
        }

        public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
            return new ClusterResolverLbState(helper);
        }
    }
}

