/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.otel;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.Meter;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.otel.ScopeContext;

class OtelCounter
implements Counter {
    private final LongUpDownCounter counter;
    private final Attributes attributes;

    OtelCounter(Meter meter, ScopeContext sc) {
        this.counter = meter.upDownCounterBuilder(sc.getName()).build();
        this.attributes = sc.getAttributes();
    }

    public void clear() {
    }

    public void inc() {
        this.counter.add(1L, this.attributes);
    }

    public void dec() {
        this.counter.add(-1L, this.attributes);
    }

    public void addCount(long delta) {
        this.counter.add(delta, this.attributes);
    }

    public void addLatency(long eventLatency, TimeUnit unit) {
        long valueMillis = unit.toMillis(eventLatency);
        this.counter.add(valueMillis);
    }

    public Long get() {
        return -1L;
    }
}

