/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.Host;
import org.jclouds.javax.annotation.Nullable;

public class Cluster
implements Comparable<Cluster> {
    private final String id;
    private final AllocationState allocationState;
    private final Host.ClusterType clusterType;
    private final String hypervisor;
    private final ManagedState managedState;
    private final String name;
    private final String podId;
    private final String podName;
    private final String zoneId;
    private final String zoneName;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromCluster(this);
    }

    @ConstructorProperties(value={"id", "allocationstate", "clustertype", "hypervisortype", "managedstate", "name", "podid", "podname", "zoneid", "zonename"})
    protected Cluster(String id, @Nullable AllocationState allocationState, @Nullable Host.ClusterType clusterType, @Nullable String hypervisor, @Nullable ManagedState managedState, @Nullable String name, @Nullable String podId, @Nullable String podName, @Nullable String zoneId, @Nullable String zoneName) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.allocationState = allocationState;
        this.clusterType = clusterType;
        this.hypervisor = hypervisor;
        this.managedState = managedState;
        this.name = name;
        this.podId = podId;
        this.podName = podName;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public AllocationState getAllocationState() {
        return this.allocationState;
    }

    @Nullable
    public Host.ClusterType getClusterType() {
        return this.clusterType;
    }

    @Nullable
    public String getHypervisor() {
        return this.hypervisor;
    }

    @Nullable
    public ManagedState getManagedState() {
        return this.managedState;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getPodId() {
        return this.podId;
    }

    @Nullable
    public String getPodName() {
        return this.podName;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    @Nullable
    public String getZoneName() {
        return this.zoneName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.allocationState, this.clusterType, this.hypervisor, this.managedState, this.name, this.podId, this.podName, this.zoneId, this.zoneName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cluster that = (Cluster)Cluster.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)((Object)this.allocationState), (Object)((Object)that.allocationState)) && Objects.equal((Object)((Object)this.clusterType), (Object)((Object)that.clusterType)) && Objects.equal((Object)this.hypervisor, (Object)that.hypervisor) && Objects.equal((Object)((Object)this.managedState), (Object)((Object)that.managedState)) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.podId, (Object)that.podId) && Objects.equal((Object)this.podName, (Object)that.podName) && Objects.equal((Object)this.zoneId, (Object)that.zoneId) && Objects.equal((Object)this.zoneName, (Object)that.zoneName);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("allocationState", (Object)this.allocationState).add("clusterType", (Object)this.clusterType).add("hypervisor", (Object)this.hypervisor).add("managedState", (Object)this.managedState).add("name", (Object)this.name).add("podId", (Object)this.podId).add("podName", (Object)this.podName).add("zoneId", (Object)this.zoneId).add("zoneName", (Object)this.zoneName);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Cluster other) {
        return this.id.compareTo(other.id);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected AllocationState allocationState;
        protected Host.ClusterType clusterType;
        protected String hypervisor;
        protected ManagedState managedState;
        protected String name;
        protected String podId;
        protected String podName;
        protected String zoneId;
        protected String zoneName;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T allocationState(AllocationState allocationState) {
            this.allocationState = allocationState;
            return this.self();
        }

        public T clusterType(Host.ClusterType clusterType) {
            this.clusterType = clusterType;
            return this.self();
        }

        public T hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this.self();
        }

        public T managedState(ManagedState managedState) {
            this.managedState = managedState;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T podId(String podId) {
            this.podId = podId;
            return this.self();
        }

        public T podName(String podName) {
            this.podName = podName;
            return this.self();
        }

        public T zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public T zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this.self();
        }

        public Cluster build() {
            return new Cluster(this.id, this.allocationState, this.clusterType, this.hypervisor, this.managedState, this.name, this.podId, this.podName, this.zoneId, this.zoneName);
        }

        public T fromCluster(Cluster in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).allocationState(in.getAllocationState())).clusterType(in.getClusterType())).hypervisor(in.getHypervisor())).managedState(in.getManagedState())).name(in.getName())).podId(in.getPodId())).podName(in.getPodName())).zoneId(in.getZoneId())).zoneName(in.getZoneName());
        }
    }

    public static enum ManagedState {
        MANAGED,
        PREPARE_UNMANAGED,
        UNMANAGED,
        PREPARE_UNMANAGED_ERROR,
        UNRECOGNIZED;


        public static ManagedState fromValue(String value) {
            try {
                return ManagedState.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }
}

