/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.group.DynamicClusterImpl;
import org.apache.brooklyn.entity.webapp.DynamicWebAppCluster;
import org.apache.brooklyn.entity.webapp.FilenameToWebContextMapper;
import org.apache.brooklyn.entity.webapp.JavaWebAppService;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicWebAppClusterImpl
extends DynamicClusterImpl
implements DynamicWebAppCluster {
    private static final Logger log = LoggerFactory.getLogger(DynamicWebAppClusterImpl.class);
    private static final FilenameToWebContextMapper FILENAME_TO_WEB_CONTEXT_MAPPER = new FilenameToWebContextMapper();

    public void init() {
        AttributeSensor t;
        super.init();
        ImmutableList summingEnricherSetup = ImmutableList.of((Object)ImmutableList.of((Object)REQUEST_COUNT, (Object)REQUEST_COUNT), (Object)ImmutableList.of((Object)ERROR_COUNT, (Object)ERROR_COUNT), (Object)ImmutableList.of((Object)REQUESTS_PER_SECOND_LAST, (Object)REQUESTS_PER_SECOND_LAST), (Object)ImmutableList.of((Object)REQUESTS_PER_SECOND_IN_WINDOW, (Object)REQUESTS_PER_SECOND_IN_WINDOW), (Object)ImmutableList.of((Object)TOTAL_PROCESSING_TIME, (Object)TOTAL_PROCESSING_TIME), (Object)ImmutableList.of((Object)PROCESSING_TIME_FRACTION_IN_WINDOW, (Object)PROCESSING_TIME_FRACTION_IN_WINDOW));
        ImmutableList averagingEnricherSetup = ImmutableList.of((Object)ImmutableList.of((Object)REQUEST_COUNT, (Object)REQUEST_COUNT_PER_NODE), (Object)ImmutableList.of((Object)ERROR_COUNT, (Object)ERROR_COUNT_PER_NODE), (Object)ImmutableList.of((Object)REQUESTS_PER_SECOND_LAST, (Object)REQUESTS_PER_SECOND_LAST_PER_NODE), (Object)ImmutableList.of((Object)REQUESTS_PER_SECOND_IN_WINDOW, (Object)REQUESTS_PER_SECOND_IN_WINDOW_PER_NODE), (Object)ImmutableList.of((Object)TOTAL_PROCESSING_TIME, (Object)TOTAL_PROCESSING_TIME_PER_NODE), (Object)ImmutableList.of((Object)PROCESSING_TIME_FRACTION_IN_WINDOW, (Object)PROCESSING_TIME_FRACTION_IN_WINDOW_PER_NODE));
        for (List es : summingEnricherSetup) {
            t = (AttributeSensor)es.get(0);
            AttributeSensor total = (AttributeSensor)es.get(1);
            this.enrichers().add(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(t).publishing(total).fromMembers()).computingSum()).build());
        }
        for (List es : averagingEnricherSetup) {
            t = (AttributeSensor)es.get(0);
            AttributeSensor average = (AttributeSensor)es.get(1);
            this.enrichers().add(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(t).publishing(average).fromMembers()).computingAverage()).defaultValueForUnreportedSensors((Object)0)).build());
        }
    }

    static <T> Task<T> whenServiceUp(final Entity target, final TaskAdaptable<T> task, String name) {
        return Tasks.builder().displayName(name).dynamic(true).body(new Callable<T>(){

            @Override
            public T call() {
                while (true) {
                    if (!Entities.isManaged((Entity)target)) {
                        Tasks.markInessential();
                        throw new IllegalStateException("Target " + target + " is no longer managed");
                    }
                    if (Boolean.TRUE.equals(target.getAttribute(Attributes.SERVICE_UP))) {
                        Object object;
                        Tasks.resetBlockingDetails();
                        TaskTags.markInessential((TaskAdaptable)task);
                        DynamicTasks.queue((TaskAdaptable)task);
                        try {
                            object = task.asTask().getUnchecked();
                        }
                        catch (Exception e) {
                            if (Entities.isManaged((Entity)target)) {
                                throw Exceptions.propagate((Throwable)e);
                            }
                            Tasks.markInessential();
                            throw new IllegalStateException("Target " + target + " is no longer managed", e);
                        }
                        return object;
                    }
                    Tasks.setBlockingDetails((String)("Waiting on " + target + " to be ready"));
                    Time.sleep((Duration)Duration.ONE_SECOND);
                }
                finally {
                    Tasks.resetBlockingDetails();
                }
            }
        }).build();
    }

    @Override
    public void deploy(String url, String targetName) {
        Preconditions.checkNotNull((Object)url, (Object)"url");
        Preconditions.checkNotNull((Object)targetName, (Object)"targetName");
        targetName = FILENAME_TO_WEB_CONTEXT_MAPPER.convertDeploymentTargetNameToContext(targetName);
        DynamicWebAppClusterImpl.addToWarsByContext(this, url, targetName);
        log.debug("Deploying " + targetName + "->" + url + " across cluster " + this + "; WARs now " + this.getConfig(WARS_BY_CONTEXT));
        Iterable targets = Iterables.filter((Iterable)this.getChildren(), JavaWebAppService.CanDeployAndUndeploy.class);
        TaskBuilder tb = Tasks.builder().parallel(true).displayName("Deploy " + targetName + " to cluster (size " + Iterables.size((Iterable)targets) + ")");
        for (Entity target : targets) {
            tb.add(DynamicWebAppClusterImpl.whenServiceUp(target, Effectors.invocation((Entity)target, (Effector)DEPLOY, (Map)MutableMap.of((Object)"url", (Object)url, (Object)"targetName", (Object)targetName)), "Deploy " + targetName + " to " + target + " when ready"));
        }
        DynamicTasks.queueIfPossible((TaskAdaptable)tb.build()).orSubmitAsync((Entity)this).asTask().getUnchecked();
        MutableSet deployedWars = MutableSet.copyOf((Iterable)((Iterable)this.getAttribute(DEPLOYED_WARS)));
        deployedWars.add(targetName);
        this.sensors().set(DEPLOYED_WARS, (Object)deployedWars);
    }

    @Override
    public void undeploy(String targetName) {
        Preconditions.checkNotNull((Object)targetName, (Object)"targetName");
        targetName = FILENAME_TO_WEB_CONTEXT_MAPPER.convertDeploymentTargetNameToContext(targetName);
        if (!DynamicWebAppClusterImpl.removeFromWarsByContext(this, targetName)) {
            DynamicTasks.submit((TaskAdaptable)Tasks.warning((String)("Context " + targetName + " not known at " + this + "; attempting to undeploy regardless"), null), (Entity)this);
        }
        log.debug("Undeploying " + targetName + " across cluster " + this + "; WARs now " + this.getConfig(WARS_BY_CONTEXT));
        Iterable targets = Iterables.filter((Iterable)this.getChildren(), JavaWebAppService.CanDeployAndUndeploy.class);
        TaskBuilder tb = Tasks.builder().parallel(true).displayName("Undeploy " + targetName + " across cluster (size " + Iterables.size((Iterable)targets) + ")");
        for (Entity target : targets) {
            tb.add(DynamicWebAppClusterImpl.whenServiceUp(target, Effectors.invocation((Entity)target, (Effector)UNDEPLOY, (Map)MutableMap.of((Object)"targetName", (Object)targetName)), "Undeploy " + targetName + " at " + target + " when ready"));
        }
        DynamicTasks.queueIfPossible((TaskAdaptable)tb.build()).orSubmitAsync((Entity)this).asTask().getUnchecked();
        MutableSet deployedWars = MutableSet.copyOf((Iterable)((Iterable)this.getAttribute(DEPLOYED_WARS)));
        deployedWars.remove(FILENAME_TO_WEB_CONTEXT_MAPPER.convertDeploymentTargetNameToContext(targetName));
        this.sensors().set(DEPLOYED_WARS, (Object)deployedWars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addToWarsByContext(Entity entity, String url, String targetName) {
        targetName = FILENAME_TO_WEB_CONTEXT_MAPPER.convertDeploymentTargetNameToContext(targetName);
        Entity entity2 = entity;
        synchronized (entity2) {
            MutableMap newWarsMap = MutableMap.copyOf((Map)((Map)entity.getConfig(WARS_BY_CONTEXT)));
            newWarsMap.put(targetName, url);
            entity.config().set(WARS_BY_CONTEXT, (Object)newWarsMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean removeFromWarsByContext(Entity entity, String targetName) {
        targetName = FILENAME_TO_WEB_CONTEXT_MAPPER.convertDeploymentTargetNameToContext(targetName);
        Entity entity2 = entity;
        synchronized (entity2) {
            MutableMap newWarsMap = MutableMap.copyOf((Map)((Map)entity.getConfig(WARS_BY_CONTEXT)));
            String url = (String)newWarsMap.remove(targetName);
            if (url == null) {
                return false;
            }
            entity.config().set(WARS_BY_CONTEXT, (Object)newWarsMap);
            return true;
        }
    }

    @Override
    public void redeployAll() {
        MutableMap wars = MutableMap.copyOf((Map)((Map)this.getConfig(WARS_BY_CONTEXT)));
        String redeployPrefix = "Redeploy all WARs (count " + wars.size() + ")";
        log.debug("Redeplying all WARs across cluster " + this + ": " + this.getConfig(WARS_BY_CONTEXT));
        Iterable targetEntities = Iterables.filter((Iterable)this.getChildren(), JavaWebAppService.CanDeployAndUndeploy.class);
        TaskBuilder tb = Tasks.builder().parallel(true).displayName(redeployPrefix + " across cluster (size " + Iterables.size((Iterable)targetEntities) + ")");
        for (Entity targetEntity : targetEntities) {
            TaskBuilder redeployAllToTarget = Tasks.builder().displayName(redeployPrefix + " at " + targetEntity + " (after ready check)");
            for (String warContextPath : wars.keySet()) {
                redeployAllToTarget.add(Effectors.invocation((Entity)targetEntity, (Effector)DEPLOY, (Map)MutableMap.of((Object)"url", wars.get(warContextPath), (Object)"targetName", (Object)warContextPath)));
            }
            tb.add(DynamicWebAppClusterImpl.whenServiceUp(targetEntity, redeployAllToTarget.build(), redeployPrefix + " at " + targetEntity + " when ready"));
        }
        DynamicTasks.queueIfPossible((TaskAdaptable)tb.build()).orSubmitAsync((Entity)this).asTask().getUnchecked();
    }
}

