/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.dsl;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslDeferredSupplier;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.DslAccessible;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.DslFunctionSource;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.methods.BrooklynDslCommon;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.methods.DslToStringHelpers;
import org.apache.brooklyn.util.core.task.ImmediateSupplier;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DslDeferredFunctionCall
extends BrooklynDslDeferredSupplier<Object> {
    private static final Logger log = LoggerFactory.getLogger(DslDeferredFunctionCall.class);
    private static final Set<Method> DEPRECATED_ACCESS_WARNINGS = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final long serialVersionUID = 3243262633795112155L;
    private Object object;
    private String fnName;
    private List<?> args;

    public DslDeferredFunctionCall(Object o, String fn, List<Object> args) {
        this.object = o;
        this.fnName = fn;
        this.args = args;
    }

    public Maybe<Object> getImmediately() {
        return this.invokeOnDeferred(this.object, true);
    }

    private static String toStringF(String fnName, Object args) {
        return fnName + DslDeferredFunctionCall.blankIfNull(args);
    }

    private static String blankIfNull(Object args) {
        if (args == null) {
            return "";
        }
        return args.toString();
    }

    @Override
    public Task<Object> newTask() {
        return Tasks.builder().displayName("Deferred function call " + this.object + "." + DslDeferredFunctionCall.toStringF(this.fnName, this.args)).tag((Object)"TRANSIENT").dynamic(false).body((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return DslDeferredFunctionCall.this.invokeOnDeferred(DslDeferredFunctionCall.this.object, false).get();
            }
        }).build();
    }

    protected Maybe<Object> invokeOnDeferred(Object obj, boolean immediate) {
        Maybe<?> resolvedMaybe = this.resolve(obj, immediate);
        if (resolvedMaybe.isPresent()) {
            Object instance = resolvedMaybe.get();
            if (instance == null) {
                throw new IllegalArgumentException("Deferred function call not found: " + this.object + " evaluates to null (wanting to call " + DslDeferredFunctionCall.toStringF(this.fnName, this.args) + ")");
            }
            return this.invokeOn(instance);
        }
        if (immediate) {
            return Maybe.absent((Throwable)new ImmediateSupplier.ImmediateValueNotAvailableException("Could not evaluate immediately: " + obj));
        }
        return Maybe.absent((Throwable)Maybe.getException(resolvedMaybe));
    }

    protected Maybe<Object> invokeOn(Object obj) {
        return DslDeferredFunctionCall.invokeOn(obj, this.fnName, this.args);
    }

    protected static Maybe<Object> invokeOn(Object obj, String fnName, List<?> args) {
        return new Invoker(obj, fnName, args).invoke();
    }

    protected Maybe<?> resolve(Object object, boolean immediate) {
        return Tasks.resolving((Object)object, Object.class).context(DslDeferredFunctionCall.entity().getExecutionContext()).deep(true, Boolean.valueOf(true)).immediately(immediate).iterator().nextOrLast(DslFunctionSource.class);
    }

    private static void checkCallAllowed(Method m) {
        boolean isPackageAllowed;
        boolean isAnnotationAllowed;
        DslAccessible dslAccessible = m.getAnnotation(DslAccessible.class);
        boolean bl = isAnnotationAllowed = dslAccessible != null;
        if (isAnnotationAllowed) {
            return;
        }
        Class<?> clazz = m.getDeclaringClass();
        Package whiteListPackage = BrooklynDslCommon.class.getPackage();
        boolean bl2 = isPackageAllowed = clazz.getPackage() != null && clazz.getPackage().getName().startsWith(whiteListPackage.getName());
        if (isPackageAllowed) {
            if (DEPRECATED_ACCESS_WARNINGS.add(m)) {
                log.warn("Deprecated since 0.11.0. The method '" + m.toString() + "' called by DSL should be white listed using the " + DslAccessible.class.getSimpleName() + " annotation. Support for DSL callable methods under the " + whiteListPackage + " will be fremoved in a future release.");
            }
            return;
        }
        throw new IllegalArgumentException("Not permitted to invoke function on '" + clazz + "' (outside allowed package scope)");
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.object, this.fnName, this.args});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DslDeferredFunctionCall that = (DslDeferredFunctionCall)DslDeferredFunctionCall.class.cast(obj);
        return Objects.equal((Object)this.object, (Object)that.object) && Objects.equal((Object)this.fnName, (Object)that.fnName) && Objects.equal(this.args, that.args);
    }

    public String toString() {
        return DslToStringHelpers.fn(DslToStringHelpers.internal(this.object) + "." + this.fnName, new Object[]{this.args});
    }

    protected static class Invoker {
        final Object obj;
        final String fnName;
        final List<?> args;
        Maybe<Method> method;
        Object instance;
        List<?> instanceArgs;

        protected Invoker(Object obj, String fnName, List<?> args) {
            this.fnName = fnName;
            this.obj = obj;
            this.args = args;
        }

        protected Maybe<Object> invoke() {
            this.findMethod();
            if (this.method.isPresent()) {
                Method m = (Method)this.method.get();
                DslDeferredFunctionCall.checkCallAllowed(m);
                try {
                    return Maybe.of((Object)Reflections.invokeMethodFromArgs((Object)this.instance, (Method)m, this.instanceArgs));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw Exceptions.propagateAnnotated((String)("Error invoking '" + DslDeferredFunctionCall.toStringF(this.fnName, this.instanceArgs) + "' on '" + this.instance + "'"), (Throwable)e);
                }
            }
            return Maybe.absent((Throwable)new IllegalArgumentException("No such function '" + this.fnName + "' taking args " + this.args + " (on " + this.obj + ")"));
        }

        protected void findMethod() {
            Maybe facade;
            this.method = Reflections.getMethodFromArgs((Object)this.obj, (String)this.fnName, this.args);
            if (this.method.isPresent()) {
                this.instance = this.obj;
                this.instanceArgs = this.args;
                return;
            }
            this.instance = BrooklynDslCommon.class;
            this.instanceArgs = ImmutableList.builder().add(this.obj).addAll(this.args).build();
            this.method = Reflections.getMethodFromArgs((Object)this.instance, (String)this.fnName, this.instanceArgs);
            if (this.method.isPresent()) {
                return;
            }
            try {
                facade = Reflections.invokeMethodFromArgs(BrooklynDslCommon.DslFacades.class, (String)"wrap", (List)ImmutableList.of((Object)this.obj));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                facade = Maybe.absent();
            }
            if (facade.isPresent()) {
                this.instance = facade.get();
                this.instanceArgs = this.args;
                this.method = Reflections.getMethodFromArgs((Object)this.instance, (String)this.fnName, this.instanceArgs);
                if (this.method.isPresent()) {
                    return;
                }
            }
            this.method = Maybe.absent();
        }
    }
}

