/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.guava;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.concurrent.Callable;
import org.apache.brooklyn.util.guava.IfFunctions;

public class Functionals {
    public static <A, B, C> Function<A, C> chain(Function<A, ? extends B> f1, Function<B, C> f2) {
        return Functions.compose(f2, f1);
    }

    public static <A, B, C, D> Function<A, D> chain(Function<A, ? extends B> f1, Function<B, ? extends C> f2, Function<C, D> f3) {
        return Functionals.chain(f1, Functionals.chain(f2, f3));
    }

    public static <A, B, C, D, E> Function<A, E> chain(Function<A, ? extends B> f1, Function<B, ? extends C> f2, Function<C, ? extends D> f3, Function<D, E> f4) {
        return Functionals.chain(f1, Functionals.chain(f2, Functionals.chain(f3, f4)));
    }

    public static <I> IfFunctions.IfFunctionBuilderApplyingFirst<I> ifEquals(I test) {
        return IfFunctions.ifEquals(test);
    }

    public static <I> IfFunctions.IfFunctionBuilderApplyingFirst<I> ifNotEquals(I test) {
        return IfFunctions.ifNotEquals(test);
    }

    public static <I> IfFunctions.IfFunctionBuilderApplyingFirst<I> ifPredicate(Predicate<I> test) {
        return IfFunctions.ifPredicate(test);
    }

    public static <I, O> Function<I, O> function(Supplier<O> supplier) {
        class SupplierAsFunction
        implements Function<I, O> {
            final /* synthetic */ Supplier val$supplier;

            SupplierAsFunction(Supplier supplier) {
                this.val$supplier = supplier;
            }

            public O apply(I input) {
                return this.val$supplier.get();
            }

            public String toString() {
                return "function(" + this.val$supplier + ")";
            }
        }
        return new SupplierAsFunction(supplier);
    }

    public static <I> Function<I, Void> function(Runnable runnable) {
        class RunnableAsFunction
        implements Function<I, Void> {
            final /* synthetic */ Runnable val$runnable;

            RunnableAsFunction(Runnable runnable) {
                this.val$runnable = runnable;
            }

            public Void apply(I input) {
                this.val$runnable.run();
                return null;
            }
        }
        return new RunnableAsFunction(runnable);
    }

    public static Runnable runnable(Supplier<?> supplier) {
        class SupplierAsRunnable
        implements Runnable {
            final /* synthetic */ Supplier val$supplier;

            SupplierAsRunnable(Supplier supplier) {
                this.val$supplier = supplier;
            }

            @Override
            public void run() {
                this.val$supplier.get();
            }
        }
        return new SupplierAsRunnable(supplier);
    }

    public static <T> Callable<T> callable(Supplier<T> supplier) {
        class SupplierAsCallable
        implements Callable<T> {
            final /* synthetic */ Supplier val$supplier;

            SupplierAsCallable(Supplier supplier) {
                this.val$supplier = supplier;
            }

            @Override
            public T call() {
                return this.val$supplier.get();
            }

            public String toString() {
                return "callable(" + this.val$supplier + ")";
            }
        }
        return new SupplierAsCallable(supplier);
    }

    public static <T, U> Callable<U> callable(Function<T, U> f, T x) {
        return Functionals.callable(Suppliers.compose(f, (Supplier)Suppliers.ofInstance(x)));
    }

    public static <T> Predicate<T> predicate(Function<T, Boolean> f) {
        return new FunctionAsPredicate<T>(f);
    }

    public static <T> Callable<Boolean> isSatisfied(final T subject, final Predicate<T> predicate) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return predicate.apply(subject);
            }
        };
    }

    static class FunctionAsPredicate<T>
    implements Predicate<T> {
        private final Function<T, Boolean> f;

        FunctionAsPredicate(Function<T, Boolean> f) {
            this.f = f;
        }

        public boolean apply(T input) {
            return (Boolean)this.f.apply(input);
        }

        public String toString() {
            return "predicate(" + this.f + ")";
        }
    }

    public static final class ConstantFunction<I, O>
    implements Function<I, O> {
        private final O constant;
        private Object toStringDescription;

        public ConstantFunction(O constant) {
            this(constant, null);
        }

        public ConstantFunction(O constant, Object toStringDescription) {
            this.constant = constant;
            this.toStringDescription = toStringDescription;
        }

        public O apply(I input) {
            return this.constant;
        }

        public String toString() {
            return this.toStringDescription == null ? "constant(" + this.constant + ")" : this.toStringDescription.toString();
        }
    }
}

