/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.javalang;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Threads {
    private static final Logger log = LoggerFactory.getLogger(Threads.class);
    private static final Collection<Thread> hooks = new ArrayList<Thread>();
    private static final AtomicBoolean shutdownHookRegistered = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Thread addShutdownHook(final Runnable task) {
        Thread t = new Thread("shutdownHookThread"){

            @Override
            public void run() {
                try {
                    task.run();
                }
                catch (Exception e) {
                    log.error("Failed to execute shutdown hook", (Throwable)e);
                }
            }
        };
        Collection<Thread> collection = hooks;
        synchronized (collection) {
            hooks.add(t);
        }
        Threads.registerShutdownHookOnceInClassicMode();
        return t;
    }

    private static void registerShutdownHookOnceInClassicMode() {
        if (!Threads.isRunningInOsgi() && shutdownHookRegistered.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Threads.runShutdownHooks();
                }
            });
        }
    }

    private static boolean isRunningInOsgi() {
        return FrameworkUtil.getBundle(Threads.class) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeShutdownHook(Thread hook) {
        Collection<Thread> collection = hooks;
        synchronized (collection) {
            return hooks.remove(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runShutdownHooks() {
        while (Threads.hasMoreTasks()) {
            ImmutableList localHooks;
            Iterator iterator = hooks;
            synchronized (iterator) {
                localHooks = ImmutableList.copyOf(hooks);
                hooks.clear();
            }
            for (Thread t : localHooks) {
                try {
                    t.start();
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal(e);
                    log.error("Failed to execute shutdown hook for thread " + t, (Throwable)e);
                }
            }
            for (Thread t : localHooks) {
                try {
                    t.join();
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasMoreTasks() {
        Collection<Thread> collection = hooks;
        synchronized (collection) {
            return !hooks.isEmpty();
        }
    }
}

