/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigStatus;
import io.fabric8.openshift.api.model.DeploymentConfigStatusFluent;
import io.fabric8.openshift.api.model.DeploymentDetails;
import io.fabric8.openshift.api.model.DeploymentDetailsBuilder;
import io.fabric8.openshift.api.model.DeploymentDetailsFluentImpl;

public class DeploymentConfigStatusFluentImpl<A extends DeploymentConfigStatusFluent<A>>
extends BaseFluent<A>
implements DeploymentConfigStatusFluent<A> {
    private Integer availableReplicas;
    private VisitableBuilder<? extends DeploymentDetails, ?> details;
    private Long latestVersion;
    private Long observedGeneration;
    private Integer replicas;
    private Integer unavailableReplicas;
    private Integer updatedReplicas;

    public DeploymentConfigStatusFluentImpl() {
    }

    public DeploymentConfigStatusFluentImpl(DeploymentConfigStatus instance) {
        this.withAvailableReplicas(instance.getAvailableReplicas());
        this.withDetails(instance.getDetails());
        this.withLatestVersion(instance.getLatestVersion());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReplicas(instance.getReplicas());
        this.withUnavailableReplicas(instance.getUnavailableReplicas());
        this.withUpdatedReplicas(instance.getUpdatedReplicas());
    }

    @Override
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    @Override
    public A withAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return (A)this;
    }

    @Override
    public DeploymentDetails getDetails() {
        return this.details != null ? (DeploymentDetails)this.details.build() : null;
    }

    @Override
    public A withDetails(DeploymentDetails details) {
        this._visitables.remove(this.details);
        if (details != null) {
            this.details = new DeploymentDetailsBuilder(details);
            this._visitables.add(this.details);
        }
        return (A)this;
    }

    @Override
    public DeploymentConfigStatusFluent.DetailsNested<A> withNewDetails() {
        return new DetailsNestedImpl();
    }

    @Override
    public DeploymentConfigStatusFluent.DetailsNested<A> withNewDetailsLike(DeploymentDetails item) {
        return new DetailsNestedImpl(item);
    }

    @Override
    public DeploymentConfigStatusFluent.DetailsNested<A> editDetails() {
        return this.withNewDetailsLike(this.getDetails());
    }

    @Override
    public DeploymentConfigStatusFluent.DetailsNested<A> editOrNewDetails() {
        return this.withNewDetailsLike(this.getDetails() != null ? this.getDetails() : new DeploymentDetailsBuilder().build());
    }

    @Override
    public DeploymentConfigStatusFluent.DetailsNested<A> editOrNewDetailsLike(DeploymentDetails item) {
        return this.withNewDetailsLike(this.getDetails() != null ? this.getDetails() : item);
    }

    @Override
    public Long getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public A withLatestVersion(Long latestVersion) {
        this.latestVersion = latestVersion;
        return (A)this;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Integer getUnavailableReplicas() {
        return this.unavailableReplicas;
    }

    @Override
    public A withUnavailableReplicas(Integer unavailableReplicas) {
        this.unavailableReplicas = unavailableReplicas;
        return (A)this;
    }

    @Override
    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    @Override
    public A withUpdatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigStatusFluentImpl that = (DeploymentConfigStatusFluentImpl)o;
        if (this.availableReplicas != null ? !this.availableReplicas.equals(that.availableReplicas) : that.availableReplicas != null) {
            return false;
        }
        if (this.details != null ? !this.details.equals(that.details) : that.details != null) {
            return false;
        }
        if (this.latestVersion != null ? !this.latestVersion.equals(that.latestVersion) : that.latestVersion != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.unavailableReplicas != null ? !this.unavailableReplicas.equals(that.unavailableReplicas) : that.unavailableReplicas != null) {
            return false;
        }
        return !(this.updatedReplicas != null ? !this.updatedReplicas.equals(that.updatedReplicas) : that.updatedReplicas != null);
    }

    public class DetailsNestedImpl<N>
    extends DeploymentDetailsFluentImpl<DeploymentConfigStatusFluent.DetailsNested<N>>
    implements DeploymentConfigStatusFluent.DetailsNested<N>,
    Nested<N> {
        private final DeploymentDetailsBuilder builder;

        DetailsNestedImpl(DeploymentDetails item) {
            this.builder = new DeploymentDetailsBuilder(this, item);
        }

        DetailsNestedImpl() {
            this.builder = new DeploymentDetailsBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigStatusFluentImpl.this.withDetails(this.builder.build());
        }

        @Override
        public N endDetails() {
            return this.and();
        }
    }
}

