/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.StartableApplication;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.test.framework.InfrastructureDeploymentTestCase;
import org.apache.brooklyn.test.framework.TestCaseImpl;

public class InfrastructureDeploymentTestCaseImpl
extends TestCaseImpl
implements InfrastructureDeploymentTestCase {
    @Override
    public void start(@EffectorParam(name="locations") Collection<? extends Location> locations) {
        this.setServiceState(false, Lifecycle.STARTING);
        EntitySpec infrastructureSpec = (EntitySpec)this.config().get(INFRASTRUCTURE_SPEC);
        if (infrastructureSpec == null) {
            this.setServiceState(false, Lifecycle.ON_FIRE);
            throw new IllegalArgumentException(INFRASTRUCTURE_SPEC + " not configured");
        }
        StartableApplication infrastructure = (StartableApplication)this.addChild(infrastructureSpec);
        infrastructure.start(locations);
        String deploymentLocationSensorName = (String)this.config().get(DEPLOYMENT_LOCATION_SENSOR_NAME);
        if (deploymentLocationSensorName == null) {
            this.setServiceState(false, Lifecycle.ON_FIRE);
            throw new IllegalArgumentException(DEPLOYMENT_LOCATION_SENSOR_NAME + " not configured");
        }
        Location locationToDeployTo = (Location)infrastructure.sensors().get(Sensors.newSensor(Location.class, (String)deploymentLocationSensorName));
        if (locationToDeployTo == null) {
            this.setServiceState(false, Lifecycle.ON_FIRE);
            throw new IllegalArgumentException("Infrastructure does not have a location configured on sensor " + deploymentLocationSensorName);
        }
        List entitySpecsToDeploy = (List)this.config().get(ENTITY_SPEC_TO_DEPLOY);
        if (entitySpecsToDeploy == null || entitySpecsToDeploy.isEmpty()) {
            this.setServiceState(false, Lifecycle.ON_FIRE);
            throw new IllegalArgumentException(ENTITY_SPEC_TO_DEPLOY + " not configured");
        }
        for (EntitySpec entitySpec : entitySpecsToDeploy) {
            Startable entityToDeploy = (Startable)this.addChild(entitySpec);
            entityToDeploy.start((Collection)ImmutableList.of((Object)locationToDeployTo));
        }
        super.start(locations);
        this.setServiceState(true, Lifecycle.RUNNING);
    }

    private void setServiceState(boolean serviceUpState, Lifecycle serviceStateActual) {
        this.sensors().set(Attributes.SERVICE_UP, (Object)serviceUpState);
        this.sensors().set(Attributes.SERVICE_STATE_ACTUAL, (Object)serviceStateActual);
    }
}

