/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.objs.BasicConfigurableObject;
import org.apache.brooklyn.location.jclouds.ConnectivityResolver;
import org.apache.brooklyn.location.jclouds.ConnectivityResolverOptions;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.location.jclouds.JcloudsUtil;
import org.apache.brooklyn.location.jclouds.ManagementAddressResolveResult;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.time.Duration;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.LoginCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class DefaultConnectivityResolver
extends BasicConfigurableObject
implements ConnectivityResolver,
EntityInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConnectivityResolver.class);
    public static final ConfigKey<NetworkMode> NETWORK_MODE = ConfigKeys.newConfigKey(NetworkMode.class, (String)"mode", (String)"Operation mode: PREFER_PUBLIC, PREFER_PRIVATE, ONLY_PUBLIC or ONLY_PRIVATE");
    @Beta
    public static final ConfigKey<Boolean> CHECK_CREDENTIALS = ConfigKeys.newBooleanConfigKey((String)"checkCredentials", (String)"Indicates that credentials should be tested when determining endpoint reachability.", (Boolean)Boolean.TRUE);
    public static final ConfigKey<Boolean> PUBLISH_NETWORKS = ConfigKeys.newBooleanConfigKey((String)"publishNetworks", (String)"Indicates that the customizer should publish addresses as sensors on each entity", (Boolean)Boolean.TRUE);

    public DefaultConnectivityResolver() {
        this((Map<?, ?>)ImmutableMap.of());
    }

    public DefaultConnectivityResolver(Map<?, ?> params) {
        this(ConfigBag.newInstance(params));
    }

    public DefaultConnectivityResolver(ConfigBag params) {
        for (Map.Entry entry : params.getAllConfig().entrySet()) {
            this.config().set(ConfigKeys.newConfigKey(Object.class, (String)((String)entry.getKey())), entry.getValue());
        }
    }

    public void apply(EntityLocal entity) {
        String sensorName = JcloudsLocationConfig.CONNECTIVITY_RESOLVER.getName();
        ConfigKey subkey = BrooklynConfigKeys.PROVISIONING_PROPERTIES.subKey(sensorName);
        entity.config().set(subkey, (Object)this);
        LOG.debug("{} set itself as the {} on {}", new Object[]{this, sensorName, entity});
    }

    @Override
    public ManagementAddressResolveResult resolve(JcloudsLocation location, NodeMetadata node, ConfigBag config, ConnectivityResolverOptions options) {
        LOG.debug("{} resolving management parameters for {}, node={}, config={}, options={}", new Object[]{this, location, node, config, options});
        Stopwatch timer = Stopwatch.createStarted();
        Entity contextEntity = this.getContextEntity(config);
        if (this.shouldPublishNetworks() && !options.isRebinding() && contextEntity != null) {
            this.publishNetworks(node, contextEntity);
        }
        HostAndPort hapChoice = null;
        LoginCredentials credChoice = null;
        Iterable<HostAndPort> managementCandidates = this.getManagementCandidates(location, node, config, options);
        Iterable<Object> credentialCandidates = Collections.emptyList();
        if (!Iterables.isEmpty(managementCandidates)) {
            credentialCandidates = this.getCredentialCandidates(location, node, options, config);
            if (this.shouldCheckCredentials() && options.pollForReachableAddresses()) {
                for (HostAndPort hap : managementCandidates) {
                    for (LoginCredentials loginCredentials : credentialCandidates) {
                        LOG.trace("Testing host={} with credential={}", (Object)hap, (Object)loginCredentials);
                        if (!this.checkCredential(location, hap, loginCredentials, config, options.isWindows())) continue;
                        hapChoice = hap;
                        credChoice = loginCredentials;
                        break;
                    }
                    if (hapChoice == null) continue;
                    break;
                }
            } else if (this.shouldCheckCredentials()) {
                LOG.debug("{} set on {} but pollForFirstReachableAddress={}", new Object[]{CHECK_CREDENTIALS.getName(), this, options.pollForReachableAddresses()});
            }
        }
        if (hapChoice == null) {
            LOG.trace("Choosing first management candidate given node={} and mode={}", (Object)node, (Object)this.getNetworkMode());
            hapChoice = (HostAndPort)Iterables.getFirst(managementCandidates, null);
        }
        if (hapChoice == null) {
            LOG.trace("Choosing first address of node={} in mode={}", (Object)node, (Object)this.getNetworkMode());
            Iterator<String> hit = this.getResolvableAddressesWithMode(node).iterator();
            if (hit.hasNext()) {
                HostAndPort.fromHost((String)hit.next());
            }
        }
        if (hapChoice == null) {
            LOG.error("None of the addresses of node {} are reachable in mode {}", new Object[]{node, this.getNetworkMode()});
            throw new IllegalStateException("Could not determine management address for node: " + node + " in mode: " + (Object)((Object)this.getNetworkMode()));
        }
        if (credChoice == null && (credChoice = (LoginCredentials)Iterables.getFirst(credentialCandidates, null)) == null) {
            throw new IllegalStateException("No credentials configured for " + location);
        }
        if (contextEntity != null) {
            contextEntity.sensors().set(Attributes.ADDRESS, (Object)hapChoice.getHostText());
        }
        if (!this.isNetworkModeSet() && !options.isWindows()) {
            boolean lookupAwsHostname = Boolean.TRUE.equals(config.get(JcloudsLocationConfig.LOOKUP_AWS_HOSTNAME));
            String provider = (String)config.get(JcloudsLocationConfig.CLOUD_PROVIDER);
            if (provider == null) {
                provider = location.getProvider();
            }
            if (options.waitForConnectable() && "aws-ec2".equals(provider) && lookupAwsHostname) {
                try {
                    LOG.debug("Resolving AWS hostname of {}", (Object)location);
                    String result = location.getHostnameAws(hapChoice, credChoice, config);
                    hapChoice = HostAndPort.fromParts((String)result, (int)hapChoice.getPort());
                    LOG.debug("Resolved AWS hostname of {}: {}", (Object)location, (Object)result);
                }
                catch (Exception e) {
                    LOG.debug("Failed to resolve AWS hostname of " + location, (Throwable)e);
                }
            }
        }
        ManagementAddressResolveResult result = new ManagementAddressResolveResult(hapChoice, credChoice);
        LOG.debug("{} resolved management parameters for {} in {}: {}", new Object[]{this, location, Duration.of((Object)timer), result});
        return result;
    }

    private boolean shouldPublishNetworks() {
        return Boolean.TRUE.equals(this.config().get(PUBLISH_NETWORKS));
    }

    void publishNetworks(NodeMetadata node, Entity entity) {
        entity.sensors().set(PRIVATE_ADDRESSES, (Object)ImmutableSet.copyOf((Collection)node.getPrivateAddresses()));
        entity.sensors().set(PUBLIC_ADDRESSES, (Object)ImmutableSet.copyOf((Collection)node.getPublicAddresses()));
    }

    protected Iterable<HostAndPort> getManagementCandidates(JcloudsLocation location, NodeMetadata node, ConfigBag config, ConnectivityResolverOptions options) {
        Optional<HostAndPort> portForwardSshOverride = options.portForwardSshOverride();
        if (portForwardSshOverride.isPresent()) {
            int port = ((HostAndPort)portForwardSshOverride.get()).hasPort() ? ((HostAndPort)portForwardSshOverride.get()).getPort() : options.defaultLoginPort();
            HostAndPort override = HostAndPort.fromParts((String)((HostAndPort)portForwardSshOverride.get()).getHostText(), (int)port);
            switch (this.getNetworkMode()) {
                case ONLY_PRIVATE: {
                    LOG.info("Ignoring mode {} in favour of port forwarding override for management candidates of {}: {}", new Object[]{NetworkMode.ONLY_PRIVATE.name(), location, override});
                    break;
                }
                default: {
                    LOG.debug("Using host and port override for management candidates of {}: {}", (Object)location, (Object)override);
                }
            }
            return ImmutableList.of((Object)override);
        }
        if (options.pollForReachableAddresses() && options.reachableAddressPredicate() != null) {
            LOG.debug("Using reachable addresses for management candidates of {}", (Object)location);
            try {
                Predicate<? super HostAndPort> predicate = options.reachableAddressPredicate();
                return this.getReachableAddresses(node, predicate, options.reachableAddressTimeout());
            }
            catch (RuntimeException e) {
                if (options.propagatePollForReachableFailure()) {
                    throw Exceptions.propagate((Throwable)e);
                }
                LOG.warn("No reachable address ({}/{}); falling back to any advertised address; may cause future failures", (Object)location.getCreationString(config), (Object)node);
            }
        } else if (options.pollForReachableAddresses()) {
            throw new IllegalStateException(this + " was configured to expect " + node + " to be reachable and to poll for its reachable addresses but the predicate to determine reachability was null");
        }
        Iterable<String> addresses = this.getResolvableAddressesWithMode(node);
        LOG.debug("Using first resolvable address in {} for management candidates of {}", (Object)Iterables.toString(addresses), (Object)location);
        for (String address : addresses) {
            if (DefaultConnectivityResolver.isAddressResolvable(address)) {
                return ImmutableList.of((Object)HostAndPort.fromParts((String)address, (int)options.defaultLoginPort()));
            }
            LOG.debug("Unresolvable address: " + address);
        }
        LOG.warn("No resolvable address in {} ({}/{}); using first; may cause future failures", new Object[]{addresses, location.getCreationString(config), node});
        String host = (String)Iterables.getFirst(addresses, null);
        if (host != null) {
            return ImmutableList.of((Object)HostAndPort.fromParts((String)host, (int)options.defaultLoginPort()));
        }
        return ImmutableList.of();
    }

    protected Iterable<HostAndPort> getReachableAddresses(NodeMetadata node, Predicate<? super HostAndPort> reachablePredicate, Duration timeout) {
        if (timeout == null) {
            timeout = Duration.FIVE_MINUTES;
        }
        Iterable<String> candidates = this.getResolvableAddressesWithMode(node);
        return JcloudsUtil.getReachableAddresses(candidates, node.getLoginPort(), timeout, reachablePredicate);
    }

    protected Iterable<String> getResolvableAddressesWithMode(NodeMetadata node) {
        Iterable base;
        switch (this.getNetworkMode()) {
            case ONLY_PRIVATE: {
                base = node.getPrivateAddresses();
                break;
            }
            case ONLY_PUBLIC: {
                base = node.getPublicAddresses();
                break;
            }
            case PREFER_PRIVATE: {
                base = Iterables.concat((Iterable)node.getPrivateAddresses(), (Iterable)node.getPublicAddresses());
                break;
            }
            default: {
                base = Iterables.concat((Iterable)node.getPublicAddresses(), (Iterable)node.getPrivateAddresses());
            }
        }
        return FluentIterable.from((Iterable)base).filter((Predicate)new AddressResolvable());
    }

    protected static boolean isAddressResolvable(String addr) {
        try {
            Networking.getInetAddressWithFixedName((String)addr);
            return true;
        }
        catch (RuntimeException e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return false;
        }
    }

    protected boolean shouldCheckCredentials() {
        return Boolean.TRUE.equals(this.config().get(CHECK_CREDENTIALS));
    }

    protected boolean checkCredential(JcloudsLocation location, HostAndPort hostAndPort, LoginCredentials credentials, ConfigBag config, boolean isWindows) {
        try {
            if (isWindows) {
                location.waitForWinRmAvailable(credentials, hostAndPort, config);
            } else {
                location.waitForSshable(hostAndPort, (Iterable<LoginCredentials>)ImmutableList.of((Object)credentials), config);
            }
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    protected Iterable<LoginCredentials> getCredentialCandidates(JcloudsLocation location, NodeMetadata node, ConnectivityResolverOptions options, ConfigBag setup) {
        LoginCredentials userCredentials = null;
        if (options.skipJcloudsSshing() && options.waitForConnectable()) {
            if (options.isWindows() && options.initialCredentials().isPresent()) {
                return ImmutableList.of((Object)options.initialCredentials().get());
            }
            return location.generateCredentials(node.getCredentials(), (String)setup.get(JcloudsLocationConfig.LOGIN_USER));
        }
        LoginCredentials customCredentials = (LoginCredentials)setup.get(JcloudsLocationConfig.CUSTOM_CREDENTIALS);
        if (customCredentials != null) {
            userCredentials = customCredentials;
            Object oldUsername = setup.put(JcloudsLocationConfig.USER, (Object)customCredentials.getUser());
            LOG.debug("Using username {}, from custom credentials, on node {}. User was previously {}", new Object[]{customCredentials.getUser(), node, oldUsername});
            if (customCredentials.getOptionalPassword().isPresent()) {
                setup.put(JcloudsLocationConfig.PASSWORD, customCredentials.getOptionalPassword().get());
            }
            if (customCredentials.getOptionalPrivateKey().isPresent()) {
                setup.put(JcloudsLocationConfig.PRIVATE_KEY_DATA, customCredentials.getOptionalPrivateKey().get());
            }
        }
        if ((userCredentials == null || !userCredentials.getOptionalPassword().isPresent() && !userCredentials.getOptionalPrivateKey().isPresent()) && options.initialCredentials().isPresent()) {
            if (userCredentials != null) {
                LOG.debug("Custom credential from {} is missing both password and private key; extracting them from the VM: {}", (Object)JcloudsLocationConfig.CUSTOM_CREDENTIALS.getName(), (Object)userCredentials);
            }
            userCredentials = location.extractVmCredentials(setup, node, (LoginCredentials)options.initialCredentials().get());
        }
        if (userCredentials == null) {
            userCredentials = node.getCredentials();
        }
        return userCredentials != null ? ImmutableList.of((Object)userCredentials) : ImmutableList.of();
    }

    protected Entity getContextEntity(ConfigBag configBag) {
        Object context = configBag.get(LocationConfigKeys.CALLER_CONTEXT);
        if (context instanceof Entity) {
            return (Entity)context;
        }
        Entity taskContext = BrooklynTaskTags.getContextEntity((Task)Tasks.current());
        if (taskContext != null) {
            return taskContext;
        }
        LOG.warn("No context entity found in config or current task");
        return null;
    }

    protected NetworkMode getNetworkMode() {
        NetworkMode networkMode = (NetworkMode)((Object)this.config().get(NETWORK_MODE));
        return networkMode != null ? networkMode : NetworkMode.PREFER_PUBLIC;
    }

    private boolean isNetworkModeSet() {
        return this.config().get(NETWORK_MODE) != null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mode", (Object)this.getNetworkMode()).toString();
    }

    private static class AddressResolvable
    implements Predicate<String> {
        private AddressResolvable() {
        }

        public boolean apply(@Nullable String input) {
            return DefaultConnectivityResolver.isAddressResolvable(input);
        }
    }

    public static enum NetworkMode {
        PREFER_PUBLIC,
        PREFER_PRIVATE,
        ONLY_PUBLIC,
        ONLY_PRIVATE;

    }
}

