/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.apache;

import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.apache.http.HttpEntity;

final class HttpEntityBody
extends RequestBody {
    private static final MediaType DEFAULT_MEDIA_TYPE = MediaType.parse("application/octet-stream");
    private final HttpEntity entity;
    private final MediaType mediaType;

    HttpEntityBody(HttpEntity entity, String contentTypeHeader) {
        this.entity = entity;
        this.mediaType = contentTypeHeader != null ? MediaType.parse(contentTypeHeader) : (entity.getContentType() != null ? MediaType.parse(entity.getContentType().getValue()) : DEFAULT_MEDIA_TYPE);
    }

    @Override
    public long contentLength() {
        return this.entity.getContentLength();
    }

    @Override
    public MediaType contentType() {
        return this.mediaType;
    }

    @Override
    public void writeTo(BufferedSink sink) throws IOException {
        this.entity.writeTo(sink.outputStream());
    }
}

