/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.loaders;

import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.azurecompute.arm.AzureComputeApi;
import org.jclouds.azurecompute.arm.compute.functions.LocationToResourceGroupName;
import org.jclouds.azurecompute.arm.domain.ResourceGroup;
import org.jclouds.azurecompute.arm.features.ResourceGroupApi;
import org.jclouds.logging.Logger;

@Singleton
public class DefaultResourceGroup
extends CacheLoader<String, ResourceGroup> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final ResourceGroupApi api;
    private final LocationToResourceGroupName locationToResourceGroupName;

    @Inject
    DefaultResourceGroup(AzureComputeApi api, LocationToResourceGroupName locationToResourceGroupName) {
        this.api = api.getResourceGroupApi();
        this.locationToResourceGroupName = locationToResourceGroupName;
    }

    public ResourceGroup load(String locationId) throws Exception {
        String azureGroupName = this.locationToResourceGroupName.apply(locationId);
        ResourceGroup resourceGroup = this.api.get(azureGroupName);
        if (resourceGroup == null) {
            this.logger.debug(">> creating resource group %s", new Object[]{azureGroupName});
            ImmutableMap tags = ImmutableMap.of((Object)"description", (Object)"jclouds default resource group");
            resourceGroup = this.api.create(azureGroupName, locationId, (Map<String, String>)tags);
        }
        return resourceGroup;
    }
}

