/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.profitbricks.binder.storage.ConnectStorageToServerRequestBinder;
import org.jclouds.profitbricks.binder.storage.CreateStorageRequestBinder;
import org.jclouds.profitbricks.binder.storage.UpdateStorageRequestBinder;
import org.jclouds.profitbricks.domain.Storage;
import org.jclouds.profitbricks.http.filters.ProfitBricksSoapMessageEnvelope;
import org.jclouds.profitbricks.http.parser.RequestIdOnlyResponseHandler;
import org.jclouds.profitbricks.http.parser.storage.StorageIdOnlyResponseHandler;
import org.jclouds.profitbricks.http.parser.storage.StorageInfoResponseHandler;
import org.jclouds.profitbricks.http.parser.storage.StorageListResponseHandler;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={BasicAuthentication.class, ProfitBricksSoapMessageEnvelope.class})
@Consumes(value={"text/xml"})
@Produces(value={"text/xml"})
public interface StorageApi {
    @POST
    @Named(value="storage:getall")
    @Payload(value="<ws:getAllStorages/>")
    @XMLResponseParser(value=StorageListResponseHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Storage> getAllStorages();

    @POST
    @Named(value="storage:get")
    @Payload(value="<ws:getStorage><storageId>{id}</storageId></ws:getStorage>")
    @XMLResponseParser(value=StorageInfoResponseHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Storage getStorage(@PayloadParam(value="id") String var1);

    @POST
    @Named(value="storage:create")
    @MapBinder(value=CreateStorageRequestBinder.class)
    @XMLResponseParser(value=StorageIdOnlyResponseHandler.class)
    public String createStorage(@PayloadParam(value="storage") Storage.Request.CreatePayload var1);

    @POST
    @Named(value="storage:update")
    @MapBinder(value=UpdateStorageRequestBinder.class)
    @XMLResponseParser(value=RequestIdOnlyResponseHandler.class)
    public String updateStorage(@PayloadParam(value="storage") Storage.Request.UpdatePayload var1);

    @POST
    @Named(value="storage:delete")
    @Payload(value="<ws:deleteStorage><storageId>{id}</storageId></ws:deleteStorage>")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteStorage(@PayloadParam(value="id") String var1);

    @POST
    @Named(value="storage:connect")
    @MapBinder(value=ConnectStorageToServerRequestBinder.class)
    @XMLResponseParser(value=RequestIdOnlyResponseHandler.class)
    public String connectStorageToServer(@PayloadParam(value="storage") Storage.Request.ConnectPayload var1);

    @POST
    @Named(value="storage:disconnect")
    @Payload(value="<ws:disconnectStorageFromServer><storageId>{storageId}</storageId><serverId>{serverId}</serverId></ws:disconnectStorageFromServer>")
    @XMLResponseParser(value=RequestIdOnlyResponseHandler.class)
    public String disconnectStorageFromServer(@PayloadParam(value="storageId") String var1, @PayloadParam(value="serverId") String var2);
}

