/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.io;

import aQute.libg.glob.AntGlob;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileTree {
    private List<File> files = new ArrayList<File>();
    private List<Pattern> includes = new ArrayList<Pattern>();
    private List<Pattern> excludes = new ArrayList<Pattern>();

    protected void addFile(File file) {
        if (file == null) {
            return;
        }
        if (!this.files.contains(file)) {
            this.files.add(file);
        }
    }

    public void addIncludes(List<String> includes) {
        if (includes == null) {
            return;
        }
        for (String include : includes) {
            if (include == null) continue;
            this.includes.add(AntGlob.toPattern(include));
        }
    }

    public void addIncludes(String ... includes) {
        if (includes == null) {
            return;
        }
        for (String include : includes) {
            if (include == null) continue;
            this.includes.add(AntGlob.toPattern(include));
        }
    }

    public void addExcludes(String ... excludes) {
        if (excludes == null) {
            return;
        }
        for (String exclude : excludes) {
            if (exclude == null) continue;
            this.excludes.add(AntGlob.toPattern(exclude));
        }
    }

    public void addExcludes(List<String> excludes) {
        if (excludes == null) {
            return;
        }
        for (String exclude : excludes) {
            if (exclude == null) continue;
            this.excludes.add(AntGlob.toPattern(exclude));
        }
    }

    public List<File> getFiles(File baseDir, String ... defaultIncludes) throws IOException {
        if (this.includes.isEmpty() && this.files.isEmpty() && defaultIncludes != null && defaultIncludes.length > 0) {
            return this.getFiles(baseDir, this.toPatterns(Stream.of(defaultIncludes)), this.excludes);
        }
        return this.getFiles(baseDir, this.includes, this.excludes);
    }

    private List<Pattern> toPatterns(Stream<String> globs) {
        return globs.filter(Objects::nonNull).map(AntGlob::toPattern).collect(Collectors.toList());
    }

    public List<File> getFiles(File baseDir, List<String> defaultIncludes) throws IOException {
        if (this.includes.isEmpty() && this.files.isEmpty() && defaultIncludes != null && !defaultIncludes.isEmpty()) {
            return this.getFiles(baseDir, this.toPatterns(defaultIncludes.stream()), this.excludes);
        }
        return this.getFiles(baseDir, this.includes, this.excludes);
    }

    private List<File> getFiles(File baseDir, List<Pattern> includePatterns, List<Pattern> excludePatterns) throws IOException {
        if (includePatterns.isEmpty()) {
            return new ArrayList<File>(this.files);
        }
        Path basePath = baseDir.toPath();
        try (Stream<Path> walker = Files.walk(basePath, new FileVisitOption[0]).skip(1L);){
            List<File> result;
            List<File> list = result = Stream.concat(this.files.stream(), walker.filter(p -> {
                String path = basePath.relativize((Path)p).toString();
                return includePatterns.stream().anyMatch(i -> i.matcher(path).matches()) && !excludePatterns.stream().anyMatch(e -> e.matcher(path).matches());
            }).sorted().map(Path::toFile)).distinct().collect(Collectors.toList());
            return list;
        }
    }
}

