/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.annotations.Beta;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.AccessController;
import org.apache.brooklyn.core.mgmt.internal.AccessManager;

@Beta
public class LocalAccessManager
implements AccessManager {
    private volatile boolean locationProvisioningAllowed = true;
    private volatile boolean locationManagementAllowed = true;
    private volatile boolean entityManagementAllowed = true;
    private final AtomicReference<AccessControllerImpl> controller = new AtomicReference();

    public LocalAccessManager() {
        this.updateAccessController();
    }

    @Override
    public AccessController getAccessController() {
        return this.controller.get();
    }

    @Override
    public boolean isLocationProvisioningAllowed() {
        return this.locationProvisioningAllowed;
    }

    @Override
    public boolean isLocationManagementAllowed() {
        return this.locationManagementAllowed;
    }

    @Override
    public boolean isEntityManagementAllowed() {
        return this.entityManagementAllowed;
    }

    @Override
    public void setLocationProvisioningAllowed(boolean allowed) {
        this.locationProvisioningAllowed = allowed;
        this.updateAccessController();
    }

    @Override
    public void setLocationManagementAllowed(boolean allowed) {
        this.locationManagementAllowed = allowed;
        this.updateAccessController();
    }

    @Override
    public void setEntityManagementAllowed(boolean allowed) {
        this.entityManagementAllowed = allowed;
        this.updateAccessController();
    }

    private void updateAccessController() {
        this.controller.set(new AccessControllerImpl(this.locationProvisioningAllowed, this.locationManagementAllowed, this.entityManagementAllowed));
    }

    private static class AccessControllerImpl
    implements AccessController {
        private final boolean locationProvisioningAllowed;
        private final boolean locationManagementAllowed;
        private final boolean entityManagementAllowed;

        public AccessControllerImpl(boolean locationProvisioningAllowed, boolean locationManagementAllowed, boolean entityManagementAllowed) {
            this.locationProvisioningAllowed = locationProvisioningAllowed;
            this.locationManagementAllowed = locationManagementAllowed;
            this.entityManagementAllowed = entityManagementAllowed;
        }

        public AccessController.Response canProvisionLocation(Location provisioner) {
            return this.locationProvisioningAllowed ? AccessController.Response.allowed() : AccessController.Response.disallowed((String)"location provisioning disabled");
        }

        public AccessController.Response canManageLocation(Location loc) {
            return this.locationManagementAllowed ? AccessController.Response.allowed() : AccessController.Response.disallowed((String)"location management disabled");
        }

        public AccessController.Response canManageEntity(Entity entity) {
            return this.entityManagementAllowed ? AccessController.Response.allowed() : AccessController.Response.disallowed((String)"entity management disabled");
        }
    }
}

