/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor.http;

import com.google.common.annotations.Beta;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.sensor.AbstractAddSensorFeed;
import org.apache.brooklyn.feed.http.HttpFeed;
import org.apache.brooklyn.feed.http.HttpPollConfig;
import org.apache.brooklyn.feed.http.HttpValueFunctions;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class HttpRequestSensor<T>
extends AbstractAddSensorFeed<T> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestSensor.class);
    public static final ConfigKey<String> SENSOR_URI = ConfigKeys.newStringConfigKey("uri", "HTTP URI to poll for JSON");
    public static final ConfigKey<String> JSON_PATH = ConfigKeys.newStringConfigKey("jsonPath", "JSON path to select in HTTP response; default $", "$");
    public static final ConfigKey<String> USERNAME = ConfigKeys.newStringConfigKey("username", "Username for HTTP request, if required");
    public static final ConfigKey<String> PASSWORD = ConfigKeys.newStringConfigKey("password", "Password for HTTP request, if required");
    public static final ConfigKey<Map<String, String>> HEADERS = new MapConfigKey<String>(String.class, "headers");
    public static final ConfigKey<Boolean> PREEMPTIVE_BASIC_AUTH = ConfigKeys.newBooleanConfigKey("preemptiveBasicAuth", "Whether to pre-emptively including a basic-auth header of the username:password (rather than waiting for a challenge)", Boolean.FALSE);

    public HttpRequestSensor(ConfigBag params) {
        super(params);
    }

    @Override
    public void apply(EntityLocal entity) {
        super.apply(entity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding HTTP JSON sensor {} to {}", (Object)this.name, (Object)entity);
        }
        final ConfigBag allConfig = ConfigBag.newInstanceCopying(this.params).putAll(this.params);
        new Supplier<URI>(){

            public URI get() {
                return URI.create(EntityInitializers.resolve(allConfig, SENSOR_URI));
            }
        };
        UriSupplier uri = new UriSupplier(allConfig);
        String jsonPath = EntityInitializers.resolve(allConfig, JSON_PATH);
        String username = EntityInitializers.resolve(allConfig, USERNAME);
        String password = EntityInitializers.resolve(allConfig, PASSWORD);
        Map<String, String> headers = EntityInitializers.resolve(allConfig, HEADERS);
        Boolean preemptiveBasicAuth = EntityInitializers.resolve(allConfig, PREEMPTIVE_BASIC_AUTH);
        Boolean suppressDuplicates = (Boolean)EntityInitializers.resolve(allConfig, SUPPRESS_DUPLICATES);
        Duration logWarningGraceTimeOnStartup = (Duration)EntityInitializers.resolve(allConfig, LOG_WARNING_GRACE_TIME_ON_STARTUP);
        Duration logWarningGraceTime = (Duration)EntityInitializers.resolve(allConfig, LOG_WARNING_GRACE_TIME);
        Object successFunction = Strings.isBlank((CharSequence)jsonPath) ? HttpValueFunctions.stringContentsFunction() : HttpValueFunctions.jsonContentsFromPath(jsonPath);
        HttpPollConfig pollConfig = (HttpPollConfig)((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(this.sensor).checkSuccess(HttpValueFunctions.responseCodeEquals(200))).onFailureOrException(Functions.constant(null))).onSuccess(successFunction)).suppressDuplicates(Boolean.TRUE.equals(suppressDuplicates))).logWarningGraceTimeOnStartup(logWarningGraceTimeOnStartup)).logWarningGraceTime(logWarningGraceTime)).period(this.period);
        HttpFeed.Builder httpRequestBuilder = HttpFeed.builder().entity((Entity)entity).baseUri(uri).credentialsIfNotNull(username, password).preemptiveBasicAuth(Boolean.TRUE.equals(preemptiveBasicAuth)).poll(pollConfig);
        if (headers != null) {
            httpRequestBuilder.headers(headers);
        }
        HttpFeed feed = httpRequestBuilder.build();
        entity.addFeed((Feed)feed);
    }

    static class UriSupplier
    implements Supplier<URI> {
        private final ConfigBag allConfig;

        public UriSupplier(ConfigBag allConfig) {
            this.allConfig = allConfig;
        }

        public URI get() {
            return URI.create(EntityInitializers.resolve(this.allConfig, SENSOR_URI));
        }
    }
}

