/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import org.jclouds.ec2.domain.Subnet;
import org.jclouds.ec2.xml.SubnetHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class DescribeSubnetsResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<FluentIterable<Subnet>> {
    private final SubnetHandler subnetHandler;
    private StringBuilder currentText = new StringBuilder();
    private boolean inSubnetSet;
    private boolean inTagSet;
    private boolean inIpv6CidrBlockAssociationSet;
    private ImmutableSet.Builder<Subnet> subnets = ImmutableSet.builder();

    @Inject
    public DescribeSubnetsResponseHandler(SubnetHandler subnetHandler) {
        this.subnetHandler = subnetHandler;
    }

    public FluentIterable<Subnet> getResult() {
        return FluentIterable.from((Iterable)this.subnets.build());
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"subnetSet")) {
            this.inSubnetSet = true;
        } else if (this.inSubnetSet) {
            if (SaxUtils.equalsOrSuffix((String)qName, (String)"tagSet")) {
                this.inTagSet = true;
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ipv6CidrBlockAssociationSet")) {
                this.inIpv6CidrBlockAssociationSet = true;
            }
            this.subnetHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"subnetSet")) {
            this.inSubnetSet = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"tagSet")) {
            this.inTagSet = false;
            this.subnetHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ipv6CidrBlockAssociationSet")) {
            this.inIpv6CidrBlockAssociationSet = false;
            this.subnetHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"item") && !this.inTagSet && !this.inIpv6CidrBlockAssociationSet) {
            this.subnets.add((Object)this.subnetHandler.getResult());
        } else if (this.inSubnetSet) {
            this.subnetHandler.endElement(uri, name, qName);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inSubnetSet) {
            this.subnetHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

