/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.java;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.java.UsesJava;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

public interface UsesJmx
extends UsesJava {
    public static final int DEFAULT_JMX_PORT = 1099;
    @SetFromFlag(value="useJmx")
    public static final ConfigKey<Boolean> USE_JMX = ConfigKeys.newConfigKey((String)"jmx.enabled", (String)"Whether JMX is enabled", (Object)Boolean.TRUE);
    @SetFromFlag(value="jmxPort")
    public static final PortAttributeSensorAndConfigKey JMX_PORT = new PortAttributeSensorAndConfigKey("jmx.direct.port", "JMX direct/private port (e.g. JMX RMI server port, or JMXMP port, but not RMI registry port)", (Object)PortRanges.fromString((String)"31001+"));
    @Deprecated
    public static final PortAttributeSensorAndConfigKey JMX_PORT_LEGACY = new PortAttributeSensorAndConfigKey("jmx.direct.port.legacy.NOT_USED", "Legacy definition JMX direct/private port (e.g. JMX RMI server port, or JMXMP port, but not RMI registry port)", null){
        private static final long serialVersionUID = 3846846080809179437L;

        protected Integer convertConfigToSensor(PortRange value, Entity entity) {
            return super.convertConfigToSensor(value, entity);
        }
    };
    @SetFromFlag(value="rmiRegistryPort")
    public static final PortAttributeSensorAndConfigKey RMI_REGISTRY_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"rmi.registry.port", (String)"RMI registry port, used for discovering JMX (private) port", (Object)PortRanges.fromString((String)"1099,19099+"));
    @SetFromFlag(value="jmxContext")
    public static final AttributeSensorAndConfigKey<String, String> JMX_CONTEXT = ConfigKeys.newStringSensorAndConfigKey((String)"jmx.context", (String)"JMX context path (defaults to 'jmxrmi')", (String)"jmxrmi");
    public static final AttributeSensor<String> JMX_URL = new BasicAttributeSensorAndConfigKey(String.class, "jmx.service.url", "The URL for connecting to the MBean Server");
    @SetFromFlag(value="jmxSecure")
    public static final ConfigKey<Boolean> JMX_SSL_ENABLED = ConfigKeys.newBooleanConfigKey((String)"jmx.ssl.enabled", (String)"Whether to enable JMX over JMXMP with SSL/TLS", (Boolean)Boolean.FALSE);
    @SetFromFlag(value="jmxAgentMode")
    public static final ConfigKey<JmxAgentModes> JMX_AGENT_MODE = ConfigKeys.newConfigKey((String)"jmx.agent.mode", (String)"What type of JMX agent to use; defaults to null (autodetect) which means JMXMP_AND_RMI allowing firewall access through a single port as well as local access supporting jconsole (unless JMX_SSL_ENABLED is set, in which case it is JMXMP only)", (Object)((Object)JmxAgentModes.AUTODETECT));
    public static final AttributeSensorAndConfigKey<String, String> JMX_USER = ConfigKeys.newStringSensorAndConfigKey((String)"jmx.user", (String)"Optional JMX username to use when connecting");
    public static final AttributeSensorAndConfigKey<String, String> JMX_PASSWORD = ConfigKeys.newStringSensorAndConfigKey((String)"jmx.password", (String)"Optional JMX password to use when connecting");
    public static final AttributeSensorAndConfigKey<String, String> JMX_AGENT_LOCAL_PATH = ConfigKeys.newStringSensorAndConfigKey((String)"jmx.agent.local.path", (String)"Optional path to where JMX driver should be installed on the local machine (if using JMXMP or custom agent)");
    public static final ConfigKey<PrivateKey> JMX_SSL_ACCESS_KEY = new BasicConfigKey(PrivateKey.class, "jmx.ssl.access.key", "key used to access a JMX agent (typically per entity, embedded in the managed JVM)", null);
    public static final ConfigKey<Certificate> JMX_SSL_ACCESS_CERT = new BasicConfigKey(Certificate.class, "jmx.ssl.access.cert", "certificate of key used to access a JMX agent", null);

    public static enum JmxAgentModes {
        AUTODETECT,
        JMXMP,
        JMXMP_AND_RMI,
        JMX_RMI_CUSTOM_AGENT,
        JMX_RMI,
        NONE;

    }
}

