/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.system_service;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.system_service.EntityLaunchListener;
import org.apache.brooklyn.entity.system_service.SystemServiceInstallerFactory;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.ssh.SshPutTaskWrapper;
import org.apache.brooklyn.util.core.task.ssh.SshTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.net.Urls;

public class SystemServiceEnricher
extends AbstractEnricher
implements Enricher {
    public static final String DEFAULT_ENRICHER_UNIQUE_TAG = "systemService.tag";
    protected static final Set<String> LAUNCH_EFFECTOR_NAMES = ImmutableSet.of((Object)"start", (Object)"restart");
    public static final ConfigKey<String> LAUNCH_SCRIPT_NAME = ConfigKeys.newStringConfigKey((String)"service.script_name", (String)"The name of the launch script to be created in the runtime directory of the entity.", (String)"service-launch.sh");
    public static final ConfigKey<String> SERVICE_NAME = ConfigKeys.newStringConfigKey((String)"service.name", (String)"The name of the system service. Can use ${entity_name} and ${id} variables to template the value.", (String)"${entity_name}-${id}");

    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.subscribeLaunch();
        this.uniqueTag = DEFAULT_ENRICHER_UNIQUE_TAG;
    }

    private void subscribeLaunch() {
        this.subscriptions().subscribe((Entity)this.entity, (Sensor)Attributes.SERVICE_STATE_ACTUAL, (SensorEventListener)new EntityLaunchListener(this));
    }

    public void onLaunched(Task<?> task) {
        BrooklynTaskTags.WrappedStream streamStdin = BrooklynTaskTags.stream(task, (String)"stdin");
        if (streamStdin == null) {
            return;
        }
        BrooklynTaskTags.WrappedStream streamEnv = BrooklynTaskTags.stream(task, (String)"env");
        String stdin = (String)streamStdin.streamContents.get();
        String env = (String)streamEnv.streamContents.get();
        final SshMachineLocation sshMachine = EffectorTasks.getSshMachine((Entity)this.entity);
        final String launchScriptPath = Urls.mergePaths((String[])new String[]{this.getRunDir(), this.getStartScriptName()});
        Task installerTask = TaskBuilder.builder().displayName("install (service)").description("Install as a system service").body(new Runnable(){

            @Override
            public void run() {
                boolean isInstalled;
                ProcessTaskFactory taskFactory = SshTasks.newSshExecTaskFactory((SshMachineLocation)sshMachine, (String[])new String[]{"[ -e '" + launchScriptPath + "' ]"}).summary("check installed").allowingNonZeroExitCode();
                boolean bl = isInstalled = (Integer)((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)taskFactory)).get() == 0;
                if (!isInstalled) {
                    Task<?> serviceInstallTask = SystemServiceInstallerFactory.of((Entity)SystemServiceEnricher.this.entity, SystemServiceEnricher.this).getServiceInstallTask();
                    DynamicTasks.queue(serviceInstallTask);
                }
            }
        }).build();
        SshPutTaskWrapper updateLaunchScriptTask = SshTasks.newSshPutTaskFactory((SshMachineLocation)sshMachine, (String)launchScriptPath).contents(this.getLaunchScript(stdin, env)).newTask();
        ProcessTaskWrapper makeExecutableTask = (ProcessTaskWrapper)SshTasks.newSshExecTaskFactory((SshMachineLocation)sshMachine, (String[])new String[]{"chmod +x " + launchScriptPath}).requiringExitCodeZero().newTask();
        Task udpateTask = TaskBuilder.builder().displayName("update-launch").description("Update launch script used by the system service").add((TaskAdaptable)updateLaunchScriptTask).add((TaskAdaptable)makeExecutableTask).build();
        Task updateService = TaskBuilder.builder().displayName("update-system-service").description("Update system service").add((TaskAdaptable)installerTask).add((TaskAdaptable)udpateTask).tag((Object)"NON-TRANSIENT").build();
        DynamicTasks.submitTopLevelTask((TaskAdaptable)updateService, (Entity)this.entity);
    }

    private String getLaunchScript(String stdin, String env) {
        return env.replaceAll("(?m)^", "export ") + "\n" + stdin;
    }

    private String getRunDir() {
        return (String)this.entity.getAttribute(SoftwareProcess.RUN_DIR);
    }

    private String getStartScriptName() {
        return (String)this.config().get(LAUNCH_SCRIPT_NAME);
    }

    ExecutionContext getEntityExecutionContext() {
        return this.getManagementContext().getExecutionContext((Entity)this.entity);
    }
}

