/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.calcite.plan;

import org.checkerframework.checker.nullness.qual.Nullable;

import java.util.List;

/**
 * Extension to {@link RelOptSchema} with support for sample data-sets.
 *
 * @see RelOptSchema
 */
public interface RelOptSchemaWithSampling extends RelOptSchema {
  //~ Methods ----------------------------------------------------------------

  /**
   * Retrieves a {@link RelOptTable} based upon a member access, using a
   * sample dataset if it exists.
   *
   * @param names       Compound name of table
   * @param datasetName Name of sample dataset to substitute, if it exists;
   *                    null to not look for a sample
   * @param usedDataset Output parameter which is set to true if a sample
   *                    dataset is found; may be null
   * @return Table, or null if not found
   */
  @Nullable RelOptTable getTableForMember(
      List<String> names,
      @Nullable String datasetName,
      boolean @Nullable [] usedDataset);
}
