---
layout: docs
title: Powered by Calcite
permalink: /docs/powered_by.html
---
<!--
{% comment %}
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to you under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
{% endcomment %}
-->

The following companies and projects are powered by Apache Calcite.

![Companies and projects]({{ site.baseurl }}/img/powered-by.png)

* TOC
{:toc}

Is your company or project powered by Calcite?
[Add it to this page](https://github.com/apache/calcite/blob/main/site/_docs/powered_by.md)
and then use the "powered by Apache Calcite" logo
([140 px]({{ site.baseurl }}/img/pb-calcite-140.png)
or [240 px]({{ site.baseurl }}/img/pb-calcite-240.png))
on your site.


![Powered By]({{ site.baseurl }}/img/pb-calcite-240.png)

### Alibaba MaxCompute

<a href="https://www.alibabacloud.com">Alibaba</a>'s
<a href="https://www.alibabacloud.com/product/maxcompute">MaxCompute</a>
big data computing and storage platform
uses Calcite for cost-based query optimization.

### Apache Apex

<a href="https://apex.apache.org">Apache Apex</a>
uses Calcite for parsing streaming SQL and query optimization.

### Apache Beam

<a href="https://beam.apache.org">Apache Beam</a>
uses Calcite for parsing and optimizing SQL.

### Apache Drill

<a href="https://drill.apache.org">Apache Drill</a>
uses Calcite for SQL parsing and query optimization.

### Apache Flink

<a href="https://flink.apache.org">Apache Flink</a>
uses Calcite for parsing both regular and streaming SQL,
and for query optimization.

### Apache Hive

<a href="https://hive.apache.org">Apache Hive</a>
uses Calcite for cost-based query optimization.

### Apache Kylin

<a href="https://kylin.apache.org">Apache Kylin</a>
uses Calcite for SQL parsing and query optimization.

### Apache Phoenix

<a href="https://phoenix.apache.org">Apache Phoenix</a>
uses Calcite for SQL parsing and query optimization (under development),
and also uses Avatica for its remote JDBC driver.

### Apache Samza

<a href="https://github.com/milinda/samza-sql">SamzaSQL</a>,
an extension to
<a href="https://samza.apache.org">Apache Samza</a>,
uses Calcite for parsing streaming SQL and query optimization.

### Apache Storm

<a href="https://storm.apache.org">Apache Storm</a>
uses Calcite for parsing streaming SQL and query optimization.

### Apache Wayang

<a href="https://wayang.apache.org">Apache Wayang (Incubating)</a>
uses Calcite for SQL parsing and query optimization.

### AthenaX

<a href="https://www.uber.com/">Uber</a>'s SQL-based streaming analytics platform
<a href="https://github.com/uber/AthenaX/">AthenaX</a>
uses Calcite for parsing SQL and query optimization.

### Cascading

<a href="https://github.com/Cascading/lingual">Lingual</a>
component provides a SQL interface to
<a href="https://www.cascading.org/">Cascading</a>.

### Dremio

<a href="https://www.dremio.com">Dremio</a>
uses Calcite for SQL parsing and cost-based query optimization.

### HerdDB

<a href="https://herddb.org">HerdDB</a>
is a distributed JVM-Embeddable Database built on top of
<a href="https://bookkeeper.apache.org/">Apache BookKeeper</a>.
It uses Calcite as its SQL Planner.

### OmniSci

<a href="https://www.omnisci.com">OmniSci</a>
is a GPU-powered database and visual analytics platform for
interactive exploration of large datasets.

### Qubole Quark

[Quark](https://github.com/qubole/quark)
is a data virtualization engine over analytic databases.
It uses Calcite to transparently rewrite queries to use materialized views.

### SQL-Gremlin

<a href="https://github.com/twilmes/sql-gremlin">SQL-Gremlin</a>
is a SQL interface to a
<a href="https://tinkerpop.apache.org/">Apache TinkerPop</a>-enabled
graph database.

### TBDS

[TBDS](https://cloud.tencent.com/product/tbds) (Tencent Big Data Suite) is a platform for big data storage and processing. It uses calcite for SQL parsing and query optimization.
