---
layout: news_item
date: "2023-07-26 07:25:09 +0000"
author: xiong
version: 1.35.0
categories: [release]
tag: v1-35-0
sha: 75750b78b5ac692caa654f506fc1515d4d3991d6
---
<!--
{% comment %}
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to you under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
{% endcomment %}
-->

The [Apache Calcite PMC]({{ site.baseurl }}) is pleased to announce
[Apache Calcite release 1.35.0]({{ site.baseurl }}/docs/history.html#v1-35-0).

This release comes 4 months after [1.34.0](#v1-34-0),
contains contributions from 36 contributors, and resolves 140 issues.

Among other new features, it adds more than 40 new SQL functions in various libraries such as BigQuery and Spark.

It is worth highlighting the following improvements:

* Some improvements in calcite core.
    * [<a href="https://issues.apache.org/jira/browse/CALCITE-5703">CALCITE-5703</a>]
      Reduce amount of generated runtime code
    * [<a href="https://issues.apache.org/jira/browse/CALCITE-5479">CALCITE-5479</a>]
      `FamilyOperandTypeChecker` is not readily composable in sequences
    * [<a href="https://issues.apache.org/jira/browse/CALCITE-5425">CALCITE-5425</a>]
      Should not pushdown Filter through Aggregate without group keys
    * [<a href="https://issues.apache.org/jira/browse/CALCITE-5506">CALCITE-5506</a>]
      `RelToSqlConverter` should retain the aggregation logic when Project without `RexInputRef` on the Aggregate

* Some improvements in simplifying an expression.
    * [<a href="https://issues.apache.org/jira/browse/CALCITE-5769">CALCITE-5769</a>]
      Optimizing `CAST(e AS t) IS NOT NULL` to `e IS NOT NULL`
    * [<a href="https://issues.apache.org/jira/browse/CALCITE-5780">CALCITE-5780</a>]
      Simplify `1 > x OR 1 <= x OR x IS NULL` to `TRUE`
    * [<a href="https://issues.apache.org/jira/browse/CALCITE-5798">CALCITE-5798</a>]
      Improve simplification of `(x < y) IS NOT TRUE` when x and y are not nullable
    * [<a href="https://issues.apache.org/jira/browse/CALCITE-5759">CALCITE-5759</a>]
      `SEARCH(1, Sarg[IS NOT NULL])` should be simplified to `TRUE`
    * [<a href="https://issues.apache.org/jira/browse/CALCITE-5639">CALCITE-5639</a>]
      `RexSimplify` should remove `IS NOT NULL` check when `LIKE` comparison is present
