//
// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to you under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.25.1
// source: common.proto

package message

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Has to be consistent with Meta.StatementType
type StatementType int32

const (
	StatementType_SELECT    StatementType = 0
	StatementType_INSERT    StatementType = 1
	StatementType_UPDATE    StatementType = 2
	StatementType_DELETE    StatementType = 3
	StatementType_UPSERT    StatementType = 4
	StatementType_MERGE     StatementType = 5
	StatementType_OTHER_DML StatementType = 6
	StatementType_CREATE    StatementType = 7
	StatementType_DROP      StatementType = 8
	StatementType_ALTER     StatementType = 9
	StatementType_OTHER_DDL StatementType = 10
	StatementType_CALL      StatementType = 11
)

// Enum value maps for StatementType.
var (
	StatementType_name = map[int32]string{
		0:  "SELECT",
		1:  "INSERT",
		2:  "UPDATE",
		3:  "DELETE",
		4:  "UPSERT",
		5:  "MERGE",
		6:  "OTHER_DML",
		7:  "CREATE",
		8:  "DROP",
		9:  "ALTER",
		10: "OTHER_DDL",
		11: "CALL",
	}
	StatementType_value = map[string]int32{
		"SELECT":    0,
		"INSERT":    1,
		"UPDATE":    2,
		"DELETE":    3,
		"UPSERT":    4,
		"MERGE":     5,
		"OTHER_DML": 6,
		"CREATE":    7,
		"DROP":      8,
		"ALTER":     9,
		"OTHER_DDL": 10,
		"CALL":      11,
	}
)

func (x StatementType) Enum() *StatementType {
	p := new(StatementType)
	*p = x
	return p
}

func (x StatementType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StatementType) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[0].Descriptor()
}

func (StatementType) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[0]
}

func (x StatementType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StatementType.Descriptor instead.
func (StatementType) EnumDescriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{0}
}

type Rep int32

const (
	Rep_PRIMITIVE_BOOLEAN  Rep = 0
	Rep_PRIMITIVE_BYTE     Rep = 1
	Rep_PRIMITIVE_CHAR     Rep = 2
	Rep_PRIMITIVE_SHORT    Rep = 3
	Rep_PRIMITIVE_INT      Rep = 4
	Rep_PRIMITIVE_LONG     Rep = 5
	Rep_PRIMITIVE_FLOAT    Rep = 6
	Rep_PRIMITIVE_DOUBLE   Rep = 7
	Rep_BOOLEAN            Rep = 8
	Rep_BYTE               Rep = 9
	Rep_CHARACTER          Rep = 10
	Rep_SHORT              Rep = 11
	Rep_INTEGER            Rep = 12
	Rep_LONG               Rep = 13
	Rep_FLOAT              Rep = 14
	Rep_DOUBLE             Rep = 15
	Rep_BIG_INTEGER        Rep = 25
	Rep_BIG_DECIMAL        Rep = 26
	Rep_JAVA_SQL_TIME      Rep = 16
	Rep_JAVA_SQL_TIMESTAMP Rep = 17
	Rep_JAVA_SQL_DATE      Rep = 18
	Rep_JAVA_UTIL_DATE     Rep = 19
	Rep_BYTE_STRING        Rep = 20
	Rep_STRING             Rep = 21
	Rep_NUMBER             Rep = 22
	Rep_OBJECT             Rep = 23
	Rep_NULL               Rep = 24
	Rep_ARRAY              Rep = 27
	Rep_STRUCT             Rep = 28
	Rep_MULTISET           Rep = 29
)

// Enum value maps for Rep.
var (
	Rep_name = map[int32]string{
		0:  "PRIMITIVE_BOOLEAN",
		1:  "PRIMITIVE_BYTE",
		2:  "PRIMITIVE_CHAR",
		3:  "PRIMITIVE_SHORT",
		4:  "PRIMITIVE_INT",
		5:  "PRIMITIVE_LONG",
		6:  "PRIMITIVE_FLOAT",
		7:  "PRIMITIVE_DOUBLE",
		8:  "BOOLEAN",
		9:  "BYTE",
		10: "CHARACTER",
		11: "SHORT",
		12: "INTEGER",
		13: "LONG",
		14: "FLOAT",
		15: "DOUBLE",
		25: "BIG_INTEGER",
		26: "BIG_DECIMAL",
		16: "JAVA_SQL_TIME",
		17: "JAVA_SQL_TIMESTAMP",
		18: "JAVA_SQL_DATE",
		19: "JAVA_UTIL_DATE",
		20: "BYTE_STRING",
		21: "STRING",
		22: "NUMBER",
		23: "OBJECT",
		24: "NULL",
		27: "ARRAY",
		28: "STRUCT",
		29: "MULTISET",
	}
	Rep_value = map[string]int32{
		"PRIMITIVE_BOOLEAN":  0,
		"PRIMITIVE_BYTE":     1,
		"PRIMITIVE_CHAR":     2,
		"PRIMITIVE_SHORT":    3,
		"PRIMITIVE_INT":      4,
		"PRIMITIVE_LONG":     5,
		"PRIMITIVE_FLOAT":    6,
		"PRIMITIVE_DOUBLE":   7,
		"BOOLEAN":            8,
		"BYTE":               9,
		"CHARACTER":          10,
		"SHORT":              11,
		"INTEGER":            12,
		"LONG":               13,
		"FLOAT":              14,
		"DOUBLE":             15,
		"BIG_INTEGER":        25,
		"BIG_DECIMAL":        26,
		"JAVA_SQL_TIME":      16,
		"JAVA_SQL_TIMESTAMP": 17,
		"JAVA_SQL_DATE":      18,
		"JAVA_UTIL_DATE":     19,
		"BYTE_STRING":        20,
		"STRING":             21,
		"NUMBER":             22,
		"OBJECT":             23,
		"NULL":               24,
		"ARRAY":              27,
		"STRUCT":             28,
		"MULTISET":           29,
	}
)

func (x Rep) Enum() *Rep {
	p := new(Rep)
	*p = x
	return p
}

func (x Rep) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Rep) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[1].Descriptor()
}

func (Rep) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[1]
}

func (x Rep) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Rep.Descriptor instead.
func (Rep) EnumDescriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{1}
}

// The severity of some unexpected outcome to an operation.
// Protobuf enum values must be unique across all other enums
type Severity int32

const (
	Severity_UNKNOWN_SEVERITY Severity = 0
	Severity_FATAL_SEVERITY   Severity = 1
	Severity_ERROR_SEVERITY   Severity = 2
	Severity_WARNING_SEVERITY Severity = 3
)

// Enum value maps for Severity.
var (
	Severity_name = map[int32]string{
		0: "UNKNOWN_SEVERITY",
		1: "FATAL_SEVERITY",
		2: "ERROR_SEVERITY",
		3: "WARNING_SEVERITY",
	}
	Severity_value = map[string]int32{
		"UNKNOWN_SEVERITY": 0,
		"FATAL_SEVERITY":   1,
		"ERROR_SEVERITY":   2,
		"WARNING_SEVERITY": 3,
	}
)

func (x Severity) Enum() *Severity {
	p := new(Severity)
	*p = x
	return p
}

func (x Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[2].Descriptor()
}

func (Severity) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[2]
}

func (x Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Severity.Descriptor instead.
func (Severity) EnumDescriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{2}
}

// Enumeration corresponding to DatabaseMetaData operations
type MetaDataOperation int32

const (
	MetaDataOperation_GET_ATTRIBUTES             MetaDataOperation = 0
	MetaDataOperation_GET_BEST_ROW_IDENTIFIER    MetaDataOperation = 1
	MetaDataOperation_GET_CATALOGS               MetaDataOperation = 2
	MetaDataOperation_GET_CLIENT_INFO_PROPERTIES MetaDataOperation = 3
	MetaDataOperation_GET_COLUMN_PRIVILEGES      MetaDataOperation = 4
	MetaDataOperation_GET_COLUMNS                MetaDataOperation = 5
	MetaDataOperation_GET_CROSS_REFERENCE        MetaDataOperation = 6
	MetaDataOperation_GET_EXPORTED_KEYS          MetaDataOperation = 7
	MetaDataOperation_GET_FUNCTION_COLUMNS       MetaDataOperation = 8
	MetaDataOperation_GET_FUNCTIONS              MetaDataOperation = 9
	MetaDataOperation_GET_IMPORTED_KEYS          MetaDataOperation = 10
	MetaDataOperation_GET_INDEX_INFO             MetaDataOperation = 11
	MetaDataOperation_GET_PRIMARY_KEYS           MetaDataOperation = 12
	MetaDataOperation_GET_PROCEDURE_COLUMNS      MetaDataOperation = 13
	MetaDataOperation_GET_PROCEDURES             MetaDataOperation = 14
	MetaDataOperation_GET_PSEUDO_COLUMNS         MetaDataOperation = 15
	MetaDataOperation_GET_SCHEMAS                MetaDataOperation = 16
	MetaDataOperation_GET_SCHEMAS_WITH_ARGS      MetaDataOperation = 17
	MetaDataOperation_GET_SUPER_TABLES           MetaDataOperation = 18
	MetaDataOperation_GET_SUPER_TYPES            MetaDataOperation = 19
	MetaDataOperation_GET_TABLE_PRIVILEGES       MetaDataOperation = 20
	MetaDataOperation_GET_TABLES                 MetaDataOperation = 21
	MetaDataOperation_GET_TABLE_TYPES            MetaDataOperation = 22
	MetaDataOperation_GET_TYPE_INFO              MetaDataOperation = 23
	MetaDataOperation_GET_UDTS                   MetaDataOperation = 24
	MetaDataOperation_GET_VERSION_COLUMNS        MetaDataOperation = 25
)

// Enum value maps for MetaDataOperation.
var (
	MetaDataOperation_name = map[int32]string{
		0:  "GET_ATTRIBUTES",
		1:  "GET_BEST_ROW_IDENTIFIER",
		2:  "GET_CATALOGS",
		3:  "GET_CLIENT_INFO_PROPERTIES",
		4:  "GET_COLUMN_PRIVILEGES",
		5:  "GET_COLUMNS",
		6:  "GET_CROSS_REFERENCE",
		7:  "GET_EXPORTED_KEYS",
		8:  "GET_FUNCTION_COLUMNS",
		9:  "GET_FUNCTIONS",
		10: "GET_IMPORTED_KEYS",
		11: "GET_INDEX_INFO",
		12: "GET_PRIMARY_KEYS",
		13: "GET_PROCEDURE_COLUMNS",
		14: "GET_PROCEDURES",
		15: "GET_PSEUDO_COLUMNS",
		16: "GET_SCHEMAS",
		17: "GET_SCHEMAS_WITH_ARGS",
		18: "GET_SUPER_TABLES",
		19: "GET_SUPER_TYPES",
		20: "GET_TABLE_PRIVILEGES",
		21: "GET_TABLES",
		22: "GET_TABLE_TYPES",
		23: "GET_TYPE_INFO",
		24: "GET_UDTS",
		25: "GET_VERSION_COLUMNS",
	}
	MetaDataOperation_value = map[string]int32{
		"GET_ATTRIBUTES":             0,
		"GET_BEST_ROW_IDENTIFIER":    1,
		"GET_CATALOGS":               2,
		"GET_CLIENT_INFO_PROPERTIES": 3,
		"GET_COLUMN_PRIVILEGES":      4,
		"GET_COLUMNS":                5,
		"GET_CROSS_REFERENCE":        6,
		"GET_EXPORTED_KEYS":          7,
		"GET_FUNCTION_COLUMNS":       8,
		"GET_FUNCTIONS":              9,
		"GET_IMPORTED_KEYS":          10,
		"GET_INDEX_INFO":             11,
		"GET_PRIMARY_KEYS":           12,
		"GET_PROCEDURE_COLUMNS":      13,
		"GET_PROCEDURES":             14,
		"GET_PSEUDO_COLUMNS":         15,
		"GET_SCHEMAS":                16,
		"GET_SCHEMAS_WITH_ARGS":      17,
		"GET_SUPER_TABLES":           18,
		"GET_SUPER_TYPES":            19,
		"GET_TABLE_PRIVILEGES":       20,
		"GET_TABLES":                 21,
		"GET_TABLE_TYPES":            22,
		"GET_TYPE_INFO":              23,
		"GET_UDTS":                   24,
		"GET_VERSION_COLUMNS":        25,
	}
)

func (x MetaDataOperation) Enum() *MetaDataOperation {
	p := new(MetaDataOperation)
	*p = x
	return p
}

func (x MetaDataOperation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetaDataOperation) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[3].Descriptor()
}

func (MetaDataOperation) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[3]
}

func (x MetaDataOperation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetaDataOperation.Descriptor instead.
func (MetaDataOperation) EnumDescriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{3}
}

type StateType int32

const (
	StateType_SQL      StateType = 0
	StateType_METADATA StateType = 1
)

// Enum value maps for StateType.
var (
	StateType_name = map[int32]string{
		0: "SQL",
		1: "METADATA",
	}
	StateType_value = map[string]int32{
		"SQL":      0,
		"METADATA": 1,
	}
)

func (x StateType) Enum() *StateType {
	p := new(StateType)
	*p = x
	return p
}

func (x StateType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StateType) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[4].Descriptor()
}

func (StateType) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[4]
}

func (x StateType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StateType.Descriptor instead.
func (StateType) EnumDescriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{4}
}

type CursorFactory_Style int32

const (
	CursorFactory_OBJECT            CursorFactory_Style = 0
	CursorFactory_RECORD            CursorFactory_Style = 1
	CursorFactory_RECORD_PROJECTION CursorFactory_Style = 2
	CursorFactory_ARRAY             CursorFactory_Style = 3
	CursorFactory_LIST              CursorFactory_Style = 4
	CursorFactory_MAP               CursorFactory_Style = 5
)

// Enum value maps for CursorFactory_Style.
var (
	CursorFactory_Style_name = map[int32]string{
		0: "OBJECT",
		1: "RECORD",
		2: "RECORD_PROJECTION",
		3: "ARRAY",
		4: "LIST",
		5: "MAP",
	}
	CursorFactory_Style_value = map[string]int32{
		"OBJECT":            0,
		"RECORD":            1,
		"RECORD_PROJECTION": 2,
		"ARRAY":             3,
		"LIST":              4,
		"MAP":               5,
	}
)

func (x CursorFactory_Style) Enum() *CursorFactory_Style {
	p := new(CursorFactory_Style)
	*p = x
	return p
}

func (x CursorFactory_Style) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CursorFactory_Style) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[5].Descriptor()
}

func (CursorFactory_Style) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[5]
}

func (x CursorFactory_Style) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CursorFactory_Style.Descriptor instead.
func (CursorFactory_Style) EnumDescriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{6, 0}
}

type MetaDataOperationArgument_ArgumentType int32

const (
	MetaDataOperationArgument_STRING          MetaDataOperationArgument_ArgumentType = 0
	MetaDataOperationArgument_BOOL            MetaDataOperationArgument_ArgumentType = 1
	MetaDataOperationArgument_INT             MetaDataOperationArgument_ArgumentType = 2
	MetaDataOperationArgument_REPEATED_STRING MetaDataOperationArgument_ArgumentType = 3
	MetaDataOperationArgument_REPEATED_INT    MetaDataOperationArgument_ArgumentType = 4
	MetaDataOperationArgument_NULL            MetaDataOperationArgument_ArgumentType = 5
)

// Enum value maps for MetaDataOperationArgument_ArgumentType.
var (
	MetaDataOperationArgument_ArgumentType_name = map[int32]string{
		0: "STRING",
		1: "BOOL",
		2: "INT",
		3: "REPEATED_STRING",
		4: "REPEATED_INT",
		5: "NULL",
	}
	MetaDataOperationArgument_ArgumentType_value = map[string]int32{
		"STRING":          0,
		"BOOL":            1,
		"INT":             2,
		"REPEATED_STRING": 3,
		"REPEATED_INT":    4,
		"NULL":            5,
	}
)

func (x MetaDataOperationArgument_ArgumentType) Enum() *MetaDataOperationArgument_ArgumentType {
	p := new(MetaDataOperationArgument_ArgumentType)
	*p = x
	return p
}

func (x MetaDataOperationArgument_ArgumentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetaDataOperationArgument_ArgumentType) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[6].Descriptor()
}

func (MetaDataOperationArgument_ArgumentType) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[6]
}

func (x MetaDataOperationArgument_ArgumentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetaDataOperationArgument_ArgumentType.Descriptor instead.
func (MetaDataOperationArgument_ArgumentType) EnumDescriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{13, 0}
}

// Details about a connection
type ConnectionProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IsDirty              bool   `protobuf:"varint,1,opt,name=is_dirty,json=isDirty,proto3" json:"is_dirty,omitempty"`
	AutoCommit           bool   `protobuf:"varint,2,opt,name=auto_commit,json=autoCommit,proto3" json:"auto_commit,omitempty"`
	HasAutoCommit        bool   `protobuf:"varint,7,opt,name=has_auto_commit,json=hasAutoCommit,proto3" json:"has_auto_commit,omitempty"` // field is a Boolean, need to discern null and default value
	ReadOnly             bool   `protobuf:"varint,3,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	HasReadOnly          bool   `protobuf:"varint,8,opt,name=has_read_only,json=hasReadOnly,proto3" json:"has_read_only,omitempty"` // field is a Boolean, need to discern null and default value
	TransactionIsolation uint32 `protobuf:"varint,4,opt,name=transaction_isolation,json=transactionIsolation,proto3" json:"transaction_isolation,omitempty"`
	Catalog              string `protobuf:"bytes,5,opt,name=catalog,proto3" json:"catalog,omitempty"`
	Schema               string `protobuf:"bytes,6,opt,name=schema,proto3" json:"schema,omitempty"`
}

func (x *ConnectionProperties) Reset() {
	*x = ConnectionProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionProperties) ProtoMessage() {}

func (x *ConnectionProperties) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionProperties.ProtoReflect.Descriptor instead.
func (*ConnectionProperties) Descriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{0}
}

func (x *ConnectionProperties) GetIsDirty() bool {
	if x != nil {
		return x.IsDirty
	}
	return false
}

func (x *ConnectionProperties) GetAutoCommit() bool {
	if x != nil {
		return x.AutoCommit
	}
	return false
}

func (x *ConnectionProperties) GetHasAutoCommit() bool {
	if x != nil {
		return x.HasAutoCommit
	}
	return false
}

func (x *ConnectionProperties) GetReadOnly() bool {
	if x != nil {
		return x.ReadOnly
	}
	return false
}

func (x *ConnectionProperties) GetHasReadOnly() bool {
	if x != nil {
		return x.HasReadOnly
	}
	return false
}

func (x *ConnectionProperties) GetTransactionIsolation() uint32 {
	if x != nil {
		return x.TransactionIsolation
	}
	return 0
}

func (x *ConnectionProperties) GetCatalog() string {
	if x != nil {
		return x.Catalog
	}
	return ""
}

func (x *ConnectionProperties) GetSchema() string {
	if x != nil {
		return x.Schema
	}
	return ""
}

// Statement handle
type StatementHandle struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string     `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	Id           uint32     `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	Signature    *Signature `protobuf:"bytes,3,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (x *StatementHandle) Reset() {
	*x = StatementHandle{}
	if protoimpl.UnsafeEnabled {
		mi := &file_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatementHandle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatementHandle) ProtoMessage() {}

func (x *StatementHandle) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatementHandle.ProtoReflect.Descriptor instead.
func (*StatementHandle) Descriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{1}
}

func (x *StatementHandle) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *StatementHandle) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *StatementHandle) GetSignature() *Signature {
	if x != nil {
		return x.Signature
	}
	return nil
}

// Results of preparing a statement
type Signature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Columns       []*ColumnMetaData   `protobuf:"bytes,1,rep,name=columns,proto3" json:"columns,omitempty"`
	Sql           string              `protobuf:"bytes,2,opt,name=sql,proto3" json:"sql,omitempty"`
	Parameters    []*AvaticaParameter `protobuf:"bytes,3,rep,name=parameters,proto3" json:"parameters,omitempty"`
	CursorFactory *CursorFactory      `protobuf:"bytes,4,opt,name=cursor_factory,json=cursorFactory,proto3" json:"cursor_factory,omitempty"`
	StatementType StatementType       `protobuf:"varint,5,opt,name=statementType,proto3,enum=StatementType" json:"statementType,omitempty"`
}

func (x *Signature) Reset() {
	*x = Signature{}
	if protoimpl.UnsafeEnabled {
		mi := &file_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Signature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Signature) ProtoMessage() {}

func (x *Signature) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Signature.ProtoReflect.Descriptor instead.
func (*Signature) Descriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{2}
}

func (x *Signature) GetColumns() []*ColumnMetaData {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *Signature) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

func (x *Signature) GetParameters() []*AvaticaParameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *Signature) GetCursorFactory() *CursorFactory {
	if x != nil {
		return x.CursorFactory
	}
	return nil
}

func (x *Signature) GetStatementType() StatementType {
	if x != nil {
		return x.StatementType
	}
	return StatementType_SELECT
}

type ColumnMetaData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ordinal            uint32       `protobuf:"varint,1,opt,name=ordinal,proto3" json:"ordinal,omitempty"`
	AutoIncrement      bool         `protobuf:"varint,2,opt,name=auto_increment,json=autoIncrement,proto3" json:"auto_increment,omitempty"`
	CaseSensitive      bool         `protobuf:"varint,3,opt,name=case_sensitive,json=caseSensitive,proto3" json:"case_sensitive,omitempty"`
	Searchable         bool         `protobuf:"varint,4,opt,name=searchable,proto3" json:"searchable,omitempty"`
	Currency           bool         `protobuf:"varint,5,opt,name=currency,proto3" json:"currency,omitempty"`
	Nullable           uint32       `protobuf:"varint,6,opt,name=nullable,proto3" json:"nullable,omitempty"`
	Signed             bool         `protobuf:"varint,7,opt,name=signed,proto3" json:"signed,omitempty"`
	DisplaySize        uint32       `protobuf:"varint,8,opt,name=display_size,json=displaySize,proto3" json:"display_size,omitempty"`
	Label              string       `protobuf:"bytes,9,opt,name=label,proto3" json:"label,omitempty"`
	ColumnName         string       `protobuf:"bytes,10,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
	SchemaName         string       `protobuf:"bytes,11,opt,name=schema_name,json=schemaName,proto3" json:"schema_name,omitempty"`
	Precision          uint32       `protobuf:"varint,12,opt,name=precision,proto3" json:"precision,omitempty"`
	Scale              uint32       `protobuf:"varint,13,opt,name=scale,proto3" json:"scale,omitempty"`
	TableName          string       `protobuf:"bytes,14,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	CatalogName        string       `protobuf:"bytes,15,opt,name=catalog_name,json=catalogName,proto3" json:"catalog_name,omitempty"`
	ReadOnly           bool         `protobuf:"varint,16,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	Writable           bool         `protobuf:"varint,17,opt,name=writable,proto3" json:"writable,omitempty"`
	DefinitelyWritable bool         `protobuf:"varint,18,opt,name=definitely_writable,json=definitelyWritable,proto3" json:"definitely_writable,omitempty"`
	ColumnClassName    string       `protobuf:"bytes,19,opt,name=column_class_name,json=columnClassName,proto3" json:"column_class_name,omitempty"`
	Type               *AvaticaType `protobuf:"bytes,20,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *ColumnMetaData) Reset() {
	*x = ColumnMetaData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ColumnMetaData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColumnMetaData) ProtoMessage() {}

func (x *ColumnMetaData) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColumnMetaData.ProtoReflect.Descriptor instead.
func (*ColumnMetaData) Descriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{3}
}

func (x *ColumnMetaData) GetOrdinal() uint32 {
	if x != nil {
		return x.Ordinal
	}
	return 0
}

func (x *ColumnMetaData) GetAutoIncrement() bool {
	if x != nil {
		return x.AutoIncrement
	}
	return false
}

func (x *ColumnMetaData) GetCaseSensitive() bool {
	if x != nil {
		return x.CaseSensitive
	}
	return false
}

func (x *ColumnMetaData) GetSearchable() bool {
	if x != nil {
		return x.Searchable
	}
	return false
}

func (x *ColumnMetaData) GetCurrency() bool {
	if x != nil {
		return x.Currency
	}
	return false
}

func (x *ColumnMetaData) GetNullable() uint32 {
	if x != nil {
		return x.Nullable
	}
	return 0
}

func (x *ColumnMetaData) GetSigned() bool {
	if x != nil {
		return x.Signed
	}
	return false
}

func (x *ColumnMetaData) GetDisplaySize() uint32 {
	if x != nil {
		return x.DisplaySize
	}
	return 0
}

func (x *ColumnMetaData) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *ColumnMetaData) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

func (x *ColumnMetaData) GetSchemaName() string {
	if x != nil {
		return x.SchemaName
	}
	return ""
}

func (x *ColumnMetaData) GetPrecision() uint32 {
	if x != nil {
		return x.Precision
	}
	return 0
}

func (x *ColumnMetaData) GetScale() uint32 {
	if x != nil {
		return x.Scale
	}
	return 0
}

func (x *ColumnMetaData) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *ColumnMetaData) GetCatalogName() string {
	if x != nil {
		return x.CatalogName
	}
	return ""
}

func (x *ColumnMetaData) GetReadOnly() bool {
	if x != nil {
		return x.ReadOnly
	}
	return false
}

func (x *ColumnMetaData) GetWritable() bool {
	if x != nil {
		return x.Writable
	}
	return false
}

func (x *ColumnMetaData) GetDefinitelyWritable() bool {
	if x != nil {
		return x.DefinitelyWritable
	}
	return false
}

func (x *ColumnMetaData) GetColumnClassName() string {
	if x != nil {
		return x.ColumnClassName
	}
	return ""
}

func (x *ColumnMetaData) GetType() *AvaticaType {
	if x != nil {
		return x.Type
	}
	return nil
}

// Base class for a column type
type AvaticaType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id        uint32            `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Name      string            `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Rep       Rep               `protobuf:"varint,3,opt,name=rep,proto3,enum=Rep" json:"rep,omitempty"`
	Columns   []*ColumnMetaData `protobuf:"bytes,4,rep,name=columns,proto3" json:"columns,omitempty"`     // Only present when name = STRUCT
	Component *AvaticaType      `protobuf:"bytes,5,opt,name=component,proto3" json:"component,omitempty"` // Only present when name = ARRAY
}

func (x *AvaticaType) Reset() {
	*x = AvaticaType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_common_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AvaticaType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvaticaType) ProtoMessage() {}

func (x *AvaticaType) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvaticaType.ProtoReflect.Descriptor instead.
func (*AvaticaType) Descriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{4}
}

func (x *AvaticaType) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *AvaticaType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AvaticaType) GetRep() Rep {
	if x != nil {
		return x.Rep
	}
	return Rep_PRIMITIVE_BOOLEAN
}

func (x *AvaticaType) GetColumns() []*ColumnMetaData {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *AvaticaType) GetComponent() *AvaticaType {
	if x != nil {
		return x.Component
	}
	return nil
}

// Metadata for a parameter
type AvaticaParameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Signed        bool   `protobuf:"varint,1,opt,name=signed,proto3" json:"signed,omitempty"`
	Precision     uint32 `protobuf:"varint,2,opt,name=precision,proto3" json:"precision,omitempty"`
	Scale         uint32 `protobuf:"varint,3,opt,name=scale,proto3" json:"scale,omitempty"`
	ParameterType uint32 `protobuf:"varint,4,opt,name=parameter_type,json=parameterType,proto3" json:"parameter_type,omitempty"`
	TypeName      string `protobuf:"bytes,5,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	ClassName     string `protobuf:"bytes,6,opt,name=class_name,json=className,proto3" json:"class_name,omitempty"`
	Name          string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *AvaticaParameter) Reset() {
	*x = AvaticaParameter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_common_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AvaticaParameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvaticaParameter) ProtoMessage() {}

func (x *AvaticaParameter) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvaticaParameter.ProtoReflect.Descriptor instead.
func (*AvaticaParameter) Descriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{5}
}

func (x *AvaticaParameter) GetSigned() bool {
	if x != nil {
		return x.Signed
	}
	return false
}

func (x *AvaticaParameter) GetPrecision() uint32 {
	if x != nil {
		return x.Precision
	}
	return 0
}

func (x *AvaticaParameter) GetScale() uint32 {
	if x != nil {
		return x.Scale
	}
	return 0
}

func (x *AvaticaParameter) GetParameterType() uint32 {
	if x != nil {
		return x.ParameterType
	}
	return 0
}

func (x *AvaticaParameter) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *AvaticaParameter) GetClassName() string {
	if x != nil {
		return x.ClassName
	}
	return ""
}

func (x *AvaticaParameter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Information necessary to convert an Iterable into a Calcite Cursor
type CursorFactory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Style      CursorFactory_Style `protobuf:"varint,1,opt,name=style,proto3,enum=CursorFactory_Style" json:"style,omitempty"`
	ClassName  string              `protobuf:"bytes,2,opt,name=class_name,json=className,proto3" json:"class_name,omitempty"`
	FieldNames []string            `protobuf:"bytes,3,rep,name=field_names,json=fieldNames,proto3" json:"field_names,omitempty"`
}

func (x *CursorFactory) Reset() {
	*x = CursorFactory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_common_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CursorFactory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CursorFactory) ProtoMessage() {}

func (x *CursorFactory) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CursorFactory.ProtoReflect.Descriptor instead.
func (*CursorFactory) Descriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{6}
}

func (x *CursorFactory) GetStyle() CursorFactory_Style {
	if x != nil {
		return x.Style
	}
	return CursorFactory_OBJECT
}

func (x *CursorFactory) GetClassName() string {
	if x != nil {
		return x.ClassName
	}
	return ""
}

func (x *CursorFactory) GetFieldNames() []string {
	if x != nil {
		return x.FieldNames
	}
	return nil
}

// A collection of rows
type Frame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Offset uint64 `protobuf:"varint,1,opt,name=offset,proto3" json:"offset,omitempty"`
	Done   bool   `protobuf:"varint,2,opt,name=done,proto3" json:"done,omitempty"`
	Rows   []*Row `protobuf:"bytes,3,rep,name=rows,proto3" json:"rows,omitempty"`
}

func (x *Frame) Reset() {
	*x = Frame{}
	if protoimpl.UnsafeEnabled {
		mi := &file_common_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Frame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Frame) ProtoMessage() {}

func (x *Frame) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Frame.ProtoReflect.Descriptor instead.
func (*Frame) Descriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{7}
}

func (x *Frame) GetOffset() uint64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *Frame) GetDone() bool {
	if x != nil {
		return x.Done
	}
	return false
}

func (x *Frame) GetRows() []*Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

// A row is a collection of values
type Row struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value []*ColumnValue `protobuf:"bytes,1,rep,name=value,proto3" json:"value,omitempty"`
}

func (x *Row) Reset() {
	*x = Row{}
	if protoimpl.UnsafeEnabled {
		mi := &file_common_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Row) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Row) ProtoMessage() {}

func (x *Row) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Row.ProtoReflect.Descriptor instead.
func (*Row) Descriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{8}
}

func (x *Row) GetValue() []*ColumnValue {
	if x != nil {
		return x.Value
	}
	return nil
}

// Database property, list of functions the database provides for a certain operation
type DatabaseProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name      string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Functions []string `protobuf:"bytes,2,rep,name=functions,proto3" json:"functions,omitempty"`
}

func (x *DatabaseProperty) Reset() {
	*x = DatabaseProperty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_common_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseProperty) ProtoMessage() {}

func (x *DatabaseProperty) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseProperty.ProtoReflect.Descriptor instead.
func (*DatabaseProperty) Descriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{9}
}

func (x *DatabaseProperty) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DatabaseProperty) GetFunctions() []string {
	if x != nil {
		return x.Functions
	}
	return nil
}

// Message which encapsulates another message to support a single RPC endpoint
type WireMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name           string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	WrappedMessage []byte `protobuf:"bytes,2,opt,name=wrapped_message,json=wrappedMessage,proto3" json:"wrapped_message,omitempty"`
}

func (x *WireMessage) Reset() {
	*x = WireMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_common_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WireMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WireMessage) ProtoMessage() {}

func (x *WireMessage) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WireMessage.ProtoReflect.Descriptor instead.
func (*WireMessage) Descriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{10}
}

func (x *WireMessage) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *WireMessage) GetWrappedMessage() []byte {
	if x != nil {
		return x.WrappedMessage
	}
	return nil
}

// A value might be a TypedValue or an Array of TypedValue's
type ColumnValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value         []*TypedValue `protobuf:"bytes,1,rep,name=value,proto3" json:"value,omitempty"` // deprecated, use array_value or scalar_value
	ArrayValue    []*TypedValue `protobuf:"bytes,2,rep,name=array_value,json=arrayValue,proto3" json:"array_value,omitempty"`
	HasArrayValue bool          `protobuf:"varint,3,opt,name=has_array_value,json=hasArrayValue,proto3" json:"has_array_value,omitempty"` // Is an array value set?
	ScalarValue   *TypedValue   `protobuf:"bytes,4,opt,name=scalar_value,json=scalarValue,proto3" json:"scalar_value,omitempty"`
}

func (x *ColumnValue) Reset() {
	*x = ColumnValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_common_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ColumnValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColumnValue) ProtoMessage() {}

func (x *ColumnValue) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColumnValue.ProtoReflect.Descriptor instead.
func (*ColumnValue) Descriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{11}
}

func (x *ColumnValue) GetValue() []*TypedValue {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *ColumnValue) GetArrayValue() []*TypedValue {
	if x != nil {
		return x.ArrayValue
	}
	return nil
}

func (x *ColumnValue) GetHasArrayValue() bool {
	if x != nil {
		return x.HasArrayValue
	}
	return false
}

func (x *ColumnValue) GetScalarValue() *TypedValue {
	if x != nil {
		return x.ScalarValue
	}
	return nil
}

// Generic wrapper to support any SQL type. Struct-like to work around no polymorphism construct.
type TypedValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type        Rep    `protobuf:"varint,1,opt,name=type,proto3,enum=Rep" json:"type,omitempty"`                           // The actual type that was serialized in the general attribute below
	BoolValue   bool   `protobuf:"varint,2,opt,name=bool_value,json=boolValue,proto3" json:"bool_value,omitempty"`         // boolean
	StringValue string `protobuf:"bytes,3,opt,name=string_value,json=stringValue,proto3" json:"string_value,omitempty"`    // char/varchar
	NumberValue int64  `protobuf:"zigzag64,4,opt,name=number_value,json=numberValue,proto3" json:"number_value,omitempty"` // var-len encoding lets us shove anything from byte to long
	// includes numeric types and date/time types.
	BytesValue     []byte        `protobuf:"bytes,5,opt,name=bytes_value,json=bytesValue,proto3" json:"bytes_value,omitempty"`                    // binary/varbinary
	DoubleValue    float64       `protobuf:"fixed64,6,opt,name=double_value,json=doubleValue,proto3" json:"double_value,omitempty"`               // big numbers
	Null           bool          `protobuf:"varint,7,opt,name=null,proto3" json:"null,omitempty"`                                                 // a null object
	ArrayValue     []*TypedValue `protobuf:"bytes,8,rep,name=array_value,json=arrayValue,proto3" json:"array_value,omitempty"`                    // The Array
	ComponentType  Rep           `protobuf:"varint,9,opt,name=component_type,json=componentType,proto3,enum=Rep" json:"component_type,omitempty"` // If an Array, the representation for the array values
	ImplicitlyNull bool          `protobuf:"varint,10,opt,name=implicitly_null,json=implicitlyNull,proto3" json:"implicitly_null,omitempty"`      // Differentiate between explicitly null (user-set) and implicitly null
}

func (x *TypedValue) Reset() {
	*x = TypedValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_common_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TypedValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TypedValue) ProtoMessage() {}

func (x *TypedValue) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TypedValue.ProtoReflect.Descriptor instead.
func (*TypedValue) Descriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{12}
}

func (x *TypedValue) GetType() Rep {
	if x != nil {
		return x.Type
	}
	return Rep_PRIMITIVE_BOOLEAN
}

func (x *TypedValue) GetBoolValue() bool {
	if x != nil {
		return x.BoolValue
	}
	return false
}

func (x *TypedValue) GetStringValue() string {
	if x != nil {
		return x.StringValue
	}
	return ""
}

func (x *TypedValue) GetNumberValue() int64 {
	if x != nil {
		return x.NumberValue
	}
	return 0
}

func (x *TypedValue) GetBytesValue() []byte {
	if x != nil {
		return x.BytesValue
	}
	return nil
}

func (x *TypedValue) GetDoubleValue() float64 {
	if x != nil {
		return x.DoubleValue
	}
	return 0
}

func (x *TypedValue) GetNull() bool {
	if x != nil {
		return x.Null
	}
	return false
}

func (x *TypedValue) GetArrayValue() []*TypedValue {
	if x != nil {
		return x.ArrayValue
	}
	return nil
}

func (x *TypedValue) GetComponentType() Rep {
	if x != nil {
		return x.ComponentType
	}
	return Rep_PRIMITIVE_BOOLEAN
}

func (x *TypedValue) GetImplicitlyNull() bool {
	if x != nil {
		return x.ImplicitlyNull
	}
	return false
}

// Represents the breadth of arguments to DatabaseMetaData functions
type MetaDataOperationArgument struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StringValue       string                                 `protobuf:"bytes,1,opt,name=string_value,json=stringValue,proto3" json:"string_value,omitempty"`
	BoolValue         bool                                   `protobuf:"varint,2,opt,name=bool_value,json=boolValue,proto3" json:"bool_value,omitempty"`
	IntValue          int32                                  `protobuf:"zigzag32,3,opt,name=int_value,json=intValue,proto3" json:"int_value,omitempty"`
	StringArrayValues []string                               `protobuf:"bytes,4,rep,name=string_array_values,json=stringArrayValues,proto3" json:"string_array_values,omitempty"`
	IntArrayValues    []int32                                `protobuf:"zigzag32,5,rep,packed,name=int_array_values,json=intArrayValues,proto3" json:"int_array_values,omitempty"`
	Type              MetaDataOperationArgument_ArgumentType `protobuf:"varint,6,opt,name=type,proto3,enum=MetaDataOperationArgument_ArgumentType" json:"type,omitempty"`
}

func (x *MetaDataOperationArgument) Reset() {
	*x = MetaDataOperationArgument{}
	if protoimpl.UnsafeEnabled {
		mi := &file_common_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetaDataOperationArgument) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetaDataOperationArgument) ProtoMessage() {}

func (x *MetaDataOperationArgument) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetaDataOperationArgument.ProtoReflect.Descriptor instead.
func (*MetaDataOperationArgument) Descriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{13}
}

func (x *MetaDataOperationArgument) GetStringValue() string {
	if x != nil {
		return x.StringValue
	}
	return ""
}

func (x *MetaDataOperationArgument) GetBoolValue() bool {
	if x != nil {
		return x.BoolValue
	}
	return false
}

func (x *MetaDataOperationArgument) GetIntValue() int32 {
	if x != nil {
		return x.IntValue
	}
	return 0
}

func (x *MetaDataOperationArgument) GetStringArrayValues() []string {
	if x != nil {
		return x.StringArrayValues
	}
	return nil
}

func (x *MetaDataOperationArgument) GetIntArrayValues() []int32 {
	if x != nil {
		return x.IntArrayValues
	}
	return nil
}

func (x *MetaDataOperationArgument) GetType() MetaDataOperationArgument_ArgumentType {
	if x != nil {
		return x.Type
	}
	return MetaDataOperationArgument_STRING
}

type QueryState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type    StateType                    `protobuf:"varint,1,opt,name=type,proto3,enum=StateType" json:"type,omitempty"`
	Sql     string                       `protobuf:"bytes,2,opt,name=sql,proto3" json:"sql,omitempty"`
	Op      MetaDataOperation            `protobuf:"varint,3,opt,name=op,proto3,enum=MetaDataOperation" json:"op,omitempty"`
	Args    []*MetaDataOperationArgument `protobuf:"bytes,4,rep,name=args,proto3" json:"args,omitempty"`
	HasArgs bool                         `protobuf:"varint,5,opt,name=has_args,json=hasArgs,proto3" json:"has_args,omitempty"`
	HasSql  bool                         `protobuf:"varint,6,opt,name=has_sql,json=hasSql,proto3" json:"has_sql,omitempty"`
	HasOp   bool                         `protobuf:"varint,7,opt,name=has_op,json=hasOp,proto3" json:"has_op,omitempty"`
}

func (x *QueryState) Reset() {
	*x = QueryState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_common_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryState) ProtoMessage() {}

func (x *QueryState) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryState.ProtoReflect.Descriptor instead.
func (*QueryState) Descriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{14}
}

func (x *QueryState) GetType() StateType {
	if x != nil {
		return x.Type
	}
	return StateType_SQL
}

func (x *QueryState) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

func (x *QueryState) GetOp() MetaDataOperation {
	if x != nil {
		return x.Op
	}
	return MetaDataOperation_GET_ATTRIBUTES
}

func (x *QueryState) GetArgs() []*MetaDataOperationArgument {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *QueryState) GetHasArgs() bool {
	if x != nil {
		return x.HasArgs
	}
	return false
}

func (x *QueryState) GetHasSql() bool {
	if x != nil {
		return x.HasSql
	}
	return false
}

func (x *QueryState) GetHasOp() bool {
	if x != nil {
		return x.HasOp
	}
	return false
}

var File_common_proto protoreflect.FileDescriptor

var file_common_proto_rawDesc = []byte{
	0x0a, 0x0c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa2,
	0x02, 0x0a, 0x14, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73, 0x5f, 0x64, 0x69,
	0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73, 0x44, 0x69, 0x72,
	0x74, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x68, 0x61, 0x73, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x68, 0x61,
	0x73, 0x41, 0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08,
	0x72, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x22, 0x0a, 0x0d, 0x68, 0x61, 0x73, 0x5f,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0b, 0x68, 0x61, 0x73, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x33, 0x0a, 0x15,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x73, 0x6f, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x14, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x73, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x16, 0x0a, 0x06, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x22, 0x70, 0x0a, 0x0f, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x28, 0x0a, 0x09, 0x73,
	0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0a,
	0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0xe8, 0x01, 0x0a, 0x09, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x12, 0x29, 0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x44, 0x61, 0x74, 0x61, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x10,
	0x0a, 0x03, 0x73, 0x71, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x73, 0x71, 0x6c,
	0x12, 0x31, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x41, 0x76, 0x61, 0x74, 0x69, 0x63, 0x61, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x35, 0x0a, 0x0e, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x5f, 0x66, 0x61,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x43, 0x75,
	0x72, 0x73, 0x6f, 0x72, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0d, 0x63, 0x75, 0x72,
	0x73, 0x6f, 0x72, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x34, 0x0a, 0x0d, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x0e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x22, 0x91, 0x05, 0x0a, 0x0e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x44,
	0x61, 0x74, 0x61, 0x12, 0x18, 0x0a, 0x07, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x12, 0x25, 0x0a,
	0x0e, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x61, 0x75, 0x74, 0x6f, 0x49, 0x6e, 0x63, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x63, 0x61,
	0x73, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x08, 0x72, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x77, 0x72, 0x69,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x77, 0x72, 0x69,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x2f, 0x0a, 0x13, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x65, 0x6c, 0x79, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x12, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x12, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x65, 0x6c, 0x79, 0x57, 0x72,
	0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x0c, 0x2e, 0x41, 0x76, 0x61, 0x74, 0x69, 0x63, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x0b, 0x41, 0x76, 0x61, 0x74, 0x69, 0x63, 0x61,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x03, 0x72, 0x65, 0x70, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x04, 0x2e, 0x52, 0x65, 0x70, 0x52, 0x03, 0x72, 0x65, 0x70,
	0x12, 0x29, 0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x0f, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x2a, 0x0a, 0x09, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c,
	0x2e, 0x41, 0x76, 0x61, 0x74, 0x69, 0x63, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x63, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x22, 0xd5, 0x01, 0x0a, 0x10, 0x41, 0x76, 0x61, 0x74,
	0x69, 0x63, 0x61, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06,
	0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x69,
	0x67, 0x6e, 0x65, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0d, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xd1, 0x01, 0x0a, 0x0d, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x12, 0x2a, 0x0a, 0x05, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x14, 0x2e, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x2e, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x52, 0x05, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x54, 0x0a,
	0x05, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x43, 0x4f, 0x52, 0x44, 0x10, 0x01, 0x12, 0x15,
	0x0a, 0x11, 0x52, 0x45, 0x43, 0x4f, 0x52, 0x44, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x52, 0x52, 0x41, 0x59, 0x10, 0x03,
	0x12, 0x08, 0x0a, 0x04, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x04, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x41,
	0x50, 0x10, 0x05, 0x22, 0x4d, 0x0a, 0x05, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x04, 0x64, 0x6f, 0x6e, 0x65, 0x12, 0x18, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x04, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f,
	0x77, 0x73, 0x22, 0x29, 0x0a, 0x03, 0x52, 0x6f, 0x77, 0x12, 0x22, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x44, 0x0a,
	0x10, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0x4a, 0x0a, 0x0b, 0x57, 0x69, 0x72, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65,
	0x64, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x0e, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22,
	0xb6, 0x01, 0x0a, 0x0b, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x21, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0b,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x2c, 0x0a, 0x0b, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x61, 0x72, 0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x26, 0x0a, 0x0f, 0x68, 0x61, 0x73, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x68, 0x61, 0x73, 0x41, 0x72,
	0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x0c, 0x73, 0x63, 0x61, 0x6c,
	0x61, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x73, 0x63, 0x61,
	0x6c, 0x61, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xe7, 0x02, 0x0a, 0x0a, 0x54, 0x79, 0x70,
	0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x18, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x04, 0x2e, 0x52, 0x65, 0x70, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x12, 0x52, 0x0b, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0b, 0x64,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x75,
	0x6c, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x04, 0x6e, 0x75, 0x6c, 0x6c, 0x12, 0x2c,
	0x0a, 0x0b, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0a, 0x61, 0x72, 0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2b, 0x0a, 0x0e,
	0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x04, 0x2e, 0x52, 0x65, 0x70, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x69, 0x6d, 0x70,
	0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x5f, 0x6e, 0x75, 0x6c, 0x6c, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0e, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x4e, 0x75,
	0x6c, 0x6c, 0x22, 0xf1, 0x02, 0x0a, 0x19, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x11, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x2e, 0x0a, 0x13, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x41, 0x72, 0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0x28, 0x0a, 0x10, 0x69, 0x6e, 0x74, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x11, 0x52, 0x0e, 0x69, 0x6e, 0x74, 0x41, 0x72,
	0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61,
	0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x67, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x5e, 0x0a, 0x0c, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47,
	0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x4f, 0x4f, 0x4c, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03,
	0x49, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x50, 0x45, 0x41, 0x54, 0x45,
	0x44, 0x5f, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45,
	0x50, 0x45, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x49, 0x4e, 0x54, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04,
	0x4e, 0x55, 0x4c, 0x4c, 0x10, 0x05, 0x22, 0xdd, 0x01, 0x0a, 0x0a, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x0a, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x71, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x73, 0x71, 0x6c, 0x12, 0x22, 0x0a, 0x02, 0x6f, 0x70, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x02, 0x6f, 0x70, 0x12, 0x2e, 0x0a, 0x04, 0x61,
	0x72, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x67,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x68,
	0x61, 0x73, 0x5f, 0x61, 0x72, 0x67, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x68,
	0x61, 0x73, 0x41, 0x72, 0x67, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x68, 0x61, 0x73, 0x5f, 0x73, 0x71,
	0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x68, 0x61, 0x73, 0x53, 0x71, 0x6c, 0x12,
	0x15, 0x0a, 0x06, 0x68, 0x61, 0x73, 0x5f, 0x6f, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x05, 0x68, 0x61, 0x73, 0x4f, 0x70, 0x2a, 0x9f, 0x01, 0x0a, 0x0d, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x45, 0x4c, 0x45,
	0x43, 0x54, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x4e, 0x53, 0x45, 0x52, 0x54, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06,
	0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x53, 0x45,
	0x52, 0x54, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x10, 0x05, 0x12,
	0x0d, 0x0a, 0x09, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x44, 0x4d, 0x4c, 0x10, 0x06, 0x12, 0x0a,
	0x0a, 0x06, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x07, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x52,
	0x4f, 0x50, 0x10, 0x08, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x4c, 0x54, 0x45, 0x52, 0x10, 0x09, 0x12,
	0x0d, 0x0a, 0x09, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x44, 0x44, 0x4c, 0x10, 0x0a, 0x12, 0x08,
	0x0a, 0x04, 0x43, 0x41, 0x4c, 0x4c, 0x10, 0x0b, 0x2a, 0xe2, 0x03, 0x0a, 0x03, 0x52, 0x65, 0x70,
	0x12, 0x15, 0x0a, 0x11, 0x50, 0x52, 0x49, 0x4d, 0x49, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x42, 0x4f,
	0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x52, 0x49, 0x4d, 0x49,
	0x54, 0x49, 0x56, 0x45, 0x5f, 0x42, 0x59, 0x54, 0x45, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x50,
	0x52, 0x49, 0x4d, 0x49, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x10, 0x02, 0x12,
	0x13, 0x0a, 0x0f, 0x50, 0x52, 0x49, 0x4d, 0x49, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x53, 0x48, 0x4f,
	0x52, 0x54, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x52, 0x49, 0x4d, 0x49, 0x54, 0x49, 0x56,
	0x45, 0x5f, 0x49, 0x4e, 0x54, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x52, 0x49, 0x4d, 0x49,
	0x54, 0x49, 0x56, 0x45, 0x5f, 0x4c, 0x4f, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x13, 0x0a, 0x0f, 0x50,
	0x52, 0x49, 0x4d, 0x49, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x46, 0x4c, 0x4f, 0x41, 0x54, 0x10, 0x06,
	0x12, 0x14, 0x0a, 0x10, 0x50, 0x52, 0x49, 0x4d, 0x49, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x44, 0x4f,
	0x55, 0x42, 0x4c, 0x45, 0x10, 0x07, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41,
	0x4e, 0x10, 0x08, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x59, 0x54, 0x45, 0x10, 0x09, 0x12, 0x0d, 0x0a,
	0x09, 0x43, 0x48, 0x41, 0x52, 0x41, 0x43, 0x54, 0x45, 0x52, 0x10, 0x0a, 0x12, 0x09, 0x0a, 0x05,
	0x53, 0x48, 0x4f, 0x52, 0x54, 0x10, 0x0b, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x54, 0x45, 0x47,
	0x45, 0x52, 0x10, 0x0c, 0x12, 0x08, 0x0a, 0x04, 0x4c, 0x4f, 0x4e, 0x47, 0x10, 0x0d, 0x12, 0x09,
	0x0a, 0x05, 0x46, 0x4c, 0x4f, 0x41, 0x54, 0x10, 0x0e, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x4f, 0x55,
	0x42, 0x4c, 0x45, 0x10, 0x0f, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x49, 0x47, 0x5f, 0x49, 0x4e, 0x54,
	0x45, 0x47, 0x45, 0x52, 0x10, 0x19, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x49, 0x47, 0x5f, 0x44, 0x45,
	0x43, 0x49, 0x4d, 0x41, 0x4c, 0x10, 0x1a, 0x12, 0x11, 0x0a, 0x0d, 0x4a, 0x41, 0x56, 0x41, 0x5f,
	0x53, 0x51, 0x4c, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x10, 0x12, 0x16, 0x0a, 0x12, 0x4a, 0x41,
	0x56, 0x41, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x54, 0x41, 0x4d, 0x50,
	0x10, 0x11, 0x12, 0x11, 0x0a, 0x0d, 0x4a, 0x41, 0x56, 0x41, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x44,
	0x41, 0x54, 0x45, 0x10, 0x12, 0x12, 0x12, 0x0a, 0x0e, 0x4a, 0x41, 0x56, 0x41, 0x5f, 0x55, 0x54,
	0x49, 0x4c, 0x5f, 0x44, 0x41, 0x54, 0x45, 0x10, 0x13, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x59, 0x54,
	0x45, 0x5f, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x14, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54,
	0x52, 0x49, 0x4e, 0x47, 0x10, 0x15, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52,
	0x10, 0x16, 0x12, 0x0a, 0x0a, 0x06, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x17, 0x12, 0x08,
	0x0a, 0x04, 0x4e, 0x55, 0x4c, 0x4c, 0x10, 0x18, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x52, 0x52, 0x41,
	0x59, 0x10, 0x1b, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x10, 0x1c, 0x12,
	0x0c, 0x0a, 0x08, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x53, 0x45, 0x54, 0x10, 0x1d, 0x2a, 0x5e, 0x0a,
	0x08, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x14, 0x0a, 0x10, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x10, 0x00, 0x12,
	0x12, 0x0a, 0x0e, 0x46, 0x41, 0x54, 0x41, 0x4c, 0x5f, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54,
	0x59, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x53, 0x45, 0x56,
	0x45, 0x52, 0x49, 0x54, 0x59, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x57, 0x41, 0x52, 0x4e, 0x49,
	0x4e, 0x47, 0x5f, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x10, 0x03, 0x2a, 0xd7, 0x04,
	0x0a, 0x11, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x0e, 0x47, 0x45, 0x54, 0x5f, 0x41, 0x54, 0x54, 0x52, 0x49,
	0x42, 0x55, 0x54, 0x45, 0x53, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x47, 0x45, 0x54, 0x5f, 0x42,
	0x45, 0x53, 0x54, 0x5f, 0x52, 0x4f, 0x57, 0x5f, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x46, 0x49,
	0x45, 0x52, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x45, 0x54, 0x5f, 0x43, 0x41, 0x54, 0x41,
	0x4c, 0x4f, 0x47, 0x53, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x47, 0x45, 0x54, 0x5f, 0x43, 0x4c,
	0x49, 0x45, 0x4e, 0x54, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x5f, 0x50, 0x52, 0x4f, 0x50, 0x45, 0x52,
	0x54, 0x49, 0x45, 0x53, 0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x47, 0x45, 0x54, 0x5f, 0x43, 0x4f,
	0x4c, 0x55, 0x4d, 0x4e, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x49, 0x4c, 0x45, 0x47, 0x45, 0x53, 0x10,
	0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x47, 0x45, 0x54, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53,
	0x10, 0x05, 0x12, 0x17, 0x0a, 0x13, 0x47, 0x45, 0x54, 0x5f, 0x43, 0x52, 0x4f, 0x53, 0x53, 0x5f,
	0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x10, 0x06, 0x12, 0x15, 0x0a, 0x11, 0x47,
	0x45, 0x54, 0x5f, 0x45, 0x58, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x4b, 0x45, 0x59, 0x53,
	0x10, 0x07, 0x12, 0x18, 0x0a, 0x14, 0x47, 0x45, 0x54, 0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x08, 0x12, 0x11, 0x0a, 0x0d,
	0x47, 0x45, 0x54, 0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x09, 0x12,
	0x15, 0x0a, 0x11, 0x47, 0x45, 0x54, 0x5f, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f,
	0x4b, 0x45, 0x59, 0x53, 0x10, 0x0a, 0x12, 0x12, 0x0a, 0x0e, 0x47, 0x45, 0x54, 0x5f, 0x49, 0x4e,
	0x44, 0x45, 0x58, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x0b, 0x12, 0x14, 0x0a, 0x10, 0x47, 0x45,
	0x54, 0x5f, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x5f, 0x4b, 0x45, 0x59, 0x53, 0x10, 0x0c,
	0x12, 0x19, 0x0a, 0x15, 0x47, 0x45, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x44, 0x55, 0x52,
	0x45, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x0d, 0x12, 0x12, 0x0a, 0x0e, 0x47,
	0x45, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x44, 0x55, 0x52, 0x45, 0x53, 0x10, 0x0e, 0x12,
	0x16, 0x0a, 0x12, 0x47, 0x45, 0x54, 0x5f, 0x50, 0x53, 0x45, 0x55, 0x44, 0x4f, 0x5f, 0x43, 0x4f,
	0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x0f, 0x12, 0x0f, 0x0a, 0x0b, 0x47, 0x45, 0x54, 0x5f, 0x53,
	0x43, 0x48, 0x45, 0x4d, 0x41, 0x53, 0x10, 0x10, 0x12, 0x19, 0x0a, 0x15, 0x47, 0x45, 0x54, 0x5f,
	0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x53, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x41, 0x52, 0x47,
	0x53, 0x10, 0x11, 0x12, 0x14, 0x0a, 0x10, 0x47, 0x45, 0x54, 0x5f, 0x53, 0x55, 0x50, 0x45, 0x52,
	0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x53, 0x10, 0x12, 0x12, 0x13, 0x0a, 0x0f, 0x47, 0x45, 0x54,
	0x5f, 0x53, 0x55, 0x50, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x53, 0x10, 0x13, 0x12, 0x18,
	0x0a, 0x14, 0x47, 0x45, 0x54, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x50, 0x52, 0x49, 0x56,
	0x49, 0x4c, 0x45, 0x47, 0x45, 0x53, 0x10, 0x14, 0x12, 0x0e, 0x0a, 0x0a, 0x47, 0x45, 0x54, 0x5f,
	0x54, 0x41, 0x42, 0x4c, 0x45, 0x53, 0x10, 0x15, 0x12, 0x13, 0x0a, 0x0f, 0x47, 0x45, 0x54, 0x5f,
	0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x53, 0x10, 0x16, 0x12, 0x11, 0x0a,
	0x0d, 0x47, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x17,
	0x12, 0x0c, 0x0a, 0x08, 0x47, 0x45, 0x54, 0x5f, 0x55, 0x44, 0x54, 0x53, 0x10, 0x18, 0x12, 0x17,
	0x0a, 0x13, 0x47, 0x45, 0x54, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f,
	0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x19, 0x2a, 0x22, 0x0a, 0x09, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x07, 0x0a, 0x03, 0x53, 0x51, 0x4c, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x10, 0x01, 0x42, 0x22, 0x0a, 0x20, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x63, 0x61, 0x6c, 0x63, 0x69, 0x74,
	0x65, 0x2e, 0x61, 0x76, 0x61, 0x74, 0x69, 0x63, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_common_proto_rawDescOnce sync.Once
	file_common_proto_rawDescData = file_common_proto_rawDesc
)

func file_common_proto_rawDescGZIP() []byte {
	file_common_proto_rawDescOnce.Do(func() {
		file_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_common_proto_rawDescData)
	})
	return file_common_proto_rawDescData
}

var file_common_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_common_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_common_proto_goTypes = []interface{}{
	(StatementType)(0),       // 0: StatementType
	(Rep)(0),                 // 1: Rep
	(Severity)(0),            // 2: Severity
	(MetaDataOperation)(0),   // 3: MetaDataOperation
	(StateType)(0),           // 4: StateType
	(CursorFactory_Style)(0), // 5: CursorFactory.Style
	(MetaDataOperationArgument_ArgumentType)(0), // 6: MetaDataOperationArgument.ArgumentType
	(*ConnectionProperties)(nil),                // 7: ConnectionProperties
	(*StatementHandle)(nil),                     // 8: StatementHandle
	(*Signature)(nil),                           // 9: Signature
	(*ColumnMetaData)(nil),                      // 10: ColumnMetaData
	(*AvaticaType)(nil),                         // 11: AvaticaType
	(*AvaticaParameter)(nil),                    // 12: AvaticaParameter
	(*CursorFactory)(nil),                       // 13: CursorFactory
	(*Frame)(nil),                               // 14: Frame
	(*Row)(nil),                                 // 15: Row
	(*DatabaseProperty)(nil),                    // 16: DatabaseProperty
	(*WireMessage)(nil),                         // 17: WireMessage
	(*ColumnValue)(nil),                         // 18: ColumnValue
	(*TypedValue)(nil),                          // 19: TypedValue
	(*MetaDataOperationArgument)(nil),           // 20: MetaDataOperationArgument
	(*QueryState)(nil),                          // 21: QueryState
}
var file_common_proto_depIdxs = []int32{
	9,  // 0: StatementHandle.signature:type_name -> Signature
	10, // 1: Signature.columns:type_name -> ColumnMetaData
	12, // 2: Signature.parameters:type_name -> AvaticaParameter
	13, // 3: Signature.cursor_factory:type_name -> CursorFactory
	0,  // 4: Signature.statementType:type_name -> StatementType
	11, // 5: ColumnMetaData.type:type_name -> AvaticaType
	1,  // 6: AvaticaType.rep:type_name -> Rep
	10, // 7: AvaticaType.columns:type_name -> ColumnMetaData
	11, // 8: AvaticaType.component:type_name -> AvaticaType
	5,  // 9: CursorFactory.style:type_name -> CursorFactory.Style
	15, // 10: Frame.rows:type_name -> Row
	18, // 11: Row.value:type_name -> ColumnValue
	19, // 12: ColumnValue.value:type_name -> TypedValue
	19, // 13: ColumnValue.array_value:type_name -> TypedValue
	19, // 14: ColumnValue.scalar_value:type_name -> TypedValue
	1,  // 15: TypedValue.type:type_name -> Rep
	19, // 16: TypedValue.array_value:type_name -> TypedValue
	1,  // 17: TypedValue.component_type:type_name -> Rep
	6,  // 18: MetaDataOperationArgument.type:type_name -> MetaDataOperationArgument.ArgumentType
	4,  // 19: QueryState.type:type_name -> StateType
	3,  // 20: QueryState.op:type_name -> MetaDataOperation
	20, // 21: QueryState.args:type_name -> MetaDataOperationArgument
	22, // [22:22] is the sub-list for method output_type
	22, // [22:22] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_common_proto_init() }
func file_common_proto_init() {
	if File_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectionProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_common_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatementHandle); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_common_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Signature); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_common_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ColumnMetaData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_common_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AvaticaType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_common_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AvaticaParameter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_common_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CursorFactory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_common_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Frame); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_common_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Row); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_common_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseProperty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_common_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WireMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_common_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ColumnValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_common_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TypedValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_common_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetaDataOperationArgument); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_common_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_common_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_common_proto_goTypes,
		DependencyIndexes: file_common_proto_depIdxs,
		EnumInfos:         file_common_proto_enumTypes,
		MessageInfos:      file_common_proto_msgTypes,
	}.Build()
	File_common_proto = out.File
	file_common_proto_rawDesc = nil
	file_common_proto_goTypes = nil
	file_common_proto_depIdxs = nil
}
