/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.zendesk.internal;

import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.processing.Generated;

import org.zendesk.client.v2.Zendesk;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;
import static org.apache.camel.support.component.ApiMethodArg.setter;

/**
 * Camel {@link ApiMethod} Enumeration for org.zendesk.client.v2.Zendesk
 */
@Generated("org.apache.camel.maven.ApiComponentGeneratorMojo")
public enum ZendeskApiMethod implements ApiMethod {

    ADD_TAG_TO_ORGANISATIONS(
        java.util.List.class,
        "addTagToOrganisations",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    ADD_TAG_TO_TICKET(
        java.util.List.class,
        "addTagToTicket",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    ADD_TAG_TO_TOPICS(
        java.util.List.class,
        "addTagToTopics",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    ASSOCIATE_ATTACHMENTS_TO_ARTICLE(
        void.class,
        "associateAttachmentsToArticle",
        arg("idArticle", String.class),
        arg("attachments", java.util.List.class)),

    CHANGE_USER_PASSWORD(
        void.class,
        "changeUserPassword",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("oldPassword", String.class),
        arg("newPassword", String.class)),

    CREATE_ARTICLE(
        org.zendesk.client.v2.model.hc.Article.class,
        "createArticle",
        arg("article", org.zendesk.client.v2.model.hc.Article.class)),

    CREATE_ARTICLE_1(
        org.zendesk.client.v2.model.hc.Article.class,
        "createArticle",
        arg("article", org.zendesk.client.v2.model.hc.Article.class),
        arg("notifySubscribers", boolean.class)),

    CREATE_ARTICLE_TRANSLATION(
        org.zendesk.client.v2.model.hc.Translation.class,
        "createArticleTranslation",
        arg("articleId", Long.class),
        arg("translation", org.zendesk.client.v2.model.hc.Translation.class)),

    CREATE_AUTOMATION(
        org.zendesk.client.v2.model.Automation.class,
        "createAutomation",
        arg("automation", org.zendesk.client.v2.model.Automation.class)),

    CREATE_CATEGORY(
        org.zendesk.client.v2.model.hc.Category.class,
        "createCategory",
        arg("category", org.zendesk.client.v2.model.hc.Category.class)),

    CREATE_CATEGORY_TRANSLATION(
        org.zendesk.client.v2.model.hc.Translation.class,
        "createCategoryTranslation",
        arg("categoryId", Long.class),
        arg("translation", org.zendesk.client.v2.model.hc.Translation.class)),

    CREATE_COMMENT(
        org.zendesk.client.v2.model.Ticket.class,
        "createComment",
        arg("ticketId", long.class),
        arg("comment", org.zendesk.client.v2.model.Comment.class)),

    CREATE_CONTENT_TAG(
        org.zendesk.client.v2.model.hc.ContentTag.class,
        "createContentTag",
        arg("contentTag", org.zendesk.client.v2.model.hc.ContentTag.class)),

    CREATE_DYNAMIC_CONTENT_ITEM(
        org.zendesk.client.v2.model.dynamic.DynamicContentItem.class,
        "createDynamicContentItem",
        arg("item", org.zendesk.client.v2.model.dynamic.DynamicContentItem.class)),

    CREATE_DYNAMIC_CONTENT_ITEM_VARIANT(
        org.zendesk.client.v2.model.dynamic.DynamicContentItemVariant.class,
        "createDynamicContentItemVariant",
        arg("itemId", Long.class),
        arg("variant", org.zendesk.client.v2.model.dynamic.DynamicContentItemVariant.class)),

    CREATE_FORUM(
        org.zendesk.client.v2.model.Forum.class,
        "createForum",
        arg("forum", org.zendesk.client.v2.model.Forum.class)),

    CREATE_GROUP(
        org.zendesk.client.v2.model.Group.class,
        "createGroup",
        arg("group", org.zendesk.client.v2.model.Group.class)),

    CREATE_GROUP_MEMBERSHIP(
        org.zendesk.client.v2.model.GroupMembership.class,
        "createGroupMembership",
        arg("groupMembership", org.zendesk.client.v2.model.GroupMembership.class)),

    CREATE_GROUP_MEMBERSHIP_1(
        org.zendesk.client.v2.model.GroupMembership.class,
        "createGroupMembership",
        arg("user_id", long.class),
        arg("groupMembership", org.zendesk.client.v2.model.GroupMembership.class)),

    CREATE_MACRO(
        org.zendesk.client.v2.model.Macro.class,
        "createMacro",
        arg("macro", org.zendesk.client.v2.model.Macro.class)),

    CREATE_OR_UPDATE_ORGANIZATION(
        org.zendesk.client.v2.model.Organization.class,
        "createOrUpdateOrganization",
        arg("organization", org.zendesk.client.v2.model.Organization.class)),

    CREATE_OR_UPDATE_USER(
        org.zendesk.client.v2.model.User.class,
        "createOrUpdateUser",
        arg("user", org.zendesk.client.v2.model.User.class)),

    CREATE_OR_UPDATE_USERS(
        org.zendesk.client.v2.model.JobStatus.class,
        "createOrUpdateUsers",
        arg("users", new org.zendesk.client.v2.model.User[0].getClass())),

    CREATE_OR_UPDATE_USERS_1(
        org.zendesk.client.v2.model.JobStatus.class,
        "createOrUpdateUsers",
        arg("usersList", java.util.List.class)),

    CREATE_OR_UPDATE_USERS_ASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "createOrUpdateUsersAsync",
        arg("usersList", java.util.List.class)),

    CREATE_ORGANIZATION(
        org.zendesk.client.v2.model.Organization.class,
        "createOrganization",
        arg("organization", org.zendesk.client.v2.model.Organization.class)),

    CREATE_ORGANIZATION_MEMBERSHIP(
        org.zendesk.client.v2.model.OrganizationMembership.class,
        "createOrganizationMembership",
        arg("organizationMembership", org.zendesk.client.v2.model.OrganizationMembership.class)),

    CREATE_ORGANIZATION_MEMBERSHIP_1(
        org.zendesk.client.v2.model.OrganizationMembership.class,
        "createOrganizationMembership",
        arg("user_id", long.class),
        arg("organizationMembership", org.zendesk.client.v2.model.OrganizationMembership.class)),

    CREATE_ORGANIZATION_MEMBERSHIPS(
        org.zendesk.client.v2.model.JobStatus.class,
        "createOrganizationMemberships",
        arg("organizationMembershipList", java.util.List.class)),

    CREATE_ORGANIZATION_MEMBERSHIPS_1(
        org.zendesk.client.v2.model.JobStatus.class,
        "createOrganizationMemberships",
        arg("organizationMemberships", new org.zendesk.client.v2.model.OrganizationMembership[0].getClass())),

    CREATE_ORGANIZATION_MEMBERSHIPS_ASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "createOrganizationMembershipsAsync",
        arg("organizationMembershipList", java.util.List.class)),

    CREATE_ORGANIZATIONS(
        org.zendesk.client.v2.model.JobStatus.class,
        "createOrganizations",
        arg("organizationList", java.util.List.class)),

    CREATE_ORGANIZATIONS_1(
        org.zendesk.client.v2.model.JobStatus.class,
        "createOrganizations",
        arg("organizations", new org.zendesk.client.v2.model.Organization[0].getClass())),

    CREATE_ORGANIZATIONS_ASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "createOrganizationsAsync",
        arg("organizationList", java.util.List.class)),

    CREATE_PERMISSION_GROUP(
        org.zendesk.client.v2.model.hc.PermissionGroup.class,
        "createPermissionGroup",
        arg("permissionGroup", org.zendesk.client.v2.model.hc.PermissionGroup.class)),

    CREATE_REQUEST(
        org.zendesk.client.v2.model.Request.class,
        "createRequest",
        arg("request", org.zendesk.client.v2.model.Request.class)),

    CREATE_SATISFACTION_RATING(
        org.zendesk.client.v2.model.SatisfactionRating.class,
        "createSatisfactionRating",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class),
        arg("satisfactionRating", org.zendesk.client.v2.model.SatisfactionRating.class)),

    CREATE_SATISFACTION_RATING_1(
        org.zendesk.client.v2.model.SatisfactionRating.class,
        "createSatisfactionRating",
        arg("ticketId", long.class),
        arg("satisfactionRating", org.zendesk.client.v2.model.SatisfactionRating.class)),

    CREATE_SECTION(
        org.zendesk.client.v2.model.hc.Section.class,
        "createSection",
        arg("section", org.zendesk.client.v2.model.hc.Section.class)),

    CREATE_SECTION_TRANSLATION(
        org.zendesk.client.v2.model.hc.Translation.class,
        "createSectionTranslation",
        arg("sectionId", Long.class),
        arg("translation", org.zendesk.client.v2.model.hc.Translation.class)),

    CREATE_TARGET(
        org.zendesk.client.v2.model.targets.Target.class,
        "createTarget",
        arg("target", org.zendesk.client.v2.model.targets.Target.class)),

    CREATE_TICKET(
        org.zendesk.client.v2.model.Ticket.class,
        "createTicket",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class)),

    CREATE_TICKET_ASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "createTicketAsync",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class)),

    CREATE_TICKET_FIELD(
        org.zendesk.client.v2.model.Field.class,
        "createTicketField",
        arg("field", org.zendesk.client.v2.model.Field.class)),

    CREATE_TICKET_FORM(
        org.zendesk.client.v2.model.TicketForm.class,
        "createTicketForm",
        arg("ticketForm", org.zendesk.client.v2.model.TicketForm.class)),

    CREATE_TICKET_FROM_TWEET(
        org.zendesk.client.v2.model.Ticket.class,
        "createTicketFromTweet",
        arg("tweetId", long.class),
        arg("monitorId", long.class)),

    CREATE_TICKETS(
        org.zendesk.client.v2.model.JobStatus.class,
        "createTickets",
        arg("ticketList", java.util.List.class)),

    CREATE_TICKETS_1(
        org.zendesk.client.v2.model.JobStatus.class,
        "createTickets",
        arg("tickets", new org.zendesk.client.v2.model.Ticket[0].getClass())),

    CREATE_TICKETS_ASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "createTicketsAsync",
        arg("ticketList", java.util.List.class)),

    CREATE_TOPIC(
        org.zendesk.client.v2.model.Topic.class,
        "createTopic",
        arg("topic", org.zendesk.client.v2.model.Topic.class)),

    CREATE_TRIGGER(
        org.zendesk.client.v2.model.Trigger.class,
        "createTrigger",
        arg("trigger", org.zendesk.client.v2.model.Trigger.class)),

    CREATE_UPLOAD(
        org.zendesk.client.v2.model.Attachment.Upload.class,
        "createUpload",
        arg("fileName", String.class),
        arg("content", byte[].class)),

    CREATE_UPLOAD_1(
        org.zendesk.client.v2.model.Attachment.Upload.class,
        "createUpload",
        arg("fileName", String.class),
        arg("contentType", String.class),
        arg("content", byte[].class)),

    CREATE_UPLOAD_2(
        org.zendesk.client.v2.model.Attachment.Upload.class,
        "createUpload",
        arg("token", String.class),
        arg("fileName", String.class),
        arg("contentType", String.class),
        arg("content", byte[].class)),

    CREATE_UPLOAD_ARTICLE(
        org.zendesk.client.v2.model.hc.ArticleAttachments.class,
        "createUploadArticle",
        arg("articleId0", long.class),
        arg("file", java.io.File.class)),

    CREATE_UPLOAD_ARTICLE_1(
        org.zendesk.client.v2.model.hc.ArticleAttachments.class,
        "createUploadArticle",
        arg("articleId0", long.class),
        arg("file", java.io.File.class),
        arg("inline", boolean.class)),

    CREATE_USER(
        org.zendesk.client.v2.model.User.class,
        "createUser",
        arg("user", org.zendesk.client.v2.model.User.class)),

    CREATE_USER_IDENTITY(
        org.zendesk.client.v2.model.Identity.class,
        "createUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    CREATE_USER_IDENTITY_1(
        org.zendesk.client.v2.model.Identity.class,
        "createUserIdentity",
        arg("userId", long.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    CREATE_USER_SEGMENT(
        org.zendesk.client.v2.model.hc.UserSegment.class,
        "createUserSegment",
        arg("userSegment", org.zendesk.client.v2.model.hc.UserSegment.class)),

    CREATE_USERS(
        org.zendesk.client.v2.model.JobStatus.class,
        "createUsers",
        arg("userList", java.util.List.class)),

    CREATE_USERS_1(
        org.zendesk.client.v2.model.JobStatus.class,
        "createUsers",
        arg("users", new org.zendesk.client.v2.model.User[0].getClass())),

    CREATE_USERS_ASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "createUsersAsync",
        arg("userList", java.util.List.class)),

    DELETE_ARTICLE(
        void.class,
        "deleteArticle",
        arg("article", org.zendesk.client.v2.model.hc.Article.class)),

    DELETE_ARTICLE_ATTACHMENT(
        void.class,
        "deleteArticleAttachment",
        arg("articleAttachments", org.zendesk.client.v2.model.hc.ArticleAttachments.class)),

    DELETE_ARTICLE_ATTACHMENT_1(
        void.class,
        "deleteArticleAttachment",
        arg("id", long.class)),

    DELETE_ATTACHMENT(
        void.class,
        "deleteAttachment",
        arg("attachment", org.zendesk.client.v2.model.Attachment.class)),

    DELETE_ATTACHMENT_1(
        void.class,
        "deleteAttachment",
        arg("id", long.class)),

    DELETE_AUTOMATION(
        void.class,
        "deleteAutomation",
        arg("automationId0", long.class)),

    DELETE_CATEGORY(
        void.class,
        "deleteCategory",
        arg("category", org.zendesk.client.v2.model.hc.Category.class)),

    DELETE_CONTENT_TAG(
        void.class,
        "deleteContentTag",
        arg("contentTag", org.zendesk.client.v2.model.hc.ContentTag.class)),

    DELETE_DYNAMIC_CONTENT_ITEM(
        void.class,
        "deleteDynamicContentItem",
        arg("item", org.zendesk.client.v2.model.dynamic.DynamicContentItem.class)),

    DELETE_DYNAMIC_CONTENT_ITEM_VARIANT(
        void.class,
        "deleteDynamicContentItemVariant",
        arg("itemId", Long.class),
        arg("variant", org.zendesk.client.v2.model.dynamic.DynamicContentItemVariant.class)),

    DELETE_FORUM(
        void.class,
        "deleteForum",
        arg("forum", org.zendesk.client.v2.model.Forum.class)),

    DELETE_GROUP(
        void.class,
        "deleteGroup",
        arg("group", org.zendesk.client.v2.model.Group.class)),

    DELETE_GROUP_1(
        void.class,
        "deleteGroup",
        arg("id", long.class)),

    DELETE_GROUP_MEMBERSHIP(
        void.class,
        "deleteGroupMembership",
        arg("groupMembership", org.zendesk.client.v2.model.GroupMembership.class)),

    DELETE_GROUP_MEMBERSHIP_1(
        void.class,
        "deleteGroupMembership",
        arg("id", long.class)),

    DELETE_GROUP_MEMBERSHIP_2(
        void.class,
        "deleteGroupMembership",
        arg("user_id", long.class),
        arg("groupMembership", org.zendesk.client.v2.model.GroupMembership.class)),

    DELETE_GROUP_MEMBERSHIP_3(
        void.class,
        "deleteGroupMembership",
        arg("user_id", long.class),
        arg("group_membership_id", long.class)),

    DELETE_ORGANIZATION(
        void.class,
        "deleteOrganization",
        arg("id", long.class)),

    DELETE_ORGANIZATION_1(
        void.class,
        "deleteOrganization",
        arg("organization", org.zendesk.client.v2.model.Organization.class)),

    DELETE_ORGANIZATION_MEMBERSHIP(
        void.class,
        "deleteOrganizationMembership",
        arg("id", long.class)),

    DELETE_ORGANIZATION_MEMBERSHIP_1(
        void.class,
        "deleteOrganizationMembership",
        arg("user_id", long.class),
        arg("organizationMembership", org.zendesk.client.v2.model.OrganizationMembership.class)),

    DELETE_ORGANIZATION_MEMBERSHIP_2(
        void.class,
        "deleteOrganizationMembership",
        arg("user_id", long.class),
        arg("organization_membership_id", long.class)),

    DELETE_ORGANIZATION_MEMBERSHIPS(
        void.class,
        "deleteOrganizationMemberships",
        arg("id", long.class),
        arg("ids", long[].class)),

    DELETE_ORGANIZATIONS(
        org.zendesk.client.v2.model.JobStatus.class,
        "deleteOrganizations",
        arg("ids", long[].class)),

    DELETE_PERMISSION_GROUP(
        void.class,
        "deletePermissionGroup",
        arg("id", long.class)),

    DELETE_PERMISSION_GROUP_1(
        void.class,
        "deletePermissionGroup",
        arg("permissionGroup", org.zendesk.client.v2.model.hc.PermissionGroup.class)),

    DELETE_SECTION(
        void.class,
        "deleteSection",
        arg("section", org.zendesk.client.v2.model.hc.Section.class)),

    DELETE_SUSPENDED_TICKET(
        void.class,
        "deleteSuspendedTicket",
        arg("id", long.class)),

    DELETE_SUSPENDED_TICKET_1(
        void.class,
        "deleteSuspendedTicket",
        arg("suspendedTicket", org.zendesk.client.v2.model.SuspendedTicket.class)),

    DELETE_TARGET(
        void.class,
        "deleteTarget",
        arg("targetId", long.class)),

    DELETE_TICKET(
        void.class,
        "deleteTicket",
        arg("id", long.class)),

    DELETE_TICKET_1(
        void.class,
        "deleteTicket",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class)),

    DELETE_TICKET_FIELD(
        void.class,
        "deleteTicketField",
        arg("field", org.zendesk.client.v2.model.Field.class)),

    DELETE_TICKET_FIELD_1(
        void.class,
        "deleteTicketField",
        arg("id", long.class)),

    DELETE_TICKET_FORM(
        void.class,
        "deleteTicketForm",
        arg("id", long.class)),

    DELETE_TICKET_FORM_1(
        void.class,
        "deleteTicketForm",
        arg("ticketForm", org.zendesk.client.v2.model.TicketForm.class)),

    DELETE_TICKETS(
        org.zendesk.client.v2.model.JobStatus.class,
        "deleteTickets",
        arg("id", long.class),
        arg("ids", long[].class)),

    DELETE_TOPIC(
        void.class,
        "deleteTopic",
        arg("topic", org.zendesk.client.v2.model.Topic.class)),

    DELETE_TRANSLATION(
        void.class,
        "deleteTranslation",
        arg("translation", org.zendesk.client.v2.model.hc.Translation.class)),

    DELETE_TRANSLATION_1(
        void.class,
        "deleteTranslation",
        arg("translationId", Long.class)),

    DELETE_TRIGGER(
        void.class,
        "deleteTrigger",
        arg("triggerId", long.class)),

    DELETE_UPLOAD(
        void.class,
        "deleteUpload",
        arg("token", String.class)),

    DELETE_UPLOAD_1(
        void.class,
        "deleteUpload",
        arg("upload", org.zendesk.client.v2.model.Attachment.Upload.class)),

    DELETE_USER(
        void.class,
        "deleteUser",
        arg("id", long.class)),

    DELETE_USER_1(
        void.class,
        "deleteUser",
        arg("user", org.zendesk.client.v2.model.User.class)),

    DELETE_USER_IDENTITY(
        void.class,
        "deleteUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    DELETE_USER_IDENTITY_1(
        void.class,
        "deleteUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identityId", long.class)),

    DELETE_USER_IDENTITY_2(
        void.class,
        "deleteUserIdentity",
        arg("userId", long.class),
        arg("identityId", long.class)),

    DELETE_USER_SEGMENT(
        void.class,
        "deleteUserSegment",
        arg("id", long.class)),

    DELETE_USER_SEGMENT_1(
        void.class,
        "deleteUserSegment",
        arg("userSegment", org.zendesk.client.v2.model.hc.UserSegment.class)),

    DELETE_USERS(
        org.zendesk.client.v2.model.JobStatus.class,
        "deleteUsers",
        arg("ids", long[].class)),

    EXECUTE_VIEW(
        java.util.Optional.class,
        "executeView",
        arg("id", long.class),
        arg("clazz", Class.class)),

    GET_ACTIVE_TRIGGERS(
        Iterable.class,
        "getActiveTriggers"),

    GET_ARTICLE(
        org.zendesk.client.v2.model.hc.Article.class,
        "getArticle",
        arg("id", long.class)),

    GET_ARTICLE_FROM_SEARCH(
        Iterable.class,
        "getArticleFromSearch",
        arg("searchTerm", String.class)),

    GET_ARTICLE_FROM_SEARCH_1(
        Iterable.class,
        "getArticleFromSearch",
        arg("searchTerm", String.class),
        arg("sectionId", Long.class)),

    GET_ARTICLE_SUBSCRIPTIONS(
        Iterable.class,
        "getArticleSubscriptions",
        arg("articleId", Long.class)),

    GET_ARTICLE_SUBSCRIPTIONS_1(
        Iterable.class,
        "getArticleSubscriptions",
        arg("articleId", Long.class),
        arg("locale", String.class)),

    GET_ARTICLE_TRANSLATIONS(
        Iterable.class,
        "getArticleTranslations",
        arg("articleId", Long.class)),

    GET_ARTICLES(
        Iterable.class,
        "getArticles"),

    GET_ARTICLES_1(
        Iterable.class,
        "getArticles",
        arg("category", org.zendesk.client.v2.model.hc.Category.class)),

    GET_ARTICLES_2(
        Iterable.class,
        "getArticles",
        arg("locale", String.class)),

    GET_ARTICLES_3(
        Iterable.class,
        "getArticles",
        arg("section", org.zendesk.client.v2.model.hc.Section.class)),

    GET_ARTICLES_4(
        Iterable.class,
        "getArticles",
        arg("category", org.zendesk.client.v2.model.hc.Category.class),
        arg("locale", String.class)),

    GET_ARTICLES_5(
        Iterable.class,
        "getArticles",
        arg("section", org.zendesk.client.v2.model.hc.Section.class),
        arg("locale", String.class)),

    GET_ARTICLES_FROM_ALL_LABELS(
        Iterable.class,
        "getArticlesFromAllLabels",
        arg("labels", java.util.List.class)),

    GET_ARTICLES_FROM_ANY_LABELS(
        Iterable.class,
        "getArticlesFromAnyLabels",
        arg("labels", java.util.List.class)),

    GET_ARTICLES_FROM_PAGE(
        java.util.List.class,
        "getArticlesFromPage",
        arg("page", int.class)),

    GET_ARTICLES_INCREMENTALLY(
        Iterable.class,
        "getArticlesIncrementally",
        arg("startTime", java.util.Date.class)),

    GET_ASSIGNABLE_GROUP_MEMBERSHIPS(
        Iterable.class,
        "getAssignableGroupMemberships"),

    GET_ASSIGNABLE_GROUP_MEMBERSHIPS_1(
        Iterable.class,
        "getAssignableGroupMemberships",
        arg("group_id", long.class)),

    GET_ASSIGNABLE_GROUPS(
        Iterable.class,
        "getAssignableGroups"),

    GET_ASSIGNED_TICKETS_COUNT_FOR_USER(
        org.zendesk.client.v2.model.TicketCount.class,
        "getAssignedTicketsCountForUser",
        arg("id", long.class)),

    GET_ATTACHMENT(
        org.zendesk.client.v2.model.Attachment.class,
        "getAttachment",
        arg("attachment", org.zendesk.client.v2.model.Attachment.class)),

    GET_ATTACHMENT_1(
        org.zendesk.client.v2.model.Attachment.class,
        "getAttachment",
        arg("id", long.class)),

    GET_ATTACHMENTS_FROM_ARTICLE(
        java.util.List.class,
        "getAttachmentsFromArticle",
        arg("articleId", Long.class)),

    GET_AUTHENTICATED_USER(
        org.zendesk.client.v2.model.User.class,
        "getAuthenticatedUser"),

    GET_AUTO_COMPLETE_ORGANIZATIONS(
        Iterable.class,
        "getAutoCompleteOrganizations",
        arg("name", String.class)),

    GET_AUTOMATION(
        org.zendesk.client.v2.model.Automation.class,
        "getAutomation",
        arg("id", long.class)),

    GET_AUTOMATIONS(
        Iterable.class,
        "getAutomations"),

    GET_BRANDS(
        Iterable.class,
        "getBrands"),

    GET_CC_REQUESTS(
        Iterable.class,
        "getCCRequests"),

    GET_CATEGORIES(
        Iterable.class,
        "getCategories"),

    GET_CATEGORY(
        org.zendesk.client.v2.model.hc.Category.class,
        "getCategory",
        arg("id", long.class)),

    GET_CATEGORY_TRANSLATIONS(
        Iterable.class,
        "getCategoryTranslations",
        arg("categoryId", Long.class)),

    GET_CCD_TICKETS_COUNT_FOR_USER(
        org.zendesk.client.v2.model.TicketCount.class,
        "getCcdTicketsCountForUser",
        arg("id", long.class)),

    GET_COMPLIANCE_DELETION_STATUSES(
        Iterable.class,
        "getComplianceDeletionStatuses",
        arg("userId", long.class)),

    GET_CONTENT_TAG(
        org.zendesk.client.v2.model.hc.ContentTag.class,
        "getContentTag",
        arg("contentTagId", String.class)),

    GET_CONTENT_TAGS(
        Iterable.class,
        "getContentTags"),

    GET_CONTENT_TAGS_1(
        Iterable.class,
        "getContentTags",
        arg("pageSize", int.class)),

    GET_CONTENT_TAGS_2(
        Iterable.class,
        "getContentTags",
        arg("pageSize", int.class),
        arg("namePrefix", String.class)),

    GET_CURRENT_USER(
        org.zendesk.client.v2.model.User.class,
        "getCurrentUser"),

    GET_CUSTOM_AGENT_ROLES(
        Iterable.class,
        "getCustomAgentRoles"),

    GET_CUSTOM_TICKET_STATUSES(
        Iterable.class,
        "getCustomTicketStatuses"),

    GET_DELETED_TICKETS(
        Iterable.class,
        "getDeletedTickets"),

    GET_DELETED_TICKETS_1(
        Iterable.class,
        "getDeletedTickets",
        arg("sortBy", String.class),
        arg("sortOrder", org.zendesk.client.v2.model.SortOrder.class)),

    GET_DYNAMIC_CONTENT_ITEM(
        org.zendesk.client.v2.model.dynamic.DynamicContentItem.class,
        "getDynamicContentItem",
        arg("id", long.class)),

    GET_DYNAMIC_CONTENT_ITEM_VARIANT(
        org.zendesk.client.v2.model.dynamic.DynamicContentItemVariant.class,
        "getDynamicContentItemVariant",
        arg("itemId", Long.class),
        arg("id", long.class)),

    GET_DYNAMIC_CONTENT_ITEM_VARIANTS(
        Iterable.class,
        "getDynamicContentItemVariants",
        arg("item", org.zendesk.client.v2.model.dynamic.DynamicContentItem.class)),

    GET_DYNAMIC_CONTENT_ITEMS(
        Iterable.class,
        "getDynamicContentItems"),

    GET_FORUM(
        org.zendesk.client.v2.model.Forum.class,
        "getForum",
        arg("id", long.class)),

    GET_FORUMS(
        Iterable.class,
        "getForums"),

    GET_FORUMS_1(
        java.util.List.class,
        "getForums",
        arg("category_id", long.class)),

    GET_GROUP(
        org.zendesk.client.v2.model.Group.class,
        "getGroup",
        arg("id", long.class)),

    GET_GROUP_MEMBERSHIP(
        org.zendesk.client.v2.model.GroupMembership.class,
        "getGroupMembership",
        arg("id", long.class)),

    GET_GROUP_MEMBERSHIP_1(
        org.zendesk.client.v2.model.GroupMembership.class,
        "getGroupMembership",
        arg("user_id", long.class),
        arg("group_membership_id", long.class)),

    GET_GROUP_MEMBERSHIP_BY_USER(
        Iterable.class,
        "getGroupMembershipByUser",
        arg("user_id", long.class)),

    GET_GROUP_MEMBERSHIPS(
        Iterable.class,
        "getGroupMemberships"),

    GET_GROUP_MEMBERSHIPS_1(
        Iterable.class,
        "getGroupMemberships",
        arg("group_id", long.class)),

    GET_GROUP_ORGANIZATION(
        org.zendesk.client.v2.model.OrganizationMembership.class,
        "getGroupOrganization",
        arg("user_id", long.class),
        arg("organization_membership_id", long.class)),

    GET_GROUP_USERS(
        Iterable.class,
        "getGroupUsers",
        arg("id", long.class)),

    GET_GROUPS(
        Iterable.class,
        "getGroups"),

    GET_HELP_CENTER_LOCALES(
        java.util.List.class,
        "getHelpCenterLocales"),

    GET_HOLIDAYS_FOR_SCHEDULE(
        Iterable.class,
        "getHolidaysForSchedule",
        arg("schedule", org.zendesk.client.v2.model.schedules.Schedule.class)),

    GET_HOLIDAYS_FOR_SCHEDULE_1(
        Iterable.class,
        "getHolidaysForSchedule",
        arg("scheduleId", Long.class)),

    GET_INCREMENTAL_TICKETS_RESULT(
        java.util.Map.class,
        "getIncrementalTicketsResult",
        arg("unixEpochTime", long.class)),

    GET_JIRA_LINKS(
        Iterable.class,
        "getJiraLinks"),

    GET_JOB_STATUS(
        org.zendesk.client.v2.model.JobStatus.class,
        "getJobStatus",
        arg("status", org.zendesk.client.v2.model.JobStatus.class)),

    GET_JOB_STATUS_ASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "getJobStatusAsync",
        arg("status", org.zendesk.client.v2.model.JobStatus.class)),

    GET_JOB_STATUSES(
        java.util.List.class,
        "getJobStatuses",
        arg("statuses", java.util.List.class)),

    GET_JOB_STATUSES_ASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "getJobStatusesAsync",
        arg("statuses", java.util.List.class)),

    GET_LOCALES(
        Iterable.class,
        "getLocales"),

    GET_MACRO(
        org.zendesk.client.v2.model.Macro.class,
        "getMacro",
        arg("macroId", long.class)),

    GET_MACROS(
        Iterable.class,
        "getMacros"),

    GET_OPEN_REQUESTS(
        Iterable.class,
        "getOpenRequests"),

    GET_ORGANIZATION(
        org.zendesk.client.v2.model.Organization.class,
        "getOrganization",
        arg("id", long.class)),

    GET_ORGANIZATION_FIELDS(
        Iterable.class,
        "getOrganizationFields"),

    GET_ORGANIZATION_MEMBERSHIP(
        org.zendesk.client.v2.model.OrganizationMembership.class,
        "getOrganizationMembership",
        arg("id", long.class)),

    GET_ORGANIZATION_MEMBERSHIP_BY_USER(
        Iterable.class,
        "getOrganizationMembershipByUser",
        arg("user_id", long.class)),

    GET_ORGANIZATION_MEMBERSHIP_FOR_USER(
        org.zendesk.client.v2.model.OrganizationMembership.class,
        "getOrganizationMembershipForUser",
        arg("user_id", long.class),
        arg("id", long.class)),

    GET_ORGANIZATION_MEMBERSHIPS(
        Iterable.class,
        "getOrganizationMemberships"),

    GET_ORGANIZATION_MEMBERSHIPS_FOR_ORG(
        Iterable.class,
        "getOrganizationMembershipsForOrg",
        arg("organization_id", long.class)),

    GET_ORGANIZATION_MEMBERSHIPS_FOR_USER(
        Iterable.class,
        "getOrganizationMembershipsForUser",
        arg("user_id", long.class)),

    GET_ORGANIZATION_REQUESTS(
        Iterable.class,
        "getOrganizationRequests",
        arg("organizationId", long.class)),

    GET_ORGANIZATION_TICKETS(
        Iterable.class,
        "getOrganizationTickets",
        arg("organizationId", long.class)),

    GET_ORGANIZATION_USERS(
        Iterable.class,
        "getOrganizationUsers",
        arg("id", long.class)),

    GET_ORGANIZATIONS(
        Iterable.class,
        "getOrganizations"),

    GET_ORGANIZATIONS_1(
        java.util.List.class,
        "getOrganizations",
        arg("id", long.class),
        arg("ids", long[].class)),

    GET_ORGANIZATIONS_INCREMENTALLY(
        Iterable.class,
        "getOrganizationsIncrementally",
        arg("startTime", java.util.Date.class)),

    GET_PERMISSION_GROUP(
        org.zendesk.client.v2.model.hc.PermissionGroup.class,
        "getPermissionGroup",
        arg("id", long.class)),

    GET_PERMISSION_GROUPS(
        Iterable.class,
        "getPermissionGroups"),

    GET_RECENT_TICKETS(
        Iterable.class,
        "getRecentTickets"),

    GET_REQUEST(
        org.zendesk.client.v2.model.Request.class,
        "getRequest",
        arg("id", long.class)),

    GET_REQUEST_COMMENT(
        org.zendesk.client.v2.model.Comment.class,
        "getRequestComment",
        arg("request", org.zendesk.client.v2.model.Request.class),
        arg("comment", org.zendesk.client.v2.model.Comment.class)),

    GET_REQUEST_COMMENT_1(
        org.zendesk.client.v2.model.Comment.class,
        "getRequestComment",
        arg("request", org.zendesk.client.v2.model.Request.class),
        arg("commentId", long.class)),

    GET_REQUEST_COMMENT_2(
        org.zendesk.client.v2.model.Comment.class,
        "getRequestComment",
        arg("requestId", long.class),
        arg("commentId", long.class)),

    GET_REQUEST_COMMENTS(
        Iterable.class,
        "getRequestComments",
        arg("id", long.class)),

    GET_REQUEST_COMMENTS_1(
        Iterable.class,
        "getRequestComments",
        arg("request", org.zendesk.client.v2.model.Request.class)),

    GET_REQUESTS(
        Iterable.class,
        "getRequests"),

    GET_SATISFACTION_RATING(
        org.zendesk.client.v2.model.SatisfactionRating.class,
        "getSatisfactionRating",
        arg("id", long.class)),

    GET_SATISFACTION_RATINGS(
        Iterable.class,
        "getSatisfactionRatings"),

    GET_SCHEDULE(
        org.zendesk.client.v2.model.schedules.Schedule.class,
        "getSchedule",
        arg("schedule", org.zendesk.client.v2.model.schedules.Schedule.class)),

    GET_SCHEDULE_1(
        org.zendesk.client.v2.model.schedules.Schedule.class,
        "getSchedule",
        arg("scheduleId", Long.class)),

    GET_SCHEDULES(
        Iterable.class,
        "getSchedules"),

    GET_SEARCH_TICKET_RESULTS(
        java.util.Optional.class,
        "getSearchTicketResults",
        arg("query", String.class),
        arg("queryParams", java.util.Map.class),
        arg("sortBy", String.class),
        arg("sortOrder", org.zendesk.client.v2.model.SortOrder.class)),

    GET_SECTION(
        org.zendesk.client.v2.model.hc.Section.class,
        "getSection",
        arg("id", long.class)),

    GET_SECTION_SUBSCRIPTIONS(
        Iterable.class,
        "getSectionSubscriptions",
        arg("sectionId", Long.class)),

    GET_SECTION_SUBSCRIPTIONS_1(
        Iterable.class,
        "getSectionSubscriptions",
        arg("sectionId", Long.class),
        arg("locale", String.class)),

    GET_SECTION_TRANSLATIONS(
        Iterable.class,
        "getSectionTranslations",
        arg("sectionId", Long.class)),

    GET_SECTIONS(
        Iterable.class,
        "getSections"),

    GET_SECTIONS_1(
        Iterable.class,
        "getSections",
        arg("category", org.zendesk.client.v2.model.hc.Category.class)),

    GET_SECTIONS_2(
        Iterable.class,
        "getSections",
        arg("userSegment", org.zendesk.client.v2.model.hc.UserSegment.class)),

    GET_SOLVED_REQUESTS(
        Iterable.class,
        "getSolvedRequests"),

    GET_SUSPENDED_TICKETS(
        Iterable.class,
        "getSuspendedTickets"),

    GET_TARGET(
        org.zendesk.client.v2.model.targets.Target.class,
        "getTarget",
        arg("id", long.class)),

    GET_TARGETS(
        Iterable.class,
        "getTargets"),

    GET_TICKET(
        org.zendesk.client.v2.model.Ticket.class,
        "getTicket",
        arg("id", long.class)),

    GET_TICKET_AUDIT(
        org.zendesk.client.v2.model.Audit.class,
        "getTicketAudit",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class),
        arg("audit", org.zendesk.client.v2.model.Audit.class)),

    GET_TICKET_AUDIT_1(
        org.zendesk.client.v2.model.Audit.class,
        "getTicketAudit",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class),
        arg("id", long.class)),

    GET_TICKET_AUDIT_2(
        org.zendesk.client.v2.model.Audit.class,
        "getTicketAudit",
        arg("ticketId", long.class),
        arg("auditId", long.class)),

    GET_TICKET_AUDITS(
        Iterable.class,
        "getTicketAudits",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class)),

    GET_TICKET_AUDITS_1(
        Iterable.class,
        "getTicketAudits",
        arg("ticketId0", Long.class)),

    GET_TICKET_COLLABORATORS(
        java.util.List.class,
        "getTicketCollaborators",
        arg("id", long.class)),

    GET_TICKET_COMMENTS(
        Iterable.class,
        "getTicketComments",
        arg("id", long.class)),

    GET_TICKET_COMMENTS_1(
        Iterable.class,
        "getTicketComments",
        arg("id", long.class),
        arg("order", org.zendesk.client.v2.model.SortOrder.class)),

    GET_TICKET_FIELD(
        org.zendesk.client.v2.model.Field.class,
        "getTicketField",
        arg("id", long.class)),

    GET_TICKET_FIELDS(
        Iterable.class,
        "getTicketFields"),

    GET_TICKET_FORM(
        org.zendesk.client.v2.model.TicketForm.class,
        "getTicketForm",
        arg("id", long.class)),

    GET_TICKET_FORMS(
        java.util.List.class,
        "getTicketForms"),

    GET_TICKET_INCIDENTS(
        Iterable.class,
        "getTicketIncidents",
        arg("id", long.class)),

    GET_TICKET_METRIC(
        org.zendesk.client.v2.model.Metric.class,
        "getTicketMetric",
        arg("id", long.class)),

    GET_TICKET_METRIC_BY_TICKET(
        org.zendesk.client.v2.model.Metric.class,
        "getTicketMetricByTicket",
        arg("id", long.class)),

    GET_TICKET_METRICS(
        Iterable.class,
        "getTicketMetrics"),

    GET_TICKETS(
        Iterable.class,
        "getTickets"),

    GET_TICKETS_1(
        java.util.List.class,
        "getTickets",
        arg("id", long.class),
        arg("ids", long[].class)),

    GET_TICKETS_BY_EXTERNAL_ID(
        Iterable.class,
        "getTicketsByExternalId",
        arg("externalId", String.class)),

    GET_TICKETS_BY_EXTERNAL_ID_1(
        Iterable.class,
        "getTicketsByExternalId",
        arg("externalId", String.class),
        arg("includeArchived", boolean.class)),

    GET_TICKETS_COUNT(
        org.zendesk.client.v2.model.TicketCount.class,
        "getTicketsCount"),

    GET_TICKETS_COUNT_FOR_ORGANIZATION(
        org.zendesk.client.v2.model.TicketCount.class,
        "getTicketsCountForOrganization",
        arg("id", long.class)),

    GET_TICKETS_FROM_SEARCH(
        Iterable.class,
        "getTicketsFromSearch",
        arg("searchTerm", String.class)),

    GET_TICKETS_INCREMENTALLY(
        Iterable.class,
        "getTicketsIncrementally",
        arg("startTime", java.util.Date.class)),

    GET_TICKETS_INCREMENTALLY_1(
        Iterable.class,
        "getTicketsIncrementally",
        arg("startTime", java.util.Date.class),
        arg("endTime", java.util.Date.class)),

    GET_TIME_ZONES(
        java.util.List.class,
        "getTimeZones"),

    GET_TOPIC(
        org.zendesk.client.v2.model.Topic.class,
        "getTopic",
        arg("id", long.class)),

    GET_TOPICS(
        Iterable.class,
        "getTopics"),

    GET_TOPICS_1(
        java.util.List.class,
        "getTopics",
        arg("forum_id", long.class)),

    GET_TOPICS_2(
        Iterable.class,
        "getTopics",
        arg("userSegment", org.zendesk.client.v2.model.hc.UserSegment.class)),

    GET_TOPICS_3(
        java.util.List.class,
        "getTopics",
        arg("id", long.class),
        arg("ids", long[].class)),

    GET_TOPICS_BY_USER(
        java.util.List.class,
        "getTopicsByUser",
        arg("user_id", long.class)),

    GET_TRIGGER(
        org.zendesk.client.v2.model.Trigger.class,
        "getTrigger",
        arg("id", long.class)),

    GET_TRIGGERS(
        Iterable.class,
        "getTriggers"),

    GET_TRIGGERS_1(
        Iterable.class,
        "getTriggers",
        arg("categoryId0", String.class),
        arg("active", boolean.class),
        arg("sortBy", String.class),
        arg("sortOrder", org.zendesk.client.v2.model.SortOrder.class)),

    GET_TWITTER_MONITORS(
        Iterable.class,
        "getTwitterMonitors"),

    GET_USER(
        org.zendesk.client.v2.model.User.class,
        "getUser",
        arg("id", long.class)),

    GET_USER_CCD_TICKETS(
        Iterable.class,
        "getUserCCDTickets",
        arg("userId", long.class)),

    GET_USER_FIELDS(
        Iterable.class,
        "getUserFields"),

    GET_USER_IDENTITIES(
        java.util.List.class,
        "getUserIdentities",
        arg("user", org.zendesk.client.v2.model.User.class)),

    GET_USER_IDENTITIES_1(
        java.util.List.class,
        "getUserIdentities",
        arg("userId", long.class)),

    GET_USER_IDENTITY(
        org.zendesk.client.v2.model.Identity.class,
        "getUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    GET_USER_IDENTITY_1(
        org.zendesk.client.v2.model.Identity.class,
        "getUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identityId", long.class)),

    GET_USER_IDENTITY_2(
        org.zendesk.client.v2.model.Identity.class,
        "getUserIdentity",
        arg("userId", long.class),
        arg("identityId", long.class)),

    GET_USER_RELATED_INFO(
        org.zendesk.client.v2.model.UserRelatedInfo.class,
        "getUserRelatedInfo",
        arg("userId", long.class)),

    GET_USER_REQUESTED_TICKETS(
        Iterable.class,
        "getUserRequestedTickets",
        arg("userId", long.class)),

    GET_USER_REQUESTS(
        Iterable.class,
        "getUserRequests",
        arg("id", long.class)),

    GET_USER_REQUESTS_1(
        Iterable.class,
        "getUserRequests",
        arg("user", org.zendesk.client.v2.model.User.class)),

    GET_USER_SEGMENT(
        org.zendesk.client.v2.model.hc.UserSegment.class,
        "getUserSegment",
        arg("id", long.class)),

    GET_USER_SEGMENTS(
        Iterable.class,
        "getUserSegments"),

    GET_USER_SEGMENTS_1(
        Iterable.class,
        "getUserSegments",
        arg("id", long.class)),

    GET_USER_SEGMENTS_APPLICABLE(
        Iterable.class,
        "getUserSegmentsApplicable"),

    GET_USER_SUBSCRIPTIONS(
        Iterable.class,
        "getUserSubscriptions",
        arg("user", org.zendesk.client.v2.model.User.class)),

    GET_USER_SUBSCRIPTIONS_1(
        Iterable.class,
        "getUserSubscriptions",
        arg("userId0", Long.class)),

    GET_USERS(
        Iterable.class,
        "getUsers"),

    GET_USERS_1(
        java.util.List.class,
        "getUsers",
        arg("id", long.class),
        arg("ids", long[].class)),

    GET_USERS_BY_EXTERNAL_IDS(
        java.util.List.class,
        "getUsersByExternalIds",
        arg("externalId", String.class),
        arg("externalIds", new String[0].getClass())),

    GET_USERS_BY_EXTERNAL_IDS_1(
        java.util.List.class,
        "getUsersByExternalIds",
        arg("externalId0", long.class),
        arg("externalId0s", long[].class)),

    GET_USERS_BY_ROLE(
        Iterable.class,
        "getUsersByRole",
        arg("role", String.class),
        arg("roles", new String[0].getClass())),

    GET_USERS_INCREMENTALLY(
        Iterable.class,
        "getUsersIncrementally",
        arg("startTime", java.util.Date.class)),

    GET_VIEW(
        Iterable.class,
        "getView",
        arg("id", long.class)),

    GET_VIEWS(
        Iterable.class,
        "getViews"),

    IMPORT_TICKET(
        org.zendesk.client.v2.model.Ticket.class,
        "importTicket",
        arg("ticketImport", org.zendesk.client.v2.model.TicketImport.class)),

    IMPORT_TOPIC(
        org.zendesk.client.v2.model.Topic.class,
        "importTopic",
        arg("topic", org.zendesk.client.v2.model.Topic.class)),

    LIST_HELP_CENTER_LOCALES(
        org.zendesk.client.v2.model.hc.Locales.class,
        "listHelpCenterLocales"),

    LOOKUP_ORGANIZATIONS_BY_EXTERNAL_ID(
        Iterable.class,
        "lookupOrganizationsByExternalId",
        arg("externalId", String.class)),

    LOOKUP_USER_BY_EMAIL(
        Iterable.class,
        "lookupUserByEmail",
        arg("email", String.class)),

    LOOKUP_USER_BY_EXTERNAL_ID(
        Iterable.class,
        "lookupUserByExternalId",
        arg("externalId", String.class)),

    MACROS_SHOW_CHANGES_TO_TICKET(
        org.zendesk.client.v2.model.Ticket.class,
        "macrosShowChangesToTicket",
        arg("macroId", long.class)),

    MACROS_SHOW_TICKET_AFTER_CHANGES(
        org.zendesk.client.v2.model.Ticket.class,
        "macrosShowTicketAfterChanges",
        arg("ticketId", long.class),
        arg("macroId", long.class)),

    MAKE_PRIVATE_TICKET_AUDIT(
        void.class,
        "makePrivateTicketAudit",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class),
        arg("audit", org.zendesk.client.v2.model.Audit.class)),

    MAKE_PRIVATE_TICKET_AUDIT_1(
        void.class,
        "makePrivateTicketAudit",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class),
        arg("id", long.class)),

    MAKE_PRIVATE_TICKET_AUDIT_2(
        void.class,
        "makePrivateTicketAudit",
        arg("ticketId", long.class),
        arg("auditId", long.class)),

    MARK_TICKET_AS_SPAM(
        void.class,
        "markTicketAsSpam",
        arg("id", long.class)),

    MARK_TICKET_AS_SPAM_1(
        void.class,
        "markTicketAsSpam",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class)),

    MERGE_USERS(
        org.zendesk.client.v2.model.User.class,
        "mergeUsers",
        arg("userIdThatWillRemain", long.class),
        arg("userIdThatWillBeMerged", long.class)),

    NOTIFY_APP(
        void.class,
        "notifyApp",
        arg("json", String.class)),

    PERMANENTLY_DELETE_TICKET(
        org.zendesk.client.v2.model.JobStatus.class,
        "permanentlyDeleteTicket",
        arg("id", long.class)),

    PERMANENTLY_DELETE_TICKET_1(
        org.zendesk.client.v2.model.JobStatus.class,
        "permanentlyDeleteTicket",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class)),

    PERMANENTLY_DELETE_TICKETS(
        org.zendesk.client.v2.model.JobStatus.class,
        "permanentlyDeleteTickets",
        arg("id", long.class),
        arg("ids", long[].class)),

    PERMANENTLY_DELETE_USER(
        org.zendesk.client.v2.model.User.class,
        "permanentlyDeleteUser",
        arg("id", long.class)),

    PERMANENTLY_DELETE_USER_1(
        org.zendesk.client.v2.model.User.class,
        "permanentlyDeleteUser",
        arg("user", org.zendesk.client.v2.model.User.class)),

    QUEUE_CREATE_TICKET_ASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "queueCreateTicketAsync",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class)),

    REMOVE_TAG_FROM_ORGANISATIONS(
        java.util.List.class,
        "removeTagFromOrganisations",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    REMOVE_TAG_FROM_TICKET(
        java.util.List.class,
        "removeTagFromTicket",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    REMOVE_TAG_FROM_TOPICS(
        java.util.List.class,
        "removeTagFromTopics",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    REQUEST_VERIFY_USER_IDENTITY(
        org.zendesk.client.v2.model.Identity.class,
        "requestVerifyUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    REQUEST_VERIFY_USER_IDENTITY_1(
        org.zendesk.client.v2.model.Identity.class,
        "requestVerifyUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identityId", long.class)),

    REQUEST_VERIFY_USER_IDENTITY_2(
        org.zendesk.client.v2.model.Identity.class,
        "requestVerifyUserIdentity",
        arg("userId", long.class),
        arg("identityId", long.class)),

    RESET_USER_PASSWORD(
        void.class,
        "resetUserPassword",
        arg("id", long.class),
        arg("password", String.class)),

    RESET_USER_PASSWORD_1(
        void.class,
        "resetUserPassword",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("password", String.class)),

    SEARCH_TRIGGERS(
        Iterable.class,
        "searchTriggers",
        arg("query", String.class)),

    SEARCH_TRIGGERS_1(
        Iterable.class,
        "searchTriggers",
        arg("query", String.class),
        arg("active", boolean.class),
        arg("sortBy", String.class),
        arg("sortOrder", org.zendesk.client.v2.model.SortOrder.class)),

    SET_GROUP_MEMBERSHIP_AS_DEFAULT(
        java.util.List.class,
        "setGroupMembershipAsDefault",
        arg("user_id", long.class),
        arg("groupMembership", org.zendesk.client.v2.model.GroupMembership.class)),

    SET_ORGANIZATION_MEMBERSHIP_AS_DEFAULT(
        java.util.List.class,
        "setOrganizationMembershipAsDefault",
        arg("user_id", long.class),
        arg("organizationMembership", org.zendesk.client.v2.model.OrganizationMembership.class)),

    SET_TAG_ON_ORGANISATIONS(
        java.util.List.class,
        "setTagOnOrganisations",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    SET_TAG_ON_TICKET(
        java.util.List.class,
        "setTagOnTicket",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    SET_TAG_ON_TOPICS(
        java.util.List.class,
        "setTagOnTopics",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    SET_USER_PRIMARY_IDENTITY(
        java.util.List.class,
        "setUserPrimaryIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    SET_USER_PRIMARY_IDENTITY_1(
        java.util.List.class,
        "setUserPrimaryIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identityId", long.class)),

    SET_USER_PRIMARY_IDENTITY_2(
        java.util.List.class,
        "setUserPrimaryIdentity",
        arg("userId", long.class),
        arg("identityId", long.class)),

    SHOW_ARTICLE_TRANSLATION(
        org.zendesk.client.v2.model.hc.Translation.class,
        "showArticleTranslation",
        arg("articleId0", long.class),
        arg("locale", String.class)),

    SHOW_CATEGORY_TRANSLATION(
        org.zendesk.client.v2.model.hc.Translation.class,
        "showCategoryTranslation",
        arg("categoryId1", long.class),
        arg("locale", String.class)),

    SHOW_SECTION_TRANSLATION(
        org.zendesk.client.v2.model.hc.Translation.class,
        "showSectionTranslation",
        arg("sectionId0", long.class),
        arg("locale", String.class)),

    SUSPEND_USER(
        org.zendesk.client.v2.model.User.class,
        "suspendUser",
        arg("id", long.class)),

    TRUST_TICKET_AUDIT(
        void.class,
        "trustTicketAudit",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class),
        arg("audit", org.zendesk.client.v2.model.Audit.class)),

    TRUST_TICKET_AUDIT_1(
        void.class,
        "trustTicketAudit",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class),
        arg("id", long.class)),

    TRUST_TICKET_AUDIT_2(
        void.class,
        "trustTicketAudit",
        arg("ticketId", long.class),
        arg("auditId", long.class)),

    UNASSIGN_ORGANIZATION_MEMBERSHIP(
        void.class,
        "unassignOrganizationMembership",
        arg("user_id", long.class),
        arg("organization_id", long.class)),

    UNSUSPEND_USER(
        org.zendesk.client.v2.model.User.class,
        "unsuspendUser",
        arg("id", long.class)),

    UPDATE_ARTICLE(
        org.zendesk.client.v2.model.hc.Article.class,
        "updateArticle",
        arg("article", org.zendesk.client.v2.model.hc.Article.class)),

    UPDATE_ARTICLE_TRANSLATION(
        org.zendesk.client.v2.model.hc.Translation.class,
        "updateArticleTranslation",
        arg("articleId", Long.class),
        arg("locale", String.class),
        arg("translation", org.zendesk.client.v2.model.hc.Translation.class)),

    UPDATE_AUTOMATION(
        org.zendesk.client.v2.model.Automation.class,
        "updateAutomation",
        arg("automationId", Long.class),
        arg("automation", org.zendesk.client.v2.model.Automation.class)),

    UPDATE_CATEGORY(
        org.zendesk.client.v2.model.hc.Category.class,
        "updateCategory",
        arg("category", org.zendesk.client.v2.model.hc.Category.class)),

    UPDATE_CATEGORY_TRANSLATION(
        org.zendesk.client.v2.model.hc.Translation.class,
        "updateCategoryTranslation",
        arg("categoryId", Long.class),
        arg("locale", String.class),
        arg("translation", org.zendesk.client.v2.model.hc.Translation.class)),

    UPDATE_CONTENT_TAG(
        org.zendesk.client.v2.model.hc.ContentTag.class,
        "updateContentTag",
        arg("contentTag", org.zendesk.client.v2.model.hc.ContentTag.class)),

    UPDATE_DYNAMIC_CONTENT_ITEM(
        org.zendesk.client.v2.model.dynamic.DynamicContentItem.class,
        "updateDynamicContentItem",
        arg("item", org.zendesk.client.v2.model.dynamic.DynamicContentItem.class)),

    UPDATE_DYNAMIC_CONTENT_ITEM_VARIANT(
        org.zendesk.client.v2.model.dynamic.DynamicContentItemVariant.class,
        "updateDynamicContentItemVariant",
        arg("itemId", Long.class),
        arg("variant", org.zendesk.client.v2.model.dynamic.DynamicContentItemVariant.class)),

    UPDATE_FORUM(
        org.zendesk.client.v2.model.Forum.class,
        "updateForum",
        arg("forum", org.zendesk.client.v2.model.Forum.class)),

    UPDATE_GROUP(
        org.zendesk.client.v2.model.Group.class,
        "updateGroup",
        arg("group", org.zendesk.client.v2.model.Group.class)),

    UPDATE_INSTALLATION(
        void.class,
        "updateInstallation",
        arg("installationId", int.class),
        arg("json", String.class)),

    UPDATE_MACRO(
        org.zendesk.client.v2.model.Macro.class,
        "updateMacro",
        arg("macroId0", Long.class),
        arg("macro", org.zendesk.client.v2.model.Macro.class)),

    UPDATE_ORGANIZATION(
        org.zendesk.client.v2.model.Organization.class,
        "updateOrganization",
        arg("organization", org.zendesk.client.v2.model.Organization.class)),

    UPDATE_ORGANIZATIONS(
        org.zendesk.client.v2.model.JobStatus.class,
        "updateOrganizations",
        arg("organizationList", java.util.List.class)),

    UPDATE_ORGANIZATIONS_1(
        org.zendesk.client.v2.model.JobStatus.class,
        "updateOrganizations",
        arg("organizations", new org.zendesk.client.v2.model.Organization[0].getClass())),

    UPDATE_ORGANIZATIONS_ASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "updateOrganizationsAsync",
        arg("organizationList", java.util.List.class)),

    UPDATE_PERMISSION_GROUP(
        org.zendesk.client.v2.model.hc.PermissionGroup.class,
        "updatePermissionGroup",
        arg("permissionGroup", org.zendesk.client.v2.model.hc.PermissionGroup.class)),

    UPDATE_REQUEST(
        org.zendesk.client.v2.model.Request.class,
        "updateRequest",
        arg("request", org.zendesk.client.v2.model.Request.class)),

    UPDATE_SECTION(
        org.zendesk.client.v2.model.hc.Section.class,
        "updateSection",
        arg("section", org.zendesk.client.v2.model.hc.Section.class)),

    UPDATE_SECTION_TRANSLATION(
        org.zendesk.client.v2.model.hc.Translation.class,
        "updateSectionTranslation",
        arg("sectionId", Long.class),
        arg("locale", String.class),
        arg("translation", org.zendesk.client.v2.model.hc.Translation.class)),

    UPDATE_TICKET(
        org.zendesk.client.v2.model.Ticket.class,
        "updateTicket",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class)),

    UPDATE_TICKET_FIELD(
        org.zendesk.client.v2.model.Field.class,
        "updateTicketField",
        arg("field", org.zendesk.client.v2.model.Field.class)),

    UPDATE_TICKET_FORM(
        org.zendesk.client.v2.model.TicketForm.class,
        "updateTicketForm",
        arg("ticketForm", org.zendesk.client.v2.model.TicketForm.class)),

    UPDATE_TICKETS(
        org.zendesk.client.v2.model.JobStatus.class,
        "updateTickets",
        arg("ticketList", java.util.List.class)),

    UPDATE_TICKETS_1(
        org.zendesk.client.v2.model.JobStatus.class,
        "updateTickets",
        arg("tickets", new org.zendesk.client.v2.model.Ticket[0].getClass())),

    UPDATE_TICKETS_ASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "updateTicketsAsync",
        arg("ticketList", java.util.List.class)),

    UPDATE_TOPIC(
        org.zendesk.client.v2.model.Topic.class,
        "updateTopic",
        arg("topic", org.zendesk.client.v2.model.Topic.class)),

    UPDATE_TRIGGER(
        org.zendesk.client.v2.model.Trigger.class,
        "updateTrigger",
        arg("triggerId0", Long.class),
        arg("trigger", org.zendesk.client.v2.model.Trigger.class)),

    UPDATE_USER(
        org.zendesk.client.v2.model.User.class,
        "updateUser",
        arg("user", org.zendesk.client.v2.model.User.class)),

    UPDATE_USER_IDENTITY(
        org.zendesk.client.v2.model.Identity.class,
        "updateUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    UPDATE_USER_IDENTITY_1(
        org.zendesk.client.v2.model.Identity.class,
        "updateUserIdentity",
        arg("userId", long.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    UPDATE_USER_SEGMENT(
        org.zendesk.client.v2.model.hc.UserSegment.class,
        "updateUserSegment",
        arg("userSegment", org.zendesk.client.v2.model.hc.UserSegment.class)),

    UPDATE_USERS(
        org.zendesk.client.v2.model.JobStatus.class,
        "updateUsers",
        arg("users", new org.zendesk.client.v2.model.User[0].getClass())),

    UPDATE_USERS_1(
        org.zendesk.client.v2.model.JobStatus.class,
        "updateUsers",
        arg("usersList", java.util.List.class)),

    UPDATE_USERS_ASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "updateUsersAsync",
        arg("usersList", java.util.List.class)),

    VERIFY_USER_IDENTITY(
        org.zendesk.client.v2.model.Identity.class,
        "verifyUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    VERIFY_USER_IDENTITY_1(
        org.zendesk.client.v2.model.Identity.class,
        "verifyUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identityId", long.class)),

    VERIFY_USER_IDENTITY_2(
        org.zendesk.client.v2.model.Identity.class,
        "verifyUserIdentity",
        arg("userId", long.class),
        arg("identityId", long.class));

    private final ApiMethod apiMethod;

    ZendeskApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(Zendesk.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<String> getSetterArgNames() { return apiMethod.getSetterArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
