/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// RepositoryApplyConfiguration represents an declarative configuration of the Repository type for use
// with apply.
type RepositoryApplyConfiguration struct {
	ID        *string                             `json:"id,omitempty"`
	Name      *string                             `json:"name,omitempty"`
	URL       *string                             `json:"url,omitempty"`
	Snapshots *RepositoryPolicyApplyConfiguration `json:"snapshots,omitempty"`
	Releases  *RepositoryPolicyApplyConfiguration `json:"releases,omitempty"`
}

// RepositoryApplyConfiguration constructs an declarative configuration of the Repository type for use with
// apply.
func Repository() *RepositoryApplyConfiguration {
	return &RepositoryApplyConfiguration{}
}

// WithID sets the ID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ID field is set to the value of the last call.
func (b *RepositoryApplyConfiguration) WithID(value string) *RepositoryApplyConfiguration {
	b.ID = &value
	return b
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *RepositoryApplyConfiguration) WithName(value string) *RepositoryApplyConfiguration {
	b.Name = &value
	return b
}

// WithURL sets the URL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the URL field is set to the value of the last call.
func (b *RepositoryApplyConfiguration) WithURL(value string) *RepositoryApplyConfiguration {
	b.URL = &value
	return b
}

// WithSnapshots sets the Snapshots field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Snapshots field is set to the value of the last call.
func (b *RepositoryApplyConfiguration) WithSnapshots(value *RepositoryPolicyApplyConfiguration) *RepositoryApplyConfiguration {
	b.Snapshots = value
	return b
}

// WithReleases sets the Releases field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Releases field is set to the value of the last call.
func (b *RepositoryApplyConfiguration) WithReleases(value *RepositoryPolicyApplyConfiguration) *RepositoryApplyConfiguration {
	b.Releases = value
	return b
}
