/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformstatus.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.integrationplatformstatus.traits.Logging;
import org.apache.camel.v1.integrationplatformstatus.traits.logging.Configuration;
import org.apache.camel.v1.integrationplatformstatus.traits.logging.ConfigurationBuilder;
import org.apache.camel.v1.integrationplatformstatus.traits.logging.ConfigurationFluent;

public class LoggingFluent<A extends LoggingFluent<A>>
extends BaseFluent<A> {
    private Boolean color;
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private String format;
    private Boolean json;
    private Boolean jsonPrettyPrint;
    private Logging.Level level;

    public LoggingFluent() {
    }

    public LoggingFluent(Logging instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Logging instance) {
        Logging logging = instance = instance != null ? instance : new Logging();
        if (instance != null) {
            this.withColor(instance.getColor());
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withFormat(instance.getFormat());
            this.withJson(instance.getJson());
            this.withJsonPrettyPrint(instance.getJsonPrettyPrint());
            this.withLevel(instance.getLevel());
        }
    }

    public Boolean getColor() {
        return this.color;
    }

    public A withColor(Boolean color) {
        this.color = color;
        return (A)((Object)this);
    }

    public boolean hasColor() {
        return this.color != null;
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public String getFormat() {
        return this.format;
    }

    public A withFormat(String format) {
        this.format = format;
        return (A)((Object)this);
    }

    public boolean hasFormat() {
        return this.format != null;
    }

    public Boolean getJson() {
        return this.json;
    }

    public A withJson(Boolean json) {
        this.json = json;
        return (A)((Object)this);
    }

    public boolean hasJson() {
        return this.json != null;
    }

    public Boolean getJsonPrettyPrint() {
        return this.jsonPrettyPrint;
    }

    public A withJsonPrettyPrint(Boolean jsonPrettyPrint) {
        this.jsonPrettyPrint = jsonPrettyPrint;
        return (A)((Object)this);
    }

    public boolean hasJsonPrettyPrint() {
        return this.jsonPrettyPrint != null;
    }

    public Logging.Level getLevel() {
        return this.level;
    }

    public A withLevel(Logging.Level level) {
        this.level = level;
        return (A)((Object)this);
    }

    public boolean hasLevel() {
        return this.level != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LoggingFluent that = (LoggingFluent)((Object)o);
        if (!Objects.equals(this.color, that.color)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.format, that.format)) {
            return false;
        }
        if (!Objects.equals(this.json, that.json)) {
            return false;
        }
        if (!Objects.equals(this.jsonPrettyPrint, that.jsonPrettyPrint)) {
            return false;
        }
        return Objects.equals((Object)this.level, (Object)that.level);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.color, this.configuration, this.enabled, this.format, this.json, this.jsonPrettyPrint, this.level, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.color != null) {
            sb.append("color:");
            sb.append(this.color + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.format != null) {
            sb.append("format:");
            sb.append(this.format + ",");
        }
        if (this.json != null) {
            sb.append("json:");
            sb.append(this.json + ",");
        }
        if (this.jsonPrettyPrint != null) {
            sb.append("jsonPrettyPrint:");
            sb.append(this.jsonPrettyPrint + ",");
        }
        if (this.level != null) {
            sb.append("level:");
            sb.append((Object)this.level);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withColor() {
        return this.withColor(true);
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withJson() {
        return this.withJson(true);
    }

    public A withJsonPrettyPrint() {
        return this.withJsonPrettyPrint(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)LoggingFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

