/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// FailureApplyConfiguration represents an declarative configuration of the Failure type for use
// with apply.
type FailureApplyConfiguration struct {
	Reason   *string                            `json:"reason,omitempty"`
	Time     *v1.Time                           `json:"time,omitempty"`
	Recovery *FailureRecoveryApplyConfiguration `json:"recovery,omitempty"`
}

// FailureApplyConfiguration constructs an declarative configuration of the Failure type for use with
// apply.
func Failure() *FailureApplyConfiguration {
	return &FailureApplyConfiguration{}
}

// WithReason sets the Reason field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Reason field is set to the value of the last call.
func (b *FailureApplyConfiguration) WithReason(value string) *FailureApplyConfiguration {
	b.Reason = &value
	return b
}

// WithTime sets the Time field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Time field is set to the value of the last call.
func (b *FailureApplyConfiguration) WithTime(value v1.Time) *FailureApplyConfiguration {
	b.Time = &value
	return b
}

// WithRecovery sets the Recovery field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Recovery field is set to the value of the last call.
func (b *FailureApplyConfiguration) WithRecovery(value *FailureRecoveryApplyConfiguration) *FailureApplyConfiguration {
	b.Recovery = value
	return b
}
