/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// IntegrationKitLister helps list IntegrationKits.
// All objects returned here must be treated as read-only.
type IntegrationKitLister interface {
	// List lists all IntegrationKits in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.IntegrationKit, err error)
	// IntegrationKits returns an object that can list and get IntegrationKits.
	IntegrationKits(namespace string) IntegrationKitNamespaceLister
	IntegrationKitListerExpansion
}

// integrationKitLister implements the IntegrationKitLister interface.
type integrationKitLister struct {
	indexer cache.Indexer
}

// NewIntegrationKitLister returns a new IntegrationKitLister.
func NewIntegrationKitLister(indexer cache.Indexer) IntegrationKitLister {
	return &integrationKitLister{indexer: indexer}
}

// List lists all IntegrationKits in the indexer.
func (s *integrationKitLister) List(selector labels.Selector) (ret []*v1.IntegrationKit, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.IntegrationKit))
	})
	return ret, err
}

// IntegrationKits returns an object that can list and get IntegrationKits.
func (s *integrationKitLister) IntegrationKits(namespace string) IntegrationKitNamespaceLister {
	return integrationKitNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// IntegrationKitNamespaceLister helps list and get IntegrationKits.
// All objects returned here must be treated as read-only.
type IntegrationKitNamespaceLister interface {
	// List lists all IntegrationKits in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.IntegrationKit, err error)
	// Get retrieves the IntegrationKit from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.IntegrationKit, error)
	IntegrationKitNamespaceListerExpansion
}

// integrationKitNamespaceLister implements the IntegrationKitNamespaceLister
// interface.
type integrationKitNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all IntegrationKits in the indexer for a given namespace.
func (s integrationKitNamespaceLister) List(selector labels.Selector) (ret []*v1.IntegrationKit, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.IntegrationKit))
	})
	return ret, err
}

// Get retrieves the IntegrationKit from the indexer for a given namespace and name.
func (s integrationKitNamespaceLister) Get(name string) (*v1.IntegrationKit, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("integrationkit"), name)
	}
	return obj.(*v1.IntegrationKit), nil
}
