/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.tables;

import org.caffinitas.ohc.tables.KeyBuffer;
import org.caffinitas.ohc.tables.Uns;
import org.caffinitas.ohc.tables.Util;

final class HashEntries {
    HashEntries() {
    }

    static void init(long hash, long keyLen, long valueLen, long hashEntryAdr) {
        Uns.putLong(hashEntryAdr, 16L, hash);
        Uns.putLong(hashEntryAdr, 32L, keyLen);
        Uns.putLong(hashEntryAdr, 24L, valueLen);
        Uns.putInt(hashEntryAdr, 0L, 1);
        Uns.putInt(hashEntryAdr, 4L, 0);
    }

    static boolean compareKey(long hashEntryAdr, KeyBuffer key, long serKeyLen) {
        if (hashEntryAdr == 0L) {
            return false;
        }
        long blkOff = 40L;
        int p = 0;
        byte[] arr = key.array();
        while ((long)p <= serKeyLen - 8L) {
            if (Uns.getLong(hashEntryAdr, blkOff) != Uns.getLongFromByteArray(arr, p)) {
                return false;
            }
            p += 8;
            blkOff += 8L;
        }
        while ((long)p <= serKeyLen - 4L) {
            if (Uns.getInt(hashEntryAdr, blkOff) != Uns.getIntFromByteArray(arr, p)) {
                return false;
            }
            p += 4;
            blkOff += 4L;
        }
        while ((long)p <= serKeyLen - 2L) {
            if (Uns.getShort(hashEntryAdr, blkOff) != Uns.getShortFromByteArray(arr, p)) {
                return false;
            }
            p += 2;
            blkOff += 2L;
        }
        while ((long)p < serKeyLen) {
            if (Uns.getByte(hashEntryAdr, blkOff) != arr[p]) {
                return false;
            }
            ++p;
            ++blkOff;
        }
        return true;
    }

    static boolean compare(long hashEntryAdr, long offset, long otherHashEntryAdr, long otherOffset, long len) {
        if (hashEntryAdr == 0L) {
            return false;
        }
        int p = 0;
        while ((long)p <= len - 8L) {
            if (Uns.getLong(hashEntryAdr, offset) != Uns.getLong(otherHashEntryAdr, otherOffset)) {
                return false;
            }
            p += 8;
            offset += 8L;
            otherOffset += 8L;
        }
        while ((long)p <= len - 4L) {
            if (Uns.getInt(hashEntryAdr, offset) != Uns.getInt(otherHashEntryAdr, otherOffset)) {
                return false;
            }
            p += 4;
            offset += 4L;
            otherOffset += 4L;
        }
        while ((long)p <= len - 2L) {
            if (Uns.getShort(hashEntryAdr, offset) != Uns.getShort(otherHashEntryAdr, otherOffset)) {
                return false;
            }
            p += 2;
            offset += 2L;
            otherOffset += 2L;
        }
        while ((long)p < len) {
            if (Uns.getByte(hashEntryAdr, offset) != Uns.getByte(otherHashEntryAdr, otherOffset)) {
                return false;
            }
            ++p;
            ++offset;
            ++otherOffset;
        }
        return true;
    }

    static int getLRUIndex(long hashEntryAdr) {
        return Uns.getInt(hashEntryAdr, 8L);
    }

    static void setLRUIndex(long hashEntryAdr, int lruIndex) {
        Uns.putInt(hashEntryAdr, 8L, lruIndex);
    }

    static long getHash(long hashEntryAdr) {
        return Uns.getLong(hashEntryAdr, 16L);
    }

    static long getKeyLen(long hashEntryAdr) {
        return Uns.getLong(hashEntryAdr, 32L);
    }

    static long getValueLen(long hashEntryAdr) {
        return Uns.getLong(hashEntryAdr, 24L);
    }

    static long getAllocLen(long address) {
        return Util.allocLen(HashEntries.getKeyLen(address), HashEntries.getValueLen(address));
    }

    static void reference(long hashEntryAdr) {
        Uns.increment(hashEntryAdr, 0L);
    }

    static boolean dereference(long hashEntryAdr) {
        if (Uns.decrement(hashEntryAdr, 0L)) {
            Uns.free(hashEntryAdr);
            return true;
        }
        return false;
    }
}

