/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.CompactionStrategyManager;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.LeveledManifest;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.Scrubber;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableHeaderFix;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.tools.BulkLoader;
import org.apache.cassandra.tools.Util;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;

public class StandaloneScrubber {
    public static final String REINSERT_OVERFLOWED_TTL_OPTION_DESCRIPTION = "Rewrites rows with overflowed expiration date affected by CASSANDRA-14092 with the maximum supported expiration date of 2038-01-19T03:14:06+00:00. The rows are rewritten with the original timestamp incremented by one millisecond to override/supersede any potential tombstone that may have been generated during compaction of the affected rows.";
    private static final String TOOL_NAME = "sstablescrub";
    private static final String VERBOSE_OPTION = "verbose";
    private static final String DEBUG_OPTION = "debug";
    private static final String HELP_OPTION = "help";
    private static final String MANIFEST_CHECK_OPTION = "manifest-check";
    private static final String SKIP_CORRUPTED_OPTION = "skip-corrupted";
    private static final String NO_VALIDATE_OPTION = "no-validate";
    private static final String REINSERT_OVERFLOWED_TTL_OPTION = "reinsert-overflowed-ttl";
    private static final String HEADERFIX_OPTION = "header-fix";

    public static void main(String[] args) {
        Options options = Options.parseArgs(args);
        Util.initDatabaseDescriptor();
        try {
            ArrayList<Pair<Descriptor, Set<Component>>> listResult;
            OutputHandler.SystemOutput handler;
            ColumnFamilyStore cfs;
            block50: {
                SSTableHeaderFix sSTableHeaderFix;
                block52: {
                    ArrayList<String> logOutput;
                    block51: {
                        block49: {
                            Schema.instance.loadFromDisk(false);
                            if (Schema.instance.getKSMetaData(options.keyspaceName) == null) {
                                throw new IllegalArgumentException(String.format("Unknown keyspace %s", options.keyspaceName));
                            }
                            Keyspace keyspace = Keyspace.openWithoutSSTables(options.keyspaceName);
                            cfs = null;
                            for (ColumnFamilyStore c : keyspace.getValidColumnFamilies(true, false, options.cfName)) {
                                if (!c.name.equals(options.cfName)) continue;
                                cfs = c;
                                break;
                            }
                            if (cfs == null) {
                                throw new IllegalArgumentException(String.format("Unknown table %s.%s", options.keyspaceName, options.cfName));
                            }
                            String snapshotName = "pre-scrub-" + System.currentTimeMillis();
                            handler = new OutputHandler.SystemOutput(options.verbose, options.debug);
                            Directories.SSTableLister lister = cfs.getDirectories().sstableLister(Directories.OnTxnErr.THROW).skipTemporary(true);
                            listResult = new ArrayList<Pair<Descriptor, Set<Component>>>();
                            for (Map.Entry<Descriptor, Set<Component>> entry : lister.list().entrySet()) {
                                Descriptor descriptor = entry.getKey();
                                Set<Component> set = entry.getValue();
                                if (!set.contains(Component.DATA)) continue;
                                listResult.add(Pair.create(descriptor, set));
                                File snapshotDirectory = Directories.getSnapshotDirectory(descriptor, snapshotName);
                                SSTableReader.createLinks(descriptor, set, snapshotDirectory.getPath());
                            }
                            System.out.println(String.format("Pre-scrub sstables snapshotted into snapshot %s", snapshotName));
                            if (options.headerFixMode == Options.HeaderFixMode.OFF) break block50;
                            logOutput = new ArrayList<String>();
                            SSTableHeaderFix.Builder headerFixBuilder = SSTableHeaderFix.builder().logToList(logOutput).schemaCallback(() -> Schema.instance::getCFMetaData);
                            if (options.headerFixMode == Options.HeaderFixMode.VALIDATE) {
                                headerFixBuilder = headerFixBuilder.dryRun();
                            }
                            for (Pair pair : listResult) {
                                headerFixBuilder.withPath(Paths.get(((Descriptor)pair.left).filenameFor(Component.DATA), new String[0]));
                            }
                            sSTableHeaderFix = headerFixBuilder.build();
                            try {
                                sSTableHeaderFix.execute();
                            }
                            catch (Exception exception) {
                                JVMStabilityInspector.inspectThrowable(exception);
                                if (!options.debug) break block49;
                                exception.printStackTrace(System.err);
                            }
                        }
                        if (sSTableHeaderFix.hasChanges()) break block51;
                        if (!sSTableHeaderFix.hasError()) break block52;
                    }
                    logOutput.forEach(System.out::println);
                }
                if (sSTableHeaderFix.hasError()) {
                    System.err.println("Errors in serialization-header detected, aborting.");
                    System.exit(1);
                }
                switch (options.headerFixMode) {
                    case VALIDATE_ONLY: 
                    case FIX_ONLY: {
                        System.out.printf("Not continuing with scrub, since '--%s %s' was specified.%n", HEADERFIX_OPTION, options.headerFixMode.asCommandLineOption());
                        System.exit(0);
                    }
                    case VALIDATE: {
                        if (!sSTableHeaderFix.hasChanges()) break;
                        System.err.printf("Unfixed, but fixable errors in serialization-header detected, aborting. Use a non-validating mode ('-e %s' or '-e %s') for --%s%n", Options.HeaderFixMode.FIX.asCommandLineOption(), Options.HeaderFixMode.FIX_ONLY.asCommandLineOption(), HEADERFIX_OPTION);
                        System.exit(2);
                        break;
                    }
                }
            }
            ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
            for (Pair pair : listResult) {
                Descriptor descriptor = (Descriptor)pair.left;
                Set components = (Set)pair.right;
                if (!components.contains(Component.DATA)) continue;
                try {
                    SSTableReader sstable = SSTableReader.openNoValidation(descriptor, components, cfs);
                    sstables.add(sstable);
                }
                catch (Exception e) {
                    JVMStabilityInspector.inspectThrowable(e);
                    System.err.println(String.format("Error Loading %s: %s", descriptor, e.getMessage()));
                    if (!options.debug) continue;
                    e.printStackTrace(System.err);
                }
            }
            if (!options.manifestCheckOnly) {
                for (SSTableReader sSTableReader : sstables) {
                    try {
                        LifecycleTransaction lifecycleTransaction = LifecycleTransaction.offline(OperationType.SCRUB, sSTableReader);
                        Throwable throwable = null;
                        try {
                            lifecycleTransaction.obsoleteOriginals();
                            try {
                                Scrubber scrubber = new Scrubber(cfs, lifecycleTransaction, options.skipCorrupted, handler, !options.noValidate, options.reinserOverflowedTTL);
                                Throwable throwable2 = null;
                                try {
                                    scrubber.scrub();
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (scrubber == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            scrubber.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    scrubber.close();
                                }
                            }
                            catch (Throwable t) {
                                if (cfs.rebuildOnFailedScrub(t)) continue;
                                System.out.println(t.getMessage());
                                throw t;
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (lifecycleTransaction == null) continue;
                            if (throwable != null) {
                                try {
                                    lifecycleTransaction.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            lifecycleTransaction.close();
                        }
                    }
                    catch (Exception exception) {
                        System.err.println(String.format("Error scrubbing %s: %s", sSTableReader, exception.getMessage()));
                        exception.printStackTrace(System.err);
                    }
                }
            }
            StandaloneScrubber.checkManifest(cfs.getCompactionStrategyManager(), cfs, sstables);
            CompactionManager.instance.finishCompactionsAndShutdown(5L, TimeUnit.MINUTES);
            LifecycleTransaction.waitForDeletions();
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            if (options.debug) {
                e.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private static void checkManifest(CompactionStrategyManager strategyManager, ColumnFamilyStore cfs, Collection<SSTableReader> sstables) {
        if (strategyManager.getCompactionParams().klass().equals(LeveledCompactionStrategy.class)) {
            int maxSizeInMB = (int)(cfs.getCompactionStrategyManager().getMaxSSTableBytes() / 0x100000L);
            int fanOut = cfs.getCompactionStrategyManager().getLevelFanoutSize();
            ArrayList<SSTableReader> repaired = new ArrayList<SSTableReader>();
            ArrayList<SSTableReader> unrepaired = new ArrayList<SSTableReader>();
            for (SSTableReader sstable : sstables) {
                if (sstable.isRepaired()) {
                    repaired.add(sstable);
                    continue;
                }
                unrepaired.add(sstable);
            }
            LeveledManifest.create(cfs, maxSizeInMB, fanOut, repaired);
            LeveledManifest.create(cfs, maxSizeInMB, fanOut, unrepaired);
        }
    }

    private static class Options {
        public final String keyspaceName;
        public final String cfName;
        public boolean debug;
        public boolean verbose;
        public boolean manifestCheckOnly;
        public boolean skipCorrupted;
        public boolean noValidate;
        public boolean reinserOverflowedTTL;
        public HeaderFixMode headerFixMode = HeaderFixMode.VALIDATE;

        private Options(String keyspaceName, String cfName) {
            this.keyspaceName = keyspaceName;
            this.cfName = cfName;
        }

        public static Options parseArgs(String[] cmdArgs) {
            GnuParser parser = new GnuParser();
            BulkLoader.CmdLineOptions options = Options.getCmdLineOptions();
            try {
                String[] args;
                CommandLine cmd = parser.parse((org.apache.commons.cli.Options)options, cmdArgs, false);
                if (cmd.hasOption(StandaloneScrubber.HELP_OPTION)) {
                    Options.printUsage(options);
                    System.exit(0);
                }
                if ((args = cmd.getArgs()).length != 2) {
                    String msg = args.length < 2 ? "Missing arguments" : "Too many arguments";
                    System.err.println(msg);
                    Options.printUsage(options);
                    System.exit(1);
                }
                String keyspaceName = args[0];
                String cfName = args[1];
                Options opts = new Options(keyspaceName, cfName);
                opts.debug = cmd.hasOption(StandaloneScrubber.DEBUG_OPTION);
                opts.verbose = cmd.hasOption(StandaloneScrubber.VERBOSE_OPTION);
                opts.manifestCheckOnly = cmd.hasOption(StandaloneScrubber.MANIFEST_CHECK_OPTION);
                opts.skipCorrupted = cmd.hasOption(StandaloneScrubber.SKIP_CORRUPTED_OPTION);
                opts.noValidate = cmd.hasOption(StandaloneScrubber.NO_VALIDATE_OPTION);
                opts.reinserOverflowedTTL = cmd.hasOption(StandaloneScrubber.REINSERT_OVERFLOWED_TTL_OPTION);
                if (cmd.hasOption(StandaloneScrubber.HEADERFIX_OPTION)) {
                    try {
                        opts.headerFixMode = HeaderFixMode.fromCommandLine(cmd.getOptionValue(StandaloneScrubber.HEADERFIX_OPTION));
                    }
                    catch (Exception e) {
                        Options.errorMsg(String.format("Invalid argument value '%s' for --%s", cmd.getOptionValue(StandaloneScrubber.HEADERFIX_OPTION), StandaloneScrubber.HEADERFIX_OPTION), options);
                        return null;
                    }
                }
                return opts;
            }
            catch (ParseException e) {
                Options.errorMsg(e.getMessage(), options);
                return null;
            }
        }

        private static void errorMsg(String msg, BulkLoader.CmdLineOptions options) {
            System.err.println(msg);
            Options.printUsage(options);
            System.exit(1);
        }

        private static BulkLoader.CmdLineOptions getCmdLineOptions() {
            BulkLoader.CmdLineOptions options = new BulkLoader.CmdLineOptions();
            options.addOption(null, StandaloneScrubber.DEBUG_OPTION, "display stack traces");
            options.addOption("v", StandaloneScrubber.VERBOSE_OPTION, "verbose output");
            options.addOption("h", StandaloneScrubber.HELP_OPTION, "display this help message");
            options.addOption("m", StandaloneScrubber.MANIFEST_CHECK_OPTION, "only check and repair the leveled manifest, without actually scrubbing the sstables");
            options.addOption("s", StandaloneScrubber.SKIP_CORRUPTED_OPTION, "skip corrupt rows in counter tables");
            options.addOption("n", StandaloneScrubber.NO_VALIDATE_OPTION, "do not validate columns using column validator");
            options.addOption("e", StandaloneScrubber.HEADERFIX_OPTION, true, "Option whether and how to perform a check of the sstable serialization-headers and fix known, fixable issues.\nPossible argument values:\n- validate-only: validate the serialization-headers, but do not fix those. Do not continue with scrub - i.e. only validate the header (dry-run of fix-only).\n- validate: (default) validate the serialization-headers, but do not fix those and only continue with scrub if no error were detected.\n- fix-only: validate and fix the serialization-headers, don't continue with scrub.\n- fix: validate and fix the serialization-headers, do not fix and do not continue with scrub if the serialization-header check encountered errors.\n- off: don't perform the serialization-header checks.");
            options.addOption("r", StandaloneScrubber.REINSERT_OVERFLOWED_TTL_OPTION, StandaloneScrubber.REINSERT_OVERFLOWED_TTL_OPTION_DESCRIPTION);
            return options;
        }

        public static void printUsage(BulkLoader.CmdLineOptions options) {
            String usage = String.format("%s [options] <keyspace> <column_family>", StandaloneScrubber.TOOL_NAME);
            StringBuilder header = new StringBuilder();
            header.append("--\n");
            header.append("Scrub the sstable for the provided table.");
            header.append("\n--\n");
            header.append("Options are:");
            new HelpFormatter().printHelp(120, usage, header.toString(), (org.apache.commons.cli.Options)options, "");
        }

        static enum HeaderFixMode {
            VALIDATE_ONLY,
            VALIDATE,
            FIX_ONLY,
            FIX,
            OFF;


            static HeaderFixMode fromCommandLine(String value) {
                return HeaderFixMode.valueOf(value.replace('-', '_').toUpperCase().trim());
            }

            String asCommandLineOption() {
                return this.name().toLowerCase().replace('_', '-');
            }
        }
    }
}

