/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.access.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TransactionResultIteratorDecorator
implements ResultIterator {
    private ResultIterator result;
    private Transaction tx;

    public TransactionResultIteratorDecorator(ResultIterator result, Transaction tx) {
        this.result = result;
        this.tx = tx;
    }

    @Override
    public void close() throws CayenneException {
        try {
            this.result.close();
            this.tx.commit();
        }
        catch (Exception e) {
            try {
                this.tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new CayenneException(e);
        }
        finally {
            if (Transaction.getThreadTransaction() == this.tx) {
                Transaction.bindThreadTransaction(null);
            }
        }
    }

    @Override
    public List<?> allRows() throws CayenneException {
        ArrayList<Object> list = new ArrayList<Object>();
        while (this.hasNextRow()) {
            list.add(this.nextRow());
        }
        return list;
    }

    @Override
    public boolean hasNextRow() throws CayenneException {
        return this.result.hasNextRow();
    }

    @Override
    public Object nextRow() throws CayenneException {
        return this.result.nextRow();
    }

    @Override
    public void skipRow() throws CayenneException {
        this.result.skipRow();
    }
}

