/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.io.File;
import javax.swing.JOptionPane;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.action.SaveAction;
import org.apache.cayenne.modeler.dialog.FileDeletedDialog;
import org.apache.cayenne.modeler.util.FileWatchdog;
import org.apache.cayenne.project.Project;

public class ProjectWatchdog
extends FileWatchdog {
    protected ProjectController mediator;

    public ProjectWatchdog(ProjectController mediator) {
        this.setName("cayenne-project-watchdog");
        this.mediator = mediator;
        this.setSingleNotification(true);
    }

    public void reconfigure() {
        this.pauseWatching();
        this.removeAllFiles();
        Project project = this.mediator.getProject();
        if (project != null && project.getConfigurationResource() != null) {
            String projectPath = project.getConfigurationResource().getURL().getPath() + File.separator;
            this.addFile(projectPath);
            for (DataMap dm : ((DataChannelDescriptor)project.getRootNode()).getDataMaps()) {
                this.addFile(dm.getConfigurationSource().getURL().getPath());
            }
        }
        this.resumeWatching();
    }

    protected void doOnChange(FileWatchdog.FileInfo fileInfo) {
        if (this.showConfirmation("One or more project files were changed by external program. Do you want to load the changes?")) {
            if (this.mediator.getProject() != null) {
                File fileDirectory = new File(this.mediator.getProject().getConfigurationResource().getURL().getPath());
                Application.getInstance().getActionManager().getAction(OpenProjectAction.class).openProject(fileDirectory);
            }
        } else {
            this.mediator.setDirty(true);
        }
    }

    protected void doOnRemove(FileWatchdog.FileInfo fileInfo) {
        if (this.mediator.getProject() != null) {
            FileDeletedDialog dialog = new FileDeletedDialog(Application.getFrame());
            dialog.show();
            if (dialog.shouldSave()) {
                Application.getInstance().getActionManager().getAction(SaveAction.class).performAction(null);
            } else if (dialog.shouldClose()) {
                CayenneModelerController controller = Application.getInstance().getFrameController();
                controller.projectClosedAction();
            } else {
                this.mediator.setDirty(true);
            }
        }
    }

    private boolean showConfirmation(String message) {
        return 0 == JOptionPane.showConfirmDialog(Application.getFrame(), message, "File changed", 0, 3);
    }
}

