/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;

public class NameValidationHelper {
    static final Collection<String> RESERVED_JAVA_KEYWORDS = Arrays.asList("abstract", "assert", "default", "enum", "if", "private", "this", "boolean", "do", "implements", "protected", "throw", "break", "double", "import", "public", "throws", "byte", "else", "instanceof", "return", "transient", "case", "extends", "int", "short", "try", "catch", "final", "interface", "static", "void", "char", "finally", "long", "strictfp", "volatile", "class", "float", "native", "super", "while", "const", "for", "new", "switch", "continue", "goto", "package", "synchronized");
    static final Collection<String> INVALID_JAVA_PROPERTIES = Arrays.asList("class", "committedSnapshot", "currentSnapshot", "dataContext", "objectId", "persistenceState", "snapshotVersion");
    static final NameValidationHelper sharedInstance = new NameValidationHelper();

    public boolean isReservedJavaKeyword(String word) {
        return RESERVED_JAVA_KEYWORDS.contains(word);
    }

    public static NameValidationHelper getInstance() {
        return sharedInstance;
    }

    public String invalidCharsInDbPathComponent(String dbPathComponent) {
        return dbPathComponent.indexOf(46) >= 0 ? "." : null;
    }

    public String invalidCharsInObjPathComponent(String objPathComponent) {
        String invalidChars = this.validateJavaIdentifier(objPathComponent, "");
        return invalidChars.length() > 0 ? invalidChars : null;
    }

    public String invalidCharsInJavaClassName(String javaClassName) {
        if (javaClassName == null) {
            return null;
        }
        String invalidChars = "";
        StringTokenizer toks = new StringTokenizer(javaClassName, ".");
        while (toks.hasMoreTokens()) {
            invalidChars = this.validateJavaIdentifier(toks.nextToken(), invalidChars);
        }
        return invalidChars.length() > 0 ? invalidChars : null;
    }

    public boolean invalidDataObjectClass(String dataObjectClassFQN) {
        if (dataObjectClassFQN == null) {
            return true;
        }
        StringTokenizer toks = new StringTokenizer(dataObjectClassFQN, ".");
        while (toks.hasMoreTokens()) {
            if (!RESERVED_JAVA_KEYWORDS.contains(toks.nextToken())) continue;
            return true;
        }
        return false;
    }

    private String validateJavaIdentifier(String id, String invalidChars) {
        int len;
        int n = len = id != null ? id.length() : 0;
        if (len == 0) {
            return invalidChars;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0)) && invalidChars.indexOf(id.charAt(0)) < 0) {
            invalidChars = invalidChars + id.charAt(0);
        }
        for (int i = 1; i < len; ++i) {
            if (Character.isJavaIdentifierPart(id.charAt(i)) || invalidChars.indexOf(id.charAt(i)) >= 0) continue;
            invalidChars = invalidChars + id.charAt(i);
        }
        return invalidChars;
    }

    public boolean invalidDataObjectProperty(String dataObjectProperty) {
        return dataObjectProperty == null || INVALID_JAVA_PROPERTIES.contains(dataObjectProperty);
    }
}

