/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.AbstractStringEncoderTest;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DoubleMetaphone2Test
extends AbstractStringEncoderTest<DoubleMetaphone> {
    private static final int ALTERNATE_INDEX = 2;
    private static final int PRIMARY_INDEX = 1;
    private static final String[][] TEST_DATA = new String[][]{{"ALLERTON", "ALRT", "ALRT"}, {"Acton", "AKTN", "AKTN"}, {"Adams", "ATMS", "ATMS"}, {"Aggar", "AKR", "AKR"}, {"Ahl", "AL", "AL"}, {"Aiken", "AKN", "AKN"}, {"Alan", "ALN", "ALN"}, {"Alcock", "ALKK", "ALKK"}, {"Alden", "ALTN", "ALTN"}, {"Aldham", "ALTM", "ALTM"}, {"Allen", "ALN", "ALN"}, {"Allerton", "ALRT", "ALRT"}, {"Alsop", "ALSP", "ALSP"}, {"Alwein", "ALN", "ALN"}, {"Ambler", "AMPL", "AMPL"}, {"Andevill", "ANTF", "ANTF"}, {"Andrews", "ANTR", "ANTR"}, {"Andreyco", "ANTR", "ANTR"}, {"Andriesse", "ANTR", "ANTR"}, {"Angier", "ANJ", "ANJR"}, {"Annabel", "ANPL", "ANPL"}, {"Anne", "AN", "AN"}, {"Anstye", "ANST", "ANST"}, {"Appling", "APLN", "APLN"}, {"Apuke", "APK", "APK"}, {"Arnold", "ARNL", "ARNL"}, {"Ashby", "AXP", "AXP"}, {"Astwood", "ASTT", "ASTT"}, {"Atkinson", "ATKN", "ATKN"}, {"Audley", "ATL", "ATL"}, {"Austin", "ASTN", "ASTN"}, {"Avenal", "AFNL", "AFNL"}, {"Ayer", "AR", "AR"}, {"Ayot", "AT", "AT"}, {"Babbitt", "PPT", "PPT"}, {"Bachelor", "PXLR", "PKLR"}, {"Bachelour", "PXLR", "PKLR"}, {"Bailey", "PL", "PL"}, {"Baivel", "PFL", "PFL"}, {"Baker", "PKR", "PKR"}, {"Baldwin", "PLTN", "PLTN"}, {"Balsley", "PLSL", "PLSL"}, {"Barber", "PRPR", "PRPR"}, {"Barker", "PRKR", "PRKR"}, {"Barlow", "PRL", "PRLF"}, {"Barnard", "PRNR", "PRNR"}, {"Barnes", "PRNS", "PRNS"}, {"Barnsley", "PRNS", "PRNS"}, {"Barouxis", "PRKS", "PRKS"}, {"Bartlet", "PRTL", "PRTL"}, {"Basley", "PSL", "PSL"}, {"Basset", "PST", "PST"}, {"Bassett", "PST", "PST"}, {"Batchlor", "PXLR", "PXLR"}, {"Bates", "PTS", "PTS"}, {"Batson", "PTSN", "PTSN"}, {"Bayes", "PS", "PS"}, {"Bayley", "PL", "PL"}, {"Beale", "PL", "PL"}, {"Beauchamp", "PXMP", "PKMP"}, {"Beauclerc", "PKLR", "PKLR"}, {"Beech", "PK", "PK"}, {"Beers", "PRS", "PRS"}, {"Beke", "PK", "PK"}, {"Belcher", "PLXR", "PLKR"}, {"benign", "PNN", "PNKN"}, {"Benjamin", "PNJM", "PNJM"}, {"Benningham", "PNNK", "PNNK"}, {"Bereford", "PRFR", "PRFR"}, {"Bergen", "PRJN", "PRKN"}, {"Berkeley", "PRKL", "PRKL"}, {"Berry", "PR", "PR"}, {"Besse", "PS", "PS"}, {"Bessey", "PS", "PS"}, {"Bessiles", "PSLS", "PSLS"}, {"Bigelow", "PJL", "PKLF"}, {"Bigg", "PK", "PK"}, {"Bigod", "PKT", "PKT"}, {"Billings", "PLNK", "PLNK"}, {"Bimper", "PMPR", "PMPR"}, {"Binker", "PNKR", "PNKR"}, {"Birdsill", "PRTS", "PRTS"}, {"Bishop", "PXP", "PXP"}, {"Black", "PLK", "PLK"}, {"Blagge", "PLK", "PLK"}, {"Blake", "PLK", "PLK"}, {"Blanck", "PLNK", "PLNK"}, {"Bledsoe", "PLTS", "PLTS"}, {"Blennerhasset", "PLNR", "PLNR"}, {"Blessing", "PLSN", "PLSN"}, {"Blewett", "PLT", "PLT"}, {"Bloctgoed", "PLKT", "PLKT"}, {"Bloetgoet", "PLTK", "PLTK"}, {"Bloodgood", "PLTK", "PLTK"}, {"Blossom", "PLSM", "PLSM"}, {"Blount", "PLNT", "PLNT"}, {"Bodine", "PTN", "PTN"}, {"Bodman", "PTMN", "PTMN"}, {"BonCoeur", "PNKR", "PNKR"}, {"Bond", "PNT", "PNT"}, {"Boscawen", "PSKN", "PSKN"}, {"Bosworth", "PSR0", "PSRT"}, {"Bouchier", "PX", "PKR"}, {"Bowne", "PN", "PN"}, {"Bradbury", "PRTP", "PRTP"}, {"Bradder", "PRTR", "PRTR"}, {"Bradford", "PRTF", "PRTF"}, {"Bradstreet", "PRTS", "PRTS"}, {"Braham", "PRHM", "PRHM"}, {"Brailsford", "PRLS", "PRLS"}, {"Brainard", "PRNR", "PRNR"}, {"Brandish", "PRNT", "PRNT"}, {"Braun", "PRN", "PRN"}, {"Brecc", "PRK", "PRK"}, {"Brent", "PRNT", "PRNT"}, {"Brenton", "PRNT", "PRNT"}, {"Briggs", "PRKS", "PRKS"}, {"Brigham", "PRM", "PRM"}, {"Brobst", "PRPS", "PRPS"}, {"Brome", "PRM", "PRM"}, {"Bronson", "PRNS", "PRNS"}, {"Brooks", "PRKS", "PRKS"}, {"Brouillard", "PRLR", "PRLR"}, {"Brown", "PRN", "PRN"}, {"Browne", "PRN", "PRN"}, {"Brownell", "PRNL", "PRNL"}, {"Bruley", "PRL", "PRL"}, {"Bryant", "PRNT", "PRNT"}, {"Brzozowski", "PRSS", "PRTS"}, {"Buide", "PT", "PT"}, {"Bulmer", "PLMR", "PLMR"}, {"Bunker", "PNKR", "PNKR"}, {"Burden", "PRTN", "PRTN"}, {"Burge", "PRJ", "PRK"}, {"Burgoyne", "PRKN", "PRKN"}, {"Burke", "PRK", "PRK"}, {"Burnett", "PRNT", "PRNT"}, {"Burpee", "PRP", "PRP"}, {"Bursley", "PRSL", "PRSL"}, {"Burton", "PRTN", "PRTN"}, {"Bushnell", "PXNL", "PXNL"}, {"Buss", "PS", "PS"}, {"Buswell", "PSL", "PSL"}, {"Butler", "PTLR", "PTLR"}, {"Calkin", "KLKN", "KLKN"}, {"Canada", "KNT", "KNT"}, {"Canmore", "KNMR", "KNMR"}, {"Canney", "KN", "KN"}, {"Capet", "KPT", "KPT"}, {"Card", "KRT", "KRT"}, {"Carman", "KRMN", "KRMN"}, {"Carpenter", "KRPN", "KRPN"}, {"Cartwright", "KRTR", "KRTR"}, {"Casey", "KS", "KS"}, {"Catterfield", "KTRF", "KTRF"}, {"Ceeley", "SL", "SL"}, {"Chambers", "XMPR", "XMPR"}, {"Champion", "XMPN", "XMPN"}, {"Chapman", "XPMN", "XPMN"}, {"Chase", "XS", "XS"}, {"Cheney", "XN", "XN"}, {"Chetwynd", "XTNT", "XTNT"}, {"Chevalier", "XFL", "XFLR"}, {"Chillingsworth", "XLNK", "XLNK"}, {"Christie", "KRST", "KRST"}, {"Chubbuck", "XPK", "XPK"}, {"Church", "XRX", "XRK"}, {"Clark", "KLRK", "KLRK"}, {"Clarke", "KLRK", "KLRK"}, {"Cleare", "KLR", "KLR"}, {"Clement", "KLMN", "KLMN"}, {"Clerke", "KLRK", "KLRK"}, {"Clibben", "KLPN", "KLPN"}, {"Clifford", "KLFR", "KLFR"}, {"Clivedon", "KLFT", "KLFT"}, {"Close", "KLS", "KLS"}, {"Clothilde", "KL0L", "KLTL"}, {"Cobb", "KP", "KP"}, {"Coburn", "KPRN", "KPRN"}, {"Coburne", "KPRN", "KPRN"}, {"Cocke", "KK", "KK"}, {"Coffin", "KFN", "KFN"}, {"Coffyn", "KFN", "KFN"}, {"Colborne", "KLPR", "KLPR"}, {"Colby", "KLP", "KLP"}, {"Cole", "KL", "KL"}, {"Coleman", "KLMN", "KLMN"}, {"Collier", "KL", "KLR"}, {"Compton", "KMPT", "KMPT"}, {"Cone", "KN", "KN"}, {"Cook", "KK", "KK"}, {"Cooke", "KK", "KK"}, {"Cooper", "KPR", "KPR"}, {"Copperthwaite", "KPR0", "KPRT"}, {"Corbet", "KRPT", "KRPT"}, {"Corell", "KRL", "KRL"}, {"Corey", "KR", "KR"}, {"Corlies", "KRLS", "KRLS"}, {"Corneliszen", "KRNL", "KRNL"}, {"Cornelius", "KRNL", "KRNL"}, {"Cornwallis", "KRNL", "KRNL"}, {"Cosgrove", "KSKR", "KSKR"}, {"Count of Brionne", "KNTF", "KNTF"}, {"Covill", "KFL", "KFL"}, {"Cowperthwaite", "KPR0", "KPRT"}, {"Cowperwaite", "KPRT", "KPRT"}, {"Crane", "KRN", "KRN"}, {"Creagmile", "KRKM", "KRKM"}, {"Crew", "KR", "KRF"}, {"Crispin", "KRSP", "KRSP"}, {"Crocker", "KRKR", "KRKR"}, {"Crockett", "KRKT", "KRKT"}, {"Crosby", "KRSP", "KRSP"}, {"Crump", "KRMP", "KRMP"}, {"Cunningham", "KNNK", "KNNK"}, {"Curtis", "KRTS", "KRTS"}, {"Cutha", "K0", "KT"}, {"Cutter", "KTR", "KTR"}, {"D'Aubigny", "TPN", "TPKN"}, {"DAVIS", "TFS", "TFS"}, {"Dabinott", "TPNT", "TPNT"}, {"Dacre", "TKR", "TKR"}, {"Daggett", "TKT", "TKT"}, {"Danvers", "TNFR", "TNFR"}, {"Darcy", "TRS", "TRS"}, {"Davis", "TFS", "TFS"}, {"Dawn", "TN", "TN"}, {"Dawson", "TSN", "TSN"}, {"Day", "T", "T"}, {"Daye", "T", "T"}, {"DeGrenier", "TKRN", "TKRN"}, {"Dean", "TN", "TN"}, {"Deekindaugh", "TKNT", "TKNT"}, {"Dennis", "TNS", "TNS"}, {"Denny", "TN", "TN"}, {"Denton", "TNTN", "TNTN"}, {"Desborough", "TSPR", "TSPR"}, {"Despenser", "TSPN", "TSPN"}, {"Deverill", "TFRL", "TFRL"}, {"Devine", "TFN", "TFN"}, {"Dexter", "TKST", "TKST"}, {"Dillaway", "TL", "TL"}, {"Dimmick", "TMK", "TMK"}, {"Dinan", "TNN", "TNN"}, {"Dix", "TKS", "TKS"}, {"Doggett", "TKT", "TKT"}, {"Donahue", "TNH", "TNH"}, {"Dorfman", "TRFM", "TRFM"}, {"Dorris", "TRS", "TRS"}, {"Dow", "T", "TF"}, {"Downey", "TN", "TN"}, {"Downing", "TNNK", "TNNK"}, {"Dowsett", "TST", "TST"}, {"Duck?", "TK", "TK"}, {"Dudley", "TTL", "TTL"}, {"Duffy", "TF", "TF"}, {"Dunn", "TN", "TN"}, {"Dunsterville", "TNST", "TNST"}, {"Durrant", "TRNT", "TRNT"}, {"Durrin", "TRN", "TRN"}, {"Dustin", "TSTN", "TSTN"}, {"Duston", "TSTN", "TSTN"}, {"Eames", "AMS", "AMS"}, {"Early", "ARL", "ARL"}, {"Easty", "AST", "AST"}, {"Ebbett", "APT", "APT"}, {"Eberbach", "APRP", "APRP"}, {"Eberhard", "APRR", "APRR"}, {"Eddy", "AT", "AT"}, {"Edenden", "ATNT", "ATNT"}, {"Edwards", "ATRT", "ATRT"}, {"Eglinton", "AKLN", "ALNT"}, {"Eliot", "ALT", "ALT"}, {"Elizabeth", "ALSP", "ALSP"}, {"Ellis", "ALS", "ALS"}, {"Ellison", "ALSN", "ALSN"}, {"Ellot", "ALT", "ALT"}, {"Elny", "ALN", "ALN"}, {"Elsner", "ALSN", "ALSN"}, {"Emerson", "AMRS", "AMRS"}, {"Empson", "AMPS", "AMPS"}, {"Est", "AST", "AST"}, {"Estabrook", "ASTP", "ASTP"}, {"Estes", "ASTS", "ASTS"}, {"Estey", "AST", "AST"}, {"Evans", "AFNS", "AFNS"}, {"Fallowell", "FLL", "FLL"}, {"Farnsworth", "FRNS", "FRNS"}, {"Feake", "FK", "FK"}, {"Feke", "FK", "FK"}, {"Fellows", "FLS", "FLS"}, {"Fettiplace", "FTPL", "FTPL"}, {"Finney", "FN", "FN"}, {"Fischer", "FXR", "FSKR"}, {"Fisher", "FXR", "FXR"}, {"Fisk", "FSK", "FSK"}, {"Fiske", "FSK", "FSK"}, {"Fletcher", "FLXR", "FLXR"}, {"Folger", "FLKR", "FLJR"}, {"Foliot", "FLT", "FLT"}, {"Folyot", "FLT", "FLT"}, {"Fones", "FNS", "FNS"}, {"Fordham", "FRTM", "FRTM"}, {"Forstner", "FRST", "FRST"}, {"Fosten", "FSTN", "FSTN"}, {"Foster", "FSTR", "FSTR"}, {"Foulke", "FLK", "FLK"}, {"Fowler", "FLR", "FLR"}, {"Foxwell", "FKSL", "FKSL"}, {"Fraley", "FRL", "FRL"}, {"Franceys", "FRNS", "FRNS"}, {"Franke", "FRNK", "FRNK"}, {"Frascella", "FRSL", "FRSL"}, {"Frazer", "FRSR", "FRSR"}, {"Fredd", "FRT", "FRT"}, {"Freeman", "FRMN", "FRMN"}, {"French", "FRNX", "FRNK"}, {"Freville", "FRFL", "FRFL"}, {"Frey", "FR", "FR"}, {"Frick", "FRK", "FRK"}, {"Frier", "FR", "FRR"}, {"Froe", "FR", "FR"}, {"Frorer", "FRRR", "FRRR"}, {"Frost", "FRST", "FRST"}, {"Frothingham", "FR0N", "FRTN"}, {"Fry", "FR", "FR"}, {"Gaffney", "KFN", "KFN"}, {"Gage", "KJ", "KK"}, {"Gallion", "KLN", "KLN"}, {"Gallishan", "KLXN", "KLXN"}, {"Gamble", "KMPL", "KMPL"}, {"garage", "KRJ", "KRK"}, {"Garbrand", "KRPR", "KRPR"}, {"Gardner", "KRTN", "KRTN"}, {"Garrett", "KRT", "KRT"}, {"Gassner", "KSNR", "KSNR"}, {"Gater", "KTR", "KTR"}, {"Gaunt", "KNT", "KNT"}, {"Gayer", "KR", "KR"}, {"George", "JRJ", "KRK"}, {"Gerken", "KRKN", "JRKN"}, {"Gerritsen", "KRTS", "JRTS"}, {"Gibbs", "KPS", "JPS"}, {"Giffard", "JFRT", "KFRT"}, {"Gilbert", "KLPR", "JLPR"}, {"Gill", "KL", "JL"}, {"Gilman", "KLMN", "JLMN"}, {"Glass", "KLS", "KLS"}, {"Goddard\\Gifford", "KTRT", "KTRT"}, {"Godfrey", "KTFR", "KTFR"}, {"Godwin", "KTN", "KTN"}, {"Goodale", "KTL", "KTL"}, {"Goodnow", "KTN", "KTNF"}, {"Gorham", "KRM", "KRM"}, {"Goseline", "KSLN", "KSLN"}, {"Gott", "KT", "KT"}, {"Gould", "KLT", "KLT"}, {"Grafton", "KRFT", "KRFT"}, {"Grant", "KRNT", "KRNT"}, {"Gray", "KR", "KR"}, {"Green", "KRN", "KRN"}, {"Griffin", "KRFN", "KRFN"}, {"Grill", "KRL", "KRL"}, {"Grim", "KRM", "KRM"}, {"Grisgonelle", "KRSK", "KRSK"}, {"Gross", "KRS", "KRS"}, {"Guba", "KP", "KP"}, {"Gybbes", "KPS", "JPS"}, {"Haburne", "HPRN", "HPRN"}, {"Hackburne", "HKPR", "HKPR"}, {"Haddon?", "HTN", "HTN"}, {"Haines", "HNS", "HNS"}, {"Hale", "HL", "HL"}, {"Hall", "HL", "HL"}, {"Hallet", "HLT", "HLT"}, {"Hallock", "HLK", "HLK"}, {"Halstead", "HLST", "HLST"}, {"Hammond", "HMNT", "HMNT"}, {"Hance", "HNS", "HNS"}, {"Handy", "HNT", "HNT"}, {"Hanson", "HNSN", "HNSN"}, {"Harasek", "HRSK", "HRSK"}, {"Harcourt", "HRKR", "HRKR"}, {"Hardy", "HRT", "HRT"}, {"Harlock", "HRLK", "HRLK"}, {"Harris", "HRS", "HRS"}, {"Hartley", "HRTL", "HRTL"}, {"Harvey", "HRF", "HRF"}, {"Harvie", "HRF", "HRF"}, {"Harwood", "HRT", "HRT"}, {"Hathaway", "H0", "HT"}, {"Haukeness", "HKNS", "HKNS"}, {"Hawkes", "HKS", "HKS"}, {"Hawkhurst", "HKRS", "HKRS"}, {"Hawkins", "HKNS", "HKNS"}, {"Hawley", "HL", "HL"}, {"Heald", "HLT", "HLT"}, {"Helsdon", "HLST", "HLST"}, {"Hemenway", "HMN", "HMN"}, {"Hemmenway", "HMN", "HMN"}, {"Henck", "HNK", "HNK"}, {"Henderson", "HNTR", "HNTR"}, {"Hendricks", "HNTR", "HNTR"}, {"Hersey", "HRS", "HRS"}, {"Hewes", "HS", "HS"}, {"Heyman", "HMN", "HMN"}, {"Hicks", "HKS", "HKS"}, {"Hidden", "HTN", "HTN"}, {"Higgs", "HKS", "HKS"}, {"Hill", "HL", "HL"}, {"Hills", "HLS", "HLS"}, {"Hinckley", "HNKL", "HNKL"}, {"Hipwell", "HPL", "HPL"}, {"Hobart", "HPRT", "HPRT"}, {"Hoben", "HPN", "HPN"}, {"Hoffmann", "HFMN", "HFMN"}, {"Hogan", "HKN", "HKN"}, {"Holmes", "HLMS", "HLMS"}, {"Hoo", "H", "H"}, {"Hooker", "HKR", "HKR"}, {"Hopcott", "HPKT", "HPKT"}, {"Hopkins", "HPKN", "HPKN"}, {"Hopkinson", "HPKN", "HPKN"}, {"Hornsey", "HRNS", "HRNS"}, {"Houckgeest", "HKJS", "HKKS"}, {"Hough", "H", "H"}, {"Houstin", "HSTN", "HSTN"}, {"How", "H", "HF"}, {"Howe", "H", "H"}, {"Howland", "HLNT", "HLNT"}, {"Hubner", "HPNR", "HPNR"}, {"Hudnut", "HTNT", "HTNT"}, {"Hughes", "HS", "HS"}, {"Hull", "HL", "HL"}, {"Hulme", "HLM", "HLM"}, {"Hume", "HM", "HM"}, {"Hundertumark", "HNTR", "HNTR"}, {"Hundley", "HNTL", "HNTL"}, {"Hungerford", "HNKR", "HNJR"}, {"Hunt", "HNT", "HNT"}, {"Hurst", "HRST", "HRST"}, {"Husbands", "HSPN", "HSPN"}, {"Hussey", "HS", "HS"}, {"Husted", "HSTT", "HSTT"}, {"Hutchins", "HXNS", "HXNS"}, {"Hutchinson", "HXNS", "HXNS"}, {"Huttinger", "HTNK", "HTNJ"}, {"Huybertsen", "HPRT", "HPRT"}, {"Iddenden", "ATNT", "ATNT"}, {"Ingraham", "ANKR", "ANKR"}, {"Ives", "AFS", "AFS"}, {"Jackson", "JKSN", "AKSN"}, {"Jacob", "JKP", "AKP"}, {"Jans", "JNS", "ANS"}, {"Jenkins", "JNKN", "ANKN"}, {"Jewett", "JT", "AT"}, {"Jewitt", "JT", "AT"}, {"Johnson", "JNSN", "ANSN"}, {"Jones", "JNS", "ANS"}, {"Josephine", "JSFN", "HSFN"}, {"Judd", "JT", "AT"}, {"June", "JN", "AN"}, {"Kamarowska", "KMRS", "KMRS"}, {"Kay", "K", "K"}, {"Kelley", "KL", "KL"}, {"Kelly", "KL", "KL"}, {"Keymber", "KMPR", "KMPR"}, {"Keynes", "KNS", "KNS"}, {"Kilham", "KLM", "KLM"}, {"Kim", "KM", "KM"}, {"Kimball", "KMPL", "KMPL"}, {"King", "KNK", "KNK"}, {"Kinsey", "KNS", "KNS"}, {"Kirk", "KRK", "KRK"}, {"Kirton", "KRTN", "KRTN"}, {"Kistler", "KSTL", "KSTL"}, {"Kitchen", "KXN", "KXN"}, {"Kitson", "KTSN", "KTSN"}, {"Klett", "KLT", "KLT"}, {"Kline", "KLN", "KLN"}, {"Knapp", "NP", "NP"}, {"Knight", "NT", "NT"}, {"Knote", "NT", "NT"}, {"Knott", "NT", "NT"}, {"Knox", "NKS", "NKS"}, {"Koeller", "KLR", "KLR"}, {"La Pointe", "LPNT", "LPNT"}, {"LaPlante", "LPLN", "LPLN"}, {"Laimbeer", "LMPR", "LMPR"}, {"Lamb", "LMP", "LMP"}, {"Lambertson", "LMPR", "LMPR"}, {"Lancto", "LNKT", "LNKT"}, {"Landry", "LNTR", "LNTR"}, {"Lane", "LN", "LN"}, {"Langendyck", "LNJN", "LNKN"}, {"Langer", "LNKR", "LNJR"}, {"Langford", "LNKF", "LNKF"}, {"Lantersee", "LNTR", "LNTR"}, {"Laquer", "LKR", "LKR"}, {"Larkin", "LRKN", "LRKN"}, {"Latham", "LTM", "LTM"}, {"Lathrop", "L0RP", "LTRP"}, {"Lauter", "LTR", "LTR"}, {"Lawrence", "LRNS", "LRNS"}, {"Leach", "LK", "LK"}, {"Leager", "LKR", "LJR"}, {"Learned", "LRNT", "LRNT"}, {"Leavitt", "LFT", "LFT"}, {"Lee", "L", "L"}, {"Leete", "LT", "LT"}, {"Leggett", "LKT", "LKT"}, {"Leland", "LLNT", "LLNT"}, {"Leonard", "LNRT", "LNRT"}, {"Lester", "LSTR", "LSTR"}, {"Lestrange", "LSTR", "LSTR"}, {"Lethem", "L0M", "LTM"}, {"Levine", "LFN", "LFN"}, {"Lewes", "LS", "LS"}, {"Lewis", "LS", "LS"}, {"Lincoln", "LNKL", "LNKL"}, {"Lindsey", "LNTS", "LNTS"}, {"Linher", "LNR", "LNR"}, {"Lippet", "LPT", "LPT"}, {"Lippincott", "LPNK", "LPNK"}, {"Lockwood", "LKT", "LKT"}, {"Loines", "LNS", "LNS"}, {"Lombard", "LMPR", "LMPR"}, {"Long", "LNK", "LNK"}, {"Longespee", "LNJS", "LNKS"}, {"Look", "LK", "LK"}, {"Lounsberry", "LNSP", "LNSP"}, {"Lounsbury", "LNSP", "LNSP"}, {"Louthe", "L0", "LT"}, {"Loveyne", "LFN", "LFN"}, {"Lowe", "L", "L"}, {"Ludlam", "LTLM", "LTLM"}, {"Lumbard", "LMPR", "LMPR"}, {"Lund", "LNT", "LNT"}, {"Luno", "LN", "LN"}, {"Lutz", "LTS", "LTS"}, {"Lydia", "LT", "LT"}, {"Lynne", "LN", "LN"}, {"Lyon", "LN", "LN"}, {"MacAlpin", "MKLP", "MKLP"}, {"MacBricc", "MKPR", "MKPR"}, {"MacCrinan", "MKRN", "MKRN"}, {"MacKenneth", "MKN0", "MKNT"}, {"MacMael nam Bo", "MKML", "MKML"}, {"MacMurchada", "MKMR", "MKMR"}, {"Macomber", "MKMP", "MKMP"}, {"Macy", "MS", "MS"}, {"Magnus", "MNS", "MKNS"}, {"Mahien", "MHN", "MHN"}, {"Malmains", "MLMN", "MLMN"}, {"Malory", "MLR", "MLR"}, {"Mancinelli", "MNSN", "MNSN"}, {"Mancini", "MNSN", "MNSN"}, {"Mann", "MN", "MN"}, {"Manning", "MNNK", "MNNK"}, {"Manter", "MNTR", "MNTR"}, {"Marion", "MRN", "MRN"}, {"Marley", "MRL", "MRL"}, {"Marmion", "MRMN", "MRMN"}, {"Marquart", "MRKR", "MRKR"}, {"Marsh", "MRX", "MRX"}, {"Marshal", "MRXL", "MRXL"}, {"Marshall", "MRXL", "MRXL"}, {"Martel", "MRTL", "MRTL"}, {"Martha", "MR0", "MRT"}, {"Martin", "MRTN", "MRTN"}, {"Marturano", "MRTR", "MRTR"}, {"Marvin", "MRFN", "MRFN"}, {"Mary", "MR", "MR"}, {"Mason", "MSN", "MSN"}, {"Maxwell", "MKSL", "MKSL"}, {"Mayhew", "MH", "MHF"}, {"McAllaster", "MKLS", "MKLS"}, {"McAllister", "MKLS", "MKLS"}, {"McConnell", "MKNL", "MKNL"}, {"McFarland", "MKFR", "MKFR"}, {"McIlroy", "MSLR", "MSLR"}, {"McNair", "MKNR", "MKNR"}, {"McNair-Landry", "MKNR", "MKNR"}, {"McRaven", "MKRF", "MKRF"}, {"Mead", "MT", "MT"}, {"Meade", "MT", "MT"}, {"Meck", "MK", "MK"}, {"Melton", "MLTN", "MLTN"}, {"Mendenhall", "MNTN", "MNTN"}, {"Mering", "MRNK", "MRNK"}, {"Merrick", "MRK", "MRK"}, {"Merry", "MR", "MR"}, {"Mighill", "ML", "ML"}, {"Miller", "MLR", "MLR"}, {"Milton", "MLTN", "MLTN"}, {"Mohun", "MHN", "MHN"}, {"Montague", "MNTK", "MNTK"}, {"Montboucher", "MNTP", "MNTP"}, {"Moore", "MR", "MR"}, {"Morrel", "MRL", "MRL"}, {"Morrill", "MRL", "MRL"}, {"Morris", "MRS", "MRS"}, {"Morton", "MRTN", "MRTN"}, {"Moton", "MTN", "MTN"}, {"Muir", "MR", "MR"}, {"Mulferd", "MLFR", "MLFR"}, {"Mullins", "MLNS", "MLNS"}, {"Mulso", "MLS", "MLS"}, {"Munger", "MNKR", "MNJR"}, {"Munt", "MNT", "MNT"}, {"Murchad", "MRXT", "MRKT"}, {"Murdock", "MRTK", "MRTK"}, {"Murray", "MR", "MR"}, {"Muskett", "MSKT", "MSKT"}, {"Myers", "MRS", "MRS"}, {"Myrick", "MRK", "MRK"}, {"NORRIS", "NRS", "NRS"}, {"Nayle", "NL", "NL"}, {"Newcomb", "NKMP", "NKMP"}, {"Newcomb(e)", "NKMP", "NKMP"}, {"Newkirk", "NKRK", "NKRK"}, {"Newton", "NTN", "NTN"}, {"Niles", "NLS", "NLS"}, {"Noble", "NPL", "NPL"}, {"Noel", "NL", "NL"}, {"Northend", "NR0N", "NRTN"}, {"Norton", "NRTN", "NRTN"}, {"Nutter", "NTR", "NTR"}, {"Odding", "ATNK", "ATNK"}, {"Odenbaugh", "ATNP", "ATNP"}, {"Ogborn", "AKPR", "AKPR"}, {"Oppenheimer", "APNM", "APNM"}, {"Otis", "ATS", "ATS"}, {"Oviatt", "AFT", "AFT"}, {"PRUST?", "PRST", "PRST"}, {"Paddock", "PTK", "PTK"}, {"Page", "PJ", "PK"}, {"Paine", "PN", "PN"}, {"Paist", "PST", "PST"}, {"Palmer", "PLMR", "PLMR"}, {"Park", "PRK", "PRK"}, {"Parker", "PRKR", "PRKR"}, {"Parkhurst", "PRKR", "PRKR"}, {"Parrat", "PRT", "PRT"}, {"Parsons", "PRSN", "PRSN"}, {"Partridge", "PRTR", "PRTR"}, {"Pashley", "PXL", "PXL"}, {"Pasley", "PSL", "PSL"}, {"Patrick", "PTRK", "PTRK"}, {"Pattee", "PT", "PT"}, {"Patten", "PTN", "PTN"}, {"Pawley", "PL", "PL"}, {"Payne", "PN", "PN"}, {"Peabody", "PPT", "PPT"}, {"Peake", "PK", "PK"}, {"Pearson", "PRSN", "PRSN"}, {"Peat", "PT", "PT"}, {"Pedersen", "PTRS", "PTRS"}, {"Percy", "PRS", "PRS"}, {"Perkins", "PRKN", "PRKN"}, {"Perrine", "PRN", "PRN"}, {"Perry", "PR", "PR"}, {"Peson", "PSN", "PSN"}, {"Peterson", "PTRS", "PTRS"}, {"Peyton", "PTN", "PTN"}, {"Phinney", "FN", "FN"}, {"Pickard", "PKRT", "PKRT"}, {"Pierce", "PRS", "PRS"}, {"Pierrepont", "PRPN", "PRPN"}, {"Pike", "PK", "PK"}, {"Pinkham", "PNKM", "PNKM"}, {"Pitman", "PTMN", "PTMN"}, {"Pitt", "PT", "PT"}, {"Pitts", "PTS", "PTS"}, {"Plantagenet", "PLNT", "PLNT"}, {"Platt", "PLT", "PLT"}, {"Platts", "PLTS", "PLTS"}, {"Pleis", "PLS", "PLS"}, {"Pleiss", "PLS", "PLS"}, {"Plisko", "PLSK", "PLSK"}, {"Pliskovitch", "PLSK", "PLSK"}, {"Plum", "PLM", "PLM"}, {"Plume", "PLM", "PLM"}, {"Poitou", "PT", "PT"}, {"Pomeroy", "PMR", "PMR"}, {"Poretiers", "PRTR", "PRTR"}, {"Pote", "PT", "PT"}, {"Potter", "PTR", "PTR"}, {"Potts", "PTS", "PTS"}, {"Powell", "PL", "PL"}, {"Pratt", "PRT", "PRT"}, {"Presbury", "PRSP", "PRSP"}, {"Priest", "PRST", "PRST"}, {"Prindle", "PRNT", "PRNT"}, {"Prior", "PRR", "PRR"}, {"Profumo", "PRFM", "PRFM"}, {"Purdy", "PRT", "PRT"}, {"Purefoy", "PRF", "PRF"}, {"Pury", "PR", "PR"}, {"Quinter", "KNTR", "KNTR"}, {"Rachel", "RXL", "RKL"}, {"Rand", "RNT", "RNT"}, {"Rankin", "RNKN", "RNKN"}, {"Ravenscroft", "RFNS", "RFNS"}, {"Raynsford", "RNSF", "RNSF"}, {"Reakirt", "RKRT", "RKRT"}, {"Reaves", "RFS", "RFS"}, {"Reeves", "RFS", "RFS"}, {"Reichert", "RXRT", "RKRT"}, {"Remmele", "RML", "RML"}, {"Reynolds", "RNLT", "RNLT"}, {"Rhodes", "RTS", "RTS"}, {"Richards", "RXRT", "RKRT"}, {"Richardson", "RXRT", "RKRT"}, {"Ring", "RNK", "RNK"}, {"Roberts", "RPRT", "RPRT"}, {"Robertson", "RPRT", "RPRT"}, {"Robson", "RPSN", "RPSN"}, {"Rodie", "RT", "RT"}, {"Rody", "RT", "RT"}, {"Rogers", "RKRS", "RJRS"}, {"Ross", "RS", "RS"}, {"Rosslevin", "RSLF", "RSLF"}, {"Rowland", "RLNT", "RLNT"}, {"Ruehl", "RL", "RL"}, {"Russell", "RSL", "RSL"}, {"Ruth", "R0", "RT"}, {"Ryan", "RN", "RN"}, {"Rysse", "RS", "RS"}, {"Sadler", "STLR", "STLR"}, {"Salmon", "SLMN", "SLMN"}, {"Salter", "SLTR", "SLTR"}, {"Salvatore", "SLFT", "SLFT"}, {"Sanders", "SNTR", "SNTR"}, {"Sands", "SNTS", "SNTS"}, {"Sanford", "SNFR", "SNFR"}, {"Sanger", "SNKR", "SNJR"}, {"Sargent", "SRJN", "SRKN"}, {"Saunders", "SNTR", "SNTR"}, {"Schilling", "XLNK", "XLNK"}, {"Schlegel", "XLKL", "SLKL"}, {"Scott", "SKT", "SKT"}, {"Sears", "SRS", "SRS"}, {"Segersall", "SJRS", "SKRS"}, {"Senecal", "SNKL", "SNKL"}, {"Sergeaux", "SRJ", "SRK"}, {"Severance", "SFRN", "SFRN"}, {"Sharp", "XRP", "XRP"}, {"Sharpe", "XRP", "XRP"}, {"Sharply", "XRPL", "XRPL"}, {"Shatswell", "XTSL", "XTSL"}, {"Shattack", "XTK", "XTK"}, {"Shattock", "XTK", "XTK"}, {"Shattuck", "XTK", "XTK"}, {"Shaw", "X", "XF"}, {"Sheldon", "XLTN", "XLTN"}, {"Sherman", "XRMN", "XRMN"}, {"Shinn", "XN", "XN"}, {"Shirford", "XRFR", "XRFR"}, {"Shirley", "XRL", "XRL"}, {"Shively", "XFL", "XFL"}, {"Shoemaker", "XMKR", "XMKR"}, {"Short", "XRT", "XRT"}, {"Shotwell", "XTL", "XTL"}, {"Shute", "XT", "XT"}, {"Sibley", "SPL", "SPL"}, {"Silver", "SLFR", "SLFR"}, {"Simes", "SMS", "SMS"}, {"Sinken", "SNKN", "SNKN"}, {"Sinn", "SN", "SN"}, {"Skelton", "SKLT", "SKLT"}, {"Skiffe", "SKF", "SKF"}, {"Skotkonung", "SKTK", "SKTK"}, {"Slade", "SLT", "XLT"}, {"Slye", "SL", "XL"}, {"Smedley", "SMTL", "XMTL"}, {"Smith", "SM0", "XMT"}, {"Smythe", "SM0", "XMT"}, {"Snow", "SN", "XNF"}, {"Soole", "SL", "SL"}, {"Soule", "SL", "SL"}, {"Southworth", "S0R0", "STRT"}, {"Sowles", "SLS", "SLS"}, {"Spalding", "SPLT", "SPLT"}, {"Spark", "SPRK", "SPRK"}, {"Spencer", "SPNS", "SPNS"}, {"Sperry", "SPR", "SPR"}, {"Spofford", "SPFR", "SPFR"}, {"Spooner", "SPNR", "SPNR"}, {"Sprague", "SPRK", "SPRK"}, {"Springer", "SPRN", "SPRN"}, {"St. Clair", "STKL", "STKL"}, {"St. Claire", "STKL", "STKL"}, {"St. Leger", "STLJ", "STLK"}, {"St. Omer", "STMR", "STMR"}, {"Stafferton", "STFR", "STFR"}, {"Stafford", "STFR", "STFR"}, {"Stalham", "STLM", "STLM"}, {"Stanford", "STNF", "STNF"}, {"Stanton", "STNT", "STNT"}, {"Star", "STR", "STR"}, {"Starbuck", "STRP", "STRP"}, {"Starkey", "STRK", "STRK"}, {"Starkweather", "STRK", "STRK"}, {"Stearns", "STRN", "STRN"}, {"Stebbins", "STPN", "STPN"}, {"Steele", "STL", "STL"}, {"Stephenson", "STFN", "STFN"}, {"Stevens", "STFN", "STFN"}, {"Stoddard", "STTR", "STTR"}, {"Stodder", "STTR", "STTR"}, {"Stone", "STN", "STN"}, {"Storey", "STR", "STR"}, {"Storrada", "STRT", "STRT"}, {"Story", "STR", "STR"}, {"Stoughton", "STFT", "STFT"}, {"Stout", "STT", "STT"}, {"Stow", "ST", "STF"}, {"Strong", "STRN", "STRN"}, {"Strutt", "STRT", "STRT"}, {"Stryker", "STRK", "STRK"}, {"Stuckeley", "STKL", "STKL"}, {"Sturges", "STRJ", "STRK"}, {"Sturgess", "STRJ", "STRK"}, {"Sturgis", "STRJ", "STRK"}, {"Suevain", "SFN", "SFN"}, {"Sulyard", "SLRT", "SLRT"}, {"Sutton", "STN", "STN"}, {"Swain", "SN", "XN"}, {"Swayne", "SN", "XN"}, {"Swayze", "SS", "XTS"}, {"Swift", "SFT", "XFT"}, {"Taber", "TPR", "TPR"}, {"Talcott", "TLKT", "TLKT"}, {"Tarne", "TRN", "TRN"}, {"Tatum", "TTM", "TTM"}, {"Taverner", "TFRN", "TFRN"}, {"Taylor", "TLR", "TLR"}, {"Tenney", "TN", "TN"}, {"Thayer", "0R", "TR"}, {"Thember", "0MPR", "TMPR"}, {"Thomas", "TMS", "TMS"}, {"Thompson", "TMPS", "TMPS"}, {"Thorne", "0RN", "TRN"}, {"Thornycraft", "0RNK", "TRNK"}, {"Threlkeld", "0RLK", "TRLK"}, {"Throckmorton", "0RKM", "TRKM"}, {"Thwaits", "0TS", "TTS"}, {"Tibbetts", "TPTS", "TPTS"}, {"Tidd", "TT", "TT"}, {"Tierney", "TRN", "TRN"}, {"Tilley", "TL", "TL"}, {"Tillieres", "TLRS", "TLRS"}, {"Tilly", "TL", "TL"}, {"Tisdale", "TSTL", "TSTL"}, {"Titus", "TTS", "TTS"}, {"Tobey", "TP", "TP"}, {"Tooker", "TKR", "TKR"}, {"Towle", "TL", "TL"}, {"Towne", "TN", "TN"}, {"Townsend", "TNSN", "TNSN"}, {"Treadway", "TRT", "TRT"}, {"Trelawney", "TRLN", "TRLN"}, {"Trinder", "TRNT", "TRNT"}, {"Tripp", "TRP", "TRP"}, {"Trippe", "TRP", "TRP"}, {"Trott", "TRT", "TRT"}, {"True", "TR", "TR"}, {"Trussebut", "TRSP", "TRSP"}, {"Tucker", "TKR", "TKR"}, {"Turgeon", "TRJN", "TRKN"}, {"Turner", "TRNR", "TRNR"}, {"Tuttle", "TTL", "TTL"}, {"Tyler", "TLR", "TLR"}, {"Tylle", "TL", "TL"}, {"Tyrrel", "TRL", "TRL"}, {"Ua Tuathail", "AT0L", "ATTL"}, {"Ulrich", "ALRX", "ALRK"}, {"Underhill", "ANTR", "ANTR"}, {"Underwood", "ANTR", "ANTR"}, {"Unknown", "ANKN", "ANKN"}, {"Valentine", "FLNT", "FLNT"}, {"Van Egmond", "FNKM", "FNKM"}, {"Van der Beek", "FNTR", "FNTR"}, {"Vaughan", "FKN", "FKN"}, {"Vermenlen", "FRMN", "FRMN"}, {"Vincent", "FNSN", "FNSN"}, {"Volentine", "FLNT", "FLNT"}, {"Wagner", "AKNR", "FKNR"}, {"Waite", "AT", "FT"}, {"Walker", "ALKR", "FLKR"}, {"Walter", "ALTR", "FLTR"}, {"Wandell", "ANTL", "FNTL"}, {"Wandesford", "ANTS", "FNTS"}, {"Warbleton", "ARPL", "FRPL"}, {"Ward", "ART", "FRT"}, {"Warde", "ART", "FRT"}, {"Ware", "AR", "FR"}, {"Wareham", "ARHM", "FRHM"}, {"Warner", "ARNR", "FRNR"}, {"Warren", "ARN", "FRN"}, {"Washburne", "AXPR", "FXPR"}, {"Waterbury", "ATRP", "FTRP"}, {"Watson", "ATSN", "FTSN"}, {"WatsonEllithorpe", "ATSN", "FTSN"}, {"Watts", "ATS", "FTS"}, {"Wayne", "AN", "FN"}, {"Webb", "AP", "FP"}, {"Weber", "APR", "FPR"}, {"Webster", "APST", "FPST"}, {"Weed", "AT", "FT"}, {"Weeks", "AKS", "FKS"}, {"Wells", "ALS", "FLS"}, {"Wenzell", "ANSL", "FNTS"}, {"West", "AST", "FST"}, {"Westbury", "ASTP", "FSTP"}, {"Whatlocke", "ATLK", "ATLK"}, {"Wheeler", "ALR", "ALR"}, {"Whiston", "ASTN", "ASTN"}, {"White", "AT", "AT"}, {"Whitman", "ATMN", "ATMN"}, {"Whiton", "ATN", "ATN"}, {"Whitson", "ATSN", "ATSN"}, {"Wickes", "AKS", "FKS"}, {"Wilbur", "ALPR", "FLPR"}, {"Wilcotes", "ALKT", "FLKT"}, {"Wilkinson", "ALKN", "FLKN"}, {"Willets", "ALTS", "FLTS"}, {"Willett", "ALT", "FLT"}, {"Willey", "AL", "FL"}, {"Williams", "ALMS", "FLMS"}, {"Williston", "ALST", "FLST"}, {"Wilson", "ALSN", "FLSN"}, {"Wimes", "AMS", "FMS"}, {"Winch", "ANX", "FNK"}, {"Winegar", "ANKR", "FNKR"}, {"Wing", "ANK", "FNK"}, {"Winsley", "ANSL", "FNSL"}, {"Winslow", "ANSL", "FNSL"}, {"Winthrop", "AN0R", "FNTR"}, {"Wise", "AS", "FS"}, {"Wood", "AT", "FT"}, {"Woodbridge", "ATPR", "FTPR"}, {"Woodward", "ATRT", "FTRT"}, {"Wooley", "AL", "FL"}, {"Woolley", "AL", "FL"}, {"Worth", "AR0", "FRT"}, {"Worthen", "AR0N", "FRTN"}, {"Worthley", "AR0L", "FRTL"}, {"Wright", "RT", "RT"}, {"Wyer", "AR", "FR"}, {"Wyere", "AR", "FR"}, {"Wynkoop", "ANKP", "FNKP"}, {"Yarnall", "ARNL", "ARNL"}, {"Yeoman", "AMN", "AMN"}, {"Yorke", "ARK", "ARK"}, {"Young", "ANK", "ANK"}, {"ab Wennonwen", "APNN", "APNN"}, {"ap Llewellyn", "APLL", "APLL"}, {"ap Lorwerth", "APLR", "APLR"}, {"d'Angouleme", "TNKL", "TNKL"}, {"de Audeham", "TTHM", "TTHM"}, {"de Bavant", "TPFN", "TPFN"}, {"de Beauchamp", "TPXM", "TPKM"}, {"de Beaumont", "TPMN", "TPMN"}, {"de Bolbec", "TPLP", "TPLP"}, {"de Braiose", "TPRS", "TPRS"}, {"de Braose", "TPRS", "TPRS"}, {"de Briwere", "TPRR", "TPRR"}, {"de Cantelou", "TKNT", "TKNT"}, {"de Cherelton", "TXRL", "TKRL"}, {"de Cherleton", "TXRL", "TKRL"}, {"de Clare", "TKLR", "TKLR"}, {"de Claremont", "TKLR", "TKLR"}, {"de Clifford", "TKLF", "TKLF"}, {"de Colville", "TKLF", "TKLF"}, {"de Courtenay", "TKRT", "TKRT"}, {"de Fauconberg", "TFKN", "TFKN"}, {"de Forest", "TFRS", "TFRS"}, {"de Gai", "TK", "TK"}, {"de Grey", "TKR", "TKR"}, {"de Guernons", "TKRN", "TKRN"}, {"de Haia", "T", "T"}, {"de Harcourt", "TRKR", "TRKR"}, {"de Hastings", "TSTN", "TSTN"}, {"de Hoke", "TK", "TK"}, {"de Hooch", "TK", "TK"}, {"de Hugelville", "TJLF", "TKLF"}, {"de Huntingdon", "TNTN", "TNTN"}, {"de Insula", "TNSL", "TNSL"}, {"de Keynes", "TKNS", "TKNS"}, {"de Lacy", "TLS", "TLS"}, {"de Lexington", "TLKS", "TLKS"}, {"de Lusignan", "TLSN", "TLSK"}, {"de Manvers", "TMNF", "TMNF"}, {"de Montagu", "TMNT", "TMNT"}, {"de Montault", "TMNT", "TMNT"}, {"de Montfort", "TMNT", "TMNT"}, {"de Mortimer", "TMRT", "TMRT"}, {"de Morville", "TMRF", "TMRF"}, {"de Morvois", "TMRF", "TMRF"}, {"de Neufmarche", "TNFM", "TNFM"}, {"de Odingsells", "TTNK", "TTNK"}, {"de Odyngsells", "TTNK", "TTNK"}, {"de Percy", "TPRS", "TPRS"}, {"de Pierrepont", "TPRP", "TPRP"}, {"de Plessetis", "TPLS", "TPLS"}, {"de Porhoet", "TPRT", "TPRT"}, {"de Prouz", "TPRS", "TPRS"}, {"de Quincy", "TKNS", "TKNS"}, {"de Ripellis", "TRPL", "TRPL"}, {"de Ros", "TRS", "TRS"}, {"de Salisbury", "TSLS", "TSLS"}, {"de Sanford", "TSNF", "TSNF"}, {"de Somery", "TSMR", "TSMR"}, {"de St. Hilary", "TSTL", "TSTL"}, {"de St. Liz", "TSTL", "TSTL"}, {"de Sutton", "TSTN", "TSTN"}, {"de Toeni", "TTN", "TTN"}, {"de Tony", "TTN", "TTN"}, {"de Umfreville", "TMFR", "TMFR"}, {"de Valognes", "TFLN", "TFLK"}, {"de Vaux", "TF", "TF"}, {"de Vere", "TFR", "TFR"}, {"de Vermandois", "TFRM", "TFRM"}, {"de Vernon", "TFRN", "TFRN"}, {"de Vexin", "TFKS", "TFKS"}, {"de Vitre", "TFTR", "TFTR"}, {"de Wandesford", "TNTS", "TNTS"}, {"de Warenne", "TRN", "TRN"}, {"de Westbury", "TSTP", "TSTP"}, {"di Saluzzo", "TSLS", "TSLT"}, {"fitz Alan", "FTSL", "FTSL"}, {"fitz Geoffrey", "FTSJ", "FTSK"}, {"fitz Herbert", "FTSR", "FTSR"}, {"fitz John", "FTSJ", "FTSJ"}, {"fitz Patrick", "FTSP", "FTSP"}, {"fitz Payn", "FTSP", "FTSP"}, {"fitz Piers", "FTSP", "FTSP"}, {"fitz Randolph", "FTSR", "FTSR"}, {"fitz Richard", "FTSR", "FTSR"}, {"fitz Robert", "FTSR", "FTSR"}, {"fitz Roy", "FTSR", "FTSR"}, {"fitz Scrob", "FTSS", "FTSS"}, {"fitz Walter", "FTSL", "FTSL"}, {"fitz Warin", "FTSR", "FTSR"}, {"fitz Williams", "FTSL", "FTSL"}, {"la Zouche", "LSX", "LSK"}, {"le Botiller", "LPTL", "LPTL"}, {"le Despenser", "LTSP", "LTSP"}, {"le deSpencer", "LTSP", "LTSP"}, {"of Allendale", "AFLN", "AFLN"}, {"of Angouleme", "AFNK", "AFNK"}, {"of Anjou", "AFNJ", "AFNJ"}, {"of Aquitaine", "AFKT", "AFKT"}, {"of Aumale", "AFML", "AFML"}, {"of Bavaria", "AFPF", "AFPF"}, {"of Boulogne", "AFPL", "AFPL"}, {"of Brittany", "AFPR", "AFPR"}, {"of Brittary", "AFPR", "AFPR"}, {"of Castile", "AFKS", "AFKS"}, {"of Chester", "AFXS", "AFKS"}, {"of Clermont", "AFKL", "AFKL"}, {"of Cologne", "AFKL", "AFKL"}, {"of Dinan", "AFTN", "AFTN"}, {"of Dunbar", "AFTN", "AFTN"}, {"of England", "AFNK", "AFNK"}, {"of Essex", "AFSK", "AFSK"}, {"of Falaise", "AFFL", "AFFL"}, {"of Flanders", "AFFL", "AFFL"}, {"of Galloway", "AFKL", "AFKL"}, {"of Germany", "AFKR", "AFJR"}, {"of Gloucester", "AFKL", "AFKL"}, {"of Heristal", "AFRS", "AFRS"}, {"of Hungary", "AFNK", "AFNK"}, {"of Huntington", "AFNT", "AFNT"}, {"of Kiev", "AFKF", "AFKF"}, {"of Kuno", "AFKN", "AFKN"}, {"of Landen", "AFLN", "AFLN"}, {"of Laon", "AFLN", "AFLN"}, {"of Leinster", "AFLN", "AFLN"}, {"of Lens", "AFLN", "AFLN"}, {"of Lorraine", "AFLR", "AFLR"}, {"of Louvain", "AFLF", "AFLF"}, {"of Mercia", "AFMR", "AFMR"}, {"of Metz", "AFMT", "AFMT"}, {"of Meulan", "AFML", "AFML"}, {"of Nass", "AFNS", "AFNS"}, {"of Normandy", "AFNR", "AFNR"}, {"of Ohningen", "AFNN", "AFNN"}, {"of Orleans", "AFRL", "AFRL"}, {"of Poitou", "AFPT", "AFPT"}, {"of Polotzk", "AFPL", "AFPL"}, {"of Provence", "AFPR", "AFPR"}, {"of Ringelheim", "AFRN", "AFRN"}, {"of Salisbury", "AFSL", "AFSL"}, {"of Saxony", "AFSK", "AFSK"}, {"of Scotland", "AFSK", "AFSK"}, {"of Senlis", "AFSN", "AFSN"}, {"of Stafford", "AFST", "AFST"}, {"of Swabia", "AFSP", "AFSP"}, {"of Tongres", "AFTN", "AFTN"}, {"of the Tributes", "AF0T", "AFTT"}, {"unknown", "ANKN", "ANKN"}, {"van der Gouda", "FNTR", "FNTR"}, {"von Adenbaugh", "FNTN", "FNTN"}, {"ARCHITure", "ARKT", "ARKT"}, {"Arnoff", "ARNF", "ARNF"}, {"Arnow", "ARN", "ARNF"}, {"DANGER", "TNJR", "TNKR"}, {"Jankelowicz", "JNKL", "ANKL"}, {"MANGER", "MNJR", "MNKR"}, {"McClellan", "MKLL", "MKLL"}, {"McHugh", "MK", "MK"}, {"McLaughlin", "MKLF", "MKLF"}, {"ORCHEStra", "ARKS", "ARKS"}, {"ORCHID", "ARKT", "ARKT"}, {"Pierce", "PRS", "PRS"}, {"RANGER", "RNJR", "RNKR"}, {"Schlesinger", "XLSN", "SLSN"}, {"Uomo", "AM", "AM"}, {"Vasserman", "FSRM", "FSRM"}, {"Wasserman", "ASRM", "FSRM"}, {"Womo", "AM", "FM"}, {"Yankelovich", "ANKL", "ANKL"}, {"accede", "AKST", "AKST"}, {"accident", "AKST", "AKST"}, {"adelsheim", "ATLS", "ATLS"}, {"aged", "AJT", "AKT"}, {"ageless", "AJLS", "AKLS"}, {"agency", "AJNS", "AKNS"}, {"aghast", "AKST", "AKST"}, {"agio", "AJ", "AK"}, {"agrimony", "AKRM", "AKRM"}, {"album", "ALPM", "ALPM"}, {"alcmene", "ALKM", "ALKM"}, {"alehouse", "ALHS", "ALHS"}, {"antique", "ANTK", "ANTK"}, {"artois", "ART", "ARTS"}, {"automation", "ATMX", "ATMX"}, {"bacchus", "PKS", "PKS"}, {"bacci", "PX", "PX"}, {"bajador", "PJTR", "PHTR"}, {"bellocchio", "PLX", "PLX"}, {"bertucci", "PRTX", "PRTX"}, {"biaggi", "PJ", "PK"}, {"bough", "P", "P"}, {"breaux", "PR", "PR"}, {"broughton", "PRTN", "PRTN"}, {"cabrillo", "KPRL", "KPR"}, {"caesar", "SSR", "SSR"}, {"cagney", "KKN", "KKN"}, {"campbell", "KMPL", "KMPL"}, {"carlisle", "KRLL", "KRLL"}, {"carlysle", "KRLL", "KRLL"}, {"chemistry", "KMST", "KMST"}, {"chianti", "KNT", "KNT"}, {"chorus", "KRS", "KRS"}, {"cough", "KF", "KF"}, {"czerny", "SRN", "XRN"}, {"deffenbacher", "TFNP", "TFNP"}, {"dumb", "TM", "TM"}, {"edgar", "ATKR", "ATKR"}, {"edge", "AJ", "AJ"}, {"filipowicz", "FLPT", "FLPF"}, {"focaccia", "FKX", "FKX"}, {"gallegos", "KLKS", "KKS"}, {"gambrelli", "KMPR", "KMPR"}, {"geithain", "K0N", "JTN"}, {"ghiradelli", "JRTL", "JRTL"}, {"ghislane", "JLN", "JLN"}, {"gough", "KF", "KF"}, {"hartheim", "HR0M", "HRTM"}, {"heimsheim", "HMSM", "HMSM"}, {"hochmeier", "HKMR", "HKMR"}, {"hugh", "H", "H"}, {"hunger", "HNKR", "HNJR"}, {"hungry", "HNKR", "HNKR"}, {"island", "ALNT", "ALNT"}, {"isle", "AL", "AL"}, {"jose", "HS", "HS"}, {"laugh", "LF", "LF"}, {"mac caffrey", "MKFR", "MKFR"}, {"mac gregor", "MKRK", "MKRK"}, {"pegnitz", "PNTS", "PKNT"}, {"piskowitz", "PSKT", "PSKF"}, {"queen", "KN", "KN"}, {"raspberry", "RSPR", "RSPR"}, {"resnais", "RSN", "RSNS"}, {"rogier", "RJ", "RJR"}, {"rough", "RF", "RF"}, {"san jacinto", "SNHS", "SNHS"}, {"schenker", "XNKR", "SKNK"}, {"schermerhorn", "XRMR", "SKRM"}, {"schmidt", "XMT", "SMT"}, {"schneider", "XNTR", "SNTR"}, {"school", "SKL", "SKL"}, {"schooner", "SKNR", "SKNR"}, {"schrozberg", "XRSP", "SRSP"}, {"schulman", "XLMN", "XLMN"}, {"schwabach", "XPK", "XFPK"}, {"schwarzach", "XRSK", "XFRT"}, {"smith", "SM0", "XMT"}, {"snider", "SNTR", "XNTR"}, {"succeed", "SKST", "SKST"}, {"sugarcane", "XKRK", "SKRK"}, {"svobodka", "SFPT", "SFPT"}, {"tagliaro", "TKLR", "TLR"}, {"thames", "TMS", "TMS"}, {"theilheim", "0LM", "TLM"}, {"thomas", "TMS", "TMS"}, {"thumb", "0M", "TM"}, {"tichner", "TXNR", "TKNR"}, {"tough", "TF", "TF"}, {"umbrella", "AMPR", "AMPR"}, {"vilshofen", "FLXF", "FLXF"}, {"von schuller", "FNXL", "FNXL"}, {"wachtler", "AKTL", "FKTL"}, {"wechsler", "AKSL", "FKSL"}, {"weikersheim", "AKRS", "FKRS"}, {"zhao", "J", "J"}};

    DoubleMetaphone2Test() {
    }

    private void checkDoubleMetaphone(int typeIndex, boolean alternate) {
        for (int i = 0; i < TEST_DATA.length; ++i) {
            String value = TEST_DATA[i][0];
            Assertions.assertEquals((Object)TEST_DATA[i][typeIndex], (Object)((DoubleMetaphone)this.getStringEncoder()).doubleMetaphone(value, alternate), (String)("Test [" + i + "]=" + value));
        }
    }

    @Override
    protected DoubleMetaphone createStringEncoder() {
        return new DoubleMetaphone();
    }

    @Test
    void testDoubleMetaphoneAlternate() {
        this.checkDoubleMetaphone(2, true);
    }

    @Test
    void testDoubleMetaphonePrimary() {
        this.checkDoubleMetaphone(1, false);
    }
}

