/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalINIConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestHierarchicalINIConfiguration {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String INI_DATA = "[section1]" + LINE_SEPARATOR + "var1 = foo" + LINE_SEPARATOR + "var2 = 451" + LINE_SEPARATOR + LINE_SEPARATOR + "[section2]" + LINE_SEPARATOR + "var1 = 123.45" + LINE_SEPARATOR + "var2 = bar" + LINE_SEPARATOR + LINE_SEPARATOR + "[section3]" + LINE_SEPARATOR + "var1 = true" + LINE_SEPARATOR + "interpolated = ${section3.var1}" + LINE_SEPARATOR + "multi = foo" + LINE_SEPARATOR + "multi = bar" + LINE_SEPARATOR + LINE_SEPARATOR;
    private static final String INI_DATA2 = "[section4]" + LINE_SEPARATOR + "var1 = \"quoted value\"" + LINE_SEPARATOR + "var2 = \"quoted value\\nwith \\\"quotes\\\"\"" + LINE_SEPARATOR + "var3 = 123 ; comment" + LINE_SEPARATOR + "var4 = \"1;2;3\" ; comment" + LINE_SEPARATOR + "var5 = '\\'quoted\\' \"value\"' ; comment" + LINE_SEPARATOR + "var6 = \"\"" + LINE_SEPARATOR;
    private static final String INI_DATA3 = "[section5]" + LINE_SEPARATOR + "multiLine = one \\" + LINE_SEPARATOR + "    two      \\" + LINE_SEPARATOR + " three" + LINE_SEPARATOR + "singleLine = C:\\Temp\\" + LINE_SEPARATOR + "multiQuoted = one \\" + LINE_SEPARATOR + "\"  two  \" \\" + LINE_SEPARATOR + "  three" + LINE_SEPARATOR + "multiComment = one \\ ; a comment" + LINE_SEPARATOR + "two" + LINE_SEPARATOR + "multiQuotedComment = \" one \" \\ ; comment" + LINE_SEPARATOR + "two" + LINE_SEPARATOR + "noFirstLine = \\" + LINE_SEPARATOR + "  line 2" + LINE_SEPARATOR + "continueNoLine = one \\" + LINE_SEPARATOR;
    private static final String INI_DATA_SEPARATORS = "[section]" + LINE_SEPARATOR + "var1 = value1" + LINE_SEPARATOR + "var2 : value2" + LINE_SEPARATOR + "var3=value3" + LINE_SEPARATOR + "var4:value4" + LINE_SEPARATOR + "var5 : value=5" + LINE_SEPARATOR + "var:6=value" + LINE_SEPARATOR + "var:7=\"value7\"" + LINE_SEPARATOR + "var:8 =  \"value8\"" + LINE_SEPARATOR;
    private static final String INI_DATA_GLOBAL_ONLY = "globalVar = testGlobal" + LINE_SEPARATOR + LINE_SEPARATOR;
    private static final String INI_DATA_GLOBAL = INI_DATA_GLOBAL_ONLY + INI_DATA;
    private static final File TEST_FILE = new File("target/test.ini");

    @After
    public void tearDown() throws Exception {
        if (TEST_FILE.exists()) {
            Assert.assertTrue((String)("Cannot remove test file: " + TEST_FILE), (boolean)TEST_FILE.delete());
        }
    }

    private static HierarchicalINIConfiguration setUpConfig(String data) throws ConfigurationException {
        HierarchicalINIConfiguration instance = new HierarchicalINIConfiguration();
        TestHierarchicalINIConfiguration.load(instance, data);
        return instance;
    }

    private static void load(HierarchicalINIConfiguration instance, String data) throws ConfigurationException {
        StringReader reader = new StringReader(data);
        instance.load((Reader)reader);
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeTestFile(String content) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(TEST_FILE));
        try {
            out.println(content);
        }
        finally {
            out.close();
        }
    }

    @Test
    public void testSave() throws Exception {
        StringWriter writer = new StringWriter();
        HierarchicalINIConfiguration instance = new HierarchicalINIConfiguration();
        instance.addProperty("section1.var1", (Object)"foo");
        instance.addProperty("section1.var2", (Object)"451");
        instance.addProperty("section2.var1", (Object)"123.45");
        instance.addProperty("section2.var2", (Object)"bar");
        instance.addProperty("section3.var1", (Object)"true");
        instance.addProperty("section3.interpolated", (Object)"${section3.var1}");
        instance.addProperty("section3.multi", (Object)"foo");
        instance.addProperty("section3.multi", (Object)"bar");
        instance.save((Writer)writer);
        Assert.assertEquals((String)"Wrong content of ini file", (Object)INI_DATA, (Object)((Object)writer).toString());
    }

    private void checkSave(String content) throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(content);
        StringWriter writer = new StringWriter();
        config.save((Writer)writer);
        Assert.assertEquals((String)"Wrong content of ini file", (Object)content, (Object)writer.toString());
    }

    @Test
    public void testSaveWithGlobalSection() throws ConfigurationException {
        this.checkSave(INI_DATA_GLOBAL);
    }

    @Test
    public void testSaveWithOnlyGlobalSection() throws ConfigurationException {
        this.checkSave(INI_DATA_GLOBAL_ONLY);
    }

    @Test
    public void testLoad() throws Exception {
        this.checkLoad(INI_DATA);
    }

    @Test
    public void testLoadAlternativeSeparator() throws Exception {
        this.checkLoad(INI_DATA.replace('=', ':'));
    }

    @Test
    public void testLoadFile() throws ConfigurationException, IOException {
        TestHierarchicalINIConfiguration.writeTestFile(INI_DATA);
        HierarchicalINIConfiguration config = new HierarchicalINIConfiguration(TEST_FILE);
        this.checkContent(config);
    }

    @Test
    public void testLoadFileName() throws ConfigurationException, IOException {
        TestHierarchicalINIConfiguration.writeTestFile(INI_DATA);
        HierarchicalINIConfiguration config = new HierarchicalINIConfiguration(TEST_FILE.getAbsolutePath());
        this.checkContent(config);
    }

    @Test
    public void testLoadURL() throws ConfigurationException, IOException {
        TestHierarchicalINIConfiguration.writeTestFile(INI_DATA);
        HierarchicalINIConfiguration config = new HierarchicalINIConfiguration(TEST_FILE.toURI().toURL());
        this.checkContent(config);
    }

    private void checkContent(HierarchicalINIConfiguration instance) {
        Assert.assertTrue((boolean)instance.getString("section1.var1").equals("foo"));
        Assert.assertTrue((instance.getInt("section1.var2") == 451 ? 1 : 0) != 0);
        Assert.assertTrue((instance.getDouble("section2.var1") == 123.45 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)instance.getString("section2.var2").equals("bar"));
        Assert.assertTrue((boolean)instance.getBoolean("section3.var1"));
        Assert.assertTrue((instance.getSections().size() == 3 ? 1 : 0) != 0);
    }

    private void checkLoad(String data) throws ConfigurationException {
        HierarchicalINIConfiguration instance = TestHierarchicalINIConfiguration.setUpConfig(data);
        this.checkContent(instance);
    }

    @Test
    public void testIsCommentLine() {
        HierarchicalINIConfiguration instance = new HierarchicalINIConfiguration();
        Assert.assertTrue((boolean)instance.isCommentLine("#comment1"));
        Assert.assertTrue((boolean)instance.isCommentLine(";comment1"));
        Assert.assertFalse((boolean)instance.isCommentLine("nocomment=true"));
        Assert.assertFalse((boolean)instance.isCommentLine(null));
    }

    @Test
    public void testIsSectionLine() {
        HierarchicalINIConfiguration instance = new HierarchicalINIConfiguration();
        Assert.assertTrue((boolean)instance.isSectionLine("[section]"));
        Assert.assertFalse((boolean)instance.isSectionLine("nosection=true"));
        Assert.assertFalse((boolean)instance.isSectionLine(null));
    }

    @Test
    public void testGetSections() {
        HierarchicalINIConfiguration instance = new HierarchicalINIConfiguration();
        instance.addProperty("test1.foo", (Object)"bar");
        instance.addProperty("test2.foo", (Object)"abc");
        HashSet<String> expResult = new HashSet<String>();
        expResult.add("test1");
        expResult.add("test2");
        Set result = instance.getSections();
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testQuotedValue() throws Exception {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA2);
        Assert.assertEquals((String)"value", (Object)"quoted value", (Object)config.getString("section4.var1"));
    }

    @Test
    public void testQuotedValueWithQuotes() throws Exception {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA2);
        Assert.assertEquals((String)"value", (Object)"quoted value\\nwith \"quotes\"", (Object)config.getString("section4.var2"));
    }

    @Test
    public void testValueWithComment() throws Exception {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA2);
        Assert.assertEquals((String)"value", (Object)"123", (Object)config.getString("section4.var3"));
    }

    @Test
    public void testQuotedValueWithComment() throws Exception {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA2);
        Assert.assertEquals((String)"value", (Object)"1;2;3", (Object)config.getString("section4.var4"));
    }

    @Test
    public void testQuotedValueWithSingleQuotes() throws Exception {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA2);
        Assert.assertEquals((String)"value", (Object)"'quoted' \"value\"", (Object)config.getString("section4.var5"));
    }

    @Test
    public void testWriteValueWithCommentChar() throws Exception {
        HierarchicalINIConfiguration config = new HierarchicalINIConfiguration();
        config.setProperty("section.key1", (Object)"1;2;3");
        StringWriter writer = new StringWriter();
        config.save((Writer)writer);
        HierarchicalINIConfiguration config2 = new HierarchicalINIConfiguration();
        config2.load((Reader)new StringReader(writer.toString()));
        Assert.assertEquals((String)"value", (Object)"1;2;3", (Object)config2.getString("section.key1"));
    }

    @Test
    public void testQuotedValueWithWhitespace() throws Exception {
        String content = "CmdPrompt = \" [test@cmd ~]$ \"";
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig("CmdPrompt = \" [test@cmd ~]$ \"");
        Assert.assertEquals((String)"Wrong propert value", (Object)" [test@cmd ~]$ ", (Object)config.getString("CmdPrompt"));
    }

    @Test
    public void testQuotedValueWithWhitespaceAndComment() throws Exception {
        String content = "CmdPrompt = \" [test@cmd ~]$ \" ; a comment";
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig("CmdPrompt = \" [test@cmd ~]$ \" ; a comment");
        Assert.assertEquals((String)"Wrong propert value", (Object)" [test@cmd ~]$ ", (Object)config.getString("CmdPrompt"));
    }

    @Test
    public void testQuotedValueEmpty() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA2);
        Assert.assertEquals((String)"Wrong value for empty property", (Object)"", (Object)config.getString("section4.var6"));
    }

    @Test
    public void testGetPropertyNoValue() throws ConfigurationException {
        String data = INI_DATA2 + LINE_SEPARATOR + "noValue =" + LINE_SEPARATOR;
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(data);
        Assert.assertEquals((String)"Wrong value of key", (Object)"", (Object)config.getString("section4.noValue"));
    }

    @Test
    public void testGetPropertyNoKey() throws ConfigurationException {
        String data = INI_DATA2 + LINE_SEPARATOR + "= noKey" + LINE_SEPARATOR;
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(data);
        Assert.assertEquals((String)"Cannot find property with no key", (Object)"noKey", (Object)config.getString("section4. "));
    }

    @Test
    public void testGlobalProperty() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        Assert.assertEquals((String)"Wrong value of global property", (Object)"testGlobal", (Object)config.getString("globalVar"));
    }

    private void checkSectionNames(HierarchicalINIConfiguration config, String[] expected) {
        Set sectionNames = config.getSections();
        Iterator it = sectionNames.iterator();
        for (int idx = 0; idx < expected.length; ++idx) {
            Assert.assertEquals((String)("Wrong section at " + idx), (Object)expected[idx], it.next());
        }
        Assert.assertFalse((String)"Too many sections", (boolean)it.hasNext());
    }

    private HierarchicalINIConfiguration checkSectionNames(String data, String[] expected) throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(data);
        this.checkSectionNames(config, expected);
        return config;
    }

    @Test
    public void testGetSectionsWithGlobal() throws ConfigurationException {
        this.checkSectionNames(INI_DATA_GLOBAL, new String[]{null, "section1", "section2", "section3"});
    }

    @Test
    public void testGetSectionsNoGlobal() throws ConfigurationException {
        this.checkSectionNames(INI_DATA, new String[]{"section1", "section2", "section3"});
    }

    @Test
    public void testGetSectionsGlobalOnly() throws ConfigurationException {
        this.checkSectionNames(INI_DATA_GLOBAL_ONLY, new String[]{null});
    }

    @Test
    public void testGetSectionsDottedVar() throws ConfigurationException {
        String data = "dotted.var = 1" + LINE_SEPARATOR + INI_DATA_GLOBAL;
        HierarchicalINIConfiguration config = this.checkSectionNames(data, new String[]{null, "section1", "section2", "section3"});
        Assert.assertEquals((String)"Wrong value of dotted variable", (long)1L, (long)config.getInt("dotted..var"));
    }

    @Test
    public void testGetSectionsAdded() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA2);
        config.addProperty("section5.test", (Object)Boolean.TRUE);
        this.checkSectionNames(config, new String[]{"section4", "section5"});
    }

    @Test
    public void testGetSectionExisting() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA);
        SubnodeConfiguration section = config.getSection("section1");
        Assert.assertEquals((String)"Wrong value of var1", (Object)"foo", (Object)section.getString("var1"));
        Assert.assertEquals((String)"Wrong value of var2", (Object)"451", (Object)section.getString("var2"));
    }

    @Test
    public void testGetSectionMerged() throws ConfigurationException {
        String data = INI_DATA + "[section1]" + LINE_SEPARATOR + "var3 = merged" + LINE_SEPARATOR;
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(data);
        SubnodeConfiguration section = config.getSection("section1");
        Assert.assertEquals((String)"Wrong value of var1", (Object)"foo", (Object)section.getString("var1"));
        Assert.assertEquals((String)"Wrong value of var2", (Object)"451", (Object)section.getString("var2"));
        Assert.assertEquals((String)"Wrong value of var3", (Object)"merged", (Object)section.getString("var3"));
    }

    @Test
    public void testGetSectionGlobal() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        SubnodeConfiguration section = config.getSection(null);
        Assert.assertEquals((String)"Wrong value of global variable", (Object)"testGlobal", (Object)section.getString("globalVar"));
    }

    @Test
    public void testGetSectionGloabalMultiThreaded() throws ConfigurationException, InterruptedException {
        int i;
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        int threadCount = 10;
        GlobalSectionTestThread[] threads = new GlobalSectionTestThread[10];
        for (i = 0; i < 10; ++i) {
            threads[i] = new GlobalSectionTestThread(config);
            threads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            threads[i].join();
            Assert.assertFalse((String)"Exception occurred", (boolean)threads[i].error);
        }
    }

    @Test
    public void testGetSectionGlobalNonExisting() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA);
        SubnodeConfiguration section = config.getSection(null);
        Assert.assertTrue((String)"Sub config not empty", (boolean)section.isEmpty());
    }

    @Test
    public void testGetSectionNonExisting() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA);
        SubnodeConfiguration section = config.getSection("Non existing section");
        Assert.assertTrue((String)"Sub config not empty", (boolean)section.isEmpty());
    }

    @Test
    public void testLineContinuation() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA3);
        Assert.assertEquals((String)"Wrong value", (Object)("one" + LINE_SEPARATOR + "two" + LINE_SEPARATOR + "three"), (Object)config.getString("section5.multiLine"));
    }

    @Test
    public void testLineContinuationNone() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA3);
        Assert.assertEquals((String)"Wrong value", (Object)"C:\\Temp\\", (Object)config.getString("section5.singleLine"));
    }

    @Test
    public void testLineContinuationQuoted() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA3);
        Assert.assertEquals((String)"Wrong value", (Object)("one" + LINE_SEPARATOR + "  two  " + LINE_SEPARATOR + "three"), (Object)config.getString("section5.multiQuoted"));
    }

    @Test
    public void testLineContinuationComment() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA3);
        Assert.assertEquals((String)"Wrong value", (Object)("one" + LINE_SEPARATOR + "two"), (Object)config.getString("section5.multiComment"));
    }

    @Test
    public void testLineContinuationQuotedComment() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA3);
        Assert.assertEquals((String)"Wrong value", (Object)(" one " + LINE_SEPARATOR + "two"), (Object)config.getString("section5.multiQuotedComment"));
    }

    @Test
    public void testLineContinuationEmptyLine() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA3);
        Assert.assertEquals((String)"Wrong value", (Object)(LINE_SEPARATOR + "line 2"), (Object)config.getString("section5.noFirstLine"));
    }

    @Test
    public void testLineContinuationAtEnd() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA3);
        Assert.assertEquals((String)"Wrong value", (Object)("one" + LINE_SEPARATOR), (Object)config.getString("section5.continueNoLine"));
    }

    @Test
    public void testSaveKeysWithDelimiters() throws ConfigurationException {
        HierarchicalINIConfiguration conf = new HierarchicalINIConfiguration();
        String section = "Section..with..dots";
        conf.addProperty("Section..with..dots.test1", (Object)"test1");
        conf.addProperty("Section..with..dots.test2", (Object)"test2");
        conf.save(TEST_FILE);
        conf = new HierarchicalINIConfiguration();
        conf.load(TEST_FILE);
        Assert.assertEquals((String)"Wrong value (1)", (Object)"test1", (Object)conf.getString("Section..with..dots.test1"));
        Assert.assertEquals((String)"Wrong value (2)", (Object)"test2", (Object)conf.getString("Section..with..dots.test2"));
    }

    @Test
    public void testValueWithSemicolon() throws ConfigurationException {
        String path = "C:\\Program Files\\jar\\manage.jar;C:\\Program Files\\jar\\guiLauncher.jar";
        String content = "[Environment]" + LINE_SEPARATOR + "Application Type=any" + LINE_SEPARATOR + "Class Path=" + "C:\\Program Files\\jar\\manage.jar;C:\\Program Files\\jar\\guiLauncher.jar" + "  ;comment" + LINE_SEPARATOR + "Path=" + "C:\\Program Files\\jar\\manage.jar;C:\\Program Files\\jar\\guiLauncher.jar" + "\t; another comment";
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(content);
        Assert.assertEquals((String)"Wrong class path", (Object)"C:\\Program Files\\jar\\manage.jar;C:\\Program Files\\jar\\guiLauncher.jar", (Object)config.getString("Environment.Class Path"));
        Assert.assertEquals((String)"Wrong path", (Object)"C:\\Program Files\\jar\\manage.jar;C:\\Program Files\\jar\\guiLauncher.jar", (Object)config.getString("Environment.Path"));
    }

    @Test
    public void testSeparators() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA_SEPARATORS);
        for (int i = 1; i <= 4; ++i) {
            Assert.assertEquals((String)"Wrong value", (Object)("value" + i), (Object)config.getString("section.var" + i));
        }
    }

    @Test
    public void testMultipleSeparators() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA_SEPARATORS);
        Assert.assertEquals((String)"Wrong value for var5", (Object)"value=5", (Object)config.getString("section.var5"));
        Assert.assertEquals((String)"Wrong value for var6", (Object)"6=value", (Object)config.getString("section.var"));
    }

    @Test
    public void testMultipleSeparatorsQuoted() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA_SEPARATORS);
        Assert.assertEquals((String)"Wrong value for var7", (Object)"value7", (Object)config.getString("section.var:7"));
        Assert.assertEquals((String)"Wrong value for var8", (Object)"value8", (Object)config.getString("section.var:8"));
    }

    @Test
    public void testSaveClearedSection() throws ConfigurationException {
        String data = "[section]\ntest = failed\n";
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig("[section]\ntest = failed\n");
        SubnodeConfiguration sub = config.getSection("section");
        Assert.assertFalse((String)"No content", (boolean)sub.isEmpty());
        sub.clear();
        sub.setProperty("test", (Object)"success");
        StringWriter writer = new StringWriter();
        config.save((Writer)writer);
        HierarchicalINIConfiguration config2 = TestHierarchicalINIConfiguration.setUpConfig(writer.toString());
        Assert.assertEquals((String)"Wrong value", (Object)"success", (Object)config2.getString("section.test"));
    }

    @Test
    public void testMergeDuplicateSection() throws ConfigurationException {
        String data = "[section]\nvar1 = sec1\n\n[section]\nvar2 = sec2\n";
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig("[section]\nvar1 = sec1\n\n[section]\nvar2 = sec2\n");
        Assert.assertEquals((String)"Wrong value 1", (Object)"sec1", (Object)config.getString("section.var1"));
        Assert.assertEquals((String)"Wrong value 2", (Object)"sec2", (Object)config.getString("section.var2"));
        SubnodeConfiguration sub = config.getSection("section");
        Assert.assertEquals((String)"Wrong sub value 1", (Object)"sec1", (Object)sub.getString("var1"));
        Assert.assertEquals((String)"Wrong sub value 2", (Object)"sec2", (Object)sub.getString("var2"));
        StringWriter writer = new StringWriter();
        config.save((Writer)writer);
        String content = writer.toString();
        int pos = content.indexOf("[section]");
        Assert.assertTrue((String)("Section not found: " + content), (pos >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Section found multiple times: " + content), (content.indexOf("[section]", pos + 1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetSectionNonExistingManipulate() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig(INI_DATA);
        SubnodeConfiguration section = config.getSection("newSection");
        section.addProperty("test", (Object)"success");
        Assert.assertEquals((String)"Main config not updated", (Object)"success", (Object)config.getString("newSection.test"));
        StringWriter writer = new StringWriter();
        config.save((Writer)writer);
        HierarchicalINIConfiguration config2 = TestHierarchicalINIConfiguration.setUpConfig(writer.toString());
        section = config2.getSection("newSection");
        Assert.assertEquals((String)"Wrong value", (Object)"success", (Object)section.getString("test"));
    }

    @Test
    public void testGetSectionDuplicate() {
        HierarchicalINIConfiguration config = new HierarchicalINIConfiguration();
        config.addProperty("section.var1", (Object)"value1");
        config.addProperty("section(-1).var2", (Object)"value2");
        SubnodeConfiguration section = config.getSection("section");
        Iterator keys = section.getKeys();
        Assert.assertEquals((String)"Wrong key", (Object)"var1", keys.next());
        Assert.assertFalse((String)"Too many keys", (boolean)keys.hasNext());
    }

    @Test
    public void testValueWithDelimiters() throws ConfigurationException {
        HierarchicalINIConfiguration config = TestHierarchicalINIConfiguration.setUpConfig("[test]" + LINE_SEPARATOR + "list=1,2,3" + LINE_SEPARATOR);
        List list = config.getList("test.list");
        Assert.assertEquals((String)"Wrong number of elements", (long)3L, (long)list.size());
        Assert.assertEquals((String)"Wrong element at 1", (Object)"1", list.get(0));
        Assert.assertEquals((String)"Wrong element at 2", (Object)"2", list.get(1));
        Assert.assertEquals((String)"Wrong element at 3", (Object)"3", list.get(2));
    }

    @Test
    public void testListParsingDisabled() throws ConfigurationException {
        HierarchicalINIConfiguration config = new HierarchicalINIConfiguration();
        config.setDelimiterParsingDisabled(true);
        TestHierarchicalINIConfiguration.load(config, "[test]" + LINE_SEPARATOR + "nolist=1,2,3");
        Assert.assertEquals((String)"Wrong value", (Object)"1,2,3", (Object)config.getString("test.nolist"));
    }

    private static class GlobalSectionTestThread
    extends Thread {
        private final HierarchicalINIConfiguration config;
        volatile boolean error;

        public GlobalSectionTestThread(HierarchicalINIConfiguration conf) {
            this.config = conf;
        }

        public void run() {
            int loopCount = 250;
            for (int i = 0; i < 250 && !this.error; ++i) {
                try {
                    this.config.getSection(null);
                    continue;
                }
                catch (IllegalStateException istex) {
                    this.error = true;
                }
            }
        }
    }
}

