/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.ConfigurationUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestImmutableConfiguration {
    private static final String TEST_FILE = "test.properties";

    private static PropertiesConfiguration createTestConfig() throws ConfigurationException {
        return (PropertiesConfiguration)new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(ConfigurationAssert.getTestFile(TEST_FILE))}).getConfiguration();
    }

    private static Set<String> fetchKeys(Iterator<String> it) {
        HashSet<String> keys = new HashSet<String>();
        while (it.hasNext()) {
            keys.add(it.next());
        }
        return keys;
    }

    @Test
    public void testExceptionHandling() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        String property = "nonExistingProperty";
        config.setThrowExceptionOnMissing(true);
        ImmutableConfiguration ic = ConfigurationUtils.unmodifiableConfiguration((Configuration)config);
        NoSuchElementException e = (NoSuchElementException)Assertions.assertThrows(NoSuchElementException.class, () -> ic.getString("nonExistingProperty"));
        Assertions.assertTrue((boolean)e.getMessage().contains("nonExistingProperty"));
    }

    @Test
    public void testImmutableSubset() throws ConfigurationException {
        ImmutableConfiguration conf = ConfigurationUtils.unmodifiableConfiguration((Configuration)TestImmutableConfiguration.createTestConfig());
        ImmutableConfiguration subset = conf.immutableSubset("test");
        Assertions.assertFalse((boolean)subset.isEmpty());
        Assertions.assertEquals((long)1000000L, (long)subset.getLong("long"));
    }

    @Test
    public void testUnmodifiableConfigurationAccess() throws ConfigurationException {
        PropertiesConfiguration confOrg = TestImmutableConfiguration.createTestConfig();
        ImmutableConfiguration conf = ConfigurationUtils.unmodifiableConfiguration((Configuration)confOrg);
        Assertions.assertFalse((boolean)conf.isEmpty());
        Iterator it = confOrg.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assertions.assertTrue((boolean)conf.containsKey(key), (String)("Key not contained: " + key));
            Assertions.assertEquals((Object)confOrg.getProperty(key), (Object)conf.getProperty(key), (String)("Wrong value for " + key));
        }
    }

    @Test
    public void testUnmodifiableConfigurationCast() throws ConfigurationException {
        ImmutableConfiguration conf = ConfigurationUtils.unmodifiableConfiguration((Configuration)TestImmutableConfiguration.createTestConfig());
        Assertions.assertThrows(ClassCastException.class, () -> {
            Configuration mutableConf = (Configuration)conf;
            mutableConf.clear();
        });
    }

    @Test
    public void testUnmodifiableConfigurationIterate() throws ConfigurationException {
        PropertiesConfiguration confOrg = TestImmutableConfiguration.createTestConfig();
        ImmutableConfiguration conf = ConfigurationUtils.unmodifiableConfiguration((Configuration)confOrg);
        Assertions.assertEquals(TestImmutableConfiguration.fetchKeys(confOrg.getKeys()), TestImmutableConfiguration.fetchKeys(conf.getKeys()));
    }

    @Test
    public void testUnmodifiableConfigurationIteratorRemove() throws ConfigurationException {
        ImmutableConfiguration conf = ConfigurationUtils.unmodifiableConfiguration((Configuration)TestImmutableConfiguration.createTestConfig());
        Iterator it = conf.getKeys();
        it.next();
        Assertions.assertThrows(UnsupportedOperationException.class, it::remove);
    }

    @Test
    public void testUnmodifiableConfigurationLiveUpdate() throws ConfigurationException {
        PropertiesConfiguration confOrg = TestImmutableConfiguration.createTestConfig();
        ImmutableConfiguration conf = ConfigurationUtils.unmodifiableConfiguration((Configuration)confOrg);
        String key = "new.property";
        String value = "new value";
        confOrg.addProperty("new.property", (Object)"new value");
        Assertions.assertEquals((Object)"new value", (Object)conf.getString("new.property"));
    }

    @Test
    public void testUnmodifiableConfigurationNull() {
        Assertions.assertThrows(NullPointerException.class, () -> ConfigurationUtils.unmodifiableConfiguration(null));
    }

    @Test
    public void testUnmodifiableConfigurationOtherTypes() throws ConfigurationException {
        ImmutableConfiguration conf = ConfigurationUtils.unmodifiableConfiguration((Configuration)TestImmutableConfiguration.createTestConfig());
        Assertions.assertEquals((byte)10, (byte)conf.getByte("test.byte"));
        Assertions.assertTrue((boolean)conf.getBoolean("test.boolean"));
        Assertions.assertEquals((double)10.25, (double)conf.getDouble("test.double"), (double)0.05);
        Assertions.assertEquals((double)20.25, (double)conf.getFloat("test.float"), (double)0.05);
        Assertions.assertEquals((int)10, (int)conf.getInt("test.integer"));
        Assertions.assertEquals((long)1000000L, (long)conf.getLong("test.long"));
        Assertions.assertEquals((short)1, (short)conf.getShort("test.short"));
    }

    @Test
    public void testUnmodifiableHierarchicalConfiguration() {
        BaseHierarchicalConfiguration conf = new BaseHierarchicalConfiguration();
        String key = "test";
        conf.addProperty("test", (Object)Boolean.TRUE);
        ImmutableHierarchicalConfiguration ihc = ConfigurationUtils.unmodifiableConfiguration((HierarchicalConfiguration)conf);
        Assertions.assertTrue((boolean)ihc.getBoolean("test"));
        Assertions.assertEquals((int)0, (int)ihc.getMaxIndex("test"));
    }
}

