/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestConfigurationConverter {
    private static BaseConfiguration createTestConfiguration() {
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("string", (Object)"teststring");
        config.addProperty("array", (Object)"item 1");
        config.addProperty("array", (Object)"item 2");
        config.addProperty("interpolated", (Object)"${string}");
        config.addProperty("interpolated-array", (Object)"${interpolated}");
        config.addProperty("interpolated-array", (Object)"${interpolated}");
        return config;
    }

    @Test
    public void testConfigurationToMap() {
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("string", (Object)"teststring");
        Map map = ConfigurationConverter.getMap((Configuration)config);
        Assertions.assertNotNull((Object)map);
        Assertions.assertEquals((Object)"teststring", map.get("string"));
    }

    @Test
    public void testConfigurationToPropertiesDefaultListHandling() {
        BaseConfiguration config = TestConfigurationConverter.createTestConfiguration();
        Properties props = ConfigurationConverter.getProperties((Configuration)config);
        Assertions.assertNotNull((Object)props);
        Assertions.assertEquals((Object)"teststring", (Object)props.getProperty("string"));
        Assertions.assertEquals((Object)"teststring", (Object)props.getProperty("interpolated"));
        Assertions.assertEquals((Object)"item 1,item 2", (Object)props.getProperty("array"));
        Assertions.assertEquals((Object)"teststring,teststring", (Object)props.getProperty("interpolated-array"));
    }

    @Test
    public void testConfigurationToPropertiesListDelimiterHandler() {
        BaseConfiguration config = TestConfigurationConverter.createTestConfiguration();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(';'));
        Properties props = ConfigurationConverter.getProperties((Configuration)config);
        Assertions.assertEquals((Object)"item 1;item 2", (Object)props.getProperty("array"));
    }

    @Test
    public void testConfigurationToPropertiesNoAbstractConfiguration() {
        Configuration src = (Configuration)Mockito.mock(Configuration.class);
        BaseConfiguration config = TestConfigurationConverter.createTestConfiguration();
        Mockito.when((Object)src.getKeys()).thenReturn((Object)config.getKeys());
        Mockito.when((Object)src.getList((String)ArgumentMatchers.any())).thenAnswer(invocation -> {
            String key = (String)invocation.getArgument(0, String.class);
            return config.getList(key);
        });
        Properties props = ConfigurationConverter.getProperties((Configuration)src);
        Assertions.assertEquals((Object)"item 1,item 2", (Object)props.getProperty("array"));
    }

    @Test
    public void testConfigurationToPropertiesScalarValue() {
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("scalar", (Object)42);
        Properties props = ConfigurationConverter.getProperties((Configuration)config);
        Assertions.assertEquals((Object)"42", (Object)props.getProperty("scalar"));
    }

    @Test
    public void testPropertiesToConfiguration() {
        Properties props = new Properties();
        props.setProperty("string", "teststring");
        props.setProperty("int", "123");
        props.setProperty("list", "item 1, item 2");
        AbstractConfiguration config = (AbstractConfiguration)ConfigurationConverter.getConfiguration((Properties)props);
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        Assertions.assertEquals((Object)"teststring", (Object)config.getString("string"));
        List item1 = config.getList("list");
        Assertions.assertEquals((Object)"item 1", item1.get(0));
        Assertions.assertEquals((int)123, (int)config.getInt("int"));
    }
}

