/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.javax;

import java.util.stream.IntStream;
import org.apache.commons.mail2.core.EmailException;
import org.apache.commons.mail2.javax.AbstractEmailTest;
import org.apache.commons.mail2.javax.mocks.MockEmailConcrete;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InvalidAddressTest
extends AbstractEmailTest {
    private static final String[] ARR_INVALID_EMAILS = new String[]{"local name@domain.com", "local(name@domain.com", "local)name@domain.com", "local<name@domain.com", "local>name@domain.com", "local,name@domain.com", "local;name@domain.com", "local:name@domain.com", "local[name@domain.com", "local]name@domain.com", "local\"name@domain.com", "local\tname@domain.com", "local\nname@domain.com", "local\rname@domain.com", "local.name@domain com", "local.name@domain(com", "local.name@domain)com", "local.name@domain<com", "local.name@domain>com", "local.name@domain,com", "local.name@domain;com", "local.name@domain:com", "local.name@domain]com", "local.name@domain\\com", "local.name@domain\tcom", "local.name@domain\ncom", "local.name@domain\rcom", "local.name@", "@domain.com"};
    private MockEmailConcrete email;

    @BeforeEach
    public void setUpInvalidAddressTest() {
        this.email = new MockEmailConcrete();
    }

    @Test
    public void testAddInvalidBcc() throws Exception {
        IntStream.range(0, ARR_INVALID_EMAILS.length).forEach(i -> Assertions.assertThrows(EmailException.class, () -> this.email.addBcc(ARR_INVALID_EMAILS[i], "Joe"), () -> "addBcc " + i + " passed: " + ARR_INVALID_EMAILS[i]));
    }

    @Test
    public void testAddInvalidCc() throws Exception {
        IntStream.range(0, ARR_INVALID_EMAILS.length).forEach(i -> Assertions.assertThrows(EmailException.class, () -> this.email.addCc(ARR_INVALID_EMAILS[i], "Joe"), () -> "addCc " + i + " passed: " + ARR_INVALID_EMAILS[i]));
    }

    @Test
    public void testAddInvalidTo() throws Exception {
        IntStream.range(0, ARR_INVALID_EMAILS.length).forEach(i -> Assertions.assertThrows(EmailException.class, () -> this.email.addTo(ARR_INVALID_EMAILS[i], "Joe"), () -> "addTo " + i + " passed: " + ARR_INVALID_EMAILS[i]));
    }

    @Test
    public void testSetInvalidFrom() throws Exception {
        IntStream.range(0, ARR_INVALID_EMAILS.length).forEach(i -> Assertions.assertThrows(EmailException.class, () -> this.email.setFrom(ARR_INVALID_EMAILS[i], "Joe"), () -> "setFrom " + i + " passed: " + ARR_INVALID_EMAILS[i]));
    }
}

