/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.roundtrip;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.stream.Stream;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.PixelDensity;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.roundtrip.FormatInfo;
import org.apache.commons.imaging.roundtrip.RoundtripBase;
import org.apache.commons.imaging.roundtrip.TestImages;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class PixelDensityRoundtrip
extends RoundtripBase {
    public static Stream<FormatInfo> testPixelDensityRoundtrip() {
        return Stream.of(FormatInfo.PRESERVING_RESOLUTION_FORMATS);
    }

    @ParameterizedTest
    @MethodSource
    public void testPixelDensityRoundtrip(FormatInfo formatInfo) throws Exception {
        BufferedImage testImage = TestImages.createFullColorImage(2, 2);
        TiffImagingParameters params = new TiffImagingParameters();
        PixelDensity pixelDensity = PixelDensity.createFromPixelsPerInch((double)75.0, (double)150.0);
        params.setPixelDensity(pixelDensity);
        TiffImageParser tiffImageParser = new TiffImageParser();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        tiffImageParser.writeImage(testImage, (OutputStream)byteArrayOutputStream, params);
        ImageInfo imageInfo = Imaging.getImageInfo((byte[])byteArrayOutputStream.toByteArray());
        if (imageInfo != null) {
            int xReadDPI = imageInfo.getPhysicalWidthDpi();
            int yReadDPI = imageInfo.getPhysicalHeightDpi();
            Assertions.assertTrue((Math.abs(((double)xReadDPI - pixelDensity.horizontalDensityInches()) / pixelDensity.horizontalDensityInches()) <= 0.05 ? 1 : 0) != 0);
            Assertions.assertTrue((Math.abs(((double)yReadDPI - pixelDensity.verticalDensityInches()) / pixelDensity.verticalDensityInches()) <= 0.05 ? 1 : 0) != 0);
        }
    }
}

