/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.function.IORunnable;
import org.apache.commons.io.function.TestConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IORunnableTest {
    IORunnableTest() {
    }

    @Test
    void testAccept() throws IOException {
        AtomicReference ref = new AtomicReference();
        IORunnable runnable = () -> ref.set("A1");
        runnable.run();
        Assertions.assertEquals((Object)"A1", ref.get());
    }

    @Test
    void testAsRunnable() throws Exception {
        Assertions.assertThrows(UncheckedIOException.class, () -> Executors.callable(TestConstants.THROWING_IO_RUNNABLE.asRunnable()).call());
        IORunnable runnable = () -> Files.size(PathUtils.current());
        Assertions.assertNull((Object)Executors.callable(runnable.asRunnable()).call());
    }

    @Test
    void testNoop() throws IOException {
        Assertions.assertTrue((boolean)(IORunnable.noop() instanceof IORunnable));
        IORunnable.noop().run();
    }
}

