/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import org.apache.commons.io.output.BrokenWriter;
import org.apache.commons.io.output.UncheckedAppendable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class UncheckedAppendableTest {
    private IOException exception;
    private UncheckedAppendable appendableBroken;
    private UncheckedAppendable appendableString;

    UncheckedAppendableTest() {
    }

    @BeforeEach
    public void setUp() {
        this.exception = new IOException("test exception");
        this.appendableBroken = UncheckedAppendable.on((Appendable)new BrokenWriter(this.exception));
        this.appendableString = UncheckedAppendable.on((Appendable)new StringWriter());
    }

    @Test
    void testAppendChar() {
        this.appendableString.append('a').append('b');
        Assertions.assertEquals((Object)"ab", (Object)this.appendableString.toString());
    }

    @Test
    void testAppendCharSequence() {
        this.appendableString.append((CharSequence)"a").append((CharSequence)"b");
        Assertions.assertEquals((Object)"ab", (Object)this.appendableString.toString());
    }

    @Test
    void testAppendCharSequenceIndexed() {
        this.appendableString.append((CharSequence)"a", 0, 1).append((CharSequence)"b", 0, 1);
        Assertions.assertEquals((Object)"ab", (Object)this.appendableString.toString());
    }

    @Test
    void testAppendCharSequenceIndexedThrows() {
        UncheckedIOException e = (UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.appendableBroken.append((CharSequence)"a", 0, 1));
        Assertions.assertEquals((Object)this.exception, (Object)e.getCause());
    }

    @Test
    void testAppendCharSequenceThrows() {
        UncheckedIOException e = (UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.appendableBroken.append((CharSequence)"a"));
        Assertions.assertEquals((Object)this.exception, (Object)e.getCause());
    }

    @Test
    void testAppendCharThrows() {
        UncheckedIOException e2 = (UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.appendableBroken.append('a'));
        Assertions.assertEquals((Object)this.exception, (Object)e2.getCause());
    }

    @Test
    void testToString() {
        Assertions.assertEquals((Object)"ab", (Object)UncheckedAppendable.on((Appendable)new StringWriter(2).append("ab")).toString());
    }
}

