/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.jcs3.engine.CacheInfo;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.behavior.IShutdownObserver;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.discovery.DiscoveredService;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryMessage;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryService;
import org.apache.commons.jcs3.utils.net.HostNameUtil;
import org.apache.commons.jcs3.utils.threadpool.PoolConfiguration;
import org.apache.commons.jcs3.utils.threadpool.ThreadPoolManager;

public class UDPDiscoveryReceiver
implements Runnable,
IShutdownObserver {
    private static final Log log = LogManager.getLog(UDPDiscoveryReceiver.class);
    private DatagramChannel multicastChannel;
    private MembershipKey multicastGroupKey;
    private Selector selector;
    private static final int maxPoolSize = 2;
    private final ExecutorService pooledExecutor;
    private final AtomicInteger cnt = new AtomicInteger(0);
    private final UDPDiscoveryService service;
    private IElementSerializer serializer;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final ArrayBlockingQueue<UDPDiscoveryMessage> msgQueue = new ArrayBlockingQueue(2);

    public UDPDiscoveryReceiver(UDPDiscoveryService service, String multicastInterfaceString, String multicastAddressString, int multicastPort) throws IOException {
        this(service, multicastInterfaceString, InetAddress.getByName(multicastAddressString), multicastPort);
    }

    public UDPDiscoveryReceiver(UDPDiscoveryService service, String multicastInterfaceString, InetAddress multicastAddress, int multicastPort) throws IOException {
        this.service = service;
        if (service != null) {
            this.serializer = service.getSerializer();
        }
        this.pooledExecutor = ThreadPoolManager.getInstance().createPool(new PoolConfiguration(false, 0, 2, 2, 0, PoolConfiguration.WhenBlockedPolicy.DISCARDOLDEST, 2), "JCS-UDPDiscoveryReceiver-", 1);
        log.info("Constructing listener, [{0}:{1}]", multicastAddress, multicastPort);
        this.createSocket(multicastInterfaceString, multicastAddress, multicastPort);
    }

    private void createSocket(String multicastInterfaceString, InetAddress multicastAddress, int multicastPort) throws IOException {
        try {
            NetworkInterface multicastInterface = null;
            multicastInterface = multicastInterfaceString != null ? NetworkInterface.getByName(multicastInterfaceString) : HostNameUtil.getMulticastNetworkInterface();
            if (multicastInterface != null) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = multicastInterface::getDisplayName;
                log.info("Using network interface {0}", supplierArray);
            }
            this.multicastChannel = ((DatagramChannel)((DatagramChannel)DatagramChannel.open(multicastAddress instanceof Inet6Address ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, multicastInterface)).bind(new InetSocketAddress(multicastPort));
            this.multicastChannel.configureBlocking(false);
            log.info("Joining Group: [{0}] on {1}", multicastAddress, multicastInterface);
            this.multicastGroupKey = this.multicastChannel.join(multicastAddress, multicastInterface);
            this.selector = Selector.open();
            this.multicastChannel.register(this.selector, 1);
        }
        catch (IOException e) {
            log.error("Could not bind to multicast address [{0}:{1}]", multicastAddress, multicastPort, e);
            throw e;
        }
    }

    @Deprecated
    public Object waitForMessage() throws IOException {
        try {
            return this.msgQueue.take();
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted waiting for message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            log.debug("Waiting for message.");
            while (!this.shutdown.get()) {
                int activeKeys = this.selector.select();
                if (activeKeys == 0) continue;
                Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
                while (i.hasNext() && !this.shutdown.get()) {
                    SelectionKey key = i.next();
                    i.remove();
                    if (!key.isValid() || !key.isReadable()) continue;
                    this.cnt.incrementAndGet();
                    log.debug("{0} messages received.", this::getCnt);
                    DatagramChannel mc = (DatagramChannel)key.channel();
                    ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
                    InetSocketAddress sourceAddress = (InetSocketAddress)mc.receive(byteBuffer);
                    byteBuffer.flip();
                    try {
                        log.debug("Received packet from address [{0}]", sourceAddress);
                        byte[] bytes = new byte[byteBuffer.limit()];
                        byteBuffer.get(bytes);
                        Object obj = this.serializer.deSerialize(bytes, null);
                        if (!(obj instanceof UDPDiscoveryMessage)) continue;
                        UDPDiscoveryMessage msg = (UDPDiscoveryMessage)obj;
                        msg.setHost(sourceAddress.getHostString());
                        log.debug("Read object from address [{0}], object=[{1}]", sourceAddress, obj);
                        ArrayBlockingQueue<UDPDiscoveryMessage> arrayBlockingQueue = this.msgQueue;
                        synchronized (arrayBlockingQueue) {
                            if (this.msgQueue.remainingCapacity() == 0) {
                                this.msgQueue.remove();
                            }
                            this.msgQueue.add(msg);
                        }
                        this.pooledExecutor.execute(() -> this.handleMessage(msg));
                        log.debug("Passed handler to executor.");
                    }
                    catch (IOException | ClassNotFoundException e) {
                        log.error("Error receiving multicast packet", e);
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("Unexpected exception in UDP receiver.", e);
        }
    }

    public void setCnt(int cnt) {
        this.cnt.set(cnt);
    }

    public int getCnt() {
        return this.cnt.get();
    }

    protected void setSerializer(IElementSerializer serializer) {
        this.serializer = serializer;
    }

    private void handleMessage(UDPDiscoveryMessage message) {
        if (message.getRequesterId() == CacheInfo.listenerId) {
            log.debug("Ignoring message sent from self");
        } else {
            log.debug("Process message sent from another");
            log.debug("Message = {0}", message);
            if (message.getHost() == null || message.getCacheNames() == null || message.getCacheNames().isEmpty()) {
                log.debug("Ignoring invalid message: {0}", message);
            } else {
                this.processMessage(message);
            }
        }
    }

    private void processMessage(UDPDiscoveryMessage message) {
        DiscoveredService discoveredService = new DiscoveredService(message);
        switch (message.getMessageType()) {
            case REMOVE: {
                log.debug("Removing service from set {0}", discoveredService);
                this.service.removeDiscoveredService(discoveredService);
                break;
            }
            case REQUEST: {
                log.debug("Message is a Request Broadcast, will have the service handle it.");
                this.service.serviceRequestBroadcast();
                break;
            }
            default: {
                log.debug("Adding or updating service to set {0}", discoveredService);
                this.service.addOrUpdateService(discoveredService);
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            try {
                this.selector.close();
                this.multicastGroupKey.drop();
                this.multicastChannel.close();
            }
            catch (IOException e) {
                log.error("Problem closing socket");
            }
        }
    }

    @Deprecated
    public class MessageHandler
    implements Runnable {
        private final UDPDiscoveryMessage message;

        public MessageHandler(UDPDiscoveryMessage message) {
            this.message = message;
        }

        @Override
        public void run() {
            UDPDiscoveryReceiver.this.handleMessage(this.message);
        }
    }
}

