/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.apache.commons.jcs3.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.net.HostNameUtil;

public class RemoteCacheStartupServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogManager.getLog(RemoteCacheStartupServlet.class);
    private static final int DEFAULT_REGISTRY_PORT = 1101;
    private static final String DEFAULT_PROPS_FILE_NAME = "/cache.ccf";
    private String propsFileName = "/cache.ccf";
    private int registryPort = 1101;
    private String registryHost;

    public void init() throws ServletException {
        super.init();
        this.loadInitParams();
        Properties props = this.loadPropertiesFromFile();
        if (this.registryHost == null) {
            try {
                this.registryHost = HostNameUtil.getLocalHostAddress();
            }
            catch (UnknownHostException e) {
                log.error("Could not get local address to use for the registry!", e);
            }
        }
        log.debug("registryHost = [{0}]", this.registryHost);
        try {
            if (InetAddress.getByName(this.registryHost).isLoopbackAddress()) {
                log.warn("The local address [{0}] is a loopback address. Other machines must be able to use the address to reach this server.", this.registryHost);
            }
        }
        catch (UnknownHostException e) {
            throw new ServletException("Could not resolve registry host " + this.registryHost, (Throwable)e);
        }
        try {
            if (props == null) {
                throw new ServletException("Could not load configuration from " + this.propsFileName);
            }
            RemoteCacheServerFactory.startup(this.registryHost, this.registryPort, props);
            log.info("Remote JCS Server started with properties from {0}", this.propsFileName);
        }
        catch (IOException e) {
            throw new ServletException("Problem starting remote cache server.", (Throwable)e);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String stats = "";
        try {
            stats = CompositeCacheManager.getInstance().getStats();
        }
        catch (CacheException e) {
            throw new ServletException((Throwable)e);
        }
        log.info(stats);
        try {
            String characterEncoding = response.getCharacterEncoding();
            if (characterEncoding == null) {
                characterEncoding = StandardCharsets.UTF_8.name();
                response.setCharacterEncoding(characterEncoding);
            }
            ServletOutputStream os = response.getOutputStream();
            os.write(stats.getBytes(characterEncoding));
            os.close();
        }
        catch (IOException e) {
            log.error("Problem writing response.", e);
        }
    }

    public void destroy() {
        super.destroy();
        log.info("Shutting down remote cache ");
        try {
            RemoteCacheServerFactory.shutdownImpl(this.registryHost, this.registryPort);
        }
        catch (IOException e) {
            log.error("Problem shutting down.", e);
        }
        try {
            CompositeCacheManager.getInstance().shutDown();
        }
        catch (CacheException e) {
            log.error("Could not retrieve cache manager instance", e);
        }
    }

    private Properties loadPropertiesFromFile() {
        Properties props = null;
        try {
            props = RemoteUtils.loadProps(this.propsFileName);
            this.registryHost = props.getProperty("registry.host", this.registryHost);
            String portS = props.getProperty("registry.port", String.valueOf(this.registryPort));
            this.setRegistryPort(portS);
        }
        catch (IOException e) {
            log.error("Problem loading props.", e);
        }
        return props;
    }

    private void loadInitParams() {
        String regPortString;
        String _registryHost;
        ServletConfig config = this.getServletConfig();
        String _propsFileName = config.getInitParameter("propsFileName");
        if (null != _propsFileName) {
            this.propsFileName = _propsFileName;
        }
        if (null != (_registryHost = config.getInitParameter("registryHost"))) {
            this.registryHost = _registryHost;
        }
        if (null != (regPortString = config.getInitParameter("registryPort"))) {
            this.setRegistryPort(regPortString);
        }
    }

    private void setRegistryPort(String portS) {
        try {
            this.registryPort = Integer.parseInt(portS);
        }
        catch (NumberFormatException e) {
            log.error("Problem converting port to an int.", e);
            this.registryPort = 1101;
        }
    }
}

