/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.indexed;

import java.util.HashSet;
import java.util.Map;
import junit.extensions.ActiveTestSuite;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;

public class IndexedDiskCacheSameRegionConcurrentUnitTest
extends TestCase {
    public IndexedDiskCacheSameRegionConcurrentUnitTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        ActiveTestSuite suite = new ActiveTestSuite();
        suite.addTest((Test)new IndexedDiskCacheSameRegionConcurrentUnitTest("testIndexedDiskCache1"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion4", 0, 200);
            }
        });
        suite.addTest((Test)new IndexedDiskCacheSameRegionConcurrentUnitTest("testIndexedDiskCache2"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion4", 1000, 1200);
            }
        });
        suite.addTest((Test)new IndexedDiskCacheSameRegionConcurrentUnitTest("testIndexedDiskCache3"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion4", 2000, 2200);
            }
        });
        suite.addTest((Test)new IndexedDiskCacheSameRegionConcurrentUnitTest("testIndexedDiskCache4"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion4", 2200, 5200);
            }
        });
        suite.addTest((Test)new IndexedDiskCacheSameRegionConcurrentUnitTest("testIndexedDiskCache5"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion4", 0, 5100);
            }
        });
        return suite;
    }

    public void setUp() {
        JCS.setConfigFilename((String)"/TestDiskCacheCon.ccf");
    }

    public void runTestForRegion(String region, int start, int end) throws Exception {
        int i;
        CacheAccess jcs = JCS.getInstance((String)region);
        for (i = start; i <= end; ++i) {
            jcs.put((Object)(i + ":key"), (Object)(region + " data " + i));
        }
        for (i = start; i <= end; ++i) {
            String key = i + ":key";
            String value = (String)jcs.get((Object)key);
            IndexedDiskCacheSameRegionConcurrentUnitTest.assertEquals((String)("Wrong value for key [" + key + "]"), (String)(region + " data " + i), (String)value);
        }
        HashSet<String> keys = new HashSet<String>();
        for (int i2 = start; i2 <= end; ++i2) {
            keys.add(i2 + ":key");
        }
        Map elements = jcs.getCacheElements(keys);
        for (int i3 = start; i3 <= end; ++i3) {
            ICacheElement element = (ICacheElement)elements.get(i3 + ":key");
            IndexedDiskCacheSameRegionConcurrentUnitTest.assertNotNull((String)("element " + i3 + ":key is missing"), (Object)element);
            IndexedDiskCacheSameRegionConcurrentUnitTest.assertEquals((String)("value " + i3 + ":key"), (String)(region + " data " + i3), (String)((String)element.getVal()));
        }
    }
}

