/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.remote.MockRemoteCacheClient;
import org.apache.commons.jcs3.auxiliary.remote.MockRemoteCacheService;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.CacheStatus;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.utils.timing.SleepUtil;

public class RemoteCacheNoWaitUnitTest
extends TestCase {
    public void testUpdate() throws Exception {
        MockRemoteCacheClient client = new MockRemoteCacheClient();
        RemoteCacheNoWait noWait = new RemoteCacheNoWait(client);
        CacheElement element = new CacheElement("testUpdate", (Object)"key", (Object)"value");
        noWait.update((ICacheElement)element);
        SleepUtil.sleepAtLeast(10L);
        RemoteCacheNoWaitUnitTest.assertEquals((String)"Wrong number updated.", (int)1, (int)client.updateList.size());
        RemoteCacheNoWaitUnitTest.assertEquals((String)"Wrong element", (Object)element, client.updateList.get(0));
    }

    public void testGet() throws Exception {
        MockRemoteCacheClient client = new MockRemoteCacheClient();
        RemoteCacheNoWait noWait = new RemoteCacheNoWait(client);
        CacheElement input = new CacheElement("testUpdate", (Object)"key", (Object)"value");
        client.getSetupMap.put("key", (ICacheElement<String, CacheElement>)input);
        ICacheElement result = noWait.get((Object)"key");
        RemoteCacheNoWaitUnitTest.assertEquals((String)"Wrong element", (Object)input, (Object)result);
    }

    public void testGetMultiple() throws Exception {
        MockRemoteCacheClient client = new MockRemoteCacheClient();
        RemoteCacheNoWait noWait = new RemoteCacheNoWait(client);
        CacheElement inputElement = new CacheElement("testUpdate", (Object)"key", (Object)"value");
        HashMap<String, CacheElement> inputMap = new HashMap<String, CacheElement>();
        inputMap.put("key", inputElement);
        HashSet<String> keys = new HashSet<String>();
        keys.add("key");
        client.getMultipleSetupMap.put(keys, inputMap);
        Map result = noWait.getMultiple(keys);
        RemoteCacheNoWaitUnitTest.assertEquals((String)"elements map", inputMap, (Object)result);
    }

    public void testRemove() throws Exception {
        MockRemoteCacheClient client = new MockRemoteCacheClient();
        RemoteCacheNoWait noWait = new RemoteCacheNoWait(client);
        String input = "MyKey";
        noWait.remove((Object)"MyKey");
        SleepUtil.sleepAtLeast(10L);
        RemoteCacheNoWaitUnitTest.assertEquals((String)"Wrong number updated.", (int)1, (int)client.removeList.size());
        RemoteCacheNoWaitUnitTest.assertEquals((String)"Wrong key", (String)"MyKey", (String)((String)client.removeList.get(0)));
    }

    public void testGetStats() throws Exception {
        MockRemoteCacheClient client = new MockRemoteCacheClient();
        client.status = CacheStatus.ALIVE;
        RemoteCacheNoWait noWait = new RemoteCacheNoWait(client);
        String result = noWait.getStats();
        RemoteCacheNoWaitUnitTest.assertTrue((String)"Status should contain 'ALIVE'", (result.indexOf("ALIVE") != -1 ? 1 : 0) != 0);
    }

    public void testGetStatus_error() throws Exception {
        MockRemoteCacheClient client = new MockRemoteCacheClient();
        client.status = CacheStatus.ERROR;
        RemoteCacheNoWait noWait = new RemoteCacheNoWait(client);
        CacheStatus result = noWait.getStatus();
        RemoteCacheNoWaitUnitTest.assertEquals((String)"Wrong status", (Object)CacheStatus.ERROR, (Object)result);
    }

    public void testFixCache() throws Exception {
        MockRemoteCacheClient client = new MockRemoteCacheClient();
        client.status = CacheStatus.ALIVE;
        RemoteCacheNoWait noWait = new RemoteCacheNoWait(client);
        MockRemoteCacheService service = new MockRemoteCacheService();
        CacheElement element = new CacheElement("testUpdate", (Object)"key", (Object)"value");
        noWait.update((ICacheElement)element);
        SleepUtil.sleepAtLeast(10L);
        noWait.fixCache(service);
        noWait.update((ICacheElement)element);
        SleepUtil.sleepAtLeast(10L);
        RemoteCacheNoWaitUnitTest.assertEquals((String)"Wrong status", service, client.fixed);
    }
}

