/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.utils.discovery.DiscoveredService;
import org.apache.commons.jcs3.utils.discovery.MockDiscoveryListener;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryAttributes;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryService;
import org.apache.commons.jcs3.utils.discovery.behavior.IDiscoveryListener;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class UDPDiscoveryServiceUnitTest
extends TestCase {
    private static final String host = "228.5.6.7";
    private static final int port = 6789;
    private UDPDiscoveryService service;
    private MockDiscoveryListener discoveryListener;

    protected void setUp() throws Exception {
        super.setUp();
        UDPDiscoveryAttributes attributes = new UDPDiscoveryAttributes();
        attributes.setUdpDiscoveryAddr(host);
        attributes.setUdpDiscoveryPort(6789);
        attributes.setServicePort(1000);
        this.service = new UDPDiscoveryService(attributes, (IElementSerializer)new StandardSerializer());
        this.service.startup();
        this.service.addParticipatingCacheName("testCache1");
        this.discoveryListener = new MockDiscoveryListener();
        this.service.addDiscoveryListener((IDiscoveryListener)this.discoveryListener);
    }

    public void testAddOrUpdateService_NotInList() {
        DiscoveredService discoveredService = new DiscoveredService();
        discoveredService.setServiceAddress(host);
        discoveredService.setCacheNames(new ArrayList());
        discoveredService.setServicePort(1000);
        discoveredService.setLastHearFromTime(100L);
        this.service.addOrUpdateService(discoveredService);
        UDPDiscoveryServiceUnitTest.assertTrue((String)"Service should be in the service list.", (boolean)this.service.getDiscoveredServices().contains(discoveredService));
        UDPDiscoveryServiceUnitTest.assertTrue((String)"Service should be in the listener list.", (boolean)this.discoveryListener.discoveredServices.contains(discoveredService));
    }

    public void testAddOrUpdateService_InList_NamesDoNotChange() {
        ArrayList<String> sameCacheNames = new ArrayList<String>();
        sameCacheNames.add("name1");
        DiscoveredService discoveredService = new DiscoveredService();
        discoveredService.setServiceAddress(host);
        discoveredService.setCacheNames(sameCacheNames);
        discoveredService.setServicePort(1000);
        discoveredService.setLastHearFromTime(100L);
        DiscoveredService discoveredService2 = new DiscoveredService();
        discoveredService2.setServiceAddress(host);
        discoveredService2.setCacheNames(sameCacheNames);
        discoveredService2.setServicePort(1000);
        discoveredService2.setLastHearFromTime(500L);
        this.service.addOrUpdateService(discoveredService);
        this.service.addOrUpdateService(discoveredService2);
        UDPDiscoveryServiceUnitTest.assertEquals((String)"Should only be one in the set.", (int)1, (int)this.service.getDiscoveredServices().size());
        UDPDiscoveryServiceUnitTest.assertTrue((String)"Service should be in the service list.", (boolean)this.service.getDiscoveredServices().contains(discoveredService));
        UDPDiscoveryServiceUnitTest.assertTrue((String)"Service should be in the listener list.", (boolean)this.discoveryListener.discoveredServices.contains(discoveredService));
        for (DiscoveredService service1 : this.service.getDiscoveredServices()) {
            if (!discoveredService.equals((Object)service1)) continue;
            UDPDiscoveryServiceUnitTest.assertEquals((String)"The match should have the new last heard from time.", (long)service1.getLastHearFromTime(), (long)discoveredService2.getLastHearFromTime());
        }
        UDPDiscoveryServiceUnitTest.assertEquals((String)"Mock should have been called twice.", (int)2, (int)this.discoveryListener.discoveredServices.size());
    }

    public void testAddOrUpdateService_InList_NamesChange() {
        DiscoveredService discoveredService = new DiscoveredService();
        discoveredService.setServiceAddress(host);
        discoveredService.setCacheNames(new ArrayList());
        discoveredService.setServicePort(1000);
        discoveredService.setLastHearFromTime(100L);
        ArrayList<String> differentCacheNames = new ArrayList<String>();
        differentCacheNames.add("name1");
        DiscoveredService discoveredService2 = new DiscoveredService();
        discoveredService2.setServiceAddress(host);
        discoveredService2.setCacheNames(differentCacheNames);
        discoveredService2.setServicePort(1000);
        discoveredService2.setLastHearFromTime(500L);
        this.service.addOrUpdateService(discoveredService);
        this.service.addOrUpdateService(discoveredService2);
        UDPDiscoveryServiceUnitTest.assertEquals((String)"Should only be one in the set.", (int)1, (int)this.service.getDiscoveredServices().size());
        UDPDiscoveryServiceUnitTest.assertTrue((String)"Service should be in the service list.", (boolean)this.service.getDiscoveredServices().contains(discoveredService));
        UDPDiscoveryServiceUnitTest.assertTrue((String)"Service should be in the listener list.", (boolean)this.discoveryListener.discoveredServices.contains(discoveredService));
        for (DiscoveredService service1 : this.service.getDiscoveredServices()) {
            if (!discoveredService.equals((Object)service1)) continue;
            UDPDiscoveryServiceUnitTest.assertEquals((String)"The match should have the new last heard from time.", (long)service1.getLastHearFromTime(), (long)discoveredService2.getLastHearFromTime());
            UDPDiscoveryServiceUnitTest.assertEquals((String)"The names should be updated.", (String)(service1.getCacheNames() + ""), (String)(differentCacheNames + ""));
        }
        UDPDiscoveryServiceUnitTest.assertEquals((String)"Mock should have been called twice.", (int)2, (int)this.discoveryListener.discoveredServices.size());
        UDPDiscoveryServiceUnitTest.assertEquals((String)"The second mock listener add should be discoveredService2", (Object)discoveredService2, (Object)this.discoveryListener.discoveredServices.get(1));
    }

    public void testRemoveDiscoveredService() {
        DiscoveredService discoveredService = new DiscoveredService();
        discoveredService.setServiceAddress(host);
        discoveredService.setCacheNames(new ArrayList());
        discoveredService.setServicePort(1000);
        discoveredService.setLastHearFromTime(100L);
        this.service.addOrUpdateService(discoveredService);
        this.service.removeDiscoveredService(discoveredService);
        UDPDiscoveryServiceUnitTest.assertFalse((String)"Service should not be in the service list.", (boolean)this.service.getDiscoveredServices().contains(discoveredService));
        UDPDiscoveryServiceUnitTest.assertFalse((String)"Service should not be in the listener list.", (boolean)this.discoveryListener.discoveredServices.contains(discoveredService));
    }
}

