/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.http.client;

import java.io.IOException;
import org.apache.commons.jcs3.auxiliary.remote.AbstractRemoteAuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.commons.jcs3.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.http.client.RemoteHttpCacheMonitor;
import org.apache.commons.jcs3.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs3.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class RemoteHttpCache<K, V>
extends AbstractRemoteAuxiliaryCache<K, V> {
    private static final Log log = LogManager.getLog(RemoteHttpCache.class);
    private final RemoteHttpCacheMonitor monitor;
    private final RemoteHttpCacheAttributes remoteHttpCacheAttributes;

    public RemoteHttpCache(RemoteHttpCacheAttributes remoteHttpCacheAttributes, ICacheServiceNonLocal<K, V> remote, IRemoteCacheListener<K, V> listener, RemoteHttpCacheMonitor monitor) {
        super(remoteHttpCacheAttributes, remote, listener);
        this.remoteHttpCacheAttributes = remoteHttpCacheAttributes;
        this.monitor = monitor;
    }

    @Override
    protected void handleException(Exception ex, String msg, String eventName) throws IOException {
        if (!(this.getRemoteCacheService() instanceof ZombieCacheServiceNonLocal)) {
            String message = "Disabling remote cache due to error: " + msg;
            this.logError(this.cacheName, "", message);
            log.error(message, ex);
            this.setRemoteCacheService(new ZombieCacheServiceNonLocal(this.getRemoteCacheAttributes().getZombieQueueMaxSize()));
            this.monitor.notifyError(this);
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        throw new IOException(ex.getMessage());
    }

    @Override
    public String getEventLoggingExtraInfo() {
        return null;
    }

    public RemoteHttpCacheAttributes getRemoteHttpCacheAttributes() {
        return this.remoteHttpCacheAttributes;
    }
}

