/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.server;

import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import org.apache.commons.jcs3.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServer;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

@Deprecated
public class RegistryKeepAliveRunner
implements Runnable {
    private static final Log log = LogManager.getLog(RegistryKeepAliveRunner.class);
    private final String registryHost;
    private final int registryPort;
    private ICacheEventLogger cacheEventLogger;
    private Registry registry;

    public RegistryKeepAliveRunner(String registryHost, int registryPort, String serviceName) {
        this.registryHost = registryHost;
        this.registryPort = registryPort;
    }

    @Override
    public void run() {
        this.checkAndRestoreIfNeeded();
    }

    protected void checkAndRestoreIfNeeded() {
        RemoteCacheServerFactory.keepAlive(this.registryHost, this.registryPort, this.cacheEventLogger);
    }

    protected void createAndRegister(String serviceName) {
        this.createReqistry(serviceName);
        this.registerServer(serviceName);
    }

    protected void createReqistry(String serviceName) {
        this.registry = RemoteUtils.createRegistry(this.registryPort);
        if (this.cacheEventLogger != null) {
            if (this.registry != null) {
                this.cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "createRegistry", "Successfully created registry [" + serviceName + "].");
            } else {
                this.cacheEventLogger.logError("RegistryKeepAliveRunner", "createRegistry", "Could not start registry [" + serviceName + "].");
            }
        }
    }

    protected void registerServer(String serviceName) {
        block3: {
            try {
                RemoteCacheServer server = RemoteCacheServerFactory.getRemoteCacheServer();
                RemoteCacheServerFactory.registerServer(serviceName, server);
                String message = "Successfully rebound server to registry [" + serviceName + "].";
                if (this.cacheEventLogger != null) {
                    this.cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "registerServer", message);
                }
                log.info(message);
            }
            catch (RemoteException e) {
                String message = "Could not rebind server to registry [" + serviceName + "].";
                log.error(message, e);
                if (this.cacheEventLogger == null) break block3;
                this.cacheEventLogger.logError("RegistryKeepAliveRunner", "registerServer", message + ":" + e.getMessage());
            }
        }
    }

    public void setCacheEventLogger(ICacheEventLogger cacheEventLogger) {
        this.cacheEventLogger = cacheEventLogger;
    }
}

